package org.cdk8s.plus23;

/**
 * Control traffic flow at the IP address or port level (OSI layer 3 or 4), network policies are an application-centric construct which allow you to specify how a pod is allowed to communicate with various network peers.
 * <p>
 * <ul>
 * <li>Outgoing traffic is allowed if there are no network policies selecting
 * the pod (and cluster policy otherwise allows the traffic),
 * OR if the traffic matches at least one egress rule across all of the
 * network policies that select the pod.</li>
 * <li>Incoming traffic is allowed to a pod if there are no network policies
 * selecting the pod (and cluster policy otherwise allows the traffic),
 * OR if the traffic source is the pod's local node,
 * OR if the traffic matches at least one ingress rule across all of
 * the network policies that select the pod.</li>
 * </ul>
 * <p>
 * Network policies do not conflict; they are additive.
 * If any policy or policies apply to a given pod for a given
 * direction, the connections allowed in that direction from
 * that pod is the union of what the applicable policies allow.
 * Thus, order of evaluation does not affect the policy result.
 * <p>
 * For a connection from a source pod to a destination pod to be allowed,
 * both the egress policy on the source pod and the ingress policy on the
 * destination pod need to allow the connection.
 * If either side does not allow the connection, it will not happen.
 * <p>
 * @see <a href="https://kubernetes.io/docs/concepts/services-networking/network-policies/#networkpolicy-resource">https://kubernetes.io/docs/concepts/services-networking/network-policies/#networkpolicy-resource</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-11T03:08:15.840Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus23.$Module.class, fqn = "cdk8s-plus-23.NetworkPolicy")
public class NetworkPolicy extends org.cdk8s.plus23.Resource {

    protected NetworkPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NetworkPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable org.cdk8s.plus23.NetworkPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NetworkPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Allow outgoing traffic to the peer.
     * <p>
     * If ports are not passed, traffic will be allowed on all ports.
     * <p>
     * @param peer This parameter is required.
     * @param ports
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addEgressRule(final @org.jetbrains.annotations.NotNull org.cdk8s.plus23.INetworkPolicyPeer peer, final @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.plus23.NetworkPolicyPort> ports) {
        software.amazon.jsii.Kernel.call(this, "addEgressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), ports });
    }

    /**
     * Allow outgoing traffic to the peer.
     * <p>
     * If ports are not passed, traffic will be allowed on all ports.
     * <p>
     * @param peer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addEgressRule(final @org.jetbrains.annotations.NotNull org.cdk8s.plus23.INetworkPolicyPeer peer) {
        software.amazon.jsii.Kernel.call(this, "addEgressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required") });
    }

    /**
     * Allow incoming traffic from the peer.
     * <p>
     * If ports are not passed, traffic will be allowed on all ports.
     * <p>
     * @param peer This parameter is required.
     * @param ports
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addIngressRule(final @org.jetbrains.annotations.NotNull org.cdk8s.plus23.INetworkPolicyPeer peer, final @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.plus23.NetworkPolicyPort> ports) {
        software.amazon.jsii.Kernel.call(this, "addIngressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), ports });
    }

    /**
     * Allow incoming traffic from the peer.
     * <p>
     * If ports are not passed, traffic will be allowed on all ports.
     * <p>
     * @param peer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addIngressRule(final @org.jetbrains.annotations.NotNull org.cdk8s.plus23.INetworkPolicyPeer peer) {
        software.amazon.jsii.Kernel.call(this, "addIngressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required") });
    }

    /**
     * The underlying cdk8s API object.
     * <p>
     * @see <a href="base.Resource.apiObject">base.Resource.apiObject</a>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull org.cdk8s.ApiObject getApiObject() {
        return software.amazon.jsii.Kernel.get(this, "apiObject", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObject.class));
    }

    /**
     * The name of a resource type as it appears in the relevant API endpoint.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceType() {
        return software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus23.NetworkPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus23.NetworkPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private org.cdk8s.plus23.NetworkPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props().metadata(metadata);
            return this;
        }

        /**
         * Egress traffic configuration.
         * <p>
         * Default: - the policy doesn't change egress behavior of the pods it selects.
         * <p>
         * @return {@code this}
         * @param egress Egress traffic configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder egress(final org.cdk8s.plus23.NetworkPolicyTraffic egress) {
            this.props().egress(egress);
            return this;
        }

        /**
         * Ingress traffic configuration.
         * <p>
         * Default: - the policy doesn't change ingress behavior of the pods it selects.
         * <p>
         * @return {@code this}
         * @param ingress Ingress traffic configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingress(final org.cdk8s.plus23.NetworkPolicyTraffic ingress) {
            this.props().ingress(ingress);
            return this;
        }

        /**
         * Which pods does this policy object applies to.
         * <p>
         * This can either be a single pod / workload, or a grouping of pods selected
         * via the <code>Pods.select</code> function. Rules is applied to any pods selected by this property.
         * Multiple network policies can select the same set of pods.
         * In this case, the rules for each are combined additively.
         * <p>
         * Note that
         * <p>
         * Default: - will select all pods in the namespace of the policy.
         * <p>
         * @return {@code this}
         * @param selector Which pods does this policy object applies to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selector(final org.cdk8s.plus23.IPodSelector selector) {
            this.props().selector(selector);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus23.NetworkPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus23.NetworkPolicy build() {
            return new org.cdk8s.plus23.NetworkPolicy(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private org.cdk8s.plus23.NetworkPolicyProps.Builder props() {
            if (this.props == null) {
                this.props = new org.cdk8s.plus23.NetworkPolicyProps.Builder();
            }
            return this.props;
        }
    }
}
