package org.cdk8s.plus23;

/**
 * Properties for `Service`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-11T03:08:15.916Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus23.$Module.class, fqn = "cdk8s-plus-23.ServiceProps")
@software.amazon.jsii.Jsii.Proxy(ServiceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServiceProps extends software.amazon.jsii.JsiiSerializable, org.cdk8s.plus23.ResourceProps {

    /**
     * The IP address of the service and is usually assigned randomly by the master.
     * <p>
     * If an address is specified manually and is not in use by others, it
     * will be allocated to the service; otherwise, creation of the service will
     * fail. This field can not be changed through updates. Valid values are
     * "None", empty string (""), or a valid IP address. "None" can be specified
     * for headless services when proxying is not required. Only applies to types
     * ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName.
     * <p>
     * Default: - Automatically assigned.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies">https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterIP() {
        return null;
    }

    /**
     * A list of IP addresses for which nodes in the cluster will also accept traffic for this service.
     * <p>
     * These IPs are not managed by Kubernetes. The user
     * is responsible for ensuring that traffic arrives at a node with this IP. A
     * common example is external load-balancers that are not part of the
     * Kubernetes system.
     * <p>
     * Default: - No external IPs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExternalIPs() {
        return null;
    }

    /**
     * The externalName to be used when ServiceType.EXTERNAL_NAME is set.
     * <p>
     * Default: - No external name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExternalName() {
        return null;
    }

    /**
     * A list of CIDR IP addresses, if specified and supported by the platform, will restrict traffic through the cloud-provider load-balancer to the specified client IPs.
     * <p>
     * More info: https://kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLoadBalancerSourceRanges() {
        return null;
    }

    /**
     * The ports this service binds to.
     * <p>
     * If the selector of the service is a managed pod / workload,
     * its ports will are automatically extracted and used as the default value.
     * Otherwise, no ports are bound.
     * <p>
     * Default: - either the selector ports, or none.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.plus23.ServicePort> getPorts() {
        return null;
    }

    /**
     * Which pods should the service select and route to.
     * <p>
     * You can pass one of the following:
     * <p>
     * <ul>
     * <li>An instance of <code>Pod</code> or any workload resource (e.g <code>Deployment</code>, <code>StatefulSet</code>, ...)</li>
     * <li>Pods selected by the <code>Pods.select</code> function. Note that in this case only labels can be specified.</li>
     * </ul>
     * <p>
     * Default: - unset, the service is assumed to have an external process managing
     * its endpoints, which Kubernetes will not modify.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // select the pods of a specific deployment
     * const backend = new kplus.Deployment(this, 'Backend', ...);
     * new kplus.Service(this, 'Service', { selector: backend });
     * // select all pods labeled with the `tier=backend` label
     * const backend = kplus.Pod.labeled({ tier: 'backend' });
     * new kplus.Service(this, 'Service', { selector: backend });
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus23.IPodSelector getSelector() {
        return null;
    }

    /**
     * Determines how the Service is exposed.
     * <p>
     * More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
     * <p>
     * Default: ServiceType.ClusterIP
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus23.ServiceType getType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ServiceProps> {
        java.lang.String clusterIp;
        java.util.List<java.lang.String> externalIPs;
        java.lang.String externalName;
        java.util.List<java.lang.String> loadBalancerSourceRanges;
        java.util.List<org.cdk8s.plus23.ServicePort> ports;
        org.cdk8s.plus23.IPodSelector selector;
        org.cdk8s.plus23.ServiceType type;
        org.cdk8s.ApiObjectMetadata metadata;

        /**
         * Sets the value of {@link ServiceProps#getClusterIp}
         * @param clusterIp The IP address of the service and is usually assigned randomly by the master.
         *                  If an address is specified manually and is not in use by others, it
         *                  will be allocated to the service; otherwise, creation of the service will
         *                  fail. This field can not be changed through updates. Valid values are
         *                  "None", empty string (""), or a valid IP address. "None" can be specified
         *                  for headless services when proxying is not required. Only applies to types
         *                  ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterIp(java.lang.String clusterIp) {
            this.clusterIp = clusterIp;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getExternalIPs}
         * @param externalIPs A list of IP addresses for which nodes in the cluster will also accept traffic for this service.
         *                    These IPs are not managed by Kubernetes. The user
         *                    is responsible for ensuring that traffic arrives at a node with this IP. A
         *                    common example is external load-balancers that are not part of the
         *                    Kubernetes system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder externalIPs(java.util.List<java.lang.String> externalIPs) {
            this.externalIPs = externalIPs;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getExternalName}
         * @param externalName The externalName to be used when ServiceType.EXTERNAL_NAME is set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder externalName(java.lang.String externalName) {
            this.externalName = externalName;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getLoadBalancerSourceRanges}
         * @param loadBalancerSourceRanges A list of CIDR IP addresses, if specified and supported by the platform, will restrict traffic through the cloud-provider load-balancer to the specified client IPs.
         *                                 More info: https://kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerSourceRanges(java.util.List<java.lang.String> loadBalancerSourceRanges) {
            this.loadBalancerSourceRanges = loadBalancerSourceRanges;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getPorts}
         * @param ports The ports this service binds to.
         *              If the selector of the service is a managed pod / workload,
         *              its ports will are automatically extracted and used as the default value.
         *              Otherwise, no ports are bound.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder ports(java.util.List<? extends org.cdk8s.plus23.ServicePort> ports) {
            this.ports = (java.util.List<org.cdk8s.plus23.ServicePort>)ports;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getSelector}
         * @param selector Which pods should the service select and route to.
         *                 You can pass one of the following:
         *                 <p>
         *                 <ul>
         *                 <li>An instance of <code>Pod</code> or any workload resource (e.g <code>Deployment</code>, <code>StatefulSet</code>, ...)</li>
         *                 <li>Pods selected by the <code>Pods.select</code> function. Note that in this case only labels can be specified.</li>
         *                 </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selector(org.cdk8s.plus23.IPodSelector selector) {
            this.selector = selector;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getType}
         * @param type Determines how the Service is exposed.
         *             More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(org.cdk8s.plus23.ServiceType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getMetadata}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(org.cdk8s.ApiObjectMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServiceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ServiceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceProps {
        private final java.lang.String clusterIp;
        private final java.util.List<java.lang.String> externalIPs;
        private final java.lang.String externalName;
        private final java.util.List<java.lang.String> loadBalancerSourceRanges;
        private final java.util.List<org.cdk8s.plus23.ServicePort> ports;
        private final org.cdk8s.plus23.IPodSelector selector;
        private final org.cdk8s.plus23.ServiceType type;
        private final org.cdk8s.ApiObjectMetadata metadata;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterIp = software.amazon.jsii.Kernel.get(this, "clusterIP", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.externalIPs = software.amazon.jsii.Kernel.get(this, "externalIPs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.externalName = software.amazon.jsii.Kernel.get(this, "externalName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loadBalancerSourceRanges = software.amazon.jsii.Kernel.get(this, "loadBalancerSourceRanges", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.ports = software.amazon.jsii.Kernel.get(this, "ports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.ServicePort.class)));
            this.selector = software.amazon.jsii.Kernel.get(this, "selector", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.IPodSelector.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.ServiceType.class));
            this.metadata = software.amazon.jsii.Kernel.get(this, "metadata", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObjectMetadata.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterIp = builder.clusterIp;
            this.externalIPs = builder.externalIPs;
            this.externalName = builder.externalName;
            this.loadBalancerSourceRanges = builder.loadBalancerSourceRanges;
            this.ports = (java.util.List<org.cdk8s.plus23.ServicePort>)builder.ports;
            this.selector = builder.selector;
            this.type = builder.type;
            this.metadata = builder.metadata;
        }

        @Override
        public final java.lang.String getClusterIP() {
            return this.clusterIp;
        }

        @Override
        public final java.util.List<java.lang.String> getExternalIPs() {
            return this.externalIPs;
        }

        @Override
        public final java.lang.String getExternalName() {
            return this.externalName;
        }

        @Override
        public final java.util.List<java.lang.String> getLoadBalancerSourceRanges() {
            return this.loadBalancerSourceRanges;
        }

        @Override
        public final java.util.List<org.cdk8s.plus23.ServicePort> getPorts() {
            return this.ports;
        }

        @Override
        public final org.cdk8s.plus23.IPodSelector getSelector() {
            return this.selector;
        }

        @Override
        public final org.cdk8s.plus23.ServiceType getType() {
            return this.type;
        }

        @Override
        public final org.cdk8s.ApiObjectMetadata getMetadata() {
            return this.metadata;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getClusterIP() != null) {
                data.set("clusterIP", om.valueToTree(this.getClusterIP()));
            }
            if (this.getExternalIPs() != null) {
                data.set("externalIPs", om.valueToTree(this.getExternalIPs()));
            }
            if (this.getExternalName() != null) {
                data.set("externalName", om.valueToTree(this.getExternalName()));
            }
            if (this.getLoadBalancerSourceRanges() != null) {
                data.set("loadBalancerSourceRanges", om.valueToTree(this.getLoadBalancerSourceRanges()));
            }
            if (this.getPorts() != null) {
                data.set("ports", om.valueToTree(this.getPorts()));
            }
            if (this.getSelector() != null) {
                data.set("selector", om.valueToTree(this.getSelector()));
            }
            if (this.getType() != null) {
                data.set("type", om.valueToTree(this.getType()));
            }
            if (this.getMetadata() != null) {
                data.set("metadata", om.valueToTree(this.getMetadata()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus-23.ServiceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServiceProps.Jsii$Proxy that = (ServiceProps.Jsii$Proxy) o;

            if (this.clusterIp != null ? !this.clusterIp.equals(that.clusterIp) : that.clusterIp != null) return false;
            if (this.externalIPs != null ? !this.externalIPs.equals(that.externalIPs) : that.externalIPs != null) return false;
            if (this.externalName != null ? !this.externalName.equals(that.externalName) : that.externalName != null) return false;
            if (this.loadBalancerSourceRanges != null ? !this.loadBalancerSourceRanges.equals(that.loadBalancerSourceRanges) : that.loadBalancerSourceRanges != null) return false;
            if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) return false;
            if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) return false;
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
            return this.metadata != null ? this.metadata.equals(that.metadata) : that.metadata == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clusterIp != null ? this.clusterIp.hashCode() : 0;
            result = 31 * result + (this.externalIPs != null ? this.externalIPs.hashCode() : 0);
            result = 31 * result + (this.externalName != null ? this.externalName.hashCode() : 0);
            result = 31 * result + (this.loadBalancerSourceRanges != null ? this.loadBalancerSourceRanges.hashCode() : 0);
            result = 31 * result + (this.ports != null ? this.ports.hashCode() : 0);
            result = 31 * result + (this.selector != null ? this.selector.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
            return result;
        }
    }
}
