package org.cdk8s.plus23;

/**
 * A Deployment provides declarative updates for Pods and ReplicaSets.
 * <p>
 * You describe a desired state in a Deployment, and the Deployment Controller changes the actual
 * state to the desired state at a controlled rate. You can define Deployments to create new ReplicaSets, or to remove
 * existing Deployments and adopt all their resources with new Deployments.
 * <p>
 * <blockquote>
 * <p>
 * Note: Do not manage ReplicaSets owned by a Deployment. Consider opening an issue in the main Kubernetes repository if your use case is not covered below.
 * <p>
 * </blockquote>
 * <p>
 * <h2>Use Case</h2>
 * <p>
 * The following are typical use cases for Deployments:
 * <p>
 * <ul>
 * <li>Create a Deployment to rollout a ReplicaSet. The ReplicaSet creates Pods in the background.
 * Check the status of the rollout to see if it succeeds or not.</li>
 * <li>Declare the new state of the Pods by updating the PodTemplateSpec of the Deployment.
 * A new ReplicaSet is created and the Deployment manages moving the Pods from the old ReplicaSet to the new one at a controlled rate.
 * Each new ReplicaSet updates the revision of the Deployment.</li>
 * <li>Rollback to an earlier Deployment revision if the current state of the Deployment is not stable.
 * Each rollback updates the revision of the Deployment.</li>
 * <li>Scale up the Deployment to facilitate more load.</li>
 * <li>Pause the Deployment to apply multiple fixes to its PodTemplateSpec and then resume it to start a new rollout.</li>
 * <li>Use the status of the Deployment as an indicator that a rollout has stuck.</li>
 * <li>Clean up older ReplicaSets that you don't need anymore.</li>
 * </ul>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.62.0 (build 293ac17)", date = "2022-07-14T03:00:06.544Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus23.$Module.class, fqn = "cdk8s-plus-23.Deployment")
public class Deployment extends org.cdk8s.plus23.Workload {

    protected Deployment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Deployment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Deployment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable org.cdk8s.plus23.DeploymentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Deployment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Expose a deployment via an ingress.
     * <p>
     * This will first expose the deployment with a service, and then expose the service via an ingress.
     * <p>
     * @param path The ingress path to register under. This parameter is required.
     * @param options Additional options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus23.Ingress exposeViaIngress(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable org.cdk8s.plus23.ExposeDeploymentViaIngressOptions options) {
        return software.amazon.jsii.Kernel.call(this, "exposeViaIngress", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.Ingress.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * Expose a deployment via an ingress.
     * <p>
     * This will first expose the deployment with a service, and then expose the service via an ingress.
     * <p>
     * @param path The ingress path to register under. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus23.Ingress exposeViaIngress(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.Kernel.call(this, "exposeViaIngress", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.Ingress.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Expose a deployment via a service.
     * <p>
     * This is equivalent to running <code>kubectl expose deployment &lt;deployment-name&gt;</code>.
     * <p>
     * @param options Options to determine details of the service and port exposed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus23.Service exposeViaService(final @org.jetbrains.annotations.Nullable org.cdk8s.plus23.DeploymentExposeViaServiceOptions options) {
        return software.amazon.jsii.Kernel.call(this, "exposeViaService", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.Service.class), new Object[] { options });
    }

    /**
     * Expose a deployment via a service.
     * <p>
     * This is equivalent to running <code>kubectl expose deployment &lt;deployment-name&gt;</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus23.Service exposeViaService() {
        return software.amazon.jsii.Kernel.call(this, "exposeViaService", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.Service.class));
    }

    /**
     * The underlying cdk8s API object.
     * <p>
     * @see <a href="base.Resource.apiObject">base.Resource.apiObject</a>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull org.cdk8s.ApiObject getApiObject() {
        return software.amazon.jsii.Kernel.get(this, "apiObject", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObject.class));
    }

    /**
     * Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.Duration getMinReady() {
        return software.amazon.jsii.Kernel.get(this, "minReady", software.amazon.jsii.NativeType.forClass(org.cdk8s.Duration.class));
    }

    /**
     * The maximum duration for a deployment to make progress before it is considered to be failed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.Duration getProgressDeadline() {
        return software.amazon.jsii.Kernel.get(this, "progressDeadline", software.amazon.jsii.NativeType.forClass(org.cdk8s.Duration.class));
    }

    /**
     * Number of desired pods.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getReplicas() {
        return software.amazon.jsii.Kernel.get(this, "replicas", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The name of a resource type as it appears in the relevant API endpoint.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceType() {
        return software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus23.DeploymentStrategy getStrategy() {
        return software.amazon.jsii.Kernel.get(this, "strategy", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.DeploymentStrategy.class));
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus23.Deployment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus23.Deployment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private org.cdk8s.plus23.DeploymentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props().metadata(metadata);
            return this;
        }

        /**
         * Indicates whether a service account token should be automatically mounted.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server">https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server</a>
         * @param automountServiceAccountToken Indicates whether a service account token should be automatically mounted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automountServiceAccountToken(final java.lang.Boolean automountServiceAccountToken) {
            this.props().automountServiceAccountToken(automountServiceAccountToken);
            return this;
        }

        /**
         * List of containers belonging to the pod.
         * <p>
         * Containers cannot currently be
         * added or removed. There must be at least one container in a Pod.
         * <p>
         * You can add additionnal containers using <code>podSpec.addContainer()</code>
         * <p>
         * Default: - No containers. Note that a pod spec must include at least one container.
         * <p>
         * @return {@code this}
         * @param containers List of containers belonging to the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containers(final java.util.List<? extends org.cdk8s.plus23.ContainerProps> containers) {
            this.props().containers(containers);
            return this;
        }

        /**
         * DNS settings for the pod.
         * <p>
         * Default:  policy: DnsPolicy.CLUSTER_FIRST
         *  hostnameAsFQDN: false
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/">https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/</a>
         * @param dns DNS settings for the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dns(final org.cdk8s.plus23.PodDnsProps dns) {
            this.props().dns(dns);
            return this;
        }

        /**
         * A secret containing docker credentials for authenticating to a registry.
         * <p>
         * Default: - No auth. Images are assumed to be publicly available.
         * <p>
         * @return {@code this}
         * @param dockerRegistryAuth A secret containing docker credentials for authenticating to a registry. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerRegistryAuth(final org.cdk8s.plus23.DockerConfigSecret dockerRegistryAuth) {
            this.props().dockerRegistryAuth(dockerRegistryAuth);
            return this;
        }

        /**
         * HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
         * <p>
         * @return {@code this}
         * @param hostAliases HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostAliases(final java.util.List<? extends org.cdk8s.plus23.HostAlias> hostAliases) {
            this.props().hostAliases(hostAliases);
            return this;
        }

        /**
         * List of initialization containers belonging to the pod.
         * <p>
         * Init containers are executed in order prior to containers being started.
         * If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
         * The name for an init container or normal container must be unique among all containers.
         * Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
         * The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
         * for each resource type, and then using the max of of that value or the sum of the normal containers.
         * Limits are applied to init containers in a similar fashion.
         * <p>
         * Init containers cannot currently be added ,removed or updated.
         * <p>
         * Default: - No init containers.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/workloads/pods/init-containers/">https://kubernetes.io/docs/concepts/workloads/pods/init-containers/</a>
         * @param initContainers List of initialization containers belonging to the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initContainers(final java.util.List<? extends org.cdk8s.plus23.ContainerProps> initContainers) {
            this.props().initContainers(initContainers);
            return this;
        }

        /**
         * Restart policy for all containers within the pod.
         * <p>
         * Default: RestartPolicy.ALWAYS
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy">https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy</a>
         * @param restartPolicy Restart policy for all containers within the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartPolicy(final org.cdk8s.plus23.RestartPolicy restartPolicy) {
            this.props().restartPolicy(restartPolicy);
            return this;
        }

        /**
         * SecurityContext holds pod-level security attributes and common container settings.
         * <p>
         * Default:   fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
         *   ensureNonRoot: false
         * <p>
         * @return {@code this}
         * @param securityContext SecurityContext holds pod-level security attributes and common container settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityContext(final org.cdk8s.plus23.PodSecurityContextProps securityContext) {
            this.props().securityContext(securityContext);
            return this;
        }

        /**
         * A service account provides an identity for processes that run in a Pod.
         * <p>
         * When you (a human) access the cluster (for example, using kubectl), you are
         * authenticated by the apiserver as a particular User Account (currently this
         * is usually admin, unless your cluster administrator has customized your
         * cluster). Processes in containers inside pods can also contact the
         * apiserver. When they do, they are authenticated as a particular Service
         * Account (for example, default).
         * <p>
         * Default: - No service account.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/">https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/</a>
         * @param serviceAccount A service account provides an identity for processes that run in a Pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccount(final org.cdk8s.plus23.IServiceAccount serviceAccount) {
            this.props().serviceAccount(serviceAccount);
            return this;
        }

        /**
         * List of volumes that can be mounted by containers belonging to the pod.
         * <p>
         * You can also add volumes later using <code>podSpec.addVolume()</code>
         * <p>
         * Default: - No volumes.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/storage/volumes">https://kubernetes.io/docs/concepts/storage/volumes</a>
         * @param volumes List of volumes that can be mounted by containers belonging to the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(final java.util.List<? extends org.cdk8s.plus23.Volume> volumes) {
            this.props().volumes(volumes);
            return this;
        }

        /**
         * The pod metadata of this workload.
         * <p>
         * @return {@code this}
         * @param podMetadata The pod metadata of this workload. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder podMetadata(final org.cdk8s.ApiObjectMetadata podMetadata) {
            this.props().podMetadata(podMetadata);
            return this;
        }

        /**
         * Automatically allocates a pod label selector for this workload and add it to the pod metadata.
         * <p>
         * This ensures this workload manages pods created by
         * its pod template.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param select Automatically allocates a pod label selector for this workload and add it to the pod metadata. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder select(final java.lang.Boolean select) {
            this.props().select(select);
            return this;
        }

        /**
         * Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available.
         * <p>
         * Zero means the pod will be considered available as soon as it is ready.
         * <p>
         * Default: Duration.seconds(0)
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/workloads/controllers/deployment/#min-ready-seconds">https://kubernetes.io/docs/concepts/workloads/controllers/deployment/#min-ready-seconds</a>
         * @param minReady Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minReady(final org.cdk8s.Duration minReady) {
            this.props().minReady(minReady);
            return this;
        }

        /**
         * The maximum duration for a deployment to make progress before it is considered to be failed.
         * <p>
         * The deployment controller will continue
         * to process failed deployments and a condition with a ProgressDeadlineExceeded
         * reason will be surfaced in the deployment status.
         * <p>
         * Note that progress will not be estimated during the time a deployment is paused.
         * <p>
         * Default: Duration.seconds(600)
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/workloads/controllers/deployment/#progress-deadline-seconds">https://kubernetes.io/docs/concepts/workloads/controllers/deployment/#progress-deadline-seconds</a>
         * @param progressDeadline The maximum duration for a deployment to make progress before it is considered to be failed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder progressDeadline(final org.cdk8s.Duration progressDeadline) {
            this.props().progressDeadline(progressDeadline);
            return this;
        }

        /**
         * Number of desired pods.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param replicas Number of desired pods. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicas(final java.lang.Number replicas) {
            this.props().replicas(replicas);
            return this;
        }

        /**
         * Specifies the strategy used to replace old Pods by new ones.
         * <p>
         * Default: - RollingUpdate with maxSurge and maxUnavailable set to 25%.
         * <p>
         * @return {@code this}
         * @param strategy Specifies the strategy used to replace old Pods by new ones. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder strategy(final org.cdk8s.plus23.DeploymentStrategy strategy) {
            this.props().strategy(strategy);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus23.Deployment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus23.Deployment build() {
            return new org.cdk8s.plus23.Deployment(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private org.cdk8s.plus23.DeploymentProps.Builder props() {
            if (this.props == null) {
                this.props = new org.cdk8s.plus23.DeploymentProps.Builder();
            }
            return this.props;
        }
    }
}
