package org.cdk8s.plus23;

/**
 * Properties for `PersistentVolume`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.62.0 (build 293ac17)", date = "2022-07-14T03:00:06.623Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus23.$Module.class, fqn = "cdk8s-plus-23.PersistentVolumeProps")
@software.amazon.jsii.Jsii.Proxy(PersistentVolumeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PersistentVolumeProps extends software.amazon.jsii.JsiiSerializable, org.cdk8s.plus23.ResourceProps {

    /**
     * Contains all ways the volume can be mounted.
     * <p>
     * Default: - No access modes.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes">https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.plus23.PersistentVolumeAccessMode> getAccessModes() {
        return null;
    }

    /**
     * Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim.
     * <p>
     * Expected to be non-nil when bound.
     * <p>
     * Default: - Not bound to a specific claim.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding">https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus23.IPersistentVolumeClaim getClaim() {
        return null;
    }

    /**
     * A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid.
     * <p>
     * Default: - No options.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options">https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMountOptions() {
        return null;
    }

    /**
     * When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource.
     * <p>
     * The reclaim policy tells the cluster what to do with
     * the volume after it has been released of its claim.
     * <p>
     * Default: PersistentVolumeReclaimPolicy.RETAIN
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming">https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus23.PersistentVolumeReclaimPolicy getReclaimPolicy() {
        return null;
    }

    /**
     * What is the storage capacity of this volume.
     * <p>
     * Default: - No specified.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources">https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.Size getStorage() {
        return null;
    }

    /**
     * Name of StorageClass to which this persistent volume belongs.
     * <p>
     * Default: - Volume does not belong to any storage class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStorageClassName() {
        return null;
    }

    /**
     * Defines what type of volume is required by the claim.
     * <p>
     * Default: VolumeMode.FILE_SYSTEM
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus23.PersistentVolumeMode getVolumeMode() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PersistentVolumeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PersistentVolumeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PersistentVolumeProps> {
        java.util.List<org.cdk8s.plus23.PersistentVolumeAccessMode> accessModes;
        org.cdk8s.plus23.IPersistentVolumeClaim claim;
        java.util.List<java.lang.String> mountOptions;
        org.cdk8s.plus23.PersistentVolumeReclaimPolicy reclaimPolicy;
        org.cdk8s.Size storage;
        java.lang.String storageClassName;
        org.cdk8s.plus23.PersistentVolumeMode volumeMode;
        org.cdk8s.ApiObjectMetadata metadata;

        /**
         * Sets the value of {@link PersistentVolumeProps#getAccessModes}
         * @param accessModes Contains all ways the volume can be mounted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder accessModes(java.util.List<? extends org.cdk8s.plus23.PersistentVolumeAccessMode> accessModes) {
            this.accessModes = (java.util.List<org.cdk8s.plus23.PersistentVolumeAccessMode>)accessModes;
            return this;
        }

        /**
         * Sets the value of {@link PersistentVolumeProps#getClaim}
         * @param claim Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim.
         *              Expected to be non-nil when bound.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder claim(org.cdk8s.plus23.IPersistentVolumeClaim claim) {
            this.claim = claim;
            return this;
        }

        /**
         * Sets the value of {@link PersistentVolumeProps#getMountOptions}
         * @param mountOptions A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mountOptions(java.util.List<java.lang.String> mountOptions) {
            this.mountOptions = mountOptions;
            return this;
        }

        /**
         * Sets the value of {@link PersistentVolumeProps#getReclaimPolicy}
         * @param reclaimPolicy When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource.
         *                      The reclaim policy tells the cluster what to do with
         *                      the volume after it has been released of its claim.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reclaimPolicy(org.cdk8s.plus23.PersistentVolumeReclaimPolicy reclaimPolicy) {
            this.reclaimPolicy = reclaimPolicy;
            return this;
        }

        /**
         * Sets the value of {@link PersistentVolumeProps#getStorage}
         * @param storage What is the storage capacity of this volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storage(org.cdk8s.Size storage) {
            this.storage = storage;
            return this;
        }

        /**
         * Sets the value of {@link PersistentVolumeProps#getStorageClassName}
         * @param storageClassName Name of StorageClass to which this persistent volume belongs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageClassName(java.lang.String storageClassName) {
            this.storageClassName = storageClassName;
            return this;
        }

        /**
         * Sets the value of {@link PersistentVolumeProps#getVolumeMode}
         * @param volumeMode Defines what type of volume is required by the claim.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeMode(org.cdk8s.plus23.PersistentVolumeMode volumeMode) {
            this.volumeMode = volumeMode;
            return this;
        }

        /**
         * Sets the value of {@link PersistentVolumeProps#getMetadata}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(org.cdk8s.ApiObjectMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PersistentVolumeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PersistentVolumeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PersistentVolumeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PersistentVolumeProps {
        private final java.util.List<org.cdk8s.plus23.PersistentVolumeAccessMode> accessModes;
        private final org.cdk8s.plus23.IPersistentVolumeClaim claim;
        private final java.util.List<java.lang.String> mountOptions;
        private final org.cdk8s.plus23.PersistentVolumeReclaimPolicy reclaimPolicy;
        private final org.cdk8s.Size storage;
        private final java.lang.String storageClassName;
        private final org.cdk8s.plus23.PersistentVolumeMode volumeMode;
        private final org.cdk8s.ApiObjectMetadata metadata;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessModes = software.amazon.jsii.Kernel.get(this, "accessModes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.PersistentVolumeAccessMode.class)));
            this.claim = software.amazon.jsii.Kernel.get(this, "claim", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.IPersistentVolumeClaim.class));
            this.mountOptions = software.amazon.jsii.Kernel.get(this, "mountOptions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.reclaimPolicy = software.amazon.jsii.Kernel.get(this, "reclaimPolicy", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.PersistentVolumeReclaimPolicy.class));
            this.storage = software.amazon.jsii.Kernel.get(this, "storage", software.amazon.jsii.NativeType.forClass(org.cdk8s.Size.class));
            this.storageClassName = software.amazon.jsii.Kernel.get(this, "storageClassName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.volumeMode = software.amazon.jsii.Kernel.get(this, "volumeMode", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.PersistentVolumeMode.class));
            this.metadata = software.amazon.jsii.Kernel.get(this, "metadata", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObjectMetadata.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessModes = (java.util.List<org.cdk8s.plus23.PersistentVolumeAccessMode>)builder.accessModes;
            this.claim = builder.claim;
            this.mountOptions = builder.mountOptions;
            this.reclaimPolicy = builder.reclaimPolicy;
            this.storage = builder.storage;
            this.storageClassName = builder.storageClassName;
            this.volumeMode = builder.volumeMode;
            this.metadata = builder.metadata;
        }

        @Override
        public final java.util.List<org.cdk8s.plus23.PersistentVolumeAccessMode> getAccessModes() {
            return this.accessModes;
        }

        @Override
        public final org.cdk8s.plus23.IPersistentVolumeClaim getClaim() {
            return this.claim;
        }

        @Override
        public final java.util.List<java.lang.String> getMountOptions() {
            return this.mountOptions;
        }

        @Override
        public final org.cdk8s.plus23.PersistentVolumeReclaimPolicy getReclaimPolicy() {
            return this.reclaimPolicy;
        }

        @Override
        public final org.cdk8s.Size getStorage() {
            return this.storage;
        }

        @Override
        public final java.lang.String getStorageClassName() {
            return this.storageClassName;
        }

        @Override
        public final org.cdk8s.plus23.PersistentVolumeMode getVolumeMode() {
            return this.volumeMode;
        }

        @Override
        public final org.cdk8s.ApiObjectMetadata getMetadata() {
            return this.metadata;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccessModes() != null) {
                data.set("accessModes", om.valueToTree(this.getAccessModes()));
            }
            if (this.getClaim() != null) {
                data.set("claim", om.valueToTree(this.getClaim()));
            }
            if (this.getMountOptions() != null) {
                data.set("mountOptions", om.valueToTree(this.getMountOptions()));
            }
            if (this.getReclaimPolicy() != null) {
                data.set("reclaimPolicy", om.valueToTree(this.getReclaimPolicy()));
            }
            if (this.getStorage() != null) {
                data.set("storage", om.valueToTree(this.getStorage()));
            }
            if (this.getStorageClassName() != null) {
                data.set("storageClassName", om.valueToTree(this.getStorageClassName()));
            }
            if (this.getVolumeMode() != null) {
                data.set("volumeMode", om.valueToTree(this.getVolumeMode()));
            }
            if (this.getMetadata() != null) {
                data.set("metadata", om.valueToTree(this.getMetadata()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus-23.PersistentVolumeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PersistentVolumeProps.Jsii$Proxy that = (PersistentVolumeProps.Jsii$Proxy) o;

            if (this.accessModes != null ? !this.accessModes.equals(that.accessModes) : that.accessModes != null) return false;
            if (this.claim != null ? !this.claim.equals(that.claim) : that.claim != null) return false;
            if (this.mountOptions != null ? !this.mountOptions.equals(that.mountOptions) : that.mountOptions != null) return false;
            if (this.reclaimPolicy != null ? !this.reclaimPolicy.equals(that.reclaimPolicy) : that.reclaimPolicy != null) return false;
            if (this.storage != null ? !this.storage.equals(that.storage) : that.storage != null) return false;
            if (this.storageClassName != null ? !this.storageClassName.equals(that.storageClassName) : that.storageClassName != null) return false;
            if (this.volumeMode != null ? !this.volumeMode.equals(that.volumeMode) : that.volumeMode != null) return false;
            return this.metadata != null ? this.metadata.equals(that.metadata) : that.metadata == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessModes != null ? this.accessModes.hashCode() : 0;
            result = 31 * result + (this.claim != null ? this.claim.hashCode() : 0);
            result = 31 * result + (this.mountOptions != null ? this.mountOptions.hashCode() : 0);
            result = 31 * result + (this.reclaimPolicy != null ? this.reclaimPolicy.hashCode() : 0);
            result = 31 * result + (this.storage != null ? this.storage.hashCode() : 0);
            result = 31 * result + (this.storageClassName != null ? this.storageClassName.hashCode() : 0);
            result = 31 * result + (this.volumeMode != null ? this.volumeMode.hashCode() : 0);
            result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
            return result;
        }
    }
}
