package org.cdk8s.plus23;

/**
 * Create a secret for storing a TLS certificate and its associated key.
 * <p>
 * @see <a href="https://kubernetes.io/docs/concepts/configuration/secret/#tls-secrets">https://kubernetes.io/docs/concepts/configuration/secret/#tls-secrets</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.62.0 (build 293ac17)", date = "2022-07-14T03:00:06.662Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus23.$Module.class, fqn = "cdk8s-plus-23.TlsSecret")
public class TlsSecret extends org.cdk8s.plus23.Secret {

    protected TlsSecret(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TlsSecret(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public TlsSecret(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull org.cdk8s.plus23.TlsSecretProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus23.TlsSecret}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus23.TlsSecret> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final org.cdk8s.plus23.TlsSecretProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new org.cdk8s.plus23.TlsSecretProps.Builder();
        }

        /**
         * Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props.metadata(metadata);
            return this;
        }

        /**
         * If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).
         * <p>
         * If not set to true, the field can be modified at any time.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param immutable If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder immutable(final java.lang.Boolean immutable) {
            this.props.immutable(immutable);
            return this;
        }

        /**
         * The TLS cert.
         * <p>
         * @return {@code this}
         * @param tlsCert The TLS cert. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsCert(final java.lang.String tlsCert) {
            this.props.tlsCert(tlsCert);
            return this;
        }

        /**
         * The TLS key.
         * <p>
         * @return {@code this}
         * @param tlsKey The TLS key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsKey(final java.lang.String tlsKey) {
            this.props.tlsKey(tlsKey);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus23.TlsSecret}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus23.TlsSecret build() {
            return new org.cdk8s.plus23.TlsSecret(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
