package org.cdk8s.plus23;

/**
 * A Job creates one or more Pods and ensures that a specified number of them successfully terminate.
 * <p>
 * As pods successfully complete,
 * the Job tracks the successful completions. When a specified number of successful completions is reached, the task (ie, Job) is complete.
 * Deleting a Job will clean up the Pods it created. A simple case is to create one Job object in order to reliably run one Pod to completion.
 * The Job object will start a new Pod if the first Pod fails or is deleted (for example due to a node hardware failure or a node reboot).
 * You can also use a Job to run multiple Pods in parallel.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.59.0 (build eb02c92)", date = "2022-06-04T02:42:52.066Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus23.$Module.class, fqn = "cdk8s-plus-23.Job")
public class Job extends org.cdk8s.plus23.Workload {

    protected Job(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Job(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Job(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable org.cdk8s.plus23.JobProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Job(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * The underlying cdk8s API object.
     * <p>
     * @see base.Resource.apiObject
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull org.cdk8s.ApiObject getApiObject() {
        return software.amazon.jsii.Kernel.get(this, "apiObject", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObject.class));
    }

    /**
     * The name of a resource type as it appears in the relevant API endpoint.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceType() {
        return software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Duration before job is terminated.
     * <p>
     * If undefined, there is no deadline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable org.cdk8s.Duration getActiveDeadline() {
        return software.amazon.jsii.Kernel.get(this, "activeDeadline", software.amazon.jsii.NativeType.forClass(org.cdk8s.Duration.class));
    }

    /**
     * Number of retries before marking failed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getBackoffLimit() {
        return software.amazon.jsii.Kernel.get(this, "backoffLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * TTL before the job is deleted after it is finished.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable org.cdk8s.Duration getTtlAfterFinished() {
        return software.amazon.jsii.Kernel.get(this, "ttlAfterFinished", software.amazon.jsii.NativeType.forClass(org.cdk8s.Duration.class));
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus23.Job}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus23.Job> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private org.cdk8s.plus23.JobProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props().metadata(metadata);
            return this;
        }

        /**
         * Indicates whether a service account token should be automatically mounted.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
         * @param automountServiceAccountToken Indicates whether a service account token should be automatically mounted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automountServiceAccountToken(final java.lang.Boolean automountServiceAccountToken) {
            this.props().automountServiceAccountToken(automountServiceAccountToken);
            return this;
        }

        /**
         * List of containers belonging to the pod.
         * <p>
         * Containers cannot currently be
         * added or removed. There must be at least one container in a Pod.
         * <p>
         * You can add additionnal containers using <code>podSpec.addContainer()</code>
         * <p>
         * Default: - No containers. Note that a pod spec must include at least one container.
         * <p>
         * @return {@code this}
         * @param containers List of containers belonging to the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containers(final java.util.List<? extends org.cdk8s.plus23.ContainerProps> containers) {
            this.props().containers(containers);
            return this;
        }

        /**
         * DNS settings for the pod.
         * <p>
         * Default:  policy: DnsPolicy.CLUSTER_FIRST
         *  hostnameAsFQDN: false
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
         * @param dns DNS settings for the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dns(final org.cdk8s.plus23.PodDnsProps dns) {
            this.props().dns(dns);
            return this;
        }

        /**
         * A secret containing docker credentials for authenticating to a registry.
         * <p>
         * Default: - No auth. Images are assumed to be publicly available.
         * <p>
         * @return {@code this}
         * @param dockerRegistryAuth A secret containing docker credentials for authenticating to a registry. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerRegistryAuth(final org.cdk8s.plus23.DockerConfigSecret dockerRegistryAuth) {
            this.props().dockerRegistryAuth(dockerRegistryAuth);
            return this;
        }

        /**
         * HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
         * <p>
         * @return {@code this}
         * @param hostAliases HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostAliases(final java.util.List<? extends org.cdk8s.plus23.HostAlias> hostAliases) {
            this.props().hostAliases(hostAliases);
            return this;
        }

        /**
         * List of initialization containers belonging to the pod.
         * <p>
         * Init containers are executed in order prior to containers being started.
         * If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
         * The name for an init container or normal container must be unique among all containers.
         * Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
         * The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
         * for each resource type, and then using the max of of that value or the sum of the normal containers.
         * Limits are applied to init containers in a similar fashion.
         * <p>
         * Init containers cannot currently be added ,removed or updated.
         * <p>
         * Default: - No init containers.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
         * @param initContainers List of initialization containers belonging to the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initContainers(final java.util.List<? extends org.cdk8s.plus23.ContainerProps> initContainers) {
            this.props().initContainers(initContainers);
            return this;
        }

        /**
         * Restart policy for all containers within the pod.
         * <p>
         * Default: RestartPolicy.ALWAYS
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
         * @param restartPolicy Restart policy for all containers within the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartPolicy(final org.cdk8s.plus23.RestartPolicy restartPolicy) {
            this.props().restartPolicy(restartPolicy);
            return this;
        }

        /**
         * SecurityContext holds pod-level security attributes and common container settings.
         * <p>
         * Default:   fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
         *   ensureNonRoot: false
         * <p>
         * @return {@code this}
         * @param securityContext SecurityContext holds pod-level security attributes and common container settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityContext(final org.cdk8s.plus23.PodSecurityContextProps securityContext) {
            this.props().securityContext(securityContext);
            return this;
        }

        /**
         * A service account provides an identity for processes that run in a Pod.
         * <p>
         * When you (a human) access the cluster (for example, using kubectl), you are
         * authenticated by the apiserver as a particular User Account (currently this
         * is usually admin, unless your cluster administrator has customized your
         * cluster). Processes in containers inside pods can also contact the
         * apiserver. When they do, they are authenticated as a particular Service
         * Account (for example, default).
         * <p>
         * Default: - No service account.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
         * @param serviceAccount A service account provides an identity for processes that run in a Pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccount(final org.cdk8s.plus23.IServiceAccount serviceAccount) {
            this.props().serviceAccount(serviceAccount);
            return this;
        }

        /**
         * List of volumes that can be mounted by containers belonging to the pod.
         * <p>
         * You can also add volumes later using <code>podSpec.addVolume()</code>
         * <p>
         * Default: - No volumes.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/storage/volumes
         * @param volumes List of volumes that can be mounted by containers belonging to the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(final java.util.List<? extends org.cdk8s.plus23.Volume> volumes) {
            this.props().volumes(volumes);
            return this;
        }

        /**
         * The pod metadata of this workload.
         * <p>
         * @return {@code this}
         * @param podMetadata The pod metadata of this workload. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder podMetadata(final org.cdk8s.ApiObjectMetadata podMetadata) {
            this.props().podMetadata(podMetadata);
            return this;
        }

        /**
         * Automatically allocates a pod label selector for this workload and add it to the pod metadata.
         * <p>
         * This ensures this workload manages pods created by
         * its pod template.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param select Automatically allocates a pod label selector for this workload and add it to the pod metadata. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder select(final java.lang.Boolean select) {
            this.props().select(select);
            return this;
        }

        /**
         * Specifies the duration the job may be active before the system tries to terminate it.
         * <p>
         * Default: - If unset, then there is no deadline.
         * <p>
         * @return {@code this}
         * @param activeDeadline Specifies the duration the job may be active before the system tries to terminate it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder activeDeadline(final org.cdk8s.Duration activeDeadline) {
            this.props().activeDeadline(activeDeadline);
            return this;
        }

        /**
         * Specifies the number of retries before marking this job failed.
         * <p>
         * Default: - If not set, system defaults to 6.
         * <p>
         * @return {@code this}
         * @param backoffLimit Specifies the number of retries before marking this job failed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backoffLimit(final java.lang.Number backoffLimit) {
            this.props().backoffLimit(backoffLimit);
            return this;
        }

        /**
         * Limits the lifetime of a Job that has finished execution (either Complete or Failed).
         * <p>
         * If this field is set, after the Job finishes, it is eligible to
         * be automatically deleted. When the Job is being deleted, its lifecycle
         * guarantees (e.g. finalizers) will be honored. If this field is set to zero,
         * the Job becomes eligible to be deleted immediately after it finishes. This
         * field is alpha-level and is only honored by servers that enable the
         * <code>TTLAfterFinished</code> feature.
         * <p>
         * Default: - If this field is unset, the Job won't be automatically deleted.
         * <p>
         * @return {@code this}
         * @param ttlAfterFinished Limits the lifetime of a Job that has finished execution (either Complete or Failed). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ttlAfterFinished(final org.cdk8s.Duration ttlAfterFinished) {
            this.props().ttlAfterFinished(ttlAfterFinished);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus23.Job}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus23.Job build() {
            return new org.cdk8s.plus23.Job(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private org.cdk8s.plus23.JobProps.Builder props() {
            if (this.props == null) {
                this.props = new org.cdk8s.plus23.JobProps.Builder();
            }
            return this.props;
        }
    }
}
