package org.cdk8s.plus23;

/**
 * Volume represents a named volume in a pod that may be accessed by any container in the pod.
 * <p>
 * Docker also has a concept of volumes, though it is somewhat looser and less
 * managed. In Docker, a volume is simply a directory on disk or in another
 * Container. Lifetimes are not managed and until very recently there were only
 * local-disk-backed volumes. Docker now provides volume drivers, but the
 * functionality is very limited for now (e.g. as of Docker 1.7 only one volume
 * driver is allowed per Container and there is no way to pass parameters to
 * volumes).
 * <p>
 * A Kubernetes volume, on the other hand, has an explicit lifetime - the same
 * as the Pod that encloses it. Consequently, a volume outlives any Containers
 * that run within the Pod, and data is preserved across Container restarts. Of
 * course, when a Pod ceases to exist, the volume will cease to exist, too.
 * Perhaps more importantly than this, Kubernetes supports many types of
 * volumes, and a Pod can use any number of them simultaneously.
 * <p>
 * At its core, a volume is just a directory, possibly with some data in it,
 * which is accessible to the Containers in a Pod. How that directory comes to
 * be, the medium that backs it, and the contents of it are determined by the
 * particular volume type used.
 * <p>
 * To use a volume, a Pod specifies what volumes to provide for the Pod (the
 * .spec.volumes field) and where to mount those into Containers (the
 * .spec.containers[*].volumeMounts field).
 * <p>
 * A process in a container sees a filesystem view composed from their Docker
 * image and volumes. The Docker image is at the root of the filesystem
 * hierarchy, and any volumes are mounted at the specified paths within the
 * image. Volumes can not mount onto other volumes
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.59.0 (build eb02c92)", date = "2022-06-04T02:42:52.142Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus23.$Module.class, fqn = "cdk8s-plus-23.Volume")
public class Volume extends software.constructs.Construct implements org.cdk8s.plus23.IStorage {

    protected Volume(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Volume(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Mounts an Amazon Web Services (AWS) EBS volume into your pod.
     * <p>
     * Unlike emptyDir, which is erased when a pod is removed, the contents of an EBS volume are
     * persisted and the volume is unmounted. This means that an EBS volume can be pre-populated with data,
     * and that data can be shared between pods.
     * <p>
     * There are some restrictions when using an awsElasticBlockStore volume:
     * <p>
     * <ul>
     * <li>the nodes on which pods are running must be AWS EC2 instances.</li>
     * <li>those instances need to be in the same region and availability zone as the EBS volume.</li>
     * <li>EBS only supports a single EC2 instance mounting a volume.</li>
     * </ul>
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param volumeId This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus23.Volume fromAwsElasticBlockStore(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String volumeId, final @org.jetbrains.annotations.Nullable org.cdk8s.plus23.AwsElasticBlockStoreVolumeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus23.Volume.class, "fromAwsElasticBlockStore", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.Volume.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(volumeId, "volumeId is required"), options });
    }

    /**
     * Mounts an Amazon Web Services (AWS) EBS volume into your pod.
     * <p>
     * Unlike emptyDir, which is erased when a pod is removed, the contents of an EBS volume are
     * persisted and the volume is unmounted. This means that an EBS volume can be pre-populated with data,
     * and that data can be shared between pods.
     * <p>
     * There are some restrictions when using an awsElasticBlockStore volume:
     * <p>
     * <ul>
     * <li>the nodes on which pods are running must be AWS EC2 instances.</li>
     * <li>those instances need to be in the same region and availability zone as the EBS volume.</li>
     * <li>EBS only supports a single EC2 instance mounting a volume.</li>
     * </ul>
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param volumeId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus23.Volume fromAwsElasticBlockStore(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String volumeId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus23.Volume.class, "fromAwsElasticBlockStore", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.Volume.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(volumeId, "volumeId is required") });
    }

    /**
     * Mounts a Microsoft Azure Data Disk into a pod.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param diskName This parameter is required.
     * @param diskUri This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus23.Volume fromAzureDisk(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String diskName, final @org.jetbrains.annotations.NotNull java.lang.String diskUri, final @org.jetbrains.annotations.Nullable org.cdk8s.plus23.AzureDiskVolumeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus23.Volume.class, "fromAzureDisk", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.Volume.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(diskName, "diskName is required"), java.util.Objects.requireNonNull(diskUri, "diskUri is required"), options });
    }

    /**
     * Mounts a Microsoft Azure Data Disk into a pod.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param diskName This parameter is required.
     * @param diskUri This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus23.Volume fromAzureDisk(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String diskName, final @org.jetbrains.annotations.NotNull java.lang.String diskUri) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus23.Volume.class, "fromAzureDisk", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.Volume.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(diskName, "diskName is required"), java.util.Objects.requireNonNull(diskUri, "diskUri is required") });
    }

    /**
     * Populate the volume from a ConfigMap.
     * <p>
     * The configMap resource provides a way to inject configuration data into
     * Pods. The data stored in a ConfigMap object can be referenced in a volume
     * of type configMap and then consumed by containerized applications running
     * in a Pod.
     * <p>
     * When referencing a configMap object, you can simply provide its name in the
     * volume to reference it. You can also customize the path to use for a
     * specific entry in the ConfigMap.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param configMap The config map to use to populate the volume. This parameter is required.
     * @param options Options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus23.Volume fromConfigMap(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull org.cdk8s.plus23.IConfigMap configMap, final @org.jetbrains.annotations.Nullable org.cdk8s.plus23.ConfigMapVolumeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus23.Volume.class, "fromConfigMap", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.Volume.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(configMap, "configMap is required"), options });
    }

    /**
     * Populate the volume from a ConfigMap.
     * <p>
     * The configMap resource provides a way to inject configuration data into
     * Pods. The data stored in a ConfigMap object can be referenced in a volume
     * of type configMap and then consumed by containerized applications running
     * in a Pod.
     * <p>
     * When referencing a configMap object, you can simply provide its name in the
     * volume to reference it. You can also customize the path to use for a
     * specific entry in the ConfigMap.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param configMap The config map to use to populate the volume. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus23.Volume fromConfigMap(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull org.cdk8s.plus23.IConfigMap configMap) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus23.Volume.class, "fromConfigMap", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.Volume.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(configMap, "configMap is required") });
    }

    /**
     * An emptyDir volume is first created when a Pod is assigned to a Node, and exists as long as that Pod is running on that node.
     * <p>
     * As the name says, it is
     * initially empty. Containers in the Pod can all read and write the same
     * files in the emptyDir volume, though that volume can be mounted at the same
     * or different paths in each Container. When a Pod is removed from a node for
     * any reason, the data in the emptyDir is deleted forever.
     * <p>
     * @see http://kubernetes.io/docs/user-guide/volumes#emptydir
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param name This parameter is required.
     * @param options - Additional options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus23.Volume fromEmptyDir(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable org.cdk8s.plus23.EmptyDirVolumeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus23.Volume.class, "fromEmptyDir", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.Volume.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(name, "name is required"), options });
    }

    /**
     * An emptyDir volume is first created when a Pod is assigned to a Node, and exists as long as that Pod is running on that node.
     * <p>
     * As the name says, it is
     * initially empty. Containers in the Pod can all read and write the same
     * files in the emptyDir volume, though that volume can be mounted at the same
     * or different paths in each Container. When a Pod is removed from a node for
     * any reason, the data in the emptyDir is deleted forever.
     * <p>
     * @see http://kubernetes.io/docs/user-guide/volumes#emptydir
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus23.Volume fromEmptyDir(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus23.Volume.class, "fromEmptyDir", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.Volume.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * Mounts a Google Compute Engine (GCE) persistent disk (PD) into your Pod.
     * <p>
     * Unlike emptyDir, which is erased when a pod is removed, the contents of a PD are
     * preserved and the volume is merely unmounted. This means that a PD can be pre-populated
     * with data, and that data can be shared between pods.
     * <p>
     * There are some restrictions when using a gcePersistentDisk:
     * <p>
     * <ul>
     * <li>the nodes on which Pods are running must be GCE VMs</li>
     * <li>those VMs need to be in the same GCE project and zone as the persistent disk</li>
     * </ul>
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param pdName This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus23.Volume fromGcePersistentDisk(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String pdName, final @org.jetbrains.annotations.Nullable org.cdk8s.plus23.GCEPersistentDiskVolumeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus23.Volume.class, "fromGcePersistentDisk", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.Volume.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(pdName, "pdName is required"), options });
    }

    /**
     * Mounts a Google Compute Engine (GCE) persistent disk (PD) into your Pod.
     * <p>
     * Unlike emptyDir, which is erased when a pod is removed, the contents of a PD are
     * preserved and the volume is merely unmounted. This means that a PD can be pre-populated
     * with data, and that data can be shared between pods.
     * <p>
     * There are some restrictions when using a gcePersistentDisk:
     * <p>
     * <ul>
     * <li>the nodes on which Pods are running must be GCE VMs</li>
     * <li>those VMs need to be in the same GCE project and zone as the persistent disk</li>
     * </ul>
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param pdName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus23.Volume fromGcePersistentDisk(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String pdName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus23.Volume.class, "fromGcePersistentDisk", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.Volume.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(pdName, "pdName is required") });
    }

    /**
     * Used to mount a PersistentVolume into a Pod.
     * <p>
     * PersistentVolumeClaims are a way for users to "claim" durable storage (such as a GCE PersistentDisk or an iSCSI volume)
     * without knowing the details of the particular cloud environment.
     * <p>
     * @see https://kubernetes.io/docs/concepts/storage/persistent-volumes/
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param claim This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus23.Volume fromPersistentVolumeClaim(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull org.cdk8s.plus23.IPersistentVolumeClaim claim, final @org.jetbrains.annotations.Nullable org.cdk8s.plus23.PersistentVolumeClaimVolumeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus23.Volume.class, "fromPersistentVolumeClaim", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.Volume.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(claim, "claim is required"), options });
    }

    /**
     * Used to mount a PersistentVolume into a Pod.
     * <p>
     * PersistentVolumeClaims are a way for users to "claim" durable storage (such as a GCE PersistentDisk or an iSCSI volume)
     * without knowing the details of the particular cloud environment.
     * <p>
     * @see https://kubernetes.io/docs/concepts/storage/persistent-volumes/
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param claim This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus23.Volume fromPersistentVolumeClaim(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull org.cdk8s.plus23.IPersistentVolumeClaim claim) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus23.Volume.class, "fromPersistentVolumeClaim", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.Volume.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(claim, "claim is required") });
    }

    /**
     * Populate the volume from a Secret.
     * <p>
     * A secret volume is used to pass sensitive information, such as passwords, to Pods.
     * You can store secrets in the Kubernetes API and mount them as files for use by pods
     * without coupling to Kubernetes directly.
     * <p>
     * secret volumes are backed by tmpfs (a RAM-backed filesystem)
     * so they are never written to non-volatile storage.
     * <p>
     * @see https://kubernetes.io/docs/concepts/storage/volumes/#secret
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param secr The secret to use to populate the volume. This parameter is required.
     * @param options Options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus23.Volume fromSecret(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull org.cdk8s.plus23.ISecret secr, final @org.jetbrains.annotations.Nullable org.cdk8s.plus23.SecretVolumeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus23.Volume.class, "fromSecret", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.Volume.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(secr, "secr is required"), options });
    }

    /**
     * Populate the volume from a Secret.
     * <p>
     * A secret volume is used to pass sensitive information, such as passwords, to Pods.
     * You can store secrets in the Kubernetes API and mount them as files for use by pods
     * without coupling to Kubernetes directly.
     * <p>
     * secret volumes are backed by tmpfs (a RAM-backed filesystem)
     * so they are never written to non-volatile storage.
     * <p>
     * @see https://kubernetes.io/docs/concepts/storage/volumes/#secret
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param secr The secret to use to populate the volume. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus23.Volume fromSecret(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull org.cdk8s.plus23.ISecret secr) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus23.Volume.class, "fromSecret", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.Volume.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(secr, "secr is required") });
    }

    /**
     * Convert the piece of storage into a concrete volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus23.Volume asVolume() {
        return software.amazon.jsii.Kernel.call(this, "asVolume", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus23.Volume.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
