package org.cdk8s.plus24;

/**
 * In Kubernetes, namespaces provides a mechanism for isolating groups of resources within a single cluster.
 * <p>
 * Names of resources need to be unique within a namespace, but not across namespaces.
 * Namespace-based scoping is applicable only for namespaced objects (e.g. Deployments, Services, etc) and
 * not for cluster-wide objects (e.g. StorageClass, Nodes, PersistentVolumes, etc).
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.59.0 (build eb02c92)", date = "2022-05-24T02:51:14.242Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus24.$Module.class, fqn = "cdk8s-plus-24.Namespace")
public class Namespace extends org.cdk8s.plus24.Resource implements org.cdk8s.plus24.INamespaceSelector {

    protected Namespace(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Namespace(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        NAME_LABEL = software.amazon.jsii.JsiiObject.jsiiStaticGet(org.cdk8s.plus24.Namespace.class, "NAME_LABEL", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Namespace(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable org.cdk8s.plus24.NamespaceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Namespace(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Return the configuration of this selector.
     * <p>
     * @see INamespaceSelector.toNamespaceSelectorConfig()
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus24.NamespaceSelectorConfig toNamespaceSelectorConfig() {
        return software.amazon.jsii.Kernel.call(this, "toNamespaceSelectorConfig", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus24.NamespaceSelectorConfig.class));
    }

    /**
     * @see https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/#automatic-labelling
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String NAME_LABEL;

    /**
     * The underlying cdk8s API object.
     * <p>
     * @see base.Resource.apiObject
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull org.cdk8s.ApiObject getApiObject() {
        return software.amazon.jsii.Kernel.get(this, "apiObject", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObject.class));
    }

    /**
     * The name of a resource type as it appears in the relevant API endpoint.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceType() {
        return software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus24.Namespace}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus24.Namespace> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private org.cdk8s.plus24.NamespaceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props().metadata(metadata);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus24.Namespace}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus24.Namespace build() {
            return new org.cdk8s.plus24.Namespace(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private org.cdk8s.plus24.NamespaceProps.Builder props() {
            if (this.props == null) {
                this.props = new org.cdk8s.plus24.NamespaceProps.Builder();
            }
            return this.props;
        }
    }
}
