package org.cdk8s.plus24;

/**
 * AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.59.0 (build eb02c92)", date = "2022-05-25T20:54:33.578Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus24.$Module.class, fqn = "cdk8s-plus-24.AzureDiskPersistentVolume")
public class AzureDiskPersistentVolume extends org.cdk8s.plus24.PersistentVolume {

    protected AzureDiskPersistentVolume(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AzureDiskPersistentVolume(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AzureDiskPersistentVolume(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull org.cdk8s.plus24.AzureDiskPersistentVolumeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Azure kind of this volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus24.AzureDiskPersistentVolumeKind getAzureKind() {
        return software.amazon.jsii.Kernel.get(this, "azureKind", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus24.AzureDiskPersistentVolumeKind.class));
    }

    /**
     * Caching mode of this volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus24.AzureDiskPersistentVolumeCachingMode getCachingMode() {
        return software.amazon.jsii.Kernel.get(this, "cachingMode", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus24.AzureDiskPersistentVolumeCachingMode.class));
    }

    /**
     * Disk name of this volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDiskName() {
        return software.amazon.jsii.Kernel.get(this, "diskName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Disk URI of this volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDiskUri() {
        return software.amazon.jsii.Kernel.get(this, "diskUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * File system type of this volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFsType() {
        return software.amazon.jsii.Kernel.get(this, "fsType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Whether or not it is mounted as a read-only volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getReadOnly() {
        return software.amazon.jsii.Kernel.get(this, "readOnly", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus24.AzureDiskPersistentVolume}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus24.AzureDiskPersistentVolume> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final org.cdk8s.plus24.AzureDiskPersistentVolumeProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new org.cdk8s.plus24.AzureDiskPersistentVolumeProps.Builder();
        }

        /**
         * Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props.metadata(metadata);
            return this;
        }

        /**
         * Contains all ways the volume can be mounted.
         * <p>
         * Default: - No access modes.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
         * @param accessModes Contains all ways the volume can be mounted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessModes(final java.util.List<? extends org.cdk8s.plus24.PersistentVolumeAccessMode> accessModes) {
            this.props.accessModes(accessModes);
            return this;
        }

        /**
         * Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim.
         * <p>
         * Expected to be non-nil when bound.
         * <p>
         * Default: - Not bound to a specific claim.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
         * @param claim Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder claim(final org.cdk8s.plus24.IPersistentVolumeClaim claim) {
            this.props.claim(claim);
            return this;
        }

        /**
         * A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid.
         * <p>
         * Default: - No options.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
         * @param mountOptions A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mountOptions(final java.util.List<java.lang.String> mountOptions) {
            this.props.mountOptions(mountOptions);
            return this;
        }

        /**
         * When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource.
         * <p>
         * The reclaim policy tells the cluster what to do with
         * the volume after it has been released of its claim.
         * <p>
         * Default: PersistentVolumeReclaimPolicy.RETAIN
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
         * @param reclaimPolicy When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reclaimPolicy(final org.cdk8s.plus24.PersistentVolumeReclaimPolicy reclaimPolicy) {
            this.props.reclaimPolicy(reclaimPolicy);
            return this;
        }

        /**
         * What is the storage capacity of this volume.
         * <p>
         * Default: - No specified.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
         * @param storage What is the storage capacity of this volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storage(final org.cdk8s.Size storage) {
            this.props.storage(storage);
            return this;
        }

        /**
         * Name of StorageClass to which this persistent volume belongs.
         * <p>
         * Default: - Volume does not belong to any storage class.
         * <p>
         * @return {@code this}
         * @param storageClassName Name of StorageClass to which this persistent volume belongs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageClassName(final java.lang.String storageClassName) {
            this.props.storageClassName(storageClassName);
            return this;
        }

        /**
         * Defines what type of volume is required by the claim.
         * <p>
         * Default: VolumeMode.FILE_SYSTEM
         * <p>
         * @return {@code this}
         * @param volumeMode Defines what type of volume is required by the claim. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeMode(final org.cdk8s.plus24.PersistentVolumeMode volumeMode) {
            this.props.volumeMode(volumeMode);
            return this;
        }

        /**
         * The Name of the data disk in the blob storage.
         * <p>
         * @return {@code this}
         * @param diskName The Name of the data disk in the blob storage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder diskName(final java.lang.String diskName) {
            this.props.diskName(diskName);
            return this;
        }

        /**
         * The URI the data disk in the blob storage.
         * <p>
         * @return {@code this}
         * @param diskUri The URI the data disk in the blob storage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder diskUri(final java.lang.String diskUri) {
            this.props.diskUri(diskUri);
            return this;
        }

        /**
         * Host Caching mode.
         * <p>
         * Default: - AzureDiskPersistentVolumeCachingMode.NONE.
         * <p>
         * @return {@code this}
         * @param cachingMode Host Caching mode. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachingMode(final org.cdk8s.plus24.AzureDiskPersistentVolumeCachingMode cachingMode) {
            this.props.cachingMode(cachingMode);
            return this;
        }

        /**
         * Filesystem type to mount.
         * <p>
         * Must be a filesystem type supported by the host operating system.
         * <p>
         * Default: 'ext4'
         * <p>
         * @return {@code this}
         * @param fsType Filesystem type to mount. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fsType(final java.lang.String fsType) {
            this.props.fsType(fsType);
            return this;
        }

        /**
         * Kind of disk.
         * <p>
         * Default: AzureDiskPersistentVolumeKind.SHARED
         * <p>
         * @return {@code this}
         * @param kind Kind of disk. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kind(final org.cdk8s.plus24.AzureDiskPersistentVolumeKind kind) {
            this.props.kind(kind);
            return this;
        }

        /**
         * Force the ReadOnly setting in VolumeMounts.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param readOnly Force the ReadOnly setting in VolumeMounts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readOnly(final java.lang.Boolean readOnly) {
            this.props.readOnly(readOnly);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus24.AzureDiskPersistentVolume}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus24.AzureDiskPersistentVolume build() {
            return new org.cdk8s.plus24.AzureDiskPersistentVolume(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
