package org.cdk8s.plus24;

/**
 * Describes a particular CIDR (Ex.
 * <p>
 * "192.168.1.1/24","2001:db9::/64") that is
 * allowed to the pods matched by a network policy selector.
 * The except entry describes CIDRs that should not be included within this rule.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-17T03:03:17.354Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus24.$Module.class, fqn = "cdk8s-plus-24.NetworkPolicyIpBlock")
public class NetworkPolicyIpBlock extends software.constructs.Construct implements org.cdk8s.plus24.INetworkPolicyPeer {

    protected NetworkPolicyIpBlock(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkPolicyIpBlock(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Any IPv4 address.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus24.NetworkPolicyIpBlock anyIpv4(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus24.NetworkPolicyIpBlock.class, "anyIpv4", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus24.NetworkPolicyIpBlock.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Any IPv6 address.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus24.NetworkPolicyIpBlock anyIpv6(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus24.NetworkPolicyIpBlock.class, "anyIpv6", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus24.NetworkPolicyIpBlock.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Create an IPv4 peer from a CIDR.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param cidrIp This parameter is required.
     * @param except
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus24.NetworkPolicyIpBlock ipv4(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String cidrIp, final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> except) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus24.NetworkPolicyIpBlock.class, "ipv4", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus24.NetworkPolicyIpBlock.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(cidrIp, "cidrIp is required"), except });
    }

    /**
     * Create an IPv4 peer from a CIDR.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param cidrIp This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus24.NetworkPolicyIpBlock ipv4(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String cidrIp) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus24.NetworkPolicyIpBlock.class, "ipv4", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus24.NetworkPolicyIpBlock.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(cidrIp, "cidrIp is required") });
    }

    /**
     * Create an IPv6 peer from a CIDR.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param cidrIp This parameter is required.
     * @param except
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus24.NetworkPolicyIpBlock ipv6(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String cidrIp, final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> except) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus24.NetworkPolicyIpBlock.class, "ipv6", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus24.NetworkPolicyIpBlock.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(cidrIp, "cidrIp is required"), except });
    }

    /**
     * Create an IPv6 peer from a CIDR.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param cidrIp This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus24.NetworkPolicyIpBlock ipv6(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String cidrIp) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus24.NetworkPolicyIpBlock.class, "ipv6", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus24.NetworkPolicyIpBlock.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(cidrIp, "cidrIp is required") });
    }

    /**
     * Return the configuration of this peer.
     * <p>
     * @see <a href="INetworkPolicyPeer.toNetworkPolicyPeerConfig()">INetworkPolicyPeer.toNetworkPolicyPeerConfig()</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus24.NetworkPolicyPeerConfig toNetworkPolicyPeerConfig() {
        return software.amazon.jsii.Kernel.call(this, "toNetworkPolicyPeerConfig", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus24.NetworkPolicyPeerConfig.class));
    }

    /**
     * Convert the peer into a pod selector, if possible.
     * <p>
     * @see <a href="INetworkPolicyPeer.toPodSelector()">INetworkPolicyPeer.toPodSelector()</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.Nullable org.cdk8s.plus24.IPodSelector toPodSelector() {
        return software.amazon.jsii.Kernel.call(this, "toPodSelector", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus24.IPodSelector.class));
    }

    /**
     * A string representing the IP Block Valid examples are "192.168.1.1/24" or "2001:db9::/64".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCidr() {
        return software.amazon.jsii.Kernel.get(this, "cidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A slice of CIDRs that should not be included within an IP Block Valid examples are "192.168.1.1/24" or "2001:db9::/64". Except values will be rejected if they are outside the CIDR range.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcept() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "except", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }
}
