package org.cdk8s.plus24;

/**
 * Create a secret for basic authentication.
 * <p>
 * @see <a href="https://kubernetes.io/docs/concepts/configuration/secret/#basic-authentication-secret">https://kubernetes.io/docs/concepts/configuration/secret/#basic-authentication-secret</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-25T03:33:25.115Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus24.$Module.class, fqn = "cdk8s-plus-24.BasicAuthSecret")
public class BasicAuthSecret extends org.cdk8s.plus24.Secret {

    protected BasicAuthSecret(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BasicAuthSecret(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public BasicAuthSecret(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull org.cdk8s.plus24.BasicAuthSecretProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus24.BasicAuthSecret}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus24.BasicAuthSecret> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final org.cdk8s.plus24.BasicAuthSecretProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new org.cdk8s.plus24.BasicAuthSecretProps.Builder();
        }

        /**
         * Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props.metadata(metadata);
            return this;
        }

        /**
         * If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).
         * <p>
         * If not set to true, the field can be modified at any time.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param immutable If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder immutable(final java.lang.Boolean immutable) {
            this.props.immutable(immutable);
            return this;
        }

        /**
         * The password or token for authentication.
         * <p>
         * @return {@code this}
         * @param password The password or token for authentication. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder password(final java.lang.String password) {
            this.props.password(password);
            return this;
        }

        /**
         * The user name for authentication.
         * <p>
         * @return {@code this}
         * @param username The user name for authentication. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder username(final java.lang.String username) {
            this.props.username(username);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus24.BasicAuthSecret}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus24.BasicAuthSecret build() {
            return new org.cdk8s.plus24.BasicAuthSecret(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
