package org.cdk8s.plus24;

/**
 * ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-25T03:33:25.129Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus24.$Module.class, fqn = "cdk8s-plus-24.ClusterRole")
public class ClusterRole extends org.cdk8s.plus24.Resource implements org.cdk8s.plus24.IClusterRole, org.cdk8s.plus24.IRole {

    protected ClusterRole(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ClusterRole(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ClusterRole(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable org.cdk8s.plus24.ClusterRoleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ClusterRole(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Imports a role from the cluster as a reference.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus24.IClusterRole fromClusterRoleName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus24.ClusterRole.class, "fromClusterRoleName", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus24.IClusterRole.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * Aggregate rules from roles matching this label selector.
     * <p>
     * @param key This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void aggregate(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.call(this, "aggregate", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Add permission to perform a list of HTTP verbs on a collection of resources.
     * <p>
     * @see <a href="https://kubernetes.io/docs/reference/access-authn-authz/authorization/#determine-the-request-verb">https://kubernetes.io/docs/reference/access-authn-authz/authorization/#determine-the-request-verb</a>
     * @param verbs This parameter is required.
     * @param endpoints The endpoints(s) to apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allow(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> verbs, final @org.jetbrains.annotations.NotNull org.cdk8s.plus24.IApiEndpoint... endpoints) {
        software.amazon.jsii.Kernel.call(this, "allow", software.amazon.jsii.NativeType.VOID, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(verbs, "verbs is required") }), java.util.Arrays.<Object>stream(endpoints)).toArray(Object[]::new));
    }

    /**
     * Add "create" permission for the resources.
     * <p>
     * @param endpoints The resource(s) to apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowCreate(final @org.jetbrains.annotations.NotNull org.cdk8s.plus24.IApiEndpoint... endpoints) {
        software.amazon.jsii.Kernel.call(this, "allowCreate", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(endpoints).toArray(Object[]::new));
    }

    /**
     * Add "delete" permission for the resources.
     * <p>
     * @param endpoints The resource(s) to apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowDelete(final @org.jetbrains.annotations.NotNull org.cdk8s.plus24.IApiEndpoint... endpoints) {
        software.amazon.jsii.Kernel.call(this, "allowDelete", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(endpoints).toArray(Object[]::new));
    }

    /**
     * Add "deletecollection" permission for the resources.
     * <p>
     * @param endpoints The resource(s) to apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowDeleteCollection(final @org.jetbrains.annotations.NotNull org.cdk8s.plus24.IApiEndpoint... endpoints) {
        software.amazon.jsii.Kernel.call(this, "allowDeleteCollection", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(endpoints).toArray(Object[]::new));
    }

    /**
     * Add "get" permission for the resources.
     * <p>
     * @param endpoints The resource(s) to apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowGet(final @org.jetbrains.annotations.NotNull org.cdk8s.plus24.IApiEndpoint... endpoints) {
        software.amazon.jsii.Kernel.call(this, "allowGet", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(endpoints).toArray(Object[]::new));
    }

    /**
     * Add "list" permission for the resources.
     * <p>
     * @param endpoints The resource(s) to apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowList(final @org.jetbrains.annotations.NotNull org.cdk8s.plus24.IApiEndpoint... endpoints) {
        software.amazon.jsii.Kernel.call(this, "allowList", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(endpoints).toArray(Object[]::new));
    }

    /**
     * Add "patch" permission for the resources.
     * <p>
     * @param endpoints The resource(s) to apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowPatch(final @org.jetbrains.annotations.NotNull org.cdk8s.plus24.IApiEndpoint... endpoints) {
        software.amazon.jsii.Kernel.call(this, "allowPatch", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(endpoints).toArray(Object[]::new));
    }

    /**
     * Add "get", "list", and "watch" permissions for the resources.
     * <p>
     * @param endpoints The resource(s) to apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowRead(final @org.jetbrains.annotations.NotNull org.cdk8s.plus24.IApiEndpoint... endpoints) {
        software.amazon.jsii.Kernel.call(this, "allowRead", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(endpoints).toArray(Object[]::new));
    }

    /**
     * Add "get", "list", "watch", "create", "update", "patch", "delete", and "deletecollection" permissions for the resources.
     * <p>
     * @param endpoints The resource(s) to apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowReadWrite(final @org.jetbrains.annotations.NotNull org.cdk8s.plus24.IApiEndpoint... endpoints) {
        software.amazon.jsii.Kernel.call(this, "allowReadWrite", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(endpoints).toArray(Object[]::new));
    }

    /**
     * Add "update" permission for the resources.
     * <p>
     * @param endpoints The resource(s) to apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowUpdate(final @org.jetbrains.annotations.NotNull org.cdk8s.plus24.IApiEndpoint... endpoints) {
        software.amazon.jsii.Kernel.call(this, "allowUpdate", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(endpoints).toArray(Object[]::new));
    }

    /**
     * Add "watch" permission for the resources.
     * <p>
     * @param endpoints The resource(s) to apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowWatch(final @org.jetbrains.annotations.NotNull org.cdk8s.plus24.IApiEndpoint... endpoints) {
        software.amazon.jsii.Kernel.call(this, "allowWatch", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(endpoints).toArray(Object[]::new));
    }

    /**
     * Create a ClusterRoleBinding that binds the permissions in this ClusterRole to a list of subjects, without namespace restrictions.
     * <p>
     * @param subjects a list of subjects to bind to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus24.ClusterRoleBinding bind(final @org.jetbrains.annotations.NotNull org.cdk8s.plus24.ISubject... subjects) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus24.ClusterRoleBinding.class), java.util.Arrays.<Object>stream(subjects).toArray(Object[]::new));
    }

    /**
     * Create a RoleBinding that binds the permissions in this ClusterRole to a list of subjects, that will only apply to the given namespace.
     * <p>
     * @param namespace the namespace to limit permissions to. This parameter is required.
     * @param subjects a list of subjects to bind to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus24.RoleBinding bindInNamespace(final @org.jetbrains.annotations.NotNull java.lang.String namespace, final @org.jetbrains.annotations.NotNull org.cdk8s.plus24.ISubject... subjects) {
        return software.amazon.jsii.Kernel.call(this, "bindInNamespace", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus24.RoleBinding.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(namespace, "namespace is required") }), java.util.Arrays.<Object>stream(subjects)).toArray(Object[]::new));
    }

    /**
     * Combines the rules of the argument ClusterRole into this ClusterRole using aggregation labels.
     * <p>
     * @param rol This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void combine(final @org.jetbrains.annotations.NotNull org.cdk8s.plus24.ClusterRole rol) {
        software.amazon.jsii.Kernel.call(this, "combine", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(rol, "rol is required") });
    }

    /**
     * The underlying cdk8s API object.
     * <p>
     * @see <a href="base.Resource.apiObject">base.Resource.apiObject</a>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull org.cdk8s.ApiObject getApiObject() {
        return software.amazon.jsii.Kernel.get(this, "apiObject", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObject.class));
    }

    /**
     * The name of a resource type as it appears in the relevant API endpoint.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceType() {
        return software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Rules associaated with this Role.
     * <p>
     * Returns a copy, use <code>allow</code> to add rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus24.ClusterRolePolicyRule> getRules() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus24.ClusterRolePolicyRule.class))));
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus24.ClusterRole}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus24.ClusterRole> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private org.cdk8s.plus24.ClusterRoleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props().metadata(metadata);
            return this;
        }

        /**
         * Specify labels that should be used to locate ClusterRoles, whose rules will be automatically filled into this ClusterRole's rules.
         * <p>
         * @return {@code this}
         * @param aggregationLabels Specify labels that should be used to locate ClusterRoles, whose rules will be automatically filled into this ClusterRole's rules. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aggregationLabels(final java.util.Map<java.lang.String, java.lang.String> aggregationLabels) {
            this.props().aggregationLabels(aggregationLabels);
            return this;
        }

        /**
         * A list of rules the role should allow.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param rules A list of rules the role should allow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rules(final java.util.List<? extends org.cdk8s.plus24.ClusterRolePolicyRule> rules) {
            this.props().rules(rules);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus24.ClusterRole}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus24.ClusterRole build() {
            return new org.cdk8s.plus24.ClusterRole(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private org.cdk8s.plus24.ClusterRoleProps.Builder props() {
            if (this.props == null) {
                this.props = new org.cdk8s.plus24.ClusterRoleProps.Builder();
            }
            return this.props;
        }
    }
}
