/*
 * Decompiled with CFR 0.152.
 */
package org.cdk8s.plus24;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cdk8s.ApiObject;
import org.cdk8s.ApiObjectMetadata;
import org.cdk8s.plus24.$Module;
import org.cdk8s.plus24.ExposeServiceViaIngressOptions;
import org.cdk8s.plus24.IPodSelector;
import org.cdk8s.plus24.Ingress;
import org.cdk8s.plus24.Resource;
import org.cdk8s.plus24.ServiceBindOptions;
import org.cdk8s.plus24.ServicePort;
import org.cdk8s.plus24.ServiceProps;
import org.cdk8s.plus24.ServiceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="cdk8s-plus-24.Service")
public class Service
extends Resource {
    protected Service(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Service(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Service(@NotNull Construct scope, @NotNull String id, @Nullable ServiceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Service(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void bind(@NotNull Number port, @Nullable ServiceBindOptions options) {
        Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(port, "port is required"), options});
    }

    public void bind(@NotNull Number port) {
        Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(port, "port is required")});
    }

    @NotNull
    public Ingress exposeViaIngress(@NotNull String path, @Nullable ExposeServiceViaIngressOptions options) {
        return (Ingress)Kernel.call((Object)this, (String)"exposeViaIngress", (NativeType)NativeType.forClass(Ingress.class), (Object[])new Object[]{Objects.requireNonNull(path, "path is required"), options});
    }

    @NotNull
    public Ingress exposeViaIngress(@NotNull String path) {
        return (Ingress)Kernel.call((Object)this, (String)"exposeViaIngress", (NativeType)NativeType.forClass(Ingress.class), (Object[])new Object[]{Objects.requireNonNull(path, "path is required")});
    }

    public void select(@NotNull IPodSelector selector) {
        Kernel.call((Object)this, (String)"select", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(selector, "selector is required")});
    }

    public void selectLabel(@NotNull String key, @NotNull String value) {
        Kernel.call((Object)this, (String)"selectLabel", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(key, "key is required"), Objects.requireNonNull(value, "value is required")});
    }

    @Override
    @NotNull
    protected ApiObject getApiObject() {
        return (ApiObject)Kernel.get((Object)this, (String)"apiObject", (NativeType)NativeType.forClass(ApiObject.class));
    }

    @NotNull
    public List<ServicePort> getPorts() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"ports", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(ServicePort.class))));
    }

    @Override
    @NotNull
    public String getResourceType() {
        return (String)Kernel.get((Object)this, (String)"resourceType", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public ServiceType getType() {
        return (ServiceType)((Object)Kernel.get((Object)this, (String)"type", (NativeType)NativeType.forClass(ServiceType.class)));
    }

    @Nullable
    public String getClusterIP() {
        return (String)Kernel.get((Object)this, (String)"clusterIP", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getExternalName() {
        return (String)Kernel.get((Object)this, (String)"externalName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Service> {
        private final Construct scope;
        private final String id;
        private ServiceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder metadata(ApiObjectMetadata metadata) {
            this.props().metadata(metadata);
            return this;
        }

        public Builder clusterIp(String clusterIp) {
            this.props().clusterIp(clusterIp);
            return this;
        }

        public Builder externalIPs(List<String> externalIPs) {
            this.props().externalIPs(externalIPs);
            return this;
        }

        public Builder externalName(String externalName) {
            this.props().externalName(externalName);
            return this;
        }

        public Builder loadBalancerSourceRanges(List<String> loadBalancerSourceRanges) {
            this.props().loadBalancerSourceRanges(loadBalancerSourceRanges);
            return this;
        }

        public Builder ports(List<? extends ServicePort> ports) {
            this.props().ports(ports);
            return this;
        }

        public Builder selector(IPodSelector selector) {
            this.props().selector(selector);
            return this;
        }

        public Builder type(ServiceType type) {
            this.props().type(type);
            return this;
        }

        public Service build() {
            return new Service(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private ServiceProps.Builder props() {
            if (this.props == null) {
                this.props = new ServiceProps.Builder();
            }
            return this.props;
        }
    }
}

