package org.cdk8s.plus24;

/**
 * Represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod.
 * <p>
 * @see <a href="https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore">https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.70.0 (build 03c2f6f)", date = "2022-10-25T03:00:29.087Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus24.$Module.class, fqn = "cdk8s-plus-24.AwsElasticBlockStorePersistentVolume")
public class AwsElasticBlockStorePersistentVolume extends org.cdk8s.plus24.PersistentVolume {

    protected AwsElasticBlockStorePersistentVolume(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AwsElasticBlockStorePersistentVolume(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AwsElasticBlockStorePersistentVolume(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull org.cdk8s.plus24.AwsElasticBlockStorePersistentVolumeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * File system type of this volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFsType() {
        return software.amazon.jsii.Kernel.get(this, "fsType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Whether or not it is mounted as a read-only volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getReadOnly() {
        return software.amazon.jsii.Kernel.get(this, "readOnly", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Volume id of this volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVolumeId() {
        return software.amazon.jsii.Kernel.get(this, "volumeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Partition of this volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPartition() {
        return software.amazon.jsii.Kernel.get(this, "partition", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus24.AwsElasticBlockStorePersistentVolume}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus24.AwsElasticBlockStorePersistentVolume> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final org.cdk8s.plus24.AwsElasticBlockStorePersistentVolumeProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new org.cdk8s.plus24.AwsElasticBlockStorePersistentVolumeProps.Builder();
        }

        /**
         * Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props.metadata(metadata);
            return this;
        }

        /**
         * Contains all ways the volume can be mounted.
         * <p>
         * Default: - No access modes.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes">https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes</a>
         * @param accessModes Contains all ways the volume can be mounted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessModes(final java.util.List<? extends org.cdk8s.plus24.PersistentVolumeAccessMode> accessModes) {
            this.props.accessModes(accessModes);
            return this;
        }

        /**
         * Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim.
         * <p>
         * Expected to be non-nil when bound.
         * <p>
         * Default: - Not bound to a specific claim.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding">https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding</a>
         * @param claim Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder claim(final org.cdk8s.plus24.IPersistentVolumeClaim claim) {
            this.props.claim(claim);
            return this;
        }

        /**
         * A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid.
         * <p>
         * Default: - No options.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options">https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options</a>
         * @param mountOptions A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mountOptions(final java.util.List<java.lang.String> mountOptions) {
            this.props.mountOptions(mountOptions);
            return this;
        }

        /**
         * When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource.
         * <p>
         * The reclaim policy tells the cluster what to do with
         * the volume after it has been released of its claim.
         * <p>
         * Default: PersistentVolumeReclaimPolicy.RETAIN
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming">https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming</a>
         * @param reclaimPolicy When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reclaimPolicy(final org.cdk8s.plus24.PersistentVolumeReclaimPolicy reclaimPolicy) {
            this.props.reclaimPolicy(reclaimPolicy);
            return this;
        }

        /**
         * What is the storage capacity of this volume.
         * <p>
         * Default: - No specified.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources">https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources</a>
         * @param storage What is the storage capacity of this volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storage(final org.cdk8s.Size storage) {
            this.props.storage(storage);
            return this;
        }

        /**
         * Name of StorageClass to which this persistent volume belongs.
         * <p>
         * Default: - Volume does not belong to any storage class.
         * <p>
         * @return {@code this}
         * @param storageClassName Name of StorageClass to which this persistent volume belongs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageClassName(final java.lang.String storageClassName) {
            this.props.storageClassName(storageClassName);
            return this;
        }

        /**
         * Defines what type of volume is required by the claim.
         * <p>
         * Default: VolumeMode.FILE_SYSTEM
         * <p>
         * @return {@code this}
         * @param volumeMode Defines what type of volume is required by the claim. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeMode(final org.cdk8s.plus24.PersistentVolumeMode volumeMode) {
            this.props.volumeMode(volumeMode);
            return this;
        }

        /**
         * Unique ID of the persistent disk resource in AWS (Amazon EBS volume).
         * <p>
         * More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore">https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore</a>
         * @param volumeId Unique ID of the persistent disk resource in AWS (Amazon EBS volume). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeId(final java.lang.String volumeId) {
            this.props.volumeId(volumeId);
            return this;
        }

        /**
         * Filesystem type of the volume that you want to mount.
         * <p>
         * Tip: Ensure that the filesystem type is supported by the host operating system.
         * <p>
         * Default: 'ext4'
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore">https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore</a>
         * @param fsType Filesystem type of the volume that you want to mount. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fsType(final java.lang.String fsType) {
            this.props.fsType(fsType);
            return this;
        }

        /**
         * The partition in the volume that you want to mount.
         * <p>
         * If omitted, the default is to mount by volume name.
         * Examples: For volume /dev/sda1, you specify the partition as "1".
         * Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
         * <p>
         * Default: - No partition.
         * <p>
         * @return {@code this}
         * @param partition The partition in the volume that you want to mount. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partition(final java.lang.Number partition) {
            this.props.partition(partition);
            return this;
        }

        /**
         * Specify "true" to force and set the ReadOnly property in VolumeMounts to "true".
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore">https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore</a>
         * @param readOnly Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readOnly(final java.lang.Boolean readOnly) {
            this.props.readOnly(readOnly);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus24.AwsElasticBlockStorePersistentVolume}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus24.AwsElasticBlockStorePersistentVolume build() {
            return new org.cdk8s.plus24.AwsElasticBlockStorePersistentVolume(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
