package org.cdk8s.plus24;

/**
 * A HorizontalPodAutoscaler scales a workload up or down in response to a metric change.
 * <p>
 * This allows your services to scale up when demand is high and scale down
 * when they are no longer needed.
 * <p>
 * Typical use cases for HorizontalPodAutoscaler:
 * <p>
 * <ul>
 * <li>When Memory usage is above 70%, scale up the number of replicas to meet the demand.</li>
 * <li>When CPU usage is below 30%, scale down the number of replicas to save resources.</li>
 * <li>When a service is experiencing a spike in traffic, scale up the number of replicas
 * to meet the demand. Then, when the traffic subsides, scale down the number of
 * replicas to save resources.</li>
 * </ul>
 * <p>
 * The autoscaler uses the following algorithm to determine the number of replicas to scale:
 * <p>
 * <code>desiredReplicas = ceil[currentReplicas * ( currentMetricValue / desiredMetricValue )]</code>
 * <p>
 * HorizontalPodAutoscaler's can be used to with any <code>Scalable</code> workload:
 * <p>
 * <ul>
 * <li>Deployment</li>
 * <li>StatefulSet</li>
 * </ul>
 * <p>
 * <strong>Targets that already have a replica count defined:</strong>
 * <p>
 * Remove any replica counts from the target resource before associating with a
 * HorizontalPodAutoscaler. If this isn't done, then any time a change to that object is applied,
 * Kubernetes will scale the current number of Pods to the value of the target.replicas key. This
 * may not be desired and could lead to unexpected behavior.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * const backend = new kplus.Deployment(this, 'Backend', ...);
 * const hpa = new kplus.HorizontalPodAutoscaler(chart, 'Hpa', {
 *  target: backend,
 *  maxReplicas: 10,
 *  scaleUp: {
 *    policies: [
 *      {
 *        replicas: kplus.Replicas.absolute(3),
 *        duration: Duration.minutes(5),
 *      },
 *    ],
 *  },
 * });
 * </pre></blockquote>
 * <p>
 * @see <a href="https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/#implicit-maintenance-mode-deactivation">https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/#implicit-maintenance-mode-deactivation</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.70.0 (build 03c2f6f)", date = "2022-10-25T03:00:29.173Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus24.$Module.class, fqn = "cdk8s-plus-24.HorizontalPodAutoscaler")
public class HorizontalPodAutoscaler extends org.cdk8s.plus24.Resource {

    protected HorizontalPodAutoscaler(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HorizontalPodAutoscaler(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HorizontalPodAutoscaler(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull org.cdk8s.plus24.HorizontalPodAutoscalerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The underlying cdk8s API object.
     * <p>
     * @see <a href="base.Resource.apiObject">base.Resource.apiObject</a>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull org.cdk8s.ApiObject getApiObject() {
        return software.amazon.jsii.Kernel.get(this, "apiObject", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObject.class));
    }

    /**
     * The maximum number of replicas that can be scaled up to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getMaxReplicas() {
        return software.amazon.jsii.Kernel.get(this, "maxReplicas", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The minimum number of replicas that can be scaled down to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getMinReplicas() {
        return software.amazon.jsii.Kernel.get(this, "minReplicas", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The name of a resource type as it appears in the relevant API endpoint.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceType() {
        return software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The scaling behavior when scaling down.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus24.ScalingRules getScaleDown() {
        return software.amazon.jsii.Kernel.get(this, "scaleDown", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus24.ScalingRules.class));
    }

    /**
     * The scaling behavior when scaling up.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus24.ScalingRules getScaleUp() {
        return software.amazon.jsii.Kernel.get(this, "scaleUp", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus24.ScalingRules.class));
    }

    /**
     * The workload to scale up or down.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus24.IScalable getTarget() {
        return software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus24.IScalable.class));
    }

    /**
     * The metric conditions that trigger a scale up or scale down.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.plus24.Metric> getMetrics() {
        return java.util.Optional.ofNullable((java.util.List<org.cdk8s.plus24.Metric>)(software.amazon.jsii.Kernel.get(this, "metrics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus24.Metric.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus24.HorizontalPodAutoscaler}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus24.HorizontalPodAutoscaler> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final org.cdk8s.plus24.HorizontalPodAutoscalerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new org.cdk8s.plus24.HorizontalPodAutoscalerProps.Builder();
        }

        /**
         * Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props.metadata(metadata);
            return this;
        }

        /**
         * The maximum number of replicas that can be scaled up to.
         * <p>
         * @return {@code this}
         * @param maxReplicas The maximum number of replicas that can be scaled up to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxReplicas(final java.lang.Number maxReplicas) {
            this.props.maxReplicas(maxReplicas);
            return this;
        }

        /**
         * The workload to scale up or down.
         * <p>
         * Scalable workload types:
         * <p>
         * <ul>
         * <li>Deployment</li>
         * <li>StatefulSet</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param target The workload to scale up or down. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(final org.cdk8s.plus24.IScalable target) {
            this.props.target(target);
            return this;
        }

        /**
         * The metric conditions that trigger a scale up or scale down.
         * <p>
         * Default: - If metrics are not provided, then the target resource
         * constraints (e.g. cpu limit) will be used as scaling metrics.
         * <p>
         * @return {@code this}
         * @param metrics The metric conditions that trigger a scale up or scale down. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metrics(final java.util.List<? extends org.cdk8s.plus24.Metric> metrics) {
            this.props.metrics(metrics);
            return this;
        }

        /**
         * The minimum number of replicas that can be scaled down to.
         * <p>
         * Can be set to 0 if the alpha feature gate <code>HPAScaleToZero</code> is enabled and
         * at least one Object or External metric is configured.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param minReplicas The minimum number of replicas that can be scaled down to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minReplicas(final java.lang.Number minReplicas) {
            this.props.minReplicas(minReplicas);
            return this;
        }

        /**
         * The scaling behavior when scaling down.
         * <p>
         * Default: - Scale down to minReplica count with a 5 minute stabilization window.
         * <p>
         * @return {@code this}
         * @param scaleDown The scaling behavior when scaling down. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleDown(final org.cdk8s.plus24.ScalingRules scaleDown) {
            this.props.scaleDown(scaleDown);
            return this;
        }

        /**
         * The scaling behavior when scaling up.
         * <p>
         * Default: - Is the higher of:
         * * Increase no more than 4 pods per 60 seconds
         * * Double the number of pods per 60 seconds
         * <p>
         * @return {@code this}
         * @param scaleUp The scaling behavior when scaling up. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleUp(final org.cdk8s.plus24.ScalingRules scaleUp) {
            this.props.scaleUp(scaleUp);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus24.HorizontalPodAutoscaler}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus24.HorizontalPodAutoscaler build() {
            return new org.cdk8s.plus24.HorizontalPodAutoscaler(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
