package org.cdk8s.plus25;

/**
 * In Kubernetes, namespaces provides a mechanism for isolating groups of resources within a single cluster.
 * <p>
 * Names of resources need to be unique within a namespace, but not across namespaces.
 * Namespace-based scoping is applicable only for namespaced objects (e.g. Deployments, Services, etc) and
 * not for cluster-wide objects (e.g. StorageClass, Nodes, PersistentVolumes, etc).
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-21T02:50:30.158Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus25.$Module.class, fqn = "cdk8s-plus-25.Namespace")
public class Namespace extends org.cdk8s.plus25.Resource implements org.cdk8s.plus25.INamespaceSelector, org.cdk8s.plus25.INetworkPolicyPeer {

    protected Namespace(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Namespace(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        NAME_LABEL = software.amazon.jsii.JsiiObject.jsiiStaticGet(org.cdk8s.plus25.Namespace.class, "NAME_LABEL", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Namespace(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable org.cdk8s.plus25.NamespaceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Namespace(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Return the configuration of this selector.
     * <p>
     * @see <a href="INamespaceSelector.toNamespaceSelectorConfig()">INamespaceSelector.toNamespaceSelectorConfig()</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus25.NamespaceSelectorConfig toNamespaceSelectorConfig() {
        return software.amazon.jsii.Kernel.call(this, "toNamespaceSelectorConfig", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus25.NamespaceSelectorConfig.class));
    }

    /**
     * Return the configuration of this peer.
     * <p>
     * @see <a href="INetworkPolicyPeer.toNetworkPolicyPeerConfig()">INetworkPolicyPeer.toNetworkPolicyPeerConfig()</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus25.NetworkPolicyPeerConfig toNetworkPolicyPeerConfig() {
        return software.amazon.jsii.Kernel.call(this, "toNetworkPolicyPeerConfig", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus25.NetworkPolicyPeerConfig.class));
    }

    /**
     * Convert the peer into a pod selector, if possible.
     * <p>
     * @see <a href="INetworkPolicyPeer.toPodSelector()">INetworkPolicyPeer.toPodSelector()</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.Nullable org.cdk8s.plus25.IPodSelector toPodSelector() {
        return software.amazon.jsii.Kernel.call(this, "toPodSelector", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus25.IPodSelector.class));
    }

    /**
     * @see <a href="https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/#automatic-labelling">https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/#automatic-labelling</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String NAME_LABEL;

    /**
     * The underlying cdk8s API object.
     * <p>
     * @see <a href="base.Resource.apiObject">base.Resource.apiObject</a>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull org.cdk8s.ApiObject getApiObject() {
        return software.amazon.jsii.Kernel.get(this, "apiObject", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObject.class));
    }

    /**
     * The name of a resource type as it appears in the relevant API endpoint.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceType() {
        return software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus25.Namespace}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus25.Namespace> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private org.cdk8s.plus25.NamespaceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props().metadata(metadata);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus25.Namespace}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus25.Namespace build() {
            return new org.cdk8s.plus25.Namespace(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private org.cdk8s.plus25.NamespaceProps.Builder props() {
            if (this.props == null) {
                this.props = new org.cdk8s.plus25.NamespaceProps.Builder();
            }
            return this.props;
        }
    }
}
