package org.cdk8s.plus25;

/**
 * Properties for `NetworkPolicy`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-21T02:50:30.164Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus25.$Module.class, fqn = "cdk8s-plus-25.NetworkPolicyProps")
@software.amazon.jsii.Jsii.Proxy(NetworkPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NetworkPolicyProps extends software.amazon.jsii.JsiiSerializable, org.cdk8s.plus25.ResourceProps {

    /**
     * Egress traffic configuration.
     * <p>
     * Default: - the policy doesn't change egress behavior of the pods it selects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus25.NetworkPolicyTraffic getEgress() {
        return null;
    }

    /**
     * Ingress traffic configuration.
     * <p>
     * Default: - the policy doesn't change ingress behavior of the pods it selects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus25.NetworkPolicyTraffic getIngress() {
        return null;
    }

    /**
     * Which pods does this policy object applies to.
     * <p>
     * This can either be a single pod / workload, or a grouping of pods selected
     * via the <code>Pods.select</code> function. Rules is applied to any pods selected by this property.
     * Multiple network policies can select the same set of pods.
     * In this case, the rules for each are combined additively.
     * <p>
     * Note that
     * <p>
     * Default: - will select all pods in the namespace of the policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus25.IPodSelector getSelector() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NetworkPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NetworkPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NetworkPolicyProps> {
        org.cdk8s.plus25.NetworkPolicyTraffic egress;
        org.cdk8s.plus25.NetworkPolicyTraffic ingress;
        org.cdk8s.plus25.IPodSelector selector;
        org.cdk8s.ApiObjectMetadata metadata;

        /**
         * Sets the value of {@link NetworkPolicyProps#getEgress}
         * @param egress Egress traffic configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder egress(org.cdk8s.plus25.NetworkPolicyTraffic egress) {
            this.egress = egress;
            return this;
        }

        /**
         * Sets the value of {@link NetworkPolicyProps#getIngress}
         * @param ingress Ingress traffic configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingress(org.cdk8s.plus25.NetworkPolicyTraffic ingress) {
            this.ingress = ingress;
            return this;
        }

        /**
         * Sets the value of {@link NetworkPolicyProps#getSelector}
         * @param selector Which pods does this policy object applies to.
         *                 This can either be a single pod / workload, or a grouping of pods selected
         *                 via the <code>Pods.select</code> function. Rules is applied to any pods selected by this property.
         *                 Multiple network policies can select the same set of pods.
         *                 In this case, the rules for each are combined additively.
         *                 <p>
         *                 Note that
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selector(org.cdk8s.plus25.IPodSelector selector) {
            this.selector = selector;
            return this;
        }

        /**
         * Sets the value of {@link NetworkPolicyProps#getMetadata}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(org.cdk8s.ApiObjectMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NetworkPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NetworkPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkPolicyProps {
        private final org.cdk8s.plus25.NetworkPolicyTraffic egress;
        private final org.cdk8s.plus25.NetworkPolicyTraffic ingress;
        private final org.cdk8s.plus25.IPodSelector selector;
        private final org.cdk8s.ApiObjectMetadata metadata;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.egress = software.amazon.jsii.Kernel.get(this, "egress", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus25.NetworkPolicyTraffic.class));
            this.ingress = software.amazon.jsii.Kernel.get(this, "ingress", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus25.NetworkPolicyTraffic.class));
            this.selector = software.amazon.jsii.Kernel.get(this, "selector", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus25.IPodSelector.class));
            this.metadata = software.amazon.jsii.Kernel.get(this, "metadata", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObjectMetadata.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.egress = builder.egress;
            this.ingress = builder.ingress;
            this.selector = builder.selector;
            this.metadata = builder.metadata;
        }

        @Override
        public final org.cdk8s.plus25.NetworkPolicyTraffic getEgress() {
            return this.egress;
        }

        @Override
        public final org.cdk8s.plus25.NetworkPolicyTraffic getIngress() {
            return this.ingress;
        }

        @Override
        public final org.cdk8s.plus25.IPodSelector getSelector() {
            return this.selector;
        }

        @Override
        public final org.cdk8s.ApiObjectMetadata getMetadata() {
            return this.metadata;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEgress() != null) {
                data.set("egress", om.valueToTree(this.getEgress()));
            }
            if (this.getIngress() != null) {
                data.set("ingress", om.valueToTree(this.getIngress()));
            }
            if (this.getSelector() != null) {
                data.set("selector", om.valueToTree(this.getSelector()));
            }
            if (this.getMetadata() != null) {
                data.set("metadata", om.valueToTree(this.getMetadata()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus-25.NetworkPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkPolicyProps.Jsii$Proxy that = (NetworkPolicyProps.Jsii$Proxy) o;

            if (this.egress != null ? !this.egress.equals(that.egress) : that.egress != null) return false;
            if (this.ingress != null ? !this.ingress.equals(that.ingress) : that.ingress != null) return false;
            if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) return false;
            return this.metadata != null ? this.metadata.equals(that.metadata) : that.metadata == null;
        }

        @Override
        public final int hashCode() {
            int result = this.egress != null ? this.egress.hashCode() : 0;
            result = 31 * result + (this.ingress != null ? this.ingress.hashCode() : 0);
            result = 31 * result + (this.selector != null ? this.selector.hashCode() : 0);
            result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
            return result;
        }
    }
}
