/*
 * Decompiled with CFR 0.152.
 */
package org.cdk8s.plus25;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.cdk8s.plus25.$Module;
import org.cdk8s.plus25.ContainerLifecycle;
import org.cdk8s.plus25.ContainerPort;
import org.cdk8s.plus25.ContainerProps;
import org.cdk8s.plus25.ContainerResources;
import org.cdk8s.plus25.ContainerSecurityContext;
import org.cdk8s.plus25.ContainerSecurityContextProps;
import org.cdk8s.plus25.Env;
import org.cdk8s.plus25.EnvFrom;
import org.cdk8s.plus25.EnvValue;
import org.cdk8s.plus25.IStorage;
import org.cdk8s.plus25.ImagePullPolicy;
import org.cdk8s.plus25.MountOptions;
import org.cdk8s.plus25.Probe;
import org.cdk8s.plus25.VolumeMount;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="cdk8s-plus-25.Container")
public class Container
extends JsiiObject {
    protected Container(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Container(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Container(@NotNull ContainerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public void addPort(@NotNull ContainerPort port) {
        Kernel.call((Object)((Object)this), (String)"addPort", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(port, "port is required")});
    }

    public void mount(@NotNull String path, @NotNull IStorage storage, @Nullable MountOptions options) {
        Kernel.call((Object)((Object)this), (String)"mount", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(path, "path is required"), Objects.requireNonNull(storage, "storage is required"), options});
    }

    public void mount(@NotNull String path, @NotNull IStorage storage) {
        Kernel.call((Object)((Object)this), (String)"mount", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(path, "path is required"), Objects.requireNonNull(storage, "storage is required")});
    }

    @NotNull
    public Env getEnv() {
        return (Env)((Object)Kernel.get((Object)((Object)this), (String)"env", (NativeType)NativeType.forClass(Env.class)));
    }

    @NotNull
    public String getImage() {
        return (String)Kernel.get((Object)((Object)this), (String)"image", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public ImagePullPolicy getImagePullPolicy() {
        return (ImagePullPolicy)((Object)Kernel.get((Object)((Object)this), (String)"imagePullPolicy", (NativeType)NativeType.forClass(ImagePullPolicy.class)));
    }

    @NotNull
    public List<VolumeMount> getMounts() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"mounts", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(VolumeMount.class))));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)((Object)this), (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<ContainerPort> getPorts() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"ports", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(ContainerPort.class))));
    }

    @NotNull
    public ContainerSecurityContext getSecurityContext() {
        return (ContainerSecurityContext)((Object)Kernel.get((Object)((Object)this), (String)"securityContext", (NativeType)NativeType.forClass(ContainerSecurityContext.class)));
    }

    @Nullable
    public List<String> getArgs() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"args", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Nullable
    public List<String> getCommand() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"command", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Deprecated
    @Nullable
    public Number getPort() {
        return (Number)Kernel.get((Object)((Object)this), (String)"port", (NativeType)NativeType.forClass(Number.class));
    }

    @Nullable
    public Number getPortNumber() {
        return (Number)Kernel.get((Object)((Object)this), (String)"portNumber", (NativeType)NativeType.forClass(Number.class));
    }

    @Nullable
    public ContainerResources getResources() {
        return (ContainerResources)Kernel.get((Object)((Object)this), (String)"resources", (NativeType)NativeType.forClass(ContainerResources.class));
    }

    @Nullable
    public String getWorkingDir() {
        return (String)Kernel.get((Object)((Object)this), (String)"workingDir", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Container> {
        private final ContainerProps.Builder props = new ContainerProps.Builder();

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder args(List<String> args) {
            this.props.args(args);
            return this;
        }

        public Builder command(List<String> command) {
            this.props.command(command);
            return this;
        }

        public Builder envFrom(List<? extends EnvFrom> envFrom) {
            this.props.envFrom(envFrom);
            return this;
        }

        public Builder envVariables(Map<String, ? extends EnvValue> envVariables) {
            this.props.envVariables(envVariables);
            return this;
        }

        public Builder imagePullPolicy(ImagePullPolicy imagePullPolicy) {
            this.props.imagePullPolicy(imagePullPolicy);
            return this;
        }

        public Builder lifecycle(ContainerLifecycle lifecycle) {
            this.props.lifecycle(lifecycle);
            return this;
        }

        public Builder liveness(Probe liveness) {
            this.props.liveness(liveness);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        @Deprecated
        public Builder port(Number port) {
            this.props.port(port);
            return this;
        }

        public Builder portNumber(Number portNumber) {
            this.props.portNumber(portNumber);
            return this;
        }

        public Builder ports(List<? extends ContainerPort> ports) {
            this.props.ports(ports);
            return this;
        }

        public Builder readiness(Probe readiness) {
            this.props.readiness(readiness);
            return this;
        }

        public Builder resources(ContainerResources resources) {
            this.props.resources(resources);
            return this;
        }

        public Builder securityContext(ContainerSecurityContextProps securityContext) {
            this.props.securityContext(securityContext);
            return this;
        }

        public Builder startup(Probe startup) {
            this.props.startup(startup);
            return this;
        }

        public Builder volumeMounts(List<? extends VolumeMount> volumeMounts) {
            this.props.volumeMounts(volumeMounts);
            return this;
        }

        public Builder workingDir(String workingDir) {
            this.props.workingDir(workingDir);
            return this;
        }

        public Builder image(String image) {
            this.props.image(image);
            return this;
        }

        public Container build() {
            return new Container(this.props.build());
        }
    }
}

