package org.cdk8s.plus25;

/**
 * Properties for `CronJob`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.79.0 (build b22f628)", date = "2023-03-28T02:31:40.534Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus25.$Module.class, fqn = "cdk8s-plus-25.CronJobProps")
@software.amazon.jsii.Jsii.Proxy(CronJobProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CronJobProps extends software.amazon.jsii.JsiiSerializable, org.cdk8s.plus25.JobProps {

    /**
     * Specifies the time in which the job would run again.
     * <p>
     * This is defined as a cron expression in the CronJob resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull org.cdk8s.Cron getSchedule();

    /**
     * Specifies the concurrency policy for the job.
     * <p>
     * Default: ConcurrencyPolicy.Forbid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus25.ConcurrencyPolicy getConcurrencyPolicy() {
        return null;
    }

    /**
     * Specifies the number of failed jobs history retained.
     * <p>
     * This would retain the Job and the associated Pod resource and can be useful for debugging.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getFailedJobsRetained() {
        return null;
    }

    /**
     * Kubernetes attempts to start cron jobs at its schedule time, but this is not guaranteed.
     * <p>
     * This deadline specifies
     * how much time can pass after a schedule point, for which kubernetes can still start the job.
     * For example, if this is set to 100 seconds, kubernetes is allowed to start the job at a maximum 100 seconds after
     * the scheduled time.
     * <p>
     * Note that the Kubernetes CronJobController checks for things every 10 seconds, for this reason, a deadline below 10
     * seconds is not allowed, as it may cause your job to never be scheduled.
     * <p>
     * In addition, kubernetes will stop scheduling jobs if more than 100 schedules were missed (for any reason).
     * This property also controls what time interval should kubernetes consider when counting for missed schedules.
     * <p>
     * For example, suppose a CronJob is set to schedule a new Job every one minute beginning at 08:30:00,
     * and its <code>startingDeadline</code> field is not set. If the CronJob controller happens to be down from 08:29:00 to 10:21:00,
     * the job will not start as the number of missed jobs which missed their schedule is greater than 100.
     * However, if <code>startingDeadline</code> is set to 200 seconds, kubernetes will only count 3 missed schedules, and thus
     * start a new execution at 10:22:00.
     * <p>
     * Default: Duration.seconds(10)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.Duration getStartingDeadline() {
        return null;
    }

    /**
     * Specifies the number of successful jobs history retained.
     * <p>
     * This would retain the Job and the associated Pod resource and can be useful for debugging.
     * <p>
     * Default: 3
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSuccessfulJobsRetained() {
        return null;
    }

    /**
     * Specifies if the cron job should be suspended.
     * <p>
     * Only applies to future executions, current ones are remained untouched.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSuspend() {
        return null;
    }

    /**
     * Specifies the timezone for the job.
     * <p>
     * This helps aligining the schedule to follow the specified timezone.
     * <p>
     * Default: - Timezone of kube-controller-manager process.
     * <p>
     * @see <a href="{@link https://en.wikipedia.org/wiki/List_of_tz_database_time_zones} for list of valid timezone values.">{@link https://en.wikipedia.org/wiki/List_of_tz_database_time_zones} for list of valid timezone values.</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTimeZone() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CronJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CronJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CronJobProps> {
        org.cdk8s.Cron schedule;
        org.cdk8s.plus25.ConcurrencyPolicy concurrencyPolicy;
        java.lang.Number failedJobsRetained;
        org.cdk8s.Duration startingDeadline;
        java.lang.Number successfulJobsRetained;
        java.lang.Boolean suspend;
        java.lang.String timeZone;
        org.cdk8s.Duration activeDeadline;
        java.lang.Number backoffLimit;
        org.cdk8s.Duration ttlAfterFinished;
        org.cdk8s.ApiObjectMetadata podMetadata;
        java.lang.Boolean select;
        java.lang.Boolean spread;
        java.lang.Boolean automountServiceAccountToken;
        java.util.List<org.cdk8s.plus25.ContainerProps> containers;
        org.cdk8s.plus25.PodDnsProps dns;
        org.cdk8s.plus25.ISecret dockerRegistryAuth;
        java.util.List<org.cdk8s.plus25.HostAlias> hostAliases;
        java.util.List<org.cdk8s.plus25.ContainerProps> initContainers;
        java.lang.Boolean isolate;
        org.cdk8s.plus25.RestartPolicy restartPolicy;
        org.cdk8s.plus25.PodSecurityContextProps securityContext;
        org.cdk8s.plus25.IServiceAccount serviceAccount;
        java.util.List<org.cdk8s.plus25.Volume> volumes;
        org.cdk8s.ApiObjectMetadata metadata;

        /**
         * Sets the value of {@link CronJobProps#getSchedule}
         * @param schedule Specifies the time in which the job would run again. This parameter is required.
         *                 This is defined as a cron expression in the CronJob resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(org.cdk8s.Cron schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getConcurrencyPolicy}
         * @param concurrencyPolicy Specifies the concurrency policy for the job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder concurrencyPolicy(org.cdk8s.plus25.ConcurrencyPolicy concurrencyPolicy) {
            this.concurrencyPolicy = concurrencyPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getFailedJobsRetained}
         * @param failedJobsRetained Specifies the number of failed jobs history retained.
         *                           This would retain the Job and the associated Pod resource and can be useful for debugging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failedJobsRetained(java.lang.Number failedJobsRetained) {
            this.failedJobsRetained = failedJobsRetained;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getStartingDeadline}
         * @param startingDeadline Kubernetes attempts to start cron jobs at its schedule time, but this is not guaranteed.
         *                         This deadline specifies
         *                         how much time can pass after a schedule point, for which kubernetes can still start the job.
         *                         For example, if this is set to 100 seconds, kubernetes is allowed to start the job at a maximum 100 seconds after
         *                         the scheduled time.
         *                         <p>
         *                         Note that the Kubernetes CronJobController checks for things every 10 seconds, for this reason, a deadline below 10
         *                         seconds is not allowed, as it may cause your job to never be scheduled.
         *                         <p>
         *                         In addition, kubernetes will stop scheduling jobs if more than 100 schedules were missed (for any reason).
         *                         This property also controls what time interval should kubernetes consider when counting for missed schedules.
         *                         <p>
         *                         For example, suppose a CronJob is set to schedule a new Job every one minute beginning at 08:30:00,
         *                         and its <code>startingDeadline</code> field is not set. If the CronJob controller happens to be down from 08:29:00 to 10:21:00,
         *                         the job will not start as the number of missed jobs which missed their schedule is greater than 100.
         *                         However, if <code>startingDeadline</code> is set to 200 seconds, kubernetes will only count 3 missed schedules, and thus
         *                         start a new execution at 10:22:00.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startingDeadline(org.cdk8s.Duration startingDeadline) {
            this.startingDeadline = startingDeadline;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getSuccessfulJobsRetained}
         * @param successfulJobsRetained Specifies the number of successful jobs history retained.
         *                               This would retain the Job and the associated Pod resource and can be useful for debugging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder successfulJobsRetained(java.lang.Number successfulJobsRetained) {
            this.successfulJobsRetained = successfulJobsRetained;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getSuspend}
         * @param suspend Specifies if the cron job should be suspended.
         *                Only applies to future executions, current ones are remained untouched.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suspend(java.lang.Boolean suspend) {
            this.suspend = suspend;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getTimeZone}
         * @param timeZone Specifies the timezone for the job.
         *                 This helps aligining the schedule to follow the specified timezone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeZone(java.lang.String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getActiveDeadline}
         * @param activeDeadline Specifies the duration the job may be active before the system tries to terminate it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder activeDeadline(org.cdk8s.Duration activeDeadline) {
            this.activeDeadline = activeDeadline;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getBackoffLimit}
         * @param backoffLimit Specifies the number of retries before marking this job failed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backoffLimit(java.lang.Number backoffLimit) {
            this.backoffLimit = backoffLimit;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getTtlAfterFinished}
         * @param ttlAfterFinished Limits the lifetime of a Job that has finished execution (either Complete or Failed).
         *                         If this field is set, after the Job finishes, it is eligible to
         *                         be automatically deleted. When the Job is being deleted, its lifecycle
         *                         guarantees (e.g. finalizers) will be honored. If this field is set to zero,
         *                         the Job becomes eligible to be deleted immediately after it finishes. This
         *                         field is alpha-level and is only honored by servers that enable the
         *                         <code>TTLAfterFinished</code> feature.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ttlAfterFinished(org.cdk8s.Duration ttlAfterFinished) {
            this.ttlAfterFinished = ttlAfterFinished;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getPodMetadata}
         * @param podMetadata The pod metadata of this workload.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder podMetadata(org.cdk8s.ApiObjectMetadata podMetadata) {
            this.podMetadata = podMetadata;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getSelect}
         * @param select Automatically allocates a pod label selector for this workload and add it to the pod metadata.
         *               This ensures this workload manages pods created by
         *               its pod template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder select(java.lang.Boolean select) {
            this.select = select;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getSpread}
         * @param spread Automatically spread pods across hostname and zones.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spread(java.lang.Boolean spread) {
            this.spread = spread;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getAutomountServiceAccountToken}
         * @param automountServiceAccountToken Indicates whether a service account token should be automatically mounted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automountServiceAccountToken(java.lang.Boolean automountServiceAccountToken) {
            this.automountServiceAccountToken = automountServiceAccountToken;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getContainers}
         * @param containers List of containers belonging to the pod.
         *                   Containers cannot currently be
         *                   added or removed. There must be at least one container in a Pod.
         *                   <p>
         *                   You can add additionnal containers using <code>podSpec.addContainer()</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder containers(java.util.List<? extends org.cdk8s.plus25.ContainerProps> containers) {
            this.containers = (java.util.List<org.cdk8s.plus25.ContainerProps>)containers;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getDns}
         * @param dns DNS settings for the pod.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dns(org.cdk8s.plus25.PodDnsProps dns) {
            this.dns = dns;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getDockerRegistryAuth}
         * @param dockerRegistryAuth A secret containing docker credentials for authenticating to a registry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerRegistryAuth(org.cdk8s.plus25.ISecret dockerRegistryAuth) {
            this.dockerRegistryAuth = dockerRegistryAuth;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getHostAliases}
         * @param hostAliases HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder hostAliases(java.util.List<? extends org.cdk8s.plus25.HostAlias> hostAliases) {
            this.hostAliases = (java.util.List<org.cdk8s.plus25.HostAlias>)hostAliases;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getInitContainers}
         * @param initContainers List of initialization containers belonging to the pod.
         *                       Init containers are executed in order prior to containers being started.
         *                       If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
         *                       The name for an init container or normal container must be unique among all containers.
         *                       Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
         *                       The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
         *                       for each resource type, and then using the max of of that value or the sum of the normal containers.
         *                       Limits are applied to init containers in a similar fashion.
         *                       <p>
         *                       Init containers cannot currently be added ,removed or updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder initContainers(java.util.List<? extends org.cdk8s.plus25.ContainerProps> initContainers) {
            this.initContainers = (java.util.List<org.cdk8s.plus25.ContainerProps>)initContainers;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getIsolate}
         * @param isolate Isolates the pod.
         *                This will prevent any ingress or egress connections to / from this pod.
         *                You can however allow explicit connections post instantiation by using the <code>.connections</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isolate(java.lang.Boolean isolate) {
            this.isolate = isolate;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getRestartPolicy}
         * @param restartPolicy Restart policy for all containers within the pod.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartPolicy(org.cdk8s.plus25.RestartPolicy restartPolicy) {
            this.restartPolicy = restartPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getSecurityContext}
         * @param securityContext SecurityContext holds pod-level security attributes and common container settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityContext(org.cdk8s.plus25.PodSecurityContextProps securityContext) {
            this.securityContext = securityContext;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getServiceAccount}
         * @param serviceAccount A service account provides an identity for processes that run in a Pod.
         *                       When you (a human) access the cluster (for example, using kubectl), you are
         *                       authenticated by the apiserver as a particular User Account (currently this
         *                       is usually admin, unless your cluster administrator has customized your
         *                       cluster). Processes in containers inside pods can also contact the
         *                       apiserver. When they do, they are authenticated as a particular Service
         *                       Account (for example, default).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccount(org.cdk8s.plus25.IServiceAccount serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getVolumes}
         * @param volumes List of volumes that can be mounted by containers belonging to the pod.
         *                You can also add volumes later using <code>podSpec.addVolume()</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder volumes(java.util.List<? extends org.cdk8s.plus25.Volume> volumes) {
            this.volumes = (java.util.List<org.cdk8s.plus25.Volume>)volumes;
            return this;
        }

        /**
         * Sets the value of {@link CronJobProps#getMetadata}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(org.cdk8s.ApiObjectMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CronJobProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CronJobProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CronJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CronJobProps {
        private final org.cdk8s.Cron schedule;
        private final org.cdk8s.plus25.ConcurrencyPolicy concurrencyPolicy;
        private final java.lang.Number failedJobsRetained;
        private final org.cdk8s.Duration startingDeadline;
        private final java.lang.Number successfulJobsRetained;
        private final java.lang.Boolean suspend;
        private final java.lang.String timeZone;
        private final org.cdk8s.Duration activeDeadline;
        private final java.lang.Number backoffLimit;
        private final org.cdk8s.Duration ttlAfterFinished;
        private final org.cdk8s.ApiObjectMetadata podMetadata;
        private final java.lang.Boolean select;
        private final java.lang.Boolean spread;
        private final java.lang.Boolean automountServiceAccountToken;
        private final java.util.List<org.cdk8s.plus25.ContainerProps> containers;
        private final org.cdk8s.plus25.PodDnsProps dns;
        private final org.cdk8s.plus25.ISecret dockerRegistryAuth;
        private final java.util.List<org.cdk8s.plus25.HostAlias> hostAliases;
        private final java.util.List<org.cdk8s.plus25.ContainerProps> initContainers;
        private final java.lang.Boolean isolate;
        private final org.cdk8s.plus25.RestartPolicy restartPolicy;
        private final org.cdk8s.plus25.PodSecurityContextProps securityContext;
        private final org.cdk8s.plus25.IServiceAccount serviceAccount;
        private final java.util.List<org.cdk8s.plus25.Volume> volumes;
        private final org.cdk8s.ApiObjectMetadata metadata;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(org.cdk8s.Cron.class));
            this.concurrencyPolicy = software.amazon.jsii.Kernel.get(this, "concurrencyPolicy", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus25.ConcurrencyPolicy.class));
            this.failedJobsRetained = software.amazon.jsii.Kernel.get(this, "failedJobsRetained", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.startingDeadline = software.amazon.jsii.Kernel.get(this, "startingDeadline", software.amazon.jsii.NativeType.forClass(org.cdk8s.Duration.class));
            this.successfulJobsRetained = software.amazon.jsii.Kernel.get(this, "successfulJobsRetained", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.suspend = software.amazon.jsii.Kernel.get(this, "suspend", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.timeZone = software.amazon.jsii.Kernel.get(this, "timeZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.activeDeadline = software.amazon.jsii.Kernel.get(this, "activeDeadline", software.amazon.jsii.NativeType.forClass(org.cdk8s.Duration.class));
            this.backoffLimit = software.amazon.jsii.Kernel.get(this, "backoffLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.ttlAfterFinished = software.amazon.jsii.Kernel.get(this, "ttlAfterFinished", software.amazon.jsii.NativeType.forClass(org.cdk8s.Duration.class));
            this.podMetadata = software.amazon.jsii.Kernel.get(this, "podMetadata", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObjectMetadata.class));
            this.select = software.amazon.jsii.Kernel.get(this, "select", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.spread = software.amazon.jsii.Kernel.get(this, "spread", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.automountServiceAccountToken = software.amazon.jsii.Kernel.get(this, "automountServiceAccountToken", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.containers = software.amazon.jsii.Kernel.get(this, "containers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus25.ContainerProps.class)));
            this.dns = software.amazon.jsii.Kernel.get(this, "dns", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus25.PodDnsProps.class));
            this.dockerRegistryAuth = software.amazon.jsii.Kernel.get(this, "dockerRegistryAuth", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus25.ISecret.class));
            this.hostAliases = software.amazon.jsii.Kernel.get(this, "hostAliases", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus25.HostAlias.class)));
            this.initContainers = software.amazon.jsii.Kernel.get(this, "initContainers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus25.ContainerProps.class)));
            this.isolate = software.amazon.jsii.Kernel.get(this, "isolate", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.restartPolicy = software.amazon.jsii.Kernel.get(this, "restartPolicy", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus25.RestartPolicy.class));
            this.securityContext = software.amazon.jsii.Kernel.get(this, "securityContext", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus25.PodSecurityContextProps.class));
            this.serviceAccount = software.amazon.jsii.Kernel.get(this, "serviceAccount", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus25.IServiceAccount.class));
            this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus25.Volume.class)));
            this.metadata = software.amazon.jsii.Kernel.get(this, "metadata", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObjectMetadata.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.schedule = java.util.Objects.requireNonNull(builder.schedule, "schedule is required");
            this.concurrencyPolicy = builder.concurrencyPolicy;
            this.failedJobsRetained = builder.failedJobsRetained;
            this.startingDeadline = builder.startingDeadline;
            this.successfulJobsRetained = builder.successfulJobsRetained;
            this.suspend = builder.suspend;
            this.timeZone = builder.timeZone;
            this.activeDeadline = builder.activeDeadline;
            this.backoffLimit = builder.backoffLimit;
            this.ttlAfterFinished = builder.ttlAfterFinished;
            this.podMetadata = builder.podMetadata;
            this.select = builder.select;
            this.spread = builder.spread;
            this.automountServiceAccountToken = builder.automountServiceAccountToken;
            this.containers = (java.util.List<org.cdk8s.plus25.ContainerProps>)builder.containers;
            this.dns = builder.dns;
            this.dockerRegistryAuth = builder.dockerRegistryAuth;
            this.hostAliases = (java.util.List<org.cdk8s.plus25.HostAlias>)builder.hostAliases;
            this.initContainers = (java.util.List<org.cdk8s.plus25.ContainerProps>)builder.initContainers;
            this.isolate = builder.isolate;
            this.restartPolicy = builder.restartPolicy;
            this.securityContext = builder.securityContext;
            this.serviceAccount = builder.serviceAccount;
            this.volumes = (java.util.List<org.cdk8s.plus25.Volume>)builder.volumes;
            this.metadata = builder.metadata;
        }

        @Override
        public final org.cdk8s.Cron getSchedule() {
            return this.schedule;
        }

        @Override
        public final org.cdk8s.plus25.ConcurrencyPolicy getConcurrencyPolicy() {
            return this.concurrencyPolicy;
        }

        @Override
        public final java.lang.Number getFailedJobsRetained() {
            return this.failedJobsRetained;
        }

        @Override
        public final org.cdk8s.Duration getStartingDeadline() {
            return this.startingDeadline;
        }

        @Override
        public final java.lang.Number getSuccessfulJobsRetained() {
            return this.successfulJobsRetained;
        }

        @Override
        public final java.lang.Boolean getSuspend() {
            return this.suspend;
        }

        @Override
        public final java.lang.String getTimeZone() {
            return this.timeZone;
        }

        @Override
        public final org.cdk8s.Duration getActiveDeadline() {
            return this.activeDeadline;
        }

        @Override
        public final java.lang.Number getBackoffLimit() {
            return this.backoffLimit;
        }

        @Override
        public final org.cdk8s.Duration getTtlAfterFinished() {
            return this.ttlAfterFinished;
        }

        @Override
        public final org.cdk8s.ApiObjectMetadata getPodMetadata() {
            return this.podMetadata;
        }

        @Override
        public final java.lang.Boolean getSelect() {
            return this.select;
        }

        @Override
        public final java.lang.Boolean getSpread() {
            return this.spread;
        }

        @Override
        public final java.lang.Boolean getAutomountServiceAccountToken() {
            return this.automountServiceAccountToken;
        }

        @Override
        public final java.util.List<org.cdk8s.plus25.ContainerProps> getContainers() {
            return this.containers;
        }

        @Override
        public final org.cdk8s.plus25.PodDnsProps getDns() {
            return this.dns;
        }

        @Override
        public final org.cdk8s.plus25.ISecret getDockerRegistryAuth() {
            return this.dockerRegistryAuth;
        }

        @Override
        public final java.util.List<org.cdk8s.plus25.HostAlias> getHostAliases() {
            return this.hostAliases;
        }

        @Override
        public final java.util.List<org.cdk8s.plus25.ContainerProps> getInitContainers() {
            return this.initContainers;
        }

        @Override
        public final java.lang.Boolean getIsolate() {
            return this.isolate;
        }

        @Override
        public final org.cdk8s.plus25.RestartPolicy getRestartPolicy() {
            return this.restartPolicy;
        }

        @Override
        public final org.cdk8s.plus25.PodSecurityContextProps getSecurityContext() {
            return this.securityContext;
        }

        @Override
        public final org.cdk8s.plus25.IServiceAccount getServiceAccount() {
            return this.serviceAccount;
        }

        @Override
        public final java.util.List<org.cdk8s.plus25.Volume> getVolumes() {
            return this.volumes;
        }

        @Override
        public final org.cdk8s.ApiObjectMetadata getMetadata() {
            return this.metadata;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("schedule", om.valueToTree(this.getSchedule()));
            if (this.getConcurrencyPolicy() != null) {
                data.set("concurrencyPolicy", om.valueToTree(this.getConcurrencyPolicy()));
            }
            if (this.getFailedJobsRetained() != null) {
                data.set("failedJobsRetained", om.valueToTree(this.getFailedJobsRetained()));
            }
            if (this.getStartingDeadline() != null) {
                data.set("startingDeadline", om.valueToTree(this.getStartingDeadline()));
            }
            if (this.getSuccessfulJobsRetained() != null) {
                data.set("successfulJobsRetained", om.valueToTree(this.getSuccessfulJobsRetained()));
            }
            if (this.getSuspend() != null) {
                data.set("suspend", om.valueToTree(this.getSuspend()));
            }
            if (this.getTimeZone() != null) {
                data.set("timeZone", om.valueToTree(this.getTimeZone()));
            }
            if (this.getActiveDeadline() != null) {
                data.set("activeDeadline", om.valueToTree(this.getActiveDeadline()));
            }
            if (this.getBackoffLimit() != null) {
                data.set("backoffLimit", om.valueToTree(this.getBackoffLimit()));
            }
            if (this.getTtlAfterFinished() != null) {
                data.set("ttlAfterFinished", om.valueToTree(this.getTtlAfterFinished()));
            }
            if (this.getPodMetadata() != null) {
                data.set("podMetadata", om.valueToTree(this.getPodMetadata()));
            }
            if (this.getSelect() != null) {
                data.set("select", om.valueToTree(this.getSelect()));
            }
            if (this.getSpread() != null) {
                data.set("spread", om.valueToTree(this.getSpread()));
            }
            if (this.getAutomountServiceAccountToken() != null) {
                data.set("automountServiceAccountToken", om.valueToTree(this.getAutomountServiceAccountToken()));
            }
            if (this.getContainers() != null) {
                data.set("containers", om.valueToTree(this.getContainers()));
            }
            if (this.getDns() != null) {
                data.set("dns", om.valueToTree(this.getDns()));
            }
            if (this.getDockerRegistryAuth() != null) {
                data.set("dockerRegistryAuth", om.valueToTree(this.getDockerRegistryAuth()));
            }
            if (this.getHostAliases() != null) {
                data.set("hostAliases", om.valueToTree(this.getHostAliases()));
            }
            if (this.getInitContainers() != null) {
                data.set("initContainers", om.valueToTree(this.getInitContainers()));
            }
            if (this.getIsolate() != null) {
                data.set("isolate", om.valueToTree(this.getIsolate()));
            }
            if (this.getRestartPolicy() != null) {
                data.set("restartPolicy", om.valueToTree(this.getRestartPolicy()));
            }
            if (this.getSecurityContext() != null) {
                data.set("securityContext", om.valueToTree(this.getSecurityContext()));
            }
            if (this.getServiceAccount() != null) {
                data.set("serviceAccount", om.valueToTree(this.getServiceAccount()));
            }
            if (this.getVolumes() != null) {
                data.set("volumes", om.valueToTree(this.getVolumes()));
            }
            if (this.getMetadata() != null) {
                data.set("metadata", om.valueToTree(this.getMetadata()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus-25.CronJobProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CronJobProps.Jsii$Proxy that = (CronJobProps.Jsii$Proxy) o;

            if (!schedule.equals(that.schedule)) return false;
            if (this.concurrencyPolicy != null ? !this.concurrencyPolicy.equals(that.concurrencyPolicy) : that.concurrencyPolicy != null) return false;
            if (this.failedJobsRetained != null ? !this.failedJobsRetained.equals(that.failedJobsRetained) : that.failedJobsRetained != null) return false;
            if (this.startingDeadline != null ? !this.startingDeadline.equals(that.startingDeadline) : that.startingDeadline != null) return false;
            if (this.successfulJobsRetained != null ? !this.successfulJobsRetained.equals(that.successfulJobsRetained) : that.successfulJobsRetained != null) return false;
            if (this.suspend != null ? !this.suspend.equals(that.suspend) : that.suspend != null) return false;
            if (this.timeZone != null ? !this.timeZone.equals(that.timeZone) : that.timeZone != null) return false;
            if (this.activeDeadline != null ? !this.activeDeadline.equals(that.activeDeadline) : that.activeDeadline != null) return false;
            if (this.backoffLimit != null ? !this.backoffLimit.equals(that.backoffLimit) : that.backoffLimit != null) return false;
            if (this.ttlAfterFinished != null ? !this.ttlAfterFinished.equals(that.ttlAfterFinished) : that.ttlAfterFinished != null) return false;
            if (this.podMetadata != null ? !this.podMetadata.equals(that.podMetadata) : that.podMetadata != null) return false;
            if (this.select != null ? !this.select.equals(that.select) : that.select != null) return false;
            if (this.spread != null ? !this.spread.equals(that.spread) : that.spread != null) return false;
            if (this.automountServiceAccountToken != null ? !this.automountServiceAccountToken.equals(that.automountServiceAccountToken) : that.automountServiceAccountToken != null) return false;
            if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) return false;
            if (this.dns != null ? !this.dns.equals(that.dns) : that.dns != null) return false;
            if (this.dockerRegistryAuth != null ? !this.dockerRegistryAuth.equals(that.dockerRegistryAuth) : that.dockerRegistryAuth != null) return false;
            if (this.hostAliases != null ? !this.hostAliases.equals(that.hostAliases) : that.hostAliases != null) return false;
            if (this.initContainers != null ? !this.initContainers.equals(that.initContainers) : that.initContainers != null) return false;
            if (this.isolate != null ? !this.isolate.equals(that.isolate) : that.isolate != null) return false;
            if (this.restartPolicy != null ? !this.restartPolicy.equals(that.restartPolicy) : that.restartPolicy != null) return false;
            if (this.securityContext != null ? !this.securityContext.equals(that.securityContext) : that.securityContext != null) return false;
            if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) return false;
            if (this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null) return false;
            return this.metadata != null ? this.metadata.equals(that.metadata) : that.metadata == null;
        }

        @Override
        public final int hashCode() {
            int result = this.schedule.hashCode();
            result = 31 * result + (this.concurrencyPolicy != null ? this.concurrencyPolicy.hashCode() : 0);
            result = 31 * result + (this.failedJobsRetained != null ? this.failedJobsRetained.hashCode() : 0);
            result = 31 * result + (this.startingDeadline != null ? this.startingDeadline.hashCode() : 0);
            result = 31 * result + (this.successfulJobsRetained != null ? this.successfulJobsRetained.hashCode() : 0);
            result = 31 * result + (this.suspend != null ? this.suspend.hashCode() : 0);
            result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
            result = 31 * result + (this.activeDeadline != null ? this.activeDeadline.hashCode() : 0);
            result = 31 * result + (this.backoffLimit != null ? this.backoffLimit.hashCode() : 0);
            result = 31 * result + (this.ttlAfterFinished != null ? this.ttlAfterFinished.hashCode() : 0);
            result = 31 * result + (this.podMetadata != null ? this.podMetadata.hashCode() : 0);
            result = 31 * result + (this.select != null ? this.select.hashCode() : 0);
            result = 31 * result + (this.spread != null ? this.spread.hashCode() : 0);
            result = 31 * result + (this.automountServiceAccountToken != null ? this.automountServiceAccountToken.hashCode() : 0);
            result = 31 * result + (this.containers != null ? this.containers.hashCode() : 0);
            result = 31 * result + (this.dns != null ? this.dns.hashCode() : 0);
            result = 31 * result + (this.dockerRegistryAuth != null ? this.dockerRegistryAuth.hashCode() : 0);
            result = 31 * result + (this.hostAliases != null ? this.hostAliases.hashCode() : 0);
            result = 31 * result + (this.initContainers != null ? this.initContainers.hashCode() : 0);
            result = 31 * result + (this.isolate != null ? this.isolate.hashCode() : 0);
            result = 31 * result + (this.restartPolicy != null ? this.restartPolicy.hashCode() : 0);
            result = 31 * result + (this.securityContext != null ? this.securityContext.hashCode() : 0);
            result = 31 * result + (this.serviceAccount != null ? this.serviceAccount.hashCode() : 0);
            result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
            result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
            return result;
        }
    }
}
