package org.cdk8s.plus25;

/**
 * Controls the pod scheduling strategy.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.79.0 (build b22f628)", date = "2023-03-28T02:31:40.679Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus25.$Module.class, fqn = "cdk8s-plus-25.PodScheduling")
public class PodScheduling extends software.amazon.jsii.JsiiObject {

    protected PodScheduling(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PodScheduling(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param instance This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PodScheduling(final @org.jetbrains.annotations.NotNull org.cdk8s.plus25.AbstractPod instance) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(instance, "instance is required") });
    }

    /**
     * Assign this pod a specific node by name.
     * <p>
     * The scheduler ignores the Pod, and the kubelet on the named node
     * tries to place the Pod on that node. Overrules any affinity rules of the pod.
     * <p>
     * Some limitations of static assignment are:
     * <p>
     * <ul>
     * <li>If the named node does not exist, the Pod will not run, and in some
     * cases may be automatically deleted.</li>
     * <li>If the named node does not have the resources to accommodate the Pod,
     * the Pod will fail and its reason will indicate why, for example OutOfmemory or OutOfcpu.</li>
     * <li>Node names in cloud environments are not always predictable or stable.</li>
     * </ul>
     * <p>
     * Will throw is the pod is already assigned to named node.
     * <p>
     * Under the hood, this method utilizes the <code>nodeName</code> property.
     * <p>
     * @param node This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void assign(final @org.jetbrains.annotations.NotNull org.cdk8s.plus25.NamedNode node) {
        software.amazon.jsii.Kernel.call(this, "assign", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(node, "node is required") });
    }

    /**
     * Attract this pod to a node matched by selectors. You can select a node by using `Node.labeled()`.
     * <p>
     * Attracting to multiple nodes (i.e invoking this method multiple times) acts as
     * an OR condition, meaning the pod will be assigned to either one of the nodes.
     * <p>
     * Under the hood, this method utilizes the <code>nodeAffinity</code> property.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#node-affinity">https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#node-affinity</a>
     * @param node This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void attract(final @org.jetbrains.annotations.NotNull org.cdk8s.plus25.LabeledNode node, final @org.jetbrains.annotations.Nullable org.cdk8s.plus25.PodSchedulingAttractOptions options) {
        software.amazon.jsii.Kernel.call(this, "attract", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(node, "node is required"), options });
    }

    /**
     * Attract this pod to a node matched by selectors. You can select a node by using `Node.labeled()`.
     * <p>
     * Attracting to multiple nodes (i.e invoking this method multiple times) acts as
     * an OR condition, meaning the pod will be assigned to either one of the nodes.
     * <p>
     * Under the hood, this method utilizes the <code>nodeAffinity</code> property.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#node-affinity">https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#node-affinity</a>
     * @param node This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void attract(final @org.jetbrains.annotations.NotNull org.cdk8s.plus25.LabeledNode node) {
        software.amazon.jsii.Kernel.call(this, "attract", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(node, "node is required") });
    }

    /**
     * Co-locate this pod with a scheduling selection.
     * <p>
     * A selection can be one of:
     * <p>
     * <ul>
     * <li>An instance of a <code>Pod</code>.</li>
     * <li>An instance of a <code>Workload</code> (e.g <code>Deployment</code>, <code>StatefulSet</code>).</li>
     * <li>An un-managed pod that can be selected via <code>Pods.select()</code>.</li>
     * </ul>
     * <p>
     * Co-locating with multiple selections ((i.e invoking this method multiple times)) acts as
     * an AND condition. meaning the pod will be assigned to a node that satisfies all
     * selections (i.e runs at least one pod that satisifies each selection).
     * <p>
     * Under the hood, this method utilizes the <code>podAffinity</code> property.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#inter-pod-affinity-and-anti-affinity">https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#inter-pod-affinity-and-anti-affinity</a>
     * @param selector This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void colocate(final @org.jetbrains.annotations.NotNull org.cdk8s.plus25.IPodSelector selector, final @org.jetbrains.annotations.Nullable org.cdk8s.plus25.PodSchedulingColocateOptions options) {
        software.amazon.jsii.Kernel.call(this, "colocate", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(selector, "selector is required"), options });
    }

    /**
     * Co-locate this pod with a scheduling selection.
     * <p>
     * A selection can be one of:
     * <p>
     * <ul>
     * <li>An instance of a <code>Pod</code>.</li>
     * <li>An instance of a <code>Workload</code> (e.g <code>Deployment</code>, <code>StatefulSet</code>).</li>
     * <li>An un-managed pod that can be selected via <code>Pods.select()</code>.</li>
     * </ul>
     * <p>
     * Co-locating with multiple selections ((i.e invoking this method multiple times)) acts as
     * an AND condition. meaning the pod will be assigned to a node that satisfies all
     * selections (i.e runs at least one pod that satisifies each selection).
     * <p>
     * Under the hood, this method utilizes the <code>podAffinity</code> property.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#inter-pod-affinity-and-anti-affinity">https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#inter-pod-affinity-and-anti-affinity</a>
     * @param selector This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void colocate(final @org.jetbrains.annotations.NotNull org.cdk8s.plus25.IPodSelector selector) {
        software.amazon.jsii.Kernel.call(this, "colocate", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(selector, "selector is required") });
    }

    /**
     * Seperate this pod from a scheduling selection.
     * <p>
     * A selection can be one of:
     * <p>
     * <ul>
     * <li>An instance of a <code>Pod</code>.</li>
     * <li>An instance of a <code>Workload</code> (e.g <code>Deployment</code>, <code>StatefulSet</code>).</li>
     * <li>An un-managed pod that can be selected via <code>Pods.select()</code>.</li>
     * </ul>
     * <p>
     * Seperating from multiple selections acts as an AND condition. meaning the pod
     * will not be assigned to a node that satisfies all selections (i.e runs at least one pod that satisifies each selection).
     * <p>
     * Under the hood, this method utilizes the <code>podAntiAffinity</code> property.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#inter-pod-affinity-and-anti-affinity">https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#inter-pod-affinity-and-anti-affinity</a>
     * @param selector This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void separate(final @org.jetbrains.annotations.NotNull org.cdk8s.plus25.IPodSelector selector, final @org.jetbrains.annotations.Nullable org.cdk8s.plus25.PodSchedulingSeparateOptions options) {
        software.amazon.jsii.Kernel.call(this, "separate", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(selector, "selector is required"), options });
    }

    /**
     * Seperate this pod from a scheduling selection.
     * <p>
     * A selection can be one of:
     * <p>
     * <ul>
     * <li>An instance of a <code>Pod</code>.</li>
     * <li>An instance of a <code>Workload</code> (e.g <code>Deployment</code>, <code>StatefulSet</code>).</li>
     * <li>An un-managed pod that can be selected via <code>Pods.select()</code>.</li>
     * </ul>
     * <p>
     * Seperating from multiple selections acts as an AND condition. meaning the pod
     * will not be assigned to a node that satisfies all selections (i.e runs at least one pod that satisifies each selection).
     * <p>
     * Under the hood, this method utilizes the <code>podAntiAffinity</code> property.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#inter-pod-affinity-and-anti-affinity">https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#inter-pod-affinity-and-anti-affinity</a>
     * @param selector This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void separate(final @org.jetbrains.annotations.NotNull org.cdk8s.plus25.IPodSelector selector) {
        software.amazon.jsii.Kernel.call(this, "separate", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(selector, "selector is required") });
    }

    /**
     * Allow this pod to tolerate taints matching these tolerations.
     * <p>
     * You can put multiple taints on the same node and multiple tolerations on the same pod.
     * The way Kubernetes processes multiple taints and tolerations is like a filter: start with
     * all of a node's taints, then ignore the ones for which the pod has a matching toleration;
     * the remaining un-ignored taints have the indicated effects on the pod. In particular:
     * <p>
     * <ul>
     * <li>if there is at least one un-ignored taint with effect NoSchedule then Kubernetes will
     * not schedule the pod onto that node</li>
     * <li>if there is no un-ignored taint with effect NoSchedule but there is at least one un-ignored
     * taint with effect PreferNoSchedule then Kubernetes will try to not schedule the pod onto the node</li>
     * <li>if there is at least one un-ignored taint with effect NoExecute then the pod will be evicted from
     * the node (if it is already running on the node), and will not be scheduled onto the node (if it is
     * not yet running on the node).</li>
     * </ul>
     * <p>
     * Under the hood, this method utilizes the <code>tolerations</code> property.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/">https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/</a>
     * @param node This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void tolerate(final @org.jetbrains.annotations.NotNull org.cdk8s.plus25.TaintedNode node) {
        software.amazon.jsii.Kernel.call(this, "tolerate", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(node, "node is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull org.cdk8s.plus25.AbstractPod getInstance() {
        return software.amazon.jsii.Kernel.get(this, "instance", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus25.AbstractPod.class));
    }
}
