/*
 * Decompiled with CFR 0.152.
 */
package org.cdk8s.plus26;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.cdk8s.ApiObject;
import org.cdk8s.ApiObjectMetadata;
import org.cdk8s.plus26.;
import org.cdk8s.plus26.HttpIngressPathType;
import org.cdk8s.plus26.IngressBackend;
import org.cdk8s.plus26.IngressProps;
import org.cdk8s.plus26.IngressRule;
import org.cdk8s.plus26.IngressTls;
import org.cdk8s.plus26.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="cdk8s-plus-26.Ingress")
public class Ingress
extends Resource {
    protected Ingress(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Ingress(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Ingress(@NotNull Construct scope, @NotNull String id, @Nullable IngressProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Ingress(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void addDefaultBackend(@NotNull IngressBackend backend) {
        Kernel.call((Object)this, (String)"addDefaultBackend", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(backend, "backend is required")});
    }

    public void addHostDefaultBackend(@NotNull String host, @NotNull IngressBackend backend) {
        Kernel.call((Object)this, (String)"addHostDefaultBackend", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(host, "host is required"), Objects.requireNonNull(backend, "backend is required")});
    }

    public void addHostRule(@NotNull String host, @NotNull String path, @NotNull IngressBackend backend, @Nullable HttpIngressPathType pathType) {
        Kernel.call((Object)this, (String)"addHostRule", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(host, "host is required"), Objects.requireNonNull(path, "path is required"), Objects.requireNonNull(backend, "backend is required"), pathType});
    }

    public void addHostRule(@NotNull String host, @NotNull String path, @NotNull IngressBackend backend) {
        Kernel.call((Object)this, (String)"addHostRule", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(host, "host is required"), Objects.requireNonNull(path, "path is required"), Objects.requireNonNull(backend, "backend is required")});
    }

    public void addRule(@NotNull String path, @NotNull IngressBackend backend, @Nullable HttpIngressPathType pathType) {
        Kernel.call((Object)this, (String)"addRule", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(path, "path is required"), Objects.requireNonNull(backend, "backend is required"), pathType});
    }

    public void addRule(@NotNull String path, @NotNull IngressBackend backend) {
        Kernel.call((Object)this, (String)"addRule", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(path, "path is required"), Objects.requireNonNull(backend, "backend is required")});
    }

    public void addRules(IngressRule ... rules) {
        Kernel.call((Object)this, (String)"addRules", (NativeType)NativeType.VOID, (Object[])Arrays.stream(rules).toArray(Object[]::new));
    }

    public void addTls(@NotNull List<IngressTls> tls) {
        Kernel.call((Object)this, (String)"addTls", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(tls, "tls is required")});
    }

    @Override
    @NotNull
    protected ApiObject getApiObject() {
        return (ApiObject)Kernel.get((Object)this, (String)"apiObject", (NativeType)NativeType.forClass(ApiObject.class));
    }

    @Override
    @NotNull
    public String getResourceType() {
        return (String)Kernel.get((Object)this, (String)"resourceType", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Ingress> {
        private final Construct scope;
        private final String id;
        private IngressProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder metadata(ApiObjectMetadata metadata) {
            this.props().metadata(metadata);
            return this;
        }

        public Builder defaultBackend(IngressBackend defaultBackend) {
            this.props().defaultBackend(defaultBackend);
            return this;
        }

        public Builder rules(List<? extends IngressRule> rules) {
            this.props().rules(rules);
            return this;
        }

        public Builder tls(List<? extends IngressTls> tls) {
            this.props().tls(tls);
            return this;
        }

        public Ingress build() {
            return new Ingress(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private IngressProps.Builder props() {
            if (this.props == null) {
                this.props = new IngressProps.Builder();
            }
            return this.props;
        }
    }
}

