/*
 * Decompiled with CFR 0.152.
 */
package org.cdk8s.plus27;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.cdk8s.ApiObject;
import org.cdk8s.ApiObjectMetadata;
import org.cdk8s.plus27.;
import org.cdk8s.plus27.ClusterRoleBinding;
import org.cdk8s.plus27.ClusterRolePolicyRule;
import org.cdk8s.plus27.ClusterRoleProps;
import org.cdk8s.plus27.IApiEndpoint;
import org.cdk8s.plus27.IClusterRole;
import org.cdk8s.plus27.IRole;
import org.cdk8s.plus27.ISubject;
import org.cdk8s.plus27.Resource;
import org.cdk8s.plus27.RoleBinding;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="cdk8s-plus-27.ClusterRole")
public class ClusterRole
extends Resource
implements IClusterRole,
IRole {
    protected ClusterRole(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ClusterRole(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ClusterRole(@NotNull Construct scope, @NotNull String id, @Nullable ClusterRoleProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public ClusterRole(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IClusterRole fromClusterRoleName(@NotNull Construct scope, @NotNull String id, @NotNull String name) {
        return (IClusterRole)JsiiObject.jsiiStaticCall(ClusterRole.class, (String)"fromClusterRoleName", (NativeType)NativeType.forClass(IClusterRole.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(name, "name is required")});
    }

    public void aggregate(@NotNull String key, @NotNull String value) {
        Kernel.call((Object)this, (String)"aggregate", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(key, "key is required"), Objects.requireNonNull(value, "value is required")});
    }

    public void allow(@NotNull List<String> verbs, IApiEndpoint ... endpoints) {
        Kernel.call((Object)this, (String)"allow", (NativeType)NativeType.VOID, (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(verbs, "verbs is required")}), Arrays.stream(endpoints)).toArray(Object[]::new));
    }

    public void allowCreate(IApiEndpoint ... endpoints) {
        Kernel.call((Object)this, (String)"allowCreate", (NativeType)NativeType.VOID, (Object[])Arrays.stream(endpoints).toArray(Object[]::new));
    }

    public void allowDelete(IApiEndpoint ... endpoints) {
        Kernel.call((Object)this, (String)"allowDelete", (NativeType)NativeType.VOID, (Object[])Arrays.stream(endpoints).toArray(Object[]::new));
    }

    public void allowDeleteCollection(IApiEndpoint ... endpoints) {
        Kernel.call((Object)this, (String)"allowDeleteCollection", (NativeType)NativeType.VOID, (Object[])Arrays.stream(endpoints).toArray(Object[]::new));
    }

    public void allowGet(IApiEndpoint ... endpoints) {
        Kernel.call((Object)this, (String)"allowGet", (NativeType)NativeType.VOID, (Object[])Arrays.stream(endpoints).toArray(Object[]::new));
    }

    public void allowList(IApiEndpoint ... endpoints) {
        Kernel.call((Object)this, (String)"allowList", (NativeType)NativeType.VOID, (Object[])Arrays.stream(endpoints).toArray(Object[]::new));
    }

    public void allowPatch(IApiEndpoint ... endpoints) {
        Kernel.call((Object)this, (String)"allowPatch", (NativeType)NativeType.VOID, (Object[])Arrays.stream(endpoints).toArray(Object[]::new));
    }

    public void allowRead(IApiEndpoint ... endpoints) {
        Kernel.call((Object)this, (String)"allowRead", (NativeType)NativeType.VOID, (Object[])Arrays.stream(endpoints).toArray(Object[]::new));
    }

    public void allowReadWrite(IApiEndpoint ... endpoints) {
        Kernel.call((Object)this, (String)"allowReadWrite", (NativeType)NativeType.VOID, (Object[])Arrays.stream(endpoints).toArray(Object[]::new));
    }

    public void allowUpdate(IApiEndpoint ... endpoints) {
        Kernel.call((Object)this, (String)"allowUpdate", (NativeType)NativeType.VOID, (Object[])Arrays.stream(endpoints).toArray(Object[]::new));
    }

    public void allowWatch(IApiEndpoint ... endpoints) {
        Kernel.call((Object)this, (String)"allowWatch", (NativeType)NativeType.VOID, (Object[])Arrays.stream(endpoints).toArray(Object[]::new));
    }

    @NotNull
    public ClusterRoleBinding bind(ISubject ... subjects) {
        return (ClusterRoleBinding)Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.forClass(ClusterRoleBinding.class), (Object[])Arrays.stream(subjects).toArray(Object[]::new));
    }

    @NotNull
    public RoleBinding bindInNamespace(@NotNull String namespace, ISubject ... subjects) {
        return (RoleBinding)Kernel.call((Object)this, (String)"bindInNamespace", (NativeType)NativeType.forClass(RoleBinding.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(namespace, "namespace is required")}), Arrays.stream(subjects)).toArray(Object[]::new));
    }

    public void combine(@NotNull ClusterRole rol) {
        Kernel.call((Object)this, (String)"combine", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(rol, "rol is required")});
    }

    @Override
    @NotNull
    protected ApiObject getApiObject() {
        return (ApiObject)Kernel.get((Object)this, (String)"apiObject", (NativeType)NativeType.forClass(ApiObject.class));
    }

    @Override
    @NotNull
    public String getResourceType() {
        return (String)Kernel.get((Object)this, (String)"resourceType", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<ClusterRolePolicyRule> getRules() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"rules", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(ClusterRolePolicyRule.class))));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ClusterRole> {
        private final Construct scope;
        private final String id;
        private ClusterRoleProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder metadata(ApiObjectMetadata metadata) {
            this.props().metadata(metadata);
            return this;
        }

        public Builder aggregationLabels(Map<String, String> aggregationLabels) {
            this.props().aggregationLabels(aggregationLabels);
            return this;
        }

        public Builder rules(List<? extends ClusterRolePolicyRule> rules) {
            this.props().rules(rules);
            return this;
        }

        public ClusterRole build() {
            return new ClusterRole(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private ClusterRoleProps.Builder props() {
            if (this.props == null) {
                this.props = new ClusterRoleProps.Builder();
            }
            return this.props;
        }
    }
}

