package org.cdk8s.plus27;

/**
 * Container lifecycle properties.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.93.0 (build 1706ca5)", date = "2023-12-09T12:11:10.446Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus27.$Module.class, fqn = "cdk8s-plus-27.ContainerLifecycle")
@software.amazon.jsii.Jsii.Proxy(ContainerLifecycle.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ContainerLifecycle extends software.amazon.jsii.JsiiSerializable {

    /**
     * This hook is executed immediately after a container is created.
     * <p>
     * However,
     * there is no guarantee that the hook will execute before the container ENTRYPOINT.
     * <p>
     * Default: - No post start handler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus27.Handler getPostStart() {
        return null;
    }

    /**
     * This hook is called immediately before a container is terminated due to an API request or management event such as a liveness/startup probe failure, preemption, resource contention and others.
     * <p>
     * A call to the PreStop hook fails if the container is already in a terminated or completed state
     * and the hook must complete before the TERM signal to stop the container can be sent.
     * The Pod's termination grace period countdown begins before the PreStop hook is executed,
     * so regardless of the outcome of the handler, the container will eventually terminate
     * within the Pod's termination grace period. No parameters are passed to the handler.
     * <p>
     * Default: - No pre stop handler.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#pod-termination">https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#pod-termination</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus27.Handler getPreStop() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ContainerLifecycle}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ContainerLifecycle}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ContainerLifecycle> {
        org.cdk8s.plus27.Handler postStart;
        org.cdk8s.plus27.Handler preStop;

        /**
         * Sets the value of {@link ContainerLifecycle#getPostStart}
         * @param postStart This hook is executed immediately after a container is created.
         *                  However,
         *                  there is no guarantee that the hook will execute before the container ENTRYPOINT.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postStart(org.cdk8s.plus27.Handler postStart) {
            this.postStart = postStart;
            return this;
        }

        /**
         * Sets the value of {@link ContainerLifecycle#getPreStop}
         * @param preStop This hook is called immediately before a container is terminated due to an API request or management event such as a liveness/startup probe failure, preemption, resource contention and others.
         *                A call to the PreStop hook fails if the container is already in a terminated or completed state
         *                and the hook must complete before the TERM signal to stop the container can be sent.
         *                The Pod's termination grace period countdown begins before the PreStop hook is executed,
         *                so regardless of the outcome of the handler, the container will eventually terminate
         *                within the Pod's termination grace period. No parameters are passed to the handler.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preStop(org.cdk8s.plus27.Handler preStop) {
            this.preStop = preStop;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ContainerLifecycle}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ContainerLifecycle build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ContainerLifecycle}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerLifecycle {
        private final org.cdk8s.plus27.Handler postStart;
        private final org.cdk8s.plus27.Handler preStop;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.postStart = software.amazon.jsii.Kernel.get(this, "postStart", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus27.Handler.class));
            this.preStop = software.amazon.jsii.Kernel.get(this, "preStop", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus27.Handler.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.postStart = builder.postStart;
            this.preStop = builder.preStop;
        }

        @Override
        public final org.cdk8s.plus27.Handler getPostStart() {
            return this.postStart;
        }

        @Override
        public final org.cdk8s.plus27.Handler getPreStop() {
            return this.preStop;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPostStart() != null) {
                data.set("postStart", om.valueToTree(this.getPostStart()));
            }
            if (this.getPreStop() != null) {
                data.set("preStop", om.valueToTree(this.getPreStop()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus-27.ContainerLifecycle"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ContainerLifecycle.Jsii$Proxy that = (ContainerLifecycle.Jsii$Proxy) o;

            if (this.postStart != null ? !this.postStart.equals(that.postStart) : that.postStart != null) return false;
            return this.preStop != null ? this.preStop.equals(that.preStop) : that.preStop == null;
        }

        @Override
        public final int hashCode() {
            int result = this.postStart != null ? this.postStart.hashCode() : 0;
            result = 31 * result + (this.preStop != null ? this.preStop.hashCode() : 0);
            return result;
        }
    }
}
