package org.cdk8s.plus27;

/**
 * Controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down.
 * <p>
 * The default policy is <code>OrderedReady</code>, where pods are created in increasing order
 * (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before
 * continuing. When scaling down, the pods are removed in the opposite order.
 * <p>
 * The alternative policy is <code>Parallel</code> which will create pods in parallel to match the
 * desired scale without waiting, and on scale down will delete all pods at once.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.93.0 (build 1706ca5)", date = "2023-12-09T12:11:10.544Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus27.$Module.class, fqn = "cdk8s-plus-27.PodManagementPolicy")
public enum PodManagementPolicy {
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ORDERED_READY,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PARALLEL,
}
