package org.cdk8s.plus27;

/**
 * A service account provides an identity for processes that run in a Pod.
 * <p>
 * When you (a human) access the cluster (for example, using kubectl), you are
 * authenticated by the apiserver as a particular User Account (currently this
 * is usually admin, unless your cluster administrator has customized your
 * cluster). Processes in containers inside pods can also contact the apiserver.
 * When they do, they are authenticated as a particular Service Account (for
 * example, default).
 * <p>
 * @see <a href="https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account">https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.93.0 (build 1706ca5)", date = "2023-12-09T12:11:10.559Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus27.$Module.class, fqn = "cdk8s-plus-27.ServiceAccount")
public class ServiceAccount extends org.cdk8s.plus27.Resource implements org.cdk8s.plus27.IServiceAccount, org.cdk8s.plus27.ISubject {

    protected ServiceAccount(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ServiceAccount(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ServiceAccount(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable org.cdk8s.plus27.ServiceAccountProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ServiceAccount(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Imports a service account from the cluster as a reference.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param name The name of the service account resource. This parameter is required.
     * @param options additional options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus27.IServiceAccount fromServiceAccountName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable org.cdk8s.plus27.FromServiceAccountNameOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus27.ServiceAccount.class, "fromServiceAccountName", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus27.IServiceAccount.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(name, "name is required"), options });
    }

    /**
     * Imports a service account from the cluster as a reference.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param name The name of the service account resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus27.IServiceAccount fromServiceAccountName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus27.ServiceAccount.class, "fromServiceAccountName", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus27.IServiceAccount.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * Allow a secret to be accessed by pods using this service account.
     * <p>
     * @param secr The secret. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSecret(final @org.jetbrains.annotations.NotNull org.cdk8s.plus27.ISecret secr) {
        software.amazon.jsii.Kernel.call(this, "addSecret", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(secr, "secr is required") });
    }

    /**
     * Return the subject configuration.
     * <p>
     * @see <a href="ISubect.toSubjectConfiguration()">ISubect.toSubjectConfiguration()</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus27.SubjectConfiguration toSubjectConfiguration() {
        return software.amazon.jsii.Kernel.call(this, "toSubjectConfiguration", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus27.SubjectConfiguration.class));
    }

    /**
     * The underlying cdk8s API object.
     * <p>
     * @see <a href="base.Resource.apiObject">base.Resource.apiObject</a>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull org.cdk8s.ApiObject getApiObject() {
        return software.amazon.jsii.Kernel.get(this, "apiObject", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObject.class));
    }

    /**
     * Whether or not a token is automatically mounted for this service account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getAutomountToken() {
        return software.amazon.jsii.Kernel.get(this, "automountToken", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The name of a resource type as it appears in the relevant API endpoint.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceType() {
        return software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * List of secrets allowed to be used by pods running using this service account.
     * <p>
     * Returns a copy. To add a secret, use <code>addSecret()</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus27.ISecret> getSecrets() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "secrets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus27.ISecret.class))));
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus27.ServiceAccount}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus27.ServiceAccount> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private org.cdk8s.plus27.ServiceAccountProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props().metadata(metadata);
            return this;
        }

        /**
         * Indicates whether pods running as this service account should have an API token automatically mounted.
         * <p>
         * Can be overridden at the pod level.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server">https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server</a>
         * @param automountToken Indicates whether pods running as this service account should have an API token automatically mounted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automountToken(final java.lang.Boolean automountToken) {
            this.props().automountToken(automountToken);
            return this;
        }

        /**
         * List of secrets allowed to be used by pods running using this ServiceAccount.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/configuration/secret">https://kubernetes.io/docs/concepts/configuration/secret</a>
         * @param secrets List of secrets allowed to be used by pods running using this ServiceAccount. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secrets(final java.util.List<? extends org.cdk8s.plus27.ISecret> secrets) {
            this.props().secrets(secrets);
            return this;
        }

        /**
         * @return a newly built instance of {@link org.cdk8s.plus27.ServiceAccount}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus27.ServiceAccount build() {
            return new org.cdk8s.plus27.ServiceAccount(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private org.cdk8s.plus27.ServiceAccountProps.Builder props() {
            if (this.props == null) {
                this.props = new org.cdk8s.plus27.ServiceAccountProps.Builder();
            }
            return this.props;
        }
    }
}
