package org.cdk8s.plus27.k8s;

/**
 * FlowSchemaSpec describes how the FlowSchema's specification looks like.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.93.0 (build 1706ca5)", date = "2023-12-09T12:11:10.616Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus27.$Module.class, fqn = "cdk8s-plus-27.k8s.FlowSchemaSpecV1Beta2")
@software.amazon.jsii.Jsii.Proxy(FlowSchemaSpecV1Beta2.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FlowSchemaSpecV1Beta2 extends software.amazon.jsii.JsiiSerializable {

    /**
     * <code>priorityLevelConfiguration</code> should reference a PriorityLevelConfiguration in the cluster.
     * <p>
     * If the reference cannot be resolved, the FlowSchema will be ignored and marked as invalid in its status. Required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull org.cdk8s.plus27.k8s.PriorityLevelConfigurationReferenceV1Beta2 getPriorityLevelConfiguration();

    /**
     * <code>distinguisherMethod</code> defines how to compute the flow distinguisher for requests that match this schema.
     * <p>
     * <code>nil</code> specifies that the distinguisher is disabled and thus will always be the empty string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus27.k8s.FlowDistinguisherMethodV1Beta2 getDistinguisherMethod() {
        return null;
    }

    /**
     * <code>matchingPrecedence</code> is used to choose among the FlowSchemas that match a given request.
     * <p>
     * The chosen FlowSchema is among those with the numerically lowest (which we take to be logically highest) MatchingPrecedence.  Each MatchingPrecedence value must be ranged in [1,10000]. Note that if the precedence is not specified, it will be set to 1000 as default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMatchingPrecedence() {
        return null;
    }

    /**
     * <code>rules</code> describes which requests will match this flow schema.
     * <p>
     * This FlowSchema matches a request if and only if at least one member of rules matches the request. if it is an empty slice, there will be no requests matching the FlowSchema.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.plus27.k8s.PolicyRulesWithSubjectsV1Beta2> getRules() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FlowSchemaSpecV1Beta2}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FlowSchemaSpecV1Beta2}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FlowSchemaSpecV1Beta2> {
        org.cdk8s.plus27.k8s.PriorityLevelConfigurationReferenceV1Beta2 priorityLevelConfiguration;
        org.cdk8s.plus27.k8s.FlowDistinguisherMethodV1Beta2 distinguisherMethod;
        java.lang.Number matchingPrecedence;
        java.util.List<org.cdk8s.plus27.k8s.PolicyRulesWithSubjectsV1Beta2> rules;

        /**
         * Sets the value of {@link FlowSchemaSpecV1Beta2#getPriorityLevelConfiguration}
         * @param priorityLevelConfiguration <code>priorityLevelConfiguration</code> should reference a PriorityLevelConfiguration in the cluster. This parameter is required.
         *                                   If the reference cannot be resolved, the FlowSchema will be ignored and marked as invalid in its status. Required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priorityLevelConfiguration(org.cdk8s.plus27.k8s.PriorityLevelConfigurationReferenceV1Beta2 priorityLevelConfiguration) {
            this.priorityLevelConfiguration = priorityLevelConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link FlowSchemaSpecV1Beta2#getDistinguisherMethod}
         * @param distinguisherMethod <code>distinguisherMethod</code> defines how to compute the flow distinguisher for requests that match this schema.
         *                            <code>nil</code> specifies that the distinguisher is disabled and thus will always be the empty string.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distinguisherMethod(org.cdk8s.plus27.k8s.FlowDistinguisherMethodV1Beta2 distinguisherMethod) {
            this.distinguisherMethod = distinguisherMethod;
            return this;
        }

        /**
         * Sets the value of {@link FlowSchemaSpecV1Beta2#getMatchingPrecedence}
         * @param matchingPrecedence <code>matchingPrecedence</code> is used to choose among the FlowSchemas that match a given request.
         *                           The chosen FlowSchema is among those with the numerically lowest (which we take to be logically highest) MatchingPrecedence.  Each MatchingPrecedence value must be ranged in [1,10000]. Note that if the precedence is not specified, it will be set to 1000 as default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matchingPrecedence(java.lang.Number matchingPrecedence) {
            this.matchingPrecedence = matchingPrecedence;
            return this;
        }

        /**
         * Sets the value of {@link FlowSchemaSpecV1Beta2#getRules}
         * @param rules <code>rules</code> describes which requests will match this flow schema.
         *              This FlowSchema matches a request if and only if at least one member of rules matches the request. if it is an empty slice, there will be no requests matching the FlowSchema.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder rules(java.util.List<? extends org.cdk8s.plus27.k8s.PolicyRulesWithSubjectsV1Beta2> rules) {
            this.rules = (java.util.List<org.cdk8s.plus27.k8s.PolicyRulesWithSubjectsV1Beta2>)rules;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FlowSchemaSpecV1Beta2}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FlowSchemaSpecV1Beta2 build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FlowSchemaSpecV1Beta2}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowSchemaSpecV1Beta2 {
        private final org.cdk8s.plus27.k8s.PriorityLevelConfigurationReferenceV1Beta2 priorityLevelConfiguration;
        private final org.cdk8s.plus27.k8s.FlowDistinguisherMethodV1Beta2 distinguisherMethod;
        private final java.lang.Number matchingPrecedence;
        private final java.util.List<org.cdk8s.plus27.k8s.PolicyRulesWithSubjectsV1Beta2> rules;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.priorityLevelConfiguration = software.amazon.jsii.Kernel.get(this, "priorityLevelConfiguration", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus27.k8s.PriorityLevelConfigurationReferenceV1Beta2.class));
            this.distinguisherMethod = software.amazon.jsii.Kernel.get(this, "distinguisherMethod", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus27.k8s.FlowDistinguisherMethodV1Beta2.class));
            this.matchingPrecedence = software.amazon.jsii.Kernel.get(this, "matchingPrecedence", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus27.k8s.PolicyRulesWithSubjectsV1Beta2.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.priorityLevelConfiguration = java.util.Objects.requireNonNull(builder.priorityLevelConfiguration, "priorityLevelConfiguration is required");
            this.distinguisherMethod = builder.distinguisherMethod;
            this.matchingPrecedence = builder.matchingPrecedence;
            this.rules = (java.util.List<org.cdk8s.plus27.k8s.PolicyRulesWithSubjectsV1Beta2>)builder.rules;
        }

        @Override
        public final org.cdk8s.plus27.k8s.PriorityLevelConfigurationReferenceV1Beta2 getPriorityLevelConfiguration() {
            return this.priorityLevelConfiguration;
        }

        @Override
        public final org.cdk8s.plus27.k8s.FlowDistinguisherMethodV1Beta2 getDistinguisherMethod() {
            return this.distinguisherMethod;
        }

        @Override
        public final java.lang.Number getMatchingPrecedence() {
            return this.matchingPrecedence;
        }

        @Override
        public final java.util.List<org.cdk8s.plus27.k8s.PolicyRulesWithSubjectsV1Beta2> getRules() {
            return this.rules;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("priorityLevelConfiguration", om.valueToTree(this.getPriorityLevelConfiguration()));
            if (this.getDistinguisherMethod() != null) {
                data.set("distinguisherMethod", om.valueToTree(this.getDistinguisherMethod()));
            }
            if (this.getMatchingPrecedence() != null) {
                data.set("matchingPrecedence", om.valueToTree(this.getMatchingPrecedence()));
            }
            if (this.getRules() != null) {
                data.set("rules", om.valueToTree(this.getRules()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus-27.k8s.FlowSchemaSpecV1Beta2"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FlowSchemaSpecV1Beta2.Jsii$Proxy that = (FlowSchemaSpecV1Beta2.Jsii$Proxy) o;

            if (!priorityLevelConfiguration.equals(that.priorityLevelConfiguration)) return false;
            if (this.distinguisherMethod != null ? !this.distinguisherMethod.equals(that.distinguisherMethod) : that.distinguisherMethod != null) return false;
            if (this.matchingPrecedence != null ? !this.matchingPrecedence.equals(that.matchingPrecedence) : that.matchingPrecedence != null) return false;
            return this.rules != null ? this.rules.equals(that.rules) : that.rules == null;
        }

        @Override
        public final int hashCode() {
            int result = this.priorityLevelConfiguration.hashCode();
            result = 31 * result + (this.distinguisherMethod != null ? this.distinguisherMethod.hashCode() : 0);
            result = 31 * result + (this.matchingPrecedence != null ? this.matchingPrecedence.hashCode() : 0);
            result = 31 * result + (this.rules != null ? this.rules.hashCode() : 0);
            return result;
        }
    }
}
