package org.cdk8s.plus27;

/**
 * A CronJob is responsible for creating a Job and scheduling it based on provided cron schedule.
 * <p>
 * This helps running Jobs in a recurring manner.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-16T12:09:32.432Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus27.$Module.class, fqn = "cdk8s-plus-27.CronJob")
public class CronJob extends org.cdk8s.plus27.Workload {

    protected CronJob(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CronJob(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CronJob(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull org.cdk8s.plus27.CronJobProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The underlying cdk8s API object.
     * <p>
     * @see <a href="base.Resource.apiObject">base.Resource.apiObject</a>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull org.cdk8s.ApiObject getApiObject() {
        return software.amazon.jsii.Kernel.get(this, "apiObject", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObject.class));
    }

    /**
     * The policy used by this cron job to determine the concurrency mode in which to schedule jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConcurrencyPolicy() {
        return software.amazon.jsii.Kernel.get(this, "concurrencyPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The number of failed jobs retained by this cron job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getFailedJobsRetained() {
        return software.amazon.jsii.Kernel.get(this, "failedJobsRetained", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Represents the resource type.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceType() {
        return software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The schedule this cron job is scheduled to run in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.Cron getSchedule() {
        return software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(org.cdk8s.Cron.class));
    }

    /**
     * The time by which the running cron job needs to schedule the next job execution.
     * <p>
     * The job is considered as failed if it misses this deadline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.Duration getStartingDeadline() {
        return software.amazon.jsii.Kernel.get(this, "startingDeadline", software.amazon.jsii.NativeType.forClass(org.cdk8s.Duration.class));
    }

    /**
     * The number of successful jobs retained by this cron job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getSuccessfulJobsRetained() {
        return software.amazon.jsii.Kernel.get(this, "successfulJobsRetained", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Whether or not the cron job is currently suspended or not.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getSuspend() {
        return software.amazon.jsii.Kernel.get(this, "suspend", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The timezone which this cron job would follow to schedule jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTimeZone() {
        return software.amazon.jsii.Kernel.get(this, "timeZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus27.CronJob}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus27.CronJob> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final org.cdk8s.plus27.CronJobProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new org.cdk8s.plus27.CronJobProps.Builder();
        }

        /**
         * Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props.metadata(metadata);
            return this;
        }

        /**
         * Indicates whether a service account token should be automatically mounted.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server">https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server</a>
         * @param automountServiceAccountToken Indicates whether a service account token should be automatically mounted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automountServiceAccountToken(final java.lang.Boolean automountServiceAccountToken) {
            this.props.automountServiceAccountToken(automountServiceAccountToken);
            return this;
        }

        /**
         * List of containers belonging to the pod.
         * <p>
         * Containers cannot currently be
         * added or removed. There must be at least one container in a Pod.
         * <p>
         * You can add additionnal containers using <code>podSpec.addContainer()</code>
         * <p>
         * Default: - No containers. Note that a pod spec must include at least one container.
         * <p>
         * @return {@code this}
         * @param containers List of containers belonging to the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containers(final java.util.List<? extends org.cdk8s.plus27.ContainerProps> containers) {
            this.props.containers(containers);
            return this;
        }

        /**
         * DNS settings for the pod.
         * <p>
         * Default:  policy: DnsPolicy.CLUSTER_FIRST
         *  hostnameAsFQDN: false
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/">https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/</a>
         * @param dns DNS settings for the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dns(final org.cdk8s.plus27.PodDnsProps dns) {
            this.props.dns(dns);
            return this;
        }

        /**
         * A secret containing docker credentials for authenticating to a registry.
         * <p>
         * Default: - No auth. Images are assumed to be publicly available.
         * <p>
         * @return {@code this}
         * @param dockerRegistryAuth A secret containing docker credentials for authenticating to a registry. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerRegistryAuth(final org.cdk8s.plus27.ISecret dockerRegistryAuth) {
            this.props.dockerRegistryAuth(dockerRegistryAuth);
            return this;
        }

        /**
         * HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
         * <p>
         * @return {@code this}
         * @param hostAliases HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostAliases(final java.util.List<? extends org.cdk8s.plus27.HostAlias> hostAliases) {
            this.props.hostAliases(hostAliases);
            return this;
        }

        /**
         * Host network for the pod.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param hostNetwork Host network for the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostNetwork(final java.lang.Boolean hostNetwork) {
            this.props.hostNetwork(hostNetwork);
            return this;
        }

        /**
         * List of initialization containers belonging to the pod.
         * <p>
         * Init containers are executed in order prior to containers being started.
         * If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
         * The name for an init container or normal container must be unique among all containers.
         * Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
         * The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
         * for each resource type, and then using the max of of that value or the sum of the normal containers.
         * Limits are applied to init containers in a similar fashion.
         * <p>
         * Init containers cannot currently be added ,removed or updated.
         * <p>
         * Default: - No init containers.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/workloads/pods/init-containers/">https://kubernetes.io/docs/concepts/workloads/pods/init-containers/</a>
         * @param initContainers List of initialization containers belonging to the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initContainers(final java.util.List<? extends org.cdk8s.plus27.ContainerProps> initContainers) {
            this.props.initContainers(initContainers);
            return this;
        }

        /**
         * Isolates the pod.
         * <p>
         * This will prevent any ingress or egress connections to / from this pod.
         * You can however allow explicit connections post instantiation by using the <code>.connections</code> property.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param isolate Isolates the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isolate(final java.lang.Boolean isolate) {
            this.props.isolate(isolate);
            return this;
        }

        /**
         * Restart policy for all containers within the pod.
         * <p>
         * Default: RestartPolicy.ALWAYS
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy">https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy</a>
         * @param restartPolicy Restart policy for all containers within the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartPolicy(final org.cdk8s.plus27.RestartPolicy restartPolicy) {
            this.props.restartPolicy(restartPolicy);
            return this;
        }

        /**
         * SecurityContext holds pod-level security attributes and common container settings.
         * <p>
         * Default:   fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
         *   ensureNonRoot: true
         * <p>
         * @return {@code this}
         * @param securityContext SecurityContext holds pod-level security attributes and common container settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityContext(final org.cdk8s.plus27.PodSecurityContextProps securityContext) {
            this.props.securityContext(securityContext);
            return this;
        }

        /**
         * A service account provides an identity for processes that run in a Pod.
         * <p>
         * When you (a human) access the cluster (for example, using kubectl), you are
         * authenticated by the apiserver as a particular User Account (currently this
         * is usually admin, unless your cluster administrator has customized your
         * cluster). Processes in containers inside pods can also contact the
         * apiserver. When they do, they are authenticated as a particular Service
         * Account (for example, default).
         * <p>
         * Default: - No service account.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/">https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/</a>
         * @param serviceAccount A service account provides an identity for processes that run in a Pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccount(final org.cdk8s.plus27.IServiceAccount serviceAccount) {
            this.props.serviceAccount(serviceAccount);
            return this;
        }

        /**
         * Grace period until the pod is terminated.
         * <p>
         * Default: Duration.seconds(30)
         * <p>
         * @return {@code this}
         * @param terminationGracePeriod Grace period until the pod is terminated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationGracePeriod(final org.cdk8s.Duration terminationGracePeriod) {
            this.props.terminationGracePeriod(terminationGracePeriod);
            return this;
        }

        /**
         * List of volumes that can be mounted by containers belonging to the pod.
         * <p>
         * You can also add volumes later using <code>podSpec.addVolume()</code>
         * <p>
         * Default: - No volumes.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/storage/volumes">https://kubernetes.io/docs/concepts/storage/volumes</a>
         * @param volumes List of volumes that can be mounted by containers belonging to the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(final java.util.List<? extends org.cdk8s.plus27.Volume> volumes) {
            this.props.volumes(volumes);
            return this;
        }

        /**
         * The pod metadata of this workload.
         * <p>
         * @return {@code this}
         * @param podMetadata The pod metadata of this workload. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder podMetadata(final org.cdk8s.ApiObjectMetadata podMetadata) {
            this.props.podMetadata(podMetadata);
            return this;
        }

        /**
         * Automatically allocates a pod label selector for this workload and add it to the pod metadata.
         * <p>
         * This ensures this workload manages pods created by
         * its pod template.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param select Automatically allocates a pod label selector for this workload and add it to the pod metadata. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder select(final java.lang.Boolean select) {
            this.props.select(select);
            return this;
        }

        /**
         * Automatically spread pods across hostname and zones.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/scheduling-eviction/topology-spread-constraints/#internal-default-constraints">https://kubernetes.io/docs/concepts/scheduling-eviction/topology-spread-constraints/#internal-default-constraints</a>
         * @param spread Automatically spread pods across hostname and zones. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spread(final java.lang.Boolean spread) {
            this.props.spread(spread);
            return this;
        }

        /**
         * Specifies the duration the job may be active before the system tries to terminate it.
         * <p>
         * Default: - If unset, then there is no deadline.
         * <p>
         * @return {@code this}
         * @param activeDeadline Specifies the duration the job may be active before the system tries to terminate it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder activeDeadline(final org.cdk8s.Duration activeDeadline) {
            this.props.activeDeadline(activeDeadline);
            return this;
        }

        /**
         * Specifies the number of retries before marking this job failed.
         * <p>
         * Default: - If not set, system defaults to 6.
         * <p>
         * @return {@code this}
         * @param backoffLimit Specifies the number of retries before marking this job failed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backoffLimit(final java.lang.Number backoffLimit) {
            this.props.backoffLimit(backoffLimit);
            return this;
        }

        /**
         * Limits the lifetime of a Job that has finished execution (either Complete or Failed).
         * <p>
         * If this field is set, after the Job finishes, it is eligible to
         * be automatically deleted. When the Job is being deleted, its lifecycle
         * guarantees (e.g. finalizers) will be honored. If this field is set to zero,
         * the Job becomes eligible to be deleted immediately after it finishes. This
         * field is alpha-level and is only honored by servers that enable the
         * <code>TTLAfterFinished</code> feature.
         * <p>
         * Default: - If this field is unset, the Job won't be automatically deleted.
         * <p>
         * @return {@code this}
         * @param ttlAfterFinished Limits the lifetime of a Job that has finished execution (either Complete or Failed). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ttlAfterFinished(final org.cdk8s.Duration ttlAfterFinished) {
            this.props.ttlAfterFinished(ttlAfterFinished);
            return this;
        }

        /**
         * Specifies the time in which the job would run again.
         * <p>
         * This is defined as a cron expression in the CronJob resource.
         * <p>
         * @return {@code this}
         * @param schedule Specifies the time in which the job would run again. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final org.cdk8s.Cron schedule) {
            this.props.schedule(schedule);
            return this;
        }

        /**
         * Specifies the concurrency policy for the job.
         * <p>
         * Default: ConcurrencyPolicy.Forbid
         * <p>
         * @return {@code this}
         * @param concurrencyPolicy Specifies the concurrency policy for the job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder concurrencyPolicy(final org.cdk8s.plus27.ConcurrencyPolicy concurrencyPolicy) {
            this.props.concurrencyPolicy(concurrencyPolicy);
            return this;
        }

        /**
         * Specifies the number of failed jobs history retained.
         * <p>
         * This would retain the Job and the associated Pod resource and can be useful for debugging.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param failedJobsRetained Specifies the number of failed jobs history retained. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failedJobsRetained(final java.lang.Number failedJobsRetained) {
            this.props.failedJobsRetained(failedJobsRetained);
            return this;
        }

        /**
         * Kubernetes attempts to start cron jobs at its schedule time, but this is not guaranteed.
         * <p>
         * This deadline specifies
         * how much time can pass after a schedule point, for which kubernetes can still start the job.
         * For example, if this is set to 100 seconds, kubernetes is allowed to start the job at a maximum 100 seconds after
         * the scheduled time.
         * <p>
         * Note that the Kubernetes CronJobController checks for things every 10 seconds, for this reason, a deadline below 10
         * seconds is not allowed, as it may cause your job to never be scheduled.
         * <p>
         * In addition, kubernetes will stop scheduling jobs if more than 100 schedules were missed (for any reason).
         * This property also controls what time interval should kubernetes consider when counting for missed schedules.
         * <p>
         * For example, suppose a CronJob is set to schedule a new Job every one minute beginning at 08:30:00,
         * and its <code>startingDeadline</code> field is not set. If the CronJob controller happens to be down from 08:29:00 to 10:21:00,
         * the job will not start as the number of missed jobs which missed their schedule is greater than 100.
         * However, if <code>startingDeadline</code> is set to 200 seconds, kubernetes will only count 3 missed schedules, and thus
         * start a new execution at 10:22:00.
         * <p>
         * Default: Duration.seconds(10)
         * <p>
         * @return {@code this}
         * @param startingDeadline Kubernetes attempts to start cron jobs at its schedule time, but this is not guaranteed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startingDeadline(final org.cdk8s.Duration startingDeadline) {
            this.props.startingDeadline(startingDeadline);
            return this;
        }

        /**
         * Specifies the number of successful jobs history retained.
         * <p>
         * This would retain the Job and the associated Pod resource and can be useful for debugging.
         * <p>
         * Default: 3
         * <p>
         * @return {@code this}
         * @param successfulJobsRetained Specifies the number of successful jobs history retained. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder successfulJobsRetained(final java.lang.Number successfulJobsRetained) {
            this.props.successfulJobsRetained(successfulJobsRetained);
            return this;
        }

        /**
         * Specifies if the cron job should be suspended.
         * <p>
         * Only applies to future executions, current ones are remained untouched.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param suspend Specifies if the cron job should be suspended. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suspend(final java.lang.Boolean suspend) {
            this.props.suspend(suspend);
            return this;
        }

        /**
         * Specifies the timezone for the job.
         * <p>
         * This helps aligining the schedule to follow the specified timezone.
         * <p>
         * Default: - Timezone of kube-controller-manager process.
         * <p>
         * @return {@code this}
         * @see <a href="{@link https://en.wikipedia.org/wiki/List_of_tz_database_time_zones} for list of valid timezone values.">{@link https://en.wikipedia.org/wiki/List_of_tz_database_time_zones} for list of valid timezone values.</a>
         * @param timeZone Specifies the timezone for the job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeZone(final java.lang.String timeZone) {
            this.props.timeZone(timeZone);
            return this;
        }

        /**
         * @return a newly built instance of {@link org.cdk8s.plus27.CronJob}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus27.CronJob build() {
            return new org.cdk8s.plus27.CronJob(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
