package org.cdk8s.plus27;

/**
 * Properties for HorizontalPodAutoscaler.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-16T12:09:32.467Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus27.$Module.class, fqn = "cdk8s-plus-27.HorizontalPodAutoscalerProps")
@software.amazon.jsii.Jsii.Proxy(HorizontalPodAutoscalerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HorizontalPodAutoscalerProps extends software.amazon.jsii.JsiiSerializable, org.cdk8s.plus27.ResourceProps {

    /**
     * The maximum number of replicas that can be scaled up to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaxReplicas();

    /**
     * The workload to scale up or down.
     * <p>
     * Scalable workload types:
     * <p>
     * <ul>
     * <li>Deployment</li>
     * <li>StatefulSet</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull org.cdk8s.plus27.IScalable getTarget();

    /**
     * The metric conditions that trigger a scale up or scale down.
     * <p>
     * Default: - If metrics are not provided, then the target resource
     * constraints (e.g. cpu limit) will be used as scaling metrics.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.plus27.Metric> getMetrics() {
        return null;
    }

    /**
     * The minimum number of replicas that can be scaled down to.
     * <p>
     * Can be set to 0 if the alpha feature gate <code>HPAScaleToZero</code> is enabled and
     * at least one Object or External metric is configured.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinReplicas() {
        return null;
    }

    /**
     * The scaling behavior when scaling down.
     * <p>
     * Default: - Scale down to minReplica count with a 5 minute stabilization window.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus27.ScalingRules getScaleDown() {
        return null;
    }

    /**
     * The scaling behavior when scaling up.
     * <p>
     * Default: - Is the higher of:
     * * Increase no more than 4 pods per 60 seconds
     * * Double the number of pods per 60 seconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus27.ScalingRules getScaleUp() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HorizontalPodAutoscalerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HorizontalPodAutoscalerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HorizontalPodAutoscalerProps> {
        java.lang.Number maxReplicas;
        org.cdk8s.plus27.IScalable target;
        java.util.List<org.cdk8s.plus27.Metric> metrics;
        java.lang.Number minReplicas;
        org.cdk8s.plus27.ScalingRules scaleDown;
        org.cdk8s.plus27.ScalingRules scaleUp;
        org.cdk8s.ApiObjectMetadata metadata;

        /**
         * Sets the value of {@link HorizontalPodAutoscalerProps#getMaxReplicas}
         * @param maxReplicas The maximum number of replicas that can be scaled up to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxReplicas(java.lang.Number maxReplicas) {
            this.maxReplicas = maxReplicas;
            return this;
        }

        /**
         * Sets the value of {@link HorizontalPodAutoscalerProps#getTarget}
         * @param target The workload to scale up or down. This parameter is required.
         *               Scalable workload types:
         *               <p>
         *               <ul>
         *               <li>Deployment</li>
         *               <li>StatefulSet</li>
         *               </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(org.cdk8s.plus27.IScalable target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link HorizontalPodAutoscalerProps#getMetrics}
         * @param metrics The metric conditions that trigger a scale up or scale down.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder metrics(java.util.List<? extends org.cdk8s.plus27.Metric> metrics) {
            this.metrics = (java.util.List<org.cdk8s.plus27.Metric>)metrics;
            return this;
        }

        /**
         * Sets the value of {@link HorizontalPodAutoscalerProps#getMinReplicas}
         * @param minReplicas The minimum number of replicas that can be scaled down to.
         *                    Can be set to 0 if the alpha feature gate <code>HPAScaleToZero</code> is enabled and
         *                    at least one Object or External metric is configured.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minReplicas(java.lang.Number minReplicas) {
            this.minReplicas = minReplicas;
            return this;
        }

        /**
         * Sets the value of {@link HorizontalPodAutoscalerProps#getScaleDown}
         * @param scaleDown The scaling behavior when scaling down.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleDown(org.cdk8s.plus27.ScalingRules scaleDown) {
            this.scaleDown = scaleDown;
            return this;
        }

        /**
         * Sets the value of {@link HorizontalPodAutoscalerProps#getScaleUp}
         * @param scaleUp The scaling behavior when scaling up.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleUp(org.cdk8s.plus27.ScalingRules scaleUp) {
            this.scaleUp = scaleUp;
            return this;
        }

        /**
         * Sets the value of {@link HorizontalPodAutoscalerProps#getMetadata}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(org.cdk8s.ApiObjectMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HorizontalPodAutoscalerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HorizontalPodAutoscalerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HorizontalPodAutoscalerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HorizontalPodAutoscalerProps {
        private final java.lang.Number maxReplicas;
        private final org.cdk8s.plus27.IScalable target;
        private final java.util.List<org.cdk8s.plus27.Metric> metrics;
        private final java.lang.Number minReplicas;
        private final org.cdk8s.plus27.ScalingRules scaleDown;
        private final org.cdk8s.plus27.ScalingRules scaleUp;
        private final org.cdk8s.ApiObjectMetadata metadata;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxReplicas = software.amazon.jsii.Kernel.get(this, "maxReplicas", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus27.IScalable.class));
            this.metrics = software.amazon.jsii.Kernel.get(this, "metrics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus27.Metric.class)));
            this.minReplicas = software.amazon.jsii.Kernel.get(this, "minReplicas", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.scaleDown = software.amazon.jsii.Kernel.get(this, "scaleDown", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus27.ScalingRules.class));
            this.scaleUp = software.amazon.jsii.Kernel.get(this, "scaleUp", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus27.ScalingRules.class));
            this.metadata = software.amazon.jsii.Kernel.get(this, "metadata", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObjectMetadata.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxReplicas = java.util.Objects.requireNonNull(builder.maxReplicas, "maxReplicas is required");
            this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
            this.metrics = (java.util.List<org.cdk8s.plus27.Metric>)builder.metrics;
            this.minReplicas = builder.minReplicas;
            this.scaleDown = builder.scaleDown;
            this.scaleUp = builder.scaleUp;
            this.metadata = builder.metadata;
        }

        @Override
        public final java.lang.Number getMaxReplicas() {
            return this.maxReplicas;
        }

        @Override
        public final org.cdk8s.plus27.IScalable getTarget() {
            return this.target;
        }

        @Override
        public final java.util.List<org.cdk8s.plus27.Metric> getMetrics() {
            return this.metrics;
        }

        @Override
        public final java.lang.Number getMinReplicas() {
            return this.minReplicas;
        }

        @Override
        public final org.cdk8s.plus27.ScalingRules getScaleDown() {
            return this.scaleDown;
        }

        @Override
        public final org.cdk8s.plus27.ScalingRules getScaleUp() {
            return this.scaleUp;
        }

        @Override
        public final org.cdk8s.ApiObjectMetadata getMetadata() {
            return this.metadata;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("maxReplicas", om.valueToTree(this.getMaxReplicas()));
            data.set("target", om.valueToTree(this.getTarget()));
            if (this.getMetrics() != null) {
                data.set("metrics", om.valueToTree(this.getMetrics()));
            }
            if (this.getMinReplicas() != null) {
                data.set("minReplicas", om.valueToTree(this.getMinReplicas()));
            }
            if (this.getScaleDown() != null) {
                data.set("scaleDown", om.valueToTree(this.getScaleDown()));
            }
            if (this.getScaleUp() != null) {
                data.set("scaleUp", om.valueToTree(this.getScaleUp()));
            }
            if (this.getMetadata() != null) {
                data.set("metadata", om.valueToTree(this.getMetadata()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus-27.HorizontalPodAutoscalerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HorizontalPodAutoscalerProps.Jsii$Proxy that = (HorizontalPodAutoscalerProps.Jsii$Proxy) o;

            if (!maxReplicas.equals(that.maxReplicas)) return false;
            if (!target.equals(that.target)) return false;
            if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) return false;
            if (this.minReplicas != null ? !this.minReplicas.equals(that.minReplicas) : that.minReplicas != null) return false;
            if (this.scaleDown != null ? !this.scaleDown.equals(that.scaleDown) : that.scaleDown != null) return false;
            if (this.scaleUp != null ? !this.scaleUp.equals(that.scaleUp) : that.scaleUp != null) return false;
            return this.metadata != null ? this.metadata.equals(that.metadata) : that.metadata == null;
        }

        @Override
        public final int hashCode() {
            int result = this.maxReplicas.hashCode();
            result = 31 * result + (this.target.hashCode());
            result = 31 * result + (this.metrics != null ? this.metrics.hashCode() : 0);
            result = 31 * result + (this.minReplicas != null ? this.minReplicas.hashCode() : 0);
            result = 31 * result + (this.scaleDown != null ? this.scaleDown.hashCode() : 0);
            result = 31 * result + (this.scaleUp != null ? this.scaleUp.hashCode() : 0);
            result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
            return result;
        }
    }
}
