package org.cdk8s.plus27;

/**
 * Controls network isolation rules for inter-pod communication.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-16T12:09:32.517Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus27.$Module.class, fqn = "cdk8s-plus-27.PodConnections")
public class PodConnections extends software.amazon.jsii.JsiiObject {

    protected PodConnections(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PodConnections(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param instance This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PodConnections(final @org.jetbrains.annotations.NotNull org.cdk8s.plus27.AbstractPod instance) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(instance, "instance is required") });
    }

    /**
     * Allow network traffic from the peer to this pod.
     * <p>
     * By default, this will create an ingress network policy for this pod, and an egress
     * network policy for the peer. This is required if both sides are already isolated.
     * Use <code>options.isolation</code> to control this behavior.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // create only an egress policy that selects the 'web' pod to allow outgoing traffic
     * // to the 'redis' pod. this requires the 'redis' pod to not be isolated for ingress.
     * redis.connections.allowFrom(web, { isolation: Isolation.PEER })
     * // create only an ingress policy that selects the 'redis' peer to allow incoming traffic
     * // from the 'web' pod. this requires the 'web' pod to not be isolated for egress.
     * redis.connections.allowFrom(web, { isolation: Isolation.POD })
     * </pre></blockquote>
     * <p>
     * @param peer This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowFrom(final @org.jetbrains.annotations.NotNull org.cdk8s.plus27.INetworkPolicyPeer peer, final @org.jetbrains.annotations.Nullable org.cdk8s.plus27.PodConnectionsAllowFromOptions options) {
        software.amazon.jsii.Kernel.call(this, "allowFrom", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), options });
    }

    /**
     * Allow network traffic from the peer to this pod.
     * <p>
     * By default, this will create an ingress network policy for this pod, and an egress
     * network policy for the peer. This is required if both sides are already isolated.
     * Use <code>options.isolation</code> to control this behavior.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // create only an egress policy that selects the 'web' pod to allow outgoing traffic
     * // to the 'redis' pod. this requires the 'redis' pod to not be isolated for ingress.
     * redis.connections.allowFrom(web, { isolation: Isolation.PEER })
     * // create only an ingress policy that selects the 'redis' peer to allow incoming traffic
     * // from the 'web' pod. this requires the 'web' pod to not be isolated for egress.
     * redis.connections.allowFrom(web, { isolation: Isolation.POD })
     * </pre></blockquote>
     * <p>
     * @param peer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowFrom(final @org.jetbrains.annotations.NotNull org.cdk8s.plus27.INetworkPolicyPeer peer) {
        software.amazon.jsii.Kernel.call(this, "allowFrom", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required") });
    }

    /**
     * Allow network traffic from this pod to the peer.
     * <p>
     * By default, this will create an egress network policy for this pod, and an ingress
     * network policy for the peer. This is required if both sides are already isolated.
     * Use <code>options.isolation</code> to control this behavior.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // create only an egress policy that selects the 'web' pod to allow outgoing traffic
     * // to the 'redis' pod. this requires the 'redis' pod to not be isolated for ingress.
     * web.connections.allowTo(redis, { isolation: Isolation.POD })
     * // create only an ingress policy that selects the 'redis' peer to allow incoming traffic
     * // from the 'web' pod. this requires the 'web' pod to not be isolated for egress.
     * web.connections.allowTo(redis, { isolation: Isolation.PEER })
     * </pre></blockquote>
     * <p>
     * @param peer This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowTo(final @org.jetbrains.annotations.NotNull org.cdk8s.plus27.INetworkPolicyPeer peer, final @org.jetbrains.annotations.Nullable org.cdk8s.plus27.PodConnectionsAllowToOptions options) {
        software.amazon.jsii.Kernel.call(this, "allowTo", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), options });
    }

    /**
     * Allow network traffic from this pod to the peer.
     * <p>
     * By default, this will create an egress network policy for this pod, and an ingress
     * network policy for the peer. This is required if both sides are already isolated.
     * Use <code>options.isolation</code> to control this behavior.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // create only an egress policy that selects the 'web' pod to allow outgoing traffic
     * // to the 'redis' pod. this requires the 'redis' pod to not be isolated for ingress.
     * web.connections.allowTo(redis, { isolation: Isolation.POD })
     * // create only an ingress policy that selects the 'redis' peer to allow incoming traffic
     * // from the 'web' pod. this requires the 'web' pod to not be isolated for egress.
     * web.connections.allowTo(redis, { isolation: Isolation.PEER })
     * </pre></blockquote>
     * <p>
     * @param peer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowTo(final @org.jetbrains.annotations.NotNull org.cdk8s.plus27.INetworkPolicyPeer peer) {
        software.amazon.jsii.Kernel.call(this, "allowTo", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required") });
    }

    /**
     * Sets the default network policy for Pod/Workload to have all egress and ingress connections as disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void isolate() {
        software.amazon.jsii.Kernel.call(this, "isolate", software.amazon.jsii.NativeType.VOID);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull org.cdk8s.plus27.AbstractPod getInstance() {
        return software.amazon.jsii.Kernel.get(this, "instance", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus27.AbstractPod.class));
    }
}
