package org.cdk8s.plus27;

/**
 * Defines the scaling behavior for one direction.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-16T12:09:32.534Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus27.$Module.class, fqn = "cdk8s-plus-27.ScalingRules")
@software.amazon.jsii.Jsii.Proxy(ScalingRules.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ScalingRules extends software.amazon.jsii.JsiiSerializable {

    /**
     * The scaling policies.
     * <p>
     * Default: * Scale up
     *   * Increase no more than 4 pods per 60 seconds
     *   * Double the number of pods per 60 seconds
     * * Scale down
     *   * Decrease to minReplica count
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.plus27.ScalingPolicy> getPolicies() {
        return null;
    }

    /**
     * Defines the window of past metrics that the autoscaler should consider when calculating wether or not autoscaling should occur.
     * <p>
     * Minimum duration is 1 second, max is 1 hour.
     * <p>
     * Default: * On scale down no stabilization is performed.
     * * On scale up stabilization is performed for 5 minutes.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * stabilizationWindow: Duration.minutes(30)
     * // Autoscaler considers the last 30 minutes of metrics when deciding whether to scale.
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.Duration getStabilizationWindow() {
        return null;
    }

    /**
     * The strategy to use when scaling.
     * <p>
     * Default: MAX_CHANGE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus27.ScalingStrategy getStrategy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ScalingRules}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ScalingRules}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ScalingRules> {
        java.util.List<org.cdk8s.plus27.ScalingPolicy> policies;
        org.cdk8s.Duration stabilizationWindow;
        org.cdk8s.plus27.ScalingStrategy strategy;

        /**
         * Sets the value of {@link ScalingRules#getPolicies}
         * @param policies The scaling policies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder policies(java.util.List<? extends org.cdk8s.plus27.ScalingPolicy> policies) {
            this.policies = (java.util.List<org.cdk8s.plus27.ScalingPolicy>)policies;
            return this;
        }

        /**
         * Sets the value of {@link ScalingRules#getStabilizationWindow}
         * @param stabilizationWindow Defines the window of past metrics that the autoscaler should consider when calculating wether or not autoscaling should occur.
         *                            Minimum duration is 1 second, max is 1 hour.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stabilizationWindow(org.cdk8s.Duration stabilizationWindow) {
            this.stabilizationWindow = stabilizationWindow;
            return this;
        }

        /**
         * Sets the value of {@link ScalingRules#getStrategy}
         * @param strategy The strategy to use when scaling.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder strategy(org.cdk8s.plus27.ScalingStrategy strategy) {
            this.strategy = strategy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ScalingRules}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ScalingRules build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ScalingRules}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingRules {
        private final java.util.List<org.cdk8s.plus27.ScalingPolicy> policies;
        private final org.cdk8s.Duration stabilizationWindow;
        private final org.cdk8s.plus27.ScalingStrategy strategy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.policies = software.amazon.jsii.Kernel.get(this, "policies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus27.ScalingPolicy.class)));
            this.stabilizationWindow = software.amazon.jsii.Kernel.get(this, "stabilizationWindow", software.amazon.jsii.NativeType.forClass(org.cdk8s.Duration.class));
            this.strategy = software.amazon.jsii.Kernel.get(this, "strategy", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus27.ScalingStrategy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.policies = (java.util.List<org.cdk8s.plus27.ScalingPolicy>)builder.policies;
            this.stabilizationWindow = builder.stabilizationWindow;
            this.strategy = builder.strategy;
        }

        @Override
        public final java.util.List<org.cdk8s.plus27.ScalingPolicy> getPolicies() {
            return this.policies;
        }

        @Override
        public final org.cdk8s.Duration getStabilizationWindow() {
            return this.stabilizationWindow;
        }

        @Override
        public final org.cdk8s.plus27.ScalingStrategy getStrategy() {
            return this.strategy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPolicies() != null) {
                data.set("policies", om.valueToTree(this.getPolicies()));
            }
            if (this.getStabilizationWindow() != null) {
                data.set("stabilizationWindow", om.valueToTree(this.getStabilizationWindow()));
            }
            if (this.getStrategy() != null) {
                data.set("strategy", om.valueToTree(this.getStrategy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus-27.ScalingRules"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ScalingRules.Jsii$Proxy that = (ScalingRules.Jsii$Proxy) o;

            if (this.policies != null ? !this.policies.equals(that.policies) : that.policies != null) return false;
            if (this.stabilizationWindow != null ? !this.stabilizationWindow.equals(that.stabilizationWindow) : that.stabilizationWindow != null) return false;
            return this.strategy != null ? this.strategy.equals(that.strategy) : that.strategy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.policies != null ? this.policies.hashCode() : 0;
            result = 31 * result + (this.stabilizationWindow != null ? this.stabilizationWindow.hashCode() : 0);
            result = 31 * result + (this.strategy != null ? this.strategy.hashCode() : 0);
            return result;
        }
    }
}
