package org.cdk8s.plus27.k8s;

/**
 * ResourcePolicyRule is a predicate that matches some resource requests, testing the request's verb and the target resource.
 * <p>
 * A ResourcePolicyRule matches a resource request if and only if: (a) at least one member of verbs matches the request, (b) at least one member of apiGroups matches the request, (c) at least one member of resources matches the request, and (d) either (d1) the request does not specify a namespace (i.e., <code>Namespace==""</code>) and clusterScope is true or (d2) the request specifies a namespace and least one member of namespaces matches the request's namespace.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-16T12:09:32.779Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus27.$Module.class, fqn = "cdk8s-plus-27.k8s.ResourcePolicyRuleV1Beta3")
@software.amazon.jsii.Jsii.Proxy(ResourcePolicyRuleV1Beta3.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResourcePolicyRuleV1Beta3 extends software.amazon.jsii.JsiiSerializable {

    /**
     * <code>apiGroups</code> is a list of matching API groups and may not be empty.
     * <p>
     * "*" matches all API groups and, if present, must be the only entry. Required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getApiGroups();

    /**
     * <code>resources</code> is a list of matching resources (i.e., lowercase and plural) with, if desired, subresource.  For example, [ "services", "nodes/status" ].  This list may not be empty. "*" matches all resources and, if present, must be the only entry. Required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getResources();

    /**
     * <code>verbs</code> is a list of matching verbs and may not be empty.
     * <p>
     * "*" matches all verbs and, if present, must be the only entry. Required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getVerbs();

    /**
     * <code>clusterScope</code> indicates whether to match requests that do not specify a namespace (which happens either because the resource is not namespaced or the request targets all namespaces).
     * <p>
     * If this field is omitted or false then the <code>namespaces</code> field must contain a non-empty list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getClusterScope() {
        return null;
    }

    /**
     * <code>namespaces</code> is a list of target namespaces that restricts matches.
     * <p>
     * A request that specifies a target namespace matches only if either (a) this list contains that target namespace or (b) this list contains "<em>".  Note that "</em>" matches any specified namespace but does not match a request that <em>does not specify</em> a namespace (see the <code>clusterScope</code> field for that). This list may be empty, but only if <code>clusterScope</code> is true.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNamespaces() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ResourcePolicyRuleV1Beta3}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResourcePolicyRuleV1Beta3}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ResourcePolicyRuleV1Beta3> {
        java.util.List<java.lang.String> apiGroups;
        java.util.List<java.lang.String> resources;
        java.util.List<java.lang.String> verbs;
        java.lang.Boolean clusterScope;
        java.util.List<java.lang.String> namespaces;

        /**
         * Sets the value of {@link ResourcePolicyRuleV1Beta3#getApiGroups}
         * @param apiGroups <code>apiGroups</code> is a list of matching API groups and may not be empty. This parameter is required.
         *                  "*" matches all API groups and, if present, must be the only entry. Required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiGroups(java.util.List<java.lang.String> apiGroups) {
            this.apiGroups = apiGroups;
            return this;
        }

        /**
         * Sets the value of {@link ResourcePolicyRuleV1Beta3#getResources}
         * @param resources <code>resources</code> is a list of matching resources (i.e., lowercase and plural) with, if desired, subresource.  For example, [ "services", "nodes/status" ].  This list may not be empty. "*" matches all resources and, if present, must be the only entry. Required. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resources(java.util.List<java.lang.String> resources) {
            this.resources = resources;
            return this;
        }

        /**
         * Sets the value of {@link ResourcePolicyRuleV1Beta3#getVerbs}
         * @param verbs <code>verbs</code> is a list of matching verbs and may not be empty. This parameter is required.
         *              "*" matches all verbs and, if present, must be the only entry. Required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder verbs(java.util.List<java.lang.String> verbs) {
            this.verbs = verbs;
            return this;
        }

        /**
         * Sets the value of {@link ResourcePolicyRuleV1Beta3#getClusterScope}
         * @param clusterScope <code>clusterScope</code> indicates whether to match requests that do not specify a namespace (which happens either because the resource is not namespaced or the request targets all namespaces).
         *                     If this field is omitted or false then the <code>namespaces</code> field must contain a non-empty list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterScope(java.lang.Boolean clusterScope) {
            this.clusterScope = clusterScope;
            return this;
        }

        /**
         * Sets the value of {@link ResourcePolicyRuleV1Beta3#getNamespaces}
         * @param namespaces <code>namespaces</code> is a list of target namespaces that restricts matches.
         *                   A request that specifies a target namespace matches only if either (a) this list contains that target namespace or (b) this list contains "<em>".  Note that "</em>" matches any specified namespace but does not match a request that <em>does not specify</em> a namespace (see the <code>clusterScope</code> field for that). This list may be empty, but only if <code>clusterScope</code> is true.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespaces(java.util.List<java.lang.String> namespaces) {
            this.namespaces = namespaces;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResourcePolicyRuleV1Beta3}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ResourcePolicyRuleV1Beta3 build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ResourcePolicyRuleV1Beta3}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourcePolicyRuleV1Beta3 {
        private final java.util.List<java.lang.String> apiGroups;
        private final java.util.List<java.lang.String> resources;
        private final java.util.List<java.lang.String> verbs;
        private final java.lang.Boolean clusterScope;
        private final java.util.List<java.lang.String> namespaces;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiGroups = software.amazon.jsii.Kernel.get(this, "apiGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.resources = software.amazon.jsii.Kernel.get(this, "resources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.verbs = software.amazon.jsii.Kernel.get(this, "verbs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.clusterScope = software.amazon.jsii.Kernel.get(this, "clusterScope", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.namespaces = software.amazon.jsii.Kernel.get(this, "namespaces", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiGroups = java.util.Objects.requireNonNull(builder.apiGroups, "apiGroups is required");
            this.resources = java.util.Objects.requireNonNull(builder.resources, "resources is required");
            this.verbs = java.util.Objects.requireNonNull(builder.verbs, "verbs is required");
            this.clusterScope = builder.clusterScope;
            this.namespaces = builder.namespaces;
        }

        @Override
        public final java.util.List<java.lang.String> getApiGroups() {
            return this.apiGroups;
        }

        @Override
        public final java.util.List<java.lang.String> getResources() {
            return this.resources;
        }

        @Override
        public final java.util.List<java.lang.String> getVerbs() {
            return this.verbs;
        }

        @Override
        public final java.lang.Boolean getClusterScope() {
            return this.clusterScope;
        }

        @Override
        public final java.util.List<java.lang.String> getNamespaces() {
            return this.namespaces;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiGroups", om.valueToTree(this.getApiGroups()));
            data.set("resources", om.valueToTree(this.getResources()));
            data.set("verbs", om.valueToTree(this.getVerbs()));
            if (this.getClusterScope() != null) {
                data.set("clusterScope", om.valueToTree(this.getClusterScope()));
            }
            if (this.getNamespaces() != null) {
                data.set("namespaces", om.valueToTree(this.getNamespaces()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus-27.k8s.ResourcePolicyRuleV1Beta3"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResourcePolicyRuleV1Beta3.Jsii$Proxy that = (ResourcePolicyRuleV1Beta3.Jsii$Proxy) o;

            if (!apiGroups.equals(that.apiGroups)) return false;
            if (!resources.equals(that.resources)) return false;
            if (!verbs.equals(that.verbs)) return false;
            if (this.clusterScope != null ? !this.clusterScope.equals(that.clusterScope) : that.clusterScope != null) return false;
            return this.namespaces != null ? this.namespaces.equals(that.namespaces) : that.namespaces == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiGroups.hashCode();
            result = 31 * result + (this.resources.hashCode());
            result = 31 * result + (this.verbs.hashCode());
            result = 31 * result + (this.clusterScope != null ? this.clusterScope.hashCode() : 0);
            result = 31 * result + (this.namespaces != null ? this.namespaces.hashCode() : 0);
            return result;
        }
    }
}
