/*
 * Decompiled with CFR 0.152.
 */
package org.cementframework.querybyproxy.shared.api.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cementframework.querybyproxy.shared.api.model.joins.AbstractJoin;
import org.cementframework.querybyproxy.shared.api.model.joins.QueryJoin;
import org.cementframework.querybyproxy.shared.api.model.joins.QueryJoinModifier;
import org.cementframework.querybyproxy.shared.api.model.joins.QueryJoinType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FromClause
extends AbstractJoin {
    private final String name;
    private final Map<Object, QueryJoin> joinMap;

    public FromClause(String rootName, Object rootProxy) {
        super(null, QueryJoinType.INNER, QueryJoinModifier.NONE, rootProxy);
        this.name = rootName;
        this.joinMap = Collections.unmodifiableMap(new LinkedHashMap());
    }

    public FromClause(QueryJoin join, FromClause baseFrom) {
        super(null, QueryJoinType.INNER, QueryJoinModifier.NONE, baseFrom.getTargetProxy());
        this.name = baseFrom.getRootName();
        LinkedHashMap<Object, QueryJoin> newMap = new LinkedHashMap<Object, QueryJoin>(baseFrom.getJoinMap());
        newMap.put(join.getTargetProxy(), join);
        this.joinMap = Collections.unmodifiableMap(newMap);
    }

    public String getRootName() {
        return this.name;
    }

    public Map<Object, QueryJoin> getJoinMap() {
        return this.joinMap;
    }

    public QueryJoin findParentJoin(Object parent) {
        if (this.getTargetProxy().equals(parent)) {
            return this;
        }
        return this.joinMap.get(parent);
    }
}

