/*
 * Decompiled with CFR 0.152.
 */
package org.cementframework.querybyproxy.shared.api.model.values;

import java.util.ArrayList;
import org.cementframework.querybyproxy.shared.api.model.conditionals.BinaryConditional;
import org.cementframework.querybyproxy.shared.api.model.conditionals.ComparisonOperator;
import org.cementframework.querybyproxy.shared.api.model.conditionals.UnaryConditional;
import org.cementframework.querybyproxy.shared.api.model.values.AbstractStrictQueryValue;
import org.cementframework.querybyproxy.shared.api.model.values.QueryLiteral;
import org.cementframework.querybyproxy.shared.api.model.values.QueryValue;
import org.cementframework.querybyproxy.shared.impl.StaticProxyQueryBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueryValue<T>
extends AbstractStrictQueryValue<T>
implements QueryValue<T> {
    @Override
    public UnaryConditional<T> isNotEmpty() {
        return this.unaryOperation(ComparisonOperator.IS_NOT_EMPTY);
    }

    @Override
    public UnaryConditional<T> isEmpty() {
        return this.unaryOperation(ComparisonOperator.IS_EMPTY);
    }

    @Override
    public UnaryConditional<T> isNull() {
        return this.unaryOperation(ComparisonOperator.IS_NULL);
    }

    @Override
    public UnaryConditional<T> isNotNull() {
        return this.unaryOperation(ComparisonOperator.IS_NOT_NULL);
    }

    @Override
    public BinaryConditional<T> notIn(T ... values) {
        ArrayList params = new ArrayList(values.length);
        for (T value : values) {
            params.add(new QueryLiteral(value));
        }
        return this.inOperator(params, ComparisonOperator.NOT_IN);
    }

    @Override
    public BinaryConditional<T> in(T ... values) {
        ArrayList params = new ArrayList(values.length);
        for (T value : values) {
            params.add(new QueryLiteral(value));
        }
        return this.inOperator(params, ComparisonOperator.IN);
    }

    @Override
    public BinaryConditional<T> notLike(T value) {
        return this.binaryOperation(StaticProxyQueryBuilder.createQueryValue(value), ComparisonOperator.NOT_LIKE);
    }

    @Override
    public BinaryConditional<T> like(T value) {
        return this.binaryOperation(StaticProxyQueryBuilder.createQueryValue(value), ComparisonOperator.LIKE);
    }

    @Override
    public BinaryConditional<T> equalTo(T value) {
        return this.binaryOperation(StaticProxyQueryBuilder.createQueryValue(value), ComparisonOperator.EQUALS);
    }

    @Override
    public BinaryConditional<T> notEqualTo(T value) {
        return this.binaryOperation(StaticProxyQueryBuilder.createQueryValue(value), ComparisonOperator.NOT_EQUALS);
    }

    @Override
    public BinaryConditional<T> greaterThan(T value) {
        return this.binaryOperation(StaticProxyQueryBuilder.createQueryValue(value), ComparisonOperator.GREATER_THAN);
    }

    @Override
    public BinaryConditional<T> greaterThanOrEqualTo(T value) {
        return this.binaryOperation(StaticProxyQueryBuilder.createQueryValue(value), ComparisonOperator.GREATER_THAN_OR_EQUAL_TO);
    }

    @Override
    public BinaryConditional<T> lessThan(T value) {
        return this.binaryOperation(StaticProxyQueryBuilder.createQueryValue(value), ComparisonOperator.LESS_THAN);
    }

    @Override
    public BinaryConditional<T> lessThanOrEqualTo(T value) {
        return this.binaryOperation(StaticProxyQueryBuilder.createQueryValue(value), ComparisonOperator.LESS_THAN_OR_EQUAL_TO);
    }
}

