/*
 * Decompiled with CFR 0.152.
 */
package org.cementframework.querybyproxy.shared.api.model.values;

import java.util.List;
import org.cementframework.querybyproxy.shared.api.ProxyQuerySessions;
import org.cementframework.querybyproxy.shared.api.model.conditionals.BinaryConditional;
import org.cementframework.querybyproxy.shared.api.model.conditionals.ComparisonOperator;
import org.cementframework.querybyproxy.shared.api.model.conditionals.LogicGate;
import org.cementframework.querybyproxy.shared.api.model.conditionals.UnaryConditional;
import org.cementframework.querybyproxy.shared.api.model.values.QueryValue;
import org.cementframework.querybyproxy.shared.api.model.values.StrictQueryValue;
import org.cementframework.querybyproxy.shared.api.model.values.ValuesList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractStrictQueryValue<T>
implements StrictQueryValue<T> {
    @Override
    public BinaryConditional<T> notLike(QueryValue<T> value) {
        return this.binaryOperation(value, ComparisonOperator.NOT_LIKE);
    }

    @Override
    public BinaryConditional<T> like(QueryValue<T> value) {
        return this.binaryOperation(value, ComparisonOperator.LIKE);
    }

    @Override
    public BinaryConditional<T> notIn(List<? extends QueryValue<T>> values) {
        return this.inOperator(values, ComparisonOperator.NOT_IN);
    }

    @Override
    public BinaryConditional<T> in(List<? extends QueryValue<T>> values) {
        return this.inOperator(values, ComparisonOperator.IN);
    }

    @Override
    public BinaryConditional<T> memberOf(QueryValue<List<T>> value) {
        QueryValue<List<T>> expValue = value;
        BinaryConditional<List<T>> exp = this.binaryOperation(expValue, ComparisonOperator.MEMBER_OF);
        return exp;
    }

    @Override
    public BinaryConditional<T> notMemberOf(QueryValue<List<T>> value) {
        QueryValue<List<T>> expValue = value;
        BinaryConditional<List<T>> exp = this.binaryOperation(expValue, ComparisonOperator.NOT_MEMBER_OF);
        return exp;
    }

    @Override
    public BinaryConditional<T> equalTo(QueryValue<T> value) {
        return this.binaryOperation(value, ComparisonOperator.EQUALS);
    }

    @Override
    public BinaryConditional<T> notEqualTo(QueryValue<T> value) {
        return this.binaryOperation(value, ComparisonOperator.NOT_EQUALS);
    }

    @Override
    public BinaryConditional<T> greaterThan(QueryValue<T> value) {
        return this.binaryOperation(value, ComparisonOperator.GREATER_THAN);
    }

    @Override
    public BinaryConditional<T> greaterThanOrEqualTo(QueryValue<T> value) {
        return this.binaryOperation(value, ComparisonOperator.GREATER_THAN_OR_EQUAL_TO);
    }

    @Override
    public BinaryConditional<T> lessThan(QueryValue<T> value) {
        return this.binaryOperation(value, ComparisonOperator.LESS_THAN);
    }

    @Override
    public BinaryConditional<T> lessThanOrEqualTo(QueryValue<T> value) {
        return this.binaryOperation(value, ComparisonOperator.LESS_THAN_OR_EQUAL_TO);
    }

    protected UnaryConditional<T> unaryOperation(ComparisonOperator expression) {
        LogicGate logicGate = ProxyQuerySessions.get().getNextLogicGate();
        UnaryConditional conditional = new UnaryConditional(logicGate, this, expression);
        return conditional;
    }

    protected BinaryConditional<T> binaryOperation(QueryValue<T> value, ComparisonOperator expression) {
        LogicGate logicGate = ProxyQuerySessions.get().getNextLogicGate();
        if (value == null) {
            throw new IllegalArgumentException("Binary expression query-value must not be null:  check that querybuilder.get() was called OR unary isNull/isNotNull was intended");
        }
        BinaryConditional<T> conditional = new BinaryConditional<T>(logicGate, this, expression, value);
        return conditional;
    }

    protected BinaryConditional<T> inOperator(List<? extends QueryValue<T>> params, ComparisonOperator expression) {
        return this.binaryOperation(new ValuesList(params), expression);
    }
}

