/*
 * Decompiled with CFR 0.152.
 */
package org.cementframework.querybyproxy.shared.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.cementframework.querybyproxy.shared.api.DynamicQuery;
import org.cementframework.querybyproxy.shared.api.ProxyQuery;
import org.cementframework.querybyproxy.shared.api.TypedQuery;
import org.cementframework.querybyproxy.shared.api.model.FromClause;
import org.cementframework.querybyproxy.shared.api.model.GroupByClause;
import org.cementframework.querybyproxy.shared.api.model.HavingClause;
import org.cementframework.querybyproxy.shared.api.model.OrderByClause;
import org.cementframework.querybyproxy.shared.api.model.SelectClause;
import org.cementframework.querybyproxy.shared.api.model.WhereClause;
import org.cementframework.querybyproxy.shared.api.model.conditionals.Conditional;
import org.cementframework.querybyproxy.shared.api.model.joins.NestedPropertyJoin;
import org.cementframework.querybyproxy.shared.api.model.joins.QueryJoin;
import org.cementframework.querybyproxy.shared.api.model.joins.QueryJoinModifier;
import org.cementframework.querybyproxy.shared.api.model.joins.QueryJoinType;
import org.cementframework.querybyproxy.shared.api.model.joins.ThetaJoin;
import org.cementframework.querybyproxy.shared.api.model.selections.ConstructorValue;
import org.cementframework.querybyproxy.shared.api.model.selections.SelectProxy;
import org.cementframework.querybyproxy.shared.api.model.selections.Selection;
import org.cementframework.querybyproxy.shared.api.model.sorts.DirectionalQuerySort;
import org.cementframework.querybyproxy.shared.api.model.sorts.QuerySort;
import org.cementframework.querybyproxy.shared.api.model.sorts.QuerySortOperator;
import org.cementframework.querybyproxy.shared.api.model.values.ConditionalExpressionCallback;
import org.cementframework.querybyproxy.shared.api.model.values.ProxyPathExpression;
import org.cementframework.querybyproxy.shared.api.model.values.QueryValue;
import org.cementframework.querybyproxy.shared.api.model.values.RedirectingQueryValue;
import org.cementframework.querybyproxy.shared.api.model.values.Subquery;
import org.cementframework.querybyproxy.shared.api.model.values.SubqueryValue;
import org.cementframework.querybyproxy.shared.impl.StaticProxyQueryBuilder;
import org.cementframework.recordingproxy.api.RecordedMethodCall;
import org.cementframework.recordingproxy.api.RecordingSessions;
import org.cementframework.recordingproxy.impl.MethodCallUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProxyQueryImpl<T>
implements ProxyQuery<T>,
ConditionalExpressionCallback {
    private final Class<?> rootProxyClass;
    private final T proxy;
    private DynamicQuery query;
    private SelectClause select;
    private FromClause from;
    private WhereClause where;
    private GroupByClause groupBy;
    private HavingClause having;
    private OrderByClause orderBy;

    public AbstractProxyQueryImpl(T proxy, Class<?> rootProxyClass) {
        this.proxy = proxy;
        this.rootProxyClass = rootProxyClass;
        this.select = new SelectClause(false);
        this.from = new FromClause(rootProxyClass.getSimpleName(), proxy);
        this.where = new WhereClause(new Conditional[0]);
        this.groupBy = new GroupByClause();
        this.having = new HavingClause(new Conditional[0]);
        this.orderBy = new OrderByClause();
    }

    @Override
    public AbstractProxyQueryImpl<T> distinct() {
        this.setSelect(new SelectClause(this.getSelect(), true));
        return this;
    }

    @Override
    public AbstractProxyQueryImpl<T> groupBy(Object ... selections) {
        ArrayList<Selection> selects = new ArrayList<Selection>();
        for (Object obj : selections) {
            selects.add(StaticProxyQueryBuilder.createQueryValue(obj));
        }
        this.groupBy = new GroupByClause(selects);
        return this;
    }

    @Override
    public AbstractProxyQueryImpl<T> orderBy(Object ... sorts) {
        ArrayList<QuerySort> list = new ArrayList<QuerySort>();
        for (Object sortObject : sorts) {
            if (sortObject == null) {
                DirectionalQuerySort sort = new DirectionalQuerySort(StaticProxyQueryBuilder.createQueryValue(sortObject), QuerySortOperator.ASC);
                list.add(sort);
                continue;
            }
            if (sortObject instanceof DirectionalQuerySort) {
                list.add((QuerySort)sortObject);
                continue;
            }
            if (!(sortObject instanceof Selection)) continue;
            list.add(new DirectionalQuerySort((Selection)sortObject, QuerySortOperator.ASC));
        }
        this.orderBy = new OrderByClause(list);
        return this;
    }

    @Override
    public <S> TypedQuery<S> select(Class<S> constructorClass, Object ... constructorArguments) {
        if (constructorClass == null) {
            throw new IllegalArgumentException("targetClass is required");
        }
        ArrayList<QueryValue> arugments = new ArrayList<QueryValue>(constructorArguments.length);
        for (Object object : constructorArguments) {
            arugments.add(StaticProxyQueryBuilder.createQueryValue(object));
        }
        return this.select((QueryValue<S>)new ConstructorValue<S>(constructorClass, arugments));
    }

    @Override
    public <S> TypedQuery<S> select(S selection) {
        return this.select(StaticProxyQueryBuilder.createQueryValue(selection));
    }

    @Override
    public DynamicQuery select(Object ... selections) {
        ArrayList<Selection> selects = new ArrayList<Selection>();
        for (Object obj : selections) {
            selects.add(StaticProxyQueryBuilder.createQueryValue(obj));
        }
        this.setSelect(new SelectClause(selects, this.getSelect().isDistinct()));
        this.setQuery(this.createDynamicQuery());
        return this.getQuery();
    }

    public abstract DynamicQuery createDynamicQuery();

    @Override
    public <S> RedirectingQueryValue<S> orWhere(S recordedMethodCall) {
        StaticProxyQueryBuilder.or();
        return new RedirectingQueryValue<S>(StaticProxyQueryBuilder.createQueryValue(recordedMethodCall), this);
    }

    @Override
    public <S> RedirectingQueryValue<S> andWhere(S recordedMethodCall) {
        return new RedirectingQueryValue<S>(StaticProxyQueryBuilder.createQueryValue(recordedMethodCall), this);
    }

    @Override
    public AbstractProxyQueryImpl<T> where(Conditional ... conditionalExpressions) {
        this.where = new WhereClause(conditionalExpressions);
        return this;
    }

    @Override
    public AbstractProxyQueryImpl<T> having(Conditional ... conditionalExpressions) {
        this.having = new HavingClause(conditionalExpressions);
        return this;
    }

    @Override
    public <S> Subquery<S> subquery(QueryValue<S> value) {
        ArrayList<Selection> list = new ArrayList<Selection>();
        list.add(value);
        this.setSelect(new SelectClause(list, this.getSelect().isDistinct()));
        return new SubqueryValue(this.getSelect(), this.getFrom(), this.getWhere(), this.getGroupBy(), this.getHaving(), this.getOrderBy());
    }

    @Override
    public TypedQuery<T> select() {
        ArrayList<Selection> list = new ArrayList<Selection>();
        list.add(new SelectProxy(this.getRootProxy()));
        this.setSelect(new SelectClause(list, this.getSelect().isDistinct()));
        return this.createTypedQuery();
    }

    @Override
    public <S> TypedQuery<S> select(QueryValue<S> value) {
        ArrayList<Selection> list = new ArrayList<Selection>();
        list.add(value);
        this.setSelect(new SelectClause(list, this.getSelect().isDistinct()));
        return this.createTypedQuery();
    }

    protected abstract TypedQuery createTypedQuery();

    @Override
    public SelectClause getSelect() {
        return this.select;
    }

    protected void setSelect(SelectClause select) {
        this.select = select;
    }

    @Override
    public FromClause getFrom() {
        return this.from;
    }

    @Override
    public WhereClause getWhere() {
        return this.where;
    }

    @Override
    public GroupByClause getGroupBy() {
        return this.groupBy;
    }

    @Override
    public HavingClause getHaving() {
        return this.having;
    }

    @Override
    public OrderByClause getOrderBy() {
        return this.orderBy;
    }

    @Override
    public T getRootProxy() {
        return this.proxy;
    }

    protected DynamicQuery getQuery() {
        return this.query;
    }

    protected void setQuery(DynamicQuery query) {
        this.query = query;
    }

    @Override
    public Class<?> getRootProxyClass() {
        return this.rootProxyClass;
    }

    @Override
    public DynamicQuery build() {
        if (this.query == null) {
            throw new IllegalStateException("select() was not called");
        }
        return this.query;
    }

    <C> C join(Collection<C> collectionProperty, QueryJoinType joinType, QueryJoinModifier joinModifier) {
        RecordedMethodCall call = RecordingSessions.get().getSafeFirstCall();
        if (call.getParentProxy() == null) {
            throw new IllegalStateException("No parent-proxy for call: " + call);
        }
        QueryJoin parent = this.getFrom().findParentJoin(call.getParentProxy());
        if (parent == null) {
            throw new IllegalStateException("Could not find parent join for collection join: " + call);
        }
        Object joinProxy = MethodCallUtils.proxy((Class)call.getElementType(), (String)"");
        NestedPropertyJoin join = new NestedPropertyJoin(parent, joinType, joinModifier, call.getName(), joinProxy);
        this.from = new FromClause(join, this.getFrom());
        return (C)joinProxy;
    }

    @Override
    public <C> C join(Collection<C> collectionProperty) {
        return this.join(collectionProperty, QueryJoinType.INNER, QueryJoinModifier.NONE);
    }

    @Override
    public <C> C joinFetch(Collection<C> collectionProperty) {
        return this.join(collectionProperty, QueryJoinType.INNER, QueryJoinModifier.FETCH);
    }

    @Override
    public <C> C leftJoin(Collection<C> collectionProperty) {
        return this.join(collectionProperty, QueryJoinType.LEFT, QueryJoinModifier.NONE);
    }

    @Override
    public <C> C rightJoin(Collection<C> collectionProperty) {
        return this.join(collectionProperty, QueryJoinType.RIGHT, QueryJoinModifier.NONE);
    }

    private QueryJoin findJoinParent(ProxyPathExpression targetProperty) {
        Object parentProxy = targetProperty.getCall().getParentProxy();
        if (parentProxy == null) {
            throw new IllegalStateException("No parent-proxy for call: " + targetProperty.getCall());
        }
        if (targetProperty.getCall().getElementType() == null) {
            throw new IllegalStateException("No element-type for call: " + targetProperty.getCall());
        }
        if (Collection.class.isAssignableFrom(targetProperty.getCall().getElementType())) {
            throw new IllegalStateException("Element-type for call must not be collection: " + targetProperty.getCall());
        }
        QueryJoin parent = this.getFrom().findParentJoin(parentProxy);
        if (parent == null) {
            throw new IllegalArgumentException("Could not find parent join");
        }
        return parent;
    }

    private <J> J join(QueryValue<J> targetQueryValue, QueryJoinType joinType, QueryJoinModifier joinModifier) {
        if (!(targetQueryValue instanceof ProxyPathExpression)) {
            throw new IllegalArgumentException("Invalid Join Argument, expected: " + ProxyPathExpression.class.getSimpleName());
        }
        ProxyPathExpression targetProperty = (ProxyPathExpression)targetQueryValue;
        QueryJoin parent = this.findJoinParent(targetProperty);
        Object joinProxy = MethodCallUtils.proxy((Class)targetProperty.getCall().getElementType(), (String)"");
        NestedPropertyJoin join = new NestedPropertyJoin(parent, joinType, joinModifier, targetProperty.getCall().getName(), joinProxy);
        this.from = new FromClause(join, this.getFrom());
        return (J)joinProxy;
    }

    @Override
    public <J> J join(QueryValue<J> targetProperty) {
        return this.join(targetProperty, QueryJoinType.INNER, QueryJoinModifier.NONE);
    }

    @Override
    public <J> J joinFetch(QueryValue<J> targetProperty) {
        return this.join(targetProperty, QueryJoinType.INNER, QueryJoinModifier.FETCH);
    }

    @Override
    public <J> J leftJoin(QueryValue<J> targetProperty) {
        return this.join(targetProperty, QueryJoinType.LEFT, QueryJoinModifier.NONE);
    }

    @Override
    public <J> J rightJoin(QueryValue<J> targetProperty) {
        return this.join(targetProperty, QueryJoinType.RIGHT, QueryJoinModifier.NONE);
    }

    @Override
    public <J> J thetaJoin(Object parentProxy, Class<J> joinClass) {
        if (joinClass == null) {
            throw new IllegalArgumentException("joinClass was not specified");
        }
        MethodCallUtils.validateIsProxy((Object)parentProxy, (String)"parentProxy");
        QueryJoin parent = this.getFrom().findParentJoin(parentProxy);
        if (parent == null) {
            throw new IllegalArgumentException("Could not find parent join");
        }
        Object joinProxy = MethodCallUtils.proxy(joinClass, (String)"");
        ThetaJoin join = new ThetaJoin(parent, joinClass.getSimpleName(), joinProxy);
        this.from = new FromClause(join, this.getFrom());
        return (J)joinProxy;
    }

    @Override
    public void processConditional(Conditional newConditional) {
        this.where = new WhereClause(this.where, newConditional);
    }
}

