/*
 * Decompiled with CFR 0.152.
 */
package org.cementframework.querybyproxy.shared.impl;

import java.util.HashMap;
import java.util.Map;
import org.cementframework.querybyproxy.shared.api.ProxyQueryBuilder;
import org.cementframework.querybyproxy.shared.api.ProxyQuerySession;
import org.cementframework.querybyproxy.shared.api.ProxyQuerySessions;
import org.cementframework.querybyproxy.shared.api.model.conditionals.ComparisonOperator;
import org.cementframework.querybyproxy.shared.api.model.conditionals.Conditional;
import org.cementframework.querybyproxy.shared.api.model.conditionals.GroupConditional;
import org.cementframework.querybyproxy.shared.api.model.conditionals.LogicGate;
import org.cementframework.querybyproxy.shared.api.model.conditionals.SubqueryConditional;
import org.cementframework.querybyproxy.shared.api.model.selections.AggregateSelection;
import org.cementframework.querybyproxy.shared.api.model.selections.QueryAggregate;
import org.cementframework.querybyproxy.shared.api.model.sorts.DirectionalQuerySort;
import org.cementframework.querybyproxy.shared.api.model.sorts.QuerySortOperator;
import org.cementframework.querybyproxy.shared.api.model.values.AbstractQueryValue;
import org.cementframework.querybyproxy.shared.api.model.values.ProxyPathExpression;
import org.cementframework.querybyproxy.shared.api.model.values.ProxySelectionExpression;
import org.cementframework.querybyproxy.shared.api.model.values.QueryLiteral;
import org.cementframework.querybyproxy.shared.api.model.values.QueryParameter;
import org.cementframework.querybyproxy.shared.api.model.values.QueryValue;
import org.cementframework.querybyproxy.shared.api.model.values.SimpleQueryValue;
import org.cementframework.querybyproxy.shared.api.model.values.Subquery;
import org.cementframework.querybyproxy.shared.api.model.values.SubqueryModifierDecorator;
import org.cementframework.querybyproxy.shared.api.model.values.SubqueryOperator;
import org.cementframework.recordingproxy.api.RecordedMethodCall;
import org.cementframework.recordingproxy.api.RecordingSession;
import org.cementframework.recordingproxy.api.RecordingSessions;
import org.cementframework.recordingproxy.impl.MethodCallUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProxyQueryBuilderImpl
implements ProxyQueryBuilder {
    private Map<Class<?>, Object> proxyMap = new HashMap();

    ProxyQueryBuilderImpl() {
    }

    @Override
    public <T> T createProxy(Class<T> type) {
        Object proxy = this.proxyMap.get(type);
        if (proxy == null) {
            proxy = MethodCallUtils.proxy(type);
            this.proxyMap.put(type, proxy);
        }
        return (T)proxy;
    }

    @Override
    public DirectionalQuerySort desc(Object instance) {
        return new DirectionalQuerySort(this.createQueryValue(instance), QuerySortOperator.DESC);
    }

    @Override
    public QueryValue<Long> count(Object selection) {
        return this.createAggregateSelection(selection, QueryAggregate.COUNT);
    }

    @Override
    public <T> QueryValue<T> min(T selection) {
        return this.createAggregateSelection(selection, QueryAggregate.MIN);
    }

    @Override
    public <T> QueryValue<T> max(T selection) {
        return this.createAggregateSelection(selection, QueryAggregate.MAX);
    }

    @Override
    public <T> QueryValue<T> sum(T selection) {
        return this.createAggregateSelection(selection, QueryAggregate.SUM);
    }

    @Override
    public <T> QueryValue<T> avg(T selection) {
        return this.createAggregateSelection(selection, QueryAggregate.AVG);
    }

    private <T> AggregateSelection<T> createAggregateSelection(T selection, QueryAggregate aggregate) {
        return new AggregateSelection(aggregate, this.createQueryValue((Object)selection, false));
    }

    @Override
    public <T> QueryValue<T> count(SimpleQueryValue<T> selection) {
        return this.createAggregateSelectionSrict(selection, QueryAggregate.COUNT);
    }

    @Override
    public QueryValue<Long> count() {
        return this.createAggregateSelectionSrict(new QueryLiteral(1L), QueryAggregate.COUNT);
    }

    @Override
    public QueryValue<Long> size(SimpleQueryValue selection) {
        QueryValue aggValue = (QueryValue)selection;
        return this.createAggregateSelectionSrict(aggValue, QueryAggregate.SIZE);
    }

    @Override
    public <T> QueryValue<T> min(SimpleQueryValue<T> selection) {
        return this.createAggregateSelectionSrict(selection, QueryAggregate.MIN);
    }

    @Override
    public <T> QueryValue<T> max(SimpleQueryValue<T> selection) {
        return this.createAggregateSelectionSrict(selection, QueryAggregate.MAX);
    }

    @Override
    public <T> QueryValue<T> sum(SimpleQueryValue<T> selection) {
        return this.createAggregateSelectionSrict(selection, QueryAggregate.SUM);
    }

    @Override
    public <T> QueryValue<T> avg(SimpleQueryValue<T> selection) {
        return this.createAggregateSelectionSrict(selection, QueryAggregate.AVG);
    }

    private <T> AggregateSelection<T> createAggregateSelectionSrict(SimpleQueryValue<T> selection, QueryAggregate aggregate) {
        return new AggregateSelection<T>(aggregate, selection);
    }

    @Override
    public Conditional or() {
        this.getSession().setNextLogicGate(LogicGate.OR);
        return null;
    }

    @Override
    public Conditional exists(Subquery subquery) {
        LogicGate logicGate = this.getSession().getNextLogicGate();
        return new SubqueryConditional(logicGate, ComparisonOperator.EXISTS, subquery);
    }

    @Override
    public Conditional notExists(Subquery subquery) {
        LogicGate logicGate = this.getSession().getNextLogicGate();
        return new SubqueryConditional(logicGate, ComparisonOperator.NOT_EXISTS, subquery);
    }

    @Override
    public <T> Subquery<T> all(Subquery<T> subquery) {
        return new SubqueryModifierDecorator<T>(SubqueryOperator.ALL, subquery);
    }

    @Override
    public <T> Subquery<T> any(Subquery<T> subquery) {
        return new SubqueryModifierDecorator<T>(SubqueryOperator.ANY, subquery);
    }

    @Override
    public <T> Subquery<T> some(Subquery<T> subquery) {
        return new SubqueryModifierDecorator<T>(SubqueryOperator.SOME, subquery);
    }

    @Override
    public Conditional group(Conditional ... conditionalExpressions) {
        LogicGate logicGate = this.getSession().getNextLogicGate();
        GroupConditional group = new GroupConditional(logicGate, conditionalExpressions);
        return group;
    }

    @Override
    public <T> QueryValue<T> get(Object instance, Class<T> returnType) {
        AbstractQueryValue column;
        if (MethodCallUtils.isProxy((Object)instance)) {
            RecordedMethodCall call = this.getRecordingSession().getLastCall();
            column = call != null ? new ProxyPathExpression(call) : new ProxySelectionExpression<Object>(instance);
        } else {
            RecordedMethodCall call = this.getRecordingSession().getSafeLastCall();
            column = new ProxyPathExpression(call);
        }
        return column;
    }

    @Override
    public <T> QueryValue<T> get(T instance) {
        return this.get((Object)instance, (Class)null);
    }

    @Override
    public DirectionalQuerySort desc(SimpleQueryValue selection) {
        return new DirectionalQuerySort(selection, QuerySortOperator.DESC);
    }

    public <T> QueryLiteral<T> literal(T target) {
        return new QueryLiteral(target);
    }

    @Override
    public <T> QueryValue<T> createQueryValue(T target) {
        return this.createQueryValue((Object)target, true);
    }

    @Override
    public <T> QueryValue<T> createQueryValue(T target, boolean getFirst) {
        if (target != null && !MethodCallUtils.isProxy(target)) {
            if (target instanceof QueryValue) {
                return (QueryValue)target;
            }
            return new QueryLiteral(target);
        }
        return this.createProperty(target, getFirst);
    }

    private ProxyPathExpression createProperty(Object obj, boolean getFirst) {
        RecordingSession recordingSession = RecordingSessions.get();
        RecordedMethodCall call = getFirst ? recordingSession.getSafeFirstCall() : recordingSession.getSafeLastCall();
        ProxyPathExpression selection = new ProxyPathExpression(call);
        return selection;
    }

    public <T> QueryParameter<T> param(T target) {
        return new QueryParameter(target);
    }

    private RecordingSession getRecordingSession() {
        return RecordingSessions.get();
    }

    private ProxyQuerySession getSession() {
        return ProxyQuerySessions.get();
    }
}

