/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.Collection$impl;
import ceylon.language.DefaultAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.Iterable;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.Sequence;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.TagsAnnotation$annotation$;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.LocalDeclarations;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;

@Ceylon(major=8)
@DocAnnotation$annotation$(description="An iterable collection of elements of finite [[size]], with \na well-defined notion of [[value equality|equals]]. \n`Collection` is the abstract supertype of [[List]], [[Map]], \nand [[Set]].\n\nA `Collection` forms a [[Category]] of its elements, and is \n[[Iterable]]. The elements of a collection are not\nnecessarily distinct when compared using [[Object.equals]].\n\nA `Collection` may be [[cloned|clone]]. If a collection is\nimmutable, it is acceptable that `clone()` produce a\nreference to the collection itself. If a collection is\nmutable, `clone()` should produce a collection containing \nreferences to the same elements, with the same structure as \nthe original collection&mdash;that is, it should produce a \nshallow copy of the collection.\n\nAll `Collection`s are required to support a well-defined\nnotion of [[value equality|Object.equals]], but the\ndefinition of equality depends upon the kind of collection.\nEquality for `Map`s and `Set`s has a quite different\ndefinition to equality for `List`s. Instances of two \ndifferent kinds of collection are never equal&mdash;for\nexample, a `Map` is never equal to a `List`.")
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IList", "::1.2.2:ceylon.language::IMap", "::1.2.2:ceylon.language::ISet"})})
@TagsAnnotation$annotation$(tags={"Collections"})
@SharedAnnotation$annotation$
@LocalDeclarations(value={"1anonymous_0_"})
@Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"An iterable collection of elements of finite [[size]], with \na well-defined notion of [[value equality|equals]]. \n`Collection` is the abstract supertype of [[List]], [[Map]], \nand [[Set]].\n\nA `Collection` forms a [[Category]] of its elements, and is \n[[Iterable]]. The elements of a collection are not\nnecessarily distinct when compared using [[Object.equals]].\n\nA `Collection` may be [[cloned|clone]]. If a collection is\nimmutable, it is acceptable that `clone()` produce a\nreference to the collection itself. If a collection is\nmutable, `clone()` should produce a collection containing \nreferences to the same elements, with the same structure as \nthe original collection&mdash;that is, it should produce a \nshallow copy of the collection.\n\nAll `Collection`s are required to support a well-defined\nnotion of [[value equality|Object.equals]], but the\ndefinition of equality depends upon the kind of collection.\nEquality for `Map`s and `Set`s has a quite different\ndefinition to equality for `List`s. Instances of two \ndifferent kinds of collection are never equal&mdash;for\nexample, a `Map` is never equal to a `List`."}), @Annotation(value="see", arguments={"List", "Map", "Set"}), @Annotation(value="tagged", arguments={"Collections"})})
@SatisfiedTypes(value={"{Element*}"})
@TypeParameters(value={@TypeParameter(value="Element", variance=Variance.OUT, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Anything")})
public interface Collection<Element>
extends Iterable<Element, Object> {
    @Ignore
    public Collection$impl<? extends Element> $ceylon$language$Collection$impl();

    @DocAnnotation$annotation$(description="A shallow copy of this collection, that is, a \ncollection with identical elements which does not\nchange if this collection changes. If this collection\nis immutable, it is acceptable to return a reference to\nthis collection. If this collection is mutable, a newly\ninstantiated collection must be returned.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"A shallow copy of this collection, that is, a \ncollection with identical elements which does not\nchange if this collection changes. If this collection\nis immutable, it is acceptable to return a reference to\nthis collection. If this collection is mutable, a newly\ninstantiated collection must be returned."})})
    @TypeInfo(value="ceylon.language::Collection<Element>")
    public Collection<? extends Element> $clone();

    @Override
    @DocAnnotation$annotation$(description="Determine if the collection is empty, that is, if it \nhas no elements.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Determine if the collection is empty, that is, if it \nhas no elements."})})
    @TypeInfo(value="ceylon.language::Boolean")
    @Transient
    public boolean getEmpty();

    @Override
    @DocAnnotation$annotation$(description="Return `true` if the given object is an element of this \ncollection. In this default implementation, and in most \nrefining implementations, return `false` otherwise. An \nacceptable refining implementation may return `true` \nfor objects which are not elements of the collection, \nbut this is not recommended. (For example, the \n`contains()` method of `String` returns `true` for any \nsubstring of the string.)")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Return `true` if the given object is an element of this \ncollection. In this default implementation, and in most \nrefining implementations, return `false` otherwise. An \nacceptable refining implementation may return `true` \nfor objects which are not elements of the collection, \nbut this is not recommended. (For example, the \n`contains()` method of `String` returns `true` for any \nsubstring of the string.)"})})
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean contains(@Name(value="element") @TypeInfo(value="ceylon.language::Object") Object var1);

    @Override
    @DocAnnotation$annotation$(description="A string of form `\"{ x, y, z }\"` where `x`, `y`, and \n`z` are the `string` representations of the elements of \nthis collection, as produced by the iterator of the \ncollection, or the string `\"{}\"` if this collection \nis empty. If the collection iterator produces the value \n`null`, the string representation contains the string \n`\"<null>\"`.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"A string of form `\"{ x, y, z }\"` where `x`, `y`, and \n`z` are the `string` representations of the elements of \nthis collection, as produced by the iterator of the \ncollection, or the string `\"{}\"` if this collection \nis empty. If the collection iterator produces the value \n`null`, the string representation contains the string \n`\"<null>\"`."})})
    @TypeInfo(value="ceylon.language::String")
    @Transient
    public String toString();

    @DocAnnotation$annotation$(description="The permutations of this collection, as a stream of\nnonempty [[sequences|Sequence]]. That is, a stream\nproducing every distinct ordering of the elements of\nthis collection.\n\nFor example,\n\n    \"ABC\".permutations.map(String)\n\nis the stream of strings\n`{ \"ABC\", \"ACB\", \"BAC\", \"BCA\", \"CAB\", \"CBA\" }`.\n\nIf this collection is empty, the resulting stream is\nempty.\n\nThe permutations are enumerated lexicographically\naccording to the order in which each distinct element \nof this collection is first produced by its iterator.\nNo permutation is repeated.\n\nTwo elements are considered distinct if either:\n\n- they are both instances of `Object`, and are \n  [[unequal|Object.equals]], or\n- one element is an `Object` and the other is `null`.")
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"The permutations of this collection, as a stream of\nnonempty [[sequences|Sequence]]. That is, a stream\nproducing every distinct ordering of the elements of\nthis collection.\n\nFor example,\n\n    \"ABC\".permutations.map(String)\n\nis the stream of strings\n`{ \"ABC\", \"ACB\", \"BAC\", \"BCA\", \"CAB\", \"CBA\" }`.\n\nIf this collection is empty, the resulting stream is\nempty.\n\nThe permutations are enumerated lexicographically\naccording to the order in which each distinct element \nof this collection is first produced by its iterator.\nNo permutation is repeated.\n\nTwo elements are considered distinct if either:\n\n- they are both instances of `Object`, and are \n  [[unequal|Object.equals]], or\n- one element is an `Object` and the other is `null`."})})
    @TypeInfo(value="{[Element+]*}")
    @Transient
    public Iterable<? extends Sequence<? extends Element>, ? extends Object> getPermutations();
}

