/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.AssertionError;
import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FinalAnnotation$annotation$;
import ceylon.language.Integer;
import ceylon.language.Object;
import ceylon.language.Sequence;
import ceylon.language.SerializableAnnotation$annotation$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.TagsAnnotation$annotation$;
import ceylon.language.Tuple;
import ceylon.language.impl.MemberImpl;
import ceylon.language.meta.declaration.ClassOrInterfaceDeclaration;
import ceylon.language.meta.declaration.FunctionOrValueDeclaration;
import ceylon.language.meta.declaration.ValueDeclaration;
import ceylon.language.serialization.Member;
import ceylon.language.serialization.ReachableReference;
import ceylon.language.stringify_;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Jpa;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.compiler.java.runtime.serialization.$Serialization$;
import com.redhat.ceylon.compiler.java.runtime.serialization.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;

@Ceylon(major=8)
@DocAnnotation$annotation$(description="A pair containing a _key_ and an associated value called \nthe _item_. Used primarily to represent the elements of a \n[[Map]]. The type `Entry<Key,Item>` may be abbreviated \n`Key->Item`. An instance of `Entry` may be constructed \nusing the `->` operator:\n\n    String->Person entry = person.name->person;")
@AuthorsAnnotation$annotation$(authors={"Gavin"})
@TagsAnnotation$annotation$(tags={"Collections"})
@SharedAnnotation$annotation$
@FinalAnnotation$annotation$
@SerializableAnnotation$annotation$
@Annotations(modifiers=4130L, value={@Annotation(value="doc", arguments={"A pair containing a _key_ and an associated value called \nthe _item_. Used primarily to represent the elements of a \n[[Map]]. The type `Entry<Key,Item>` may be abbreviated \n`Key->Item`. An instance of `Entry` may be constructed \nusing the `->` operator:\n\n    String->Person entry = person.name->person;"}), @Annotation(value="by", arguments={"Gavin"}), @Annotation(value="tagged", arguments={"Collections"})})
@TypeParameters(value={@TypeParameter(value="Key", variance=Variance.OUT, satisfies={"ceylon.language::Object"}, caseTypes={}), @TypeParameter(value="Item", variance=Variance.OUT, satisfies={}, caseTypes={})})
@Class(identifiable=false, basic=false, extendsType="ceylon.language::Object")
public final class Entry<Key, Item>
implements ReifiedType,
java.io.Serializable,
Serializable {
    @Ignore
    private final TypeDescriptor $reified$Key;
    @Ignore
    private final TypeDescriptor $reified$Item;
    @Ignore
    private final Key key;
    @Ignore
    private final Item item;

    @Jpa
    @Ignore
    protected Entry(@Ignore TypeDescriptor $reified$Key, @Ignore TypeDescriptor $reified$Item) {
        this(null, $reified$Key, $reified$Item);
    }

    @Ignore
    public Entry($Serialization$ ignored, TypeDescriptor $reified$Key, TypeDescriptor $reified$Item) {
        this.$reified$Key = $reified$Key;
        this.$reified$Item = $reified$Item;
        this.key = null;
        this.item = null;
    }

    public Entry(@Ignore TypeDescriptor $reified$Key, @Ignore TypeDescriptor $reified$Item, @Name(value="key") @TypeInfo(value="Key") Key key, @Name(value="item") @TypeInfo(value="Item") Item item) {
        this.$reified$Key = $reified$Key;
        this.$reified$Item = $reified$Item;
        this.key = key;
        this.item = item;
    }

    @DocAnnotation$annotation$(description="The key used to access the entry.")
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"The key used to access the entry."})})
    @TypeInfo(value="Key")
    public final Key getKey() {
        return this.key;
    }

    @DocAnnotation$annotation$(description="The item associated with the key.")
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"The item associated with the key."})})
    @TypeInfo(value="Item")
    public final Item getItem() {
        return this.item;
    }

    @DocAnnotation$annotation$(description="A pair (2 element tuple) with the key and item of this \nentry. For any `entry`:\n\n    entry.pair == [entry.key,entry.item]")
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"A pair (2 element tuple) with the key and item of this \nentry. For any `entry`:\n\n    entry.pair == [entry.key,entry.item]"})})
    @TypeInfo(value="[Key, Item]", erased=true)
    @Transient
    public final Sequence getPair() {
        return Tuple.instance(TypeDescriptor.union(this.$reified$Key, this.$reified$Item), new java.lang.Object[]{this.getKey(), this.getItem()});
    }

    /*
     * WARNING - void declaration
     */
    @DocAnnotation$annotation$(description="An `Entry` with the key and item of this entry if this \nentry's item is non-null, or `null` otherwise.")
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"An `Entry` with the key and item of this entry if this \nentry's item is non-null, or `null` otherwise."})})
    @TypeInfo(value="<Key->Item&ceylon.language::Object>?")
    @Transient
    public final Entry<? extends Key, ? extends Item> getCoalesced() {
        void var1_4;
        Entry<Key, Item> $ceylontmp$ifResult$142;
        Item item$144 = this.getItem();
        if (item$144 != null) {
            Item item$146 = item$144;
            $ceylontmp$ifResult$142 = new Entry<Key, Item>(this.$reified$Key, TypeDescriptor.intersection(this.$reified$Item, Object.$TypeDescriptor$), this.getKey(), item$146);
        } else {
            Item item$145 = item$144;
            $ceylontmp$ifResult$142 = null;
        }
        return var1_4;
    }

    @DocAnnotation$annotation$(description="Determines if this entry is equal to the given entry. \nTwo entries are equal if they have the same key and \nthe same item. \n\n- The keys are considered the same if they are equal,\n  in the sense of [[value equality|Object.equals]].\n- Two items are considered the same if they are both \n  null or if neither is null and they are equal.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L, value={@Annotation(value="doc", arguments={"Determines if this entry is equal to the given entry. \nTwo entries are equal if they have the same key and \nthe same item. \n\n- The keys are considered the same if they are equal,\n  in the sense of [[value equality|Object.equals]].\n- Two items are considered the same if they are both \n  null or if neither is null and they are equal."})})
    @TypeInfo(value="ceylon.language::Boolean")
    public final boolean equals(@Name(value="that") @TypeInfo(value="ceylon.language::Object") java.lang.Object that) {
        java.lang.Object that$148 = that;
        if (that$148 instanceof Entry) {
            java.lang.Object thatItem$155;
            Item thisItem$153;
            Entry that$149 = (Entry)that$148;
            if (!this.getKey().equals(that$149.getKey())) {
                return false;
            }
            boolean $ceylontmp$if$151 = false;
            Item thisItem$152 = this.getItem();
            if (thisItem$152 != null) {
                thisItem$153 = thisItem$152;
                Item thatItem$154 = that$149.getItem();
                if (thatItem$154 != null) {
                    thatItem$155 = thatItem$154;
                    $ceylontmp$if$151 = true;
                } else {
                    thatItem$155 = null;
                }
            } else {
                thisItem$153 = null;
                thatItem$155 = null;
            }
            if ($ceylontmp$if$151) {
                return thisItem$153.equals(thatItem$155);
            }
            return this.getItem() == null && that$149.getItem() == null;
        }
        return false;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::Integer")
    @Transient
    public final int hashCode() {
        Item safe$157 = this.getItem();
        Integer $ceylontmp$158 = safe$157 != null ? Integer.instance(safe$157.hashCode()) : null;
        long $ceylontmp$hash$159 = (31L + (long)this.getKey().hashCode()) * 31L + ($ceylontmp$158 != null ? $ceylontmp$158 : Integer.instance(0L)).longValue();
        return (int)($ceylontmp$hash$159 ^ $ceylontmp$hash$159 >>> 32);
    }

    @DocAnnotation$annotation$(description="A description of the entry in the form `key->item`. If \n[[item]] is `null`, its string representation is the \nstring `\"<null>\"`.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L, value={@Annotation(value="doc", arguments={"A description of the entry in the form `key->item`. If \n[[item]] is `null`, its string representation is the \nstring `\"<null>\"`."})})
    @TypeInfo(value="ceylon.language::String")
    @Transient
    public final String toString() {
        return this.getKey().toString() + "->" + stringify_.stringify(this.getItem());
    }

    @Override
    @Ignore
    public TypeDescriptor $getType$() {
        return TypeDescriptor.klass(Entry.class, this.$reified$Key, this.$reified$Item);
    }

    @Override
    @Ignore
    public Collection<ReachableReference> $references$() {
        ArrayList<ReachableReference> reference = new ArrayList<ReachableReference>();
        reference.add(new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(Entry.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "key")));
        reference.add(new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(Entry.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "item")));
        return reference;
    }

    @Override
    @Ignore
    public java.lang.Object $get$(ReachableReference reference) {
        switch (((Member)reference).getAttribute().getQualifiedName()) {
            case "ceylon.language::Entry.key": {
                return this.key;
            }
            case "ceylon.language::Entry.item": {
                return this.item;
            }
        }
        throw new RuntimeException("unknown attribute");
    }

    @Override
    @Ignore
    public void $set$(ReachableReference reference, java.lang.Object instance) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        if (reference instanceof Member) {
            switch (((Member)reference).getAttribute().getQualifiedName()) {
                case "ceylon.language::Entry.key": {
                    Util.setter(lookup, "key").invokeExact(this, instance);
                    break;
                }
                case "ceylon.language::Entry.item": {
                    Util.setter(lookup, "item").invokeExact(this, instance);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown attribute");
                }
            }
        } else {
            throw new AssertionError("unexpected reachable reference " + reference);
        }
    }
}

