/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.AliasesAnnotation$annotation$;
import ceylon.language.Comparable$impl;
import ceylon.language.Comparison;
import ceylon.language.Exponentiable;
import ceylon.language.Integer;
import ceylon.language.Invertible$impl;
import ceylon.language.Number;
import ceylon.language.Number$impl;
import ceylon.language.OverflowException;
import ceylon.language.equal_;
import ceylon.language.larger_;
import ceylon.language.smaller_;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.ValueType;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import java.io.Serializable;

@Ceylon(major=8)
@Class(extendsType="ceylon.language::Object", basic=false, identifiable=false)
@SatisfiedTypes(value={"ceylon.language::Number<ceylon.language::Float>", "ceylon.language::Exponentiable<ceylon.language::Float,ceylon.language::Float>"})
@ValueType
public final class Float
implements Number<Float>,
Exponentiable<Float, Float>,
ReifiedType,
Serializable {
    private static final long serialVersionUID = 8699090544995758140L;
    private static final double TWO_FIFTY_TWO = 4.503599627370496E15;
    @Ignore
    public static final TypeDescriptor $TypeDescriptor$ = TypeDescriptor.klass(Float.class, new TypeDescriptor[0]);
    @Ignore
    final double value;

    public Float(@Name(value="float") double f) {
        this.value = f;
    }

    @Override
    @Ignore
    public Number$impl<Float> $ceylon$language$Number$impl() {
        throw Util.makeUnimplementedMixinAccessException();
    }

    @Override
    @Ignore
    public Invertible$impl<Float> $ceylon$language$Invertible$impl() {
        throw Util.makeUnimplementedMixinAccessException();
    }

    @Override
    @Ignore
    public Comparable$impl<Float> $ceylon$language$Comparable$impl() {
        throw Util.makeUnimplementedMixinAccessException();
    }

    @Ignore
    public static Float instance(double d) {
        return new Float(d);
    }

    @Ignore
    public double doubleValue() {
        return this.value;
    }

    @Override
    public Float plus(@Name(value="other") Float other) {
        return Float.instance(this.value + other.value);
    }

    @Ignore
    public static double plus(double value, double otherValue) {
        return value + otherValue;
    }

    @Override
    public Float minus(@Name(value="other") Float other) {
        return Float.instance(this.value - other.value);
    }

    @Ignore
    public static double minus(double value, double otherValue) {
        return value - otherValue;
    }

    @Override
    public Float times(@Name(value="other") Float other) {
        return Float.instance(this.value * other.value);
    }

    @Ignore
    public static double times(double value, double otherValue) {
        return value * otherValue;
    }

    @Override
    public Float divided(@Name(value="other") Float other) {
        return Float.instance(this.value / other.value);
    }

    @Ignore
    public static double divided(double value, double otherValue) {
        return value / otherValue;
    }

    @Override
    public Float power(@Name(value="other") Float other) {
        return Float.instance(Float.power(this.value, other.value));
    }

    @Ignore
    public static double power(double value, double otherValue) {
        if (otherValue == 0.0 && !Double.isNaN(value)) {
            return 1.0;
        }
        if (otherValue == 1.0) {
            return value;
        }
        if (otherValue == 2.0) {
            return value * value;
        }
        if (otherValue == 3.0) {
            return value * value * value;
        }
        if (otherValue == 4.0) {
            double sqr = value * value;
            return sqr * sqr;
        }
        if (otherValue == 5.0) {
            double sqr = value * value;
            return sqr * sqr * value;
        }
        if (otherValue == 6.0) {
            double sqr = value * value;
            return sqr * sqr * sqr;
        }
        if (otherValue == 0.5) {
            return Math.sqrt(value);
        }
        if (otherValue == 0.25) {
            return Math.sqrt(Math.sqrt(value));
        }
        if (otherValue == -1.0) {
            return 1.0 / value;
        }
        if (otherValue == -2.0) {
            return 1.0 / value / value;
        }
        if (otherValue == -3.0) {
            return 1.0 / value / value / value;
        }
        if (otherValue == -4.0) {
            double sqr = value * value;
            return 1.0 / sqr / sqr;
        }
        if (otherValue == -5.0) {
            double sqr = value * value;
            return 1.0 / sqr / sqr / value;
        }
        if (otherValue == -6.0) {
            double sqr = value * value;
            return 1.0 / sqr / sqr / sqr;
        }
        if (otherValue == -0.5) {
            return 1.0 / Math.sqrt(value);
        }
        if (otherValue == -0.25) {
            return 1.0 / Math.sqrt(Math.sqrt(value));
        }
        if (value == 1.0) {
            return 1.0;
        }
        if (value == -1.0 && (otherValue == Double.POSITIVE_INFINITY || otherValue == Double.NEGATIVE_INFINITY)) {
            return 1.0;
        }
        return Math.pow(value, otherValue);
    }

    @Override
    @Ignore
    public Float plus(Integer other) {
        return Float.instance(this.value + (double)other.value);
    }

    @Ignore
    public static double plus(double value, long otherValue) {
        return value + (double)otherValue;
    }

    @Override
    @Ignore
    public Float minus(Integer other) {
        return Float.instance(this.value - (double)other.value);
    }

    @Ignore
    public static double minus(double value, long otherValue) {
        return value - (double)otherValue;
    }

    @Override
    @Ignore
    public Float times(Integer other) {
        return Float.instance(this.value * (double)other.value);
    }

    @Ignore
    public static double times(double value, long otherValue) {
        return value * (double)otherValue;
    }

    @Override
    @Ignore
    public Float divided(Integer other) {
        return Float.instance(this.value / (double)other.value);
    }

    @Ignore
    public static double divided(double value, long otherValue) {
        return value / (double)otherValue;
    }

    @Override
    @Ignore
    public Float power(Integer other) {
        return Float.instance(Float.powerOfInteger(this.value, other.value));
    }

    @Ignore
    public static double power(double value, long otherValue) {
        return Float.powerOfInteger(value, otherValue);
    }

    @Override
    @AliasesAnnotation$annotation$(aliases={"absolute"})
    public Float getMagnitude() {
        return Float.instance(Math.abs(this.value));
    }

    @Ignore
    public static double getMagnitude(double value) {
        return Math.abs(value);
    }

    @Override
    public Float getFractionalPart() {
        double fractionalPart = Float.getFractionalPart(this.value);
        if (fractionalPart != 0.0 && fractionalPart == this.value) {
            return this;
        }
        return Float.instance(fractionalPart);
    }

    @Ignore
    public static double getFractionalPart(double value) {
        if (value <= -4.503599627370496E15) {
            return -0.0;
        }
        if (value >= 4.503599627370496E15) {
            return 0.0;
        }
        if (Double.isNaN(value)) {
            return Double.NaN;
        }
        double result = value - (double)((long)value);
        if (result == 0.0 && 1.0 / value < 0.0) {
            return -0.0;
        }
        return result;
    }

    @Override
    public Float getWholePart() {
        double wholePart = Float.getWholePart(this.value);
        if (wholePart != 0.0 && wholePart == this.value) {
            return this;
        }
        return Float.instance(wholePart);
    }

    @Ignore
    public static double getWholePart(double value) {
        if (value <= -4.503599627370496E15 || value >= 4.503599627370496E15) {
            return value;
        }
        if (Double.isNaN(value)) {
            return Double.NaN;
        }
        long result = (long)value;
        if (result == 0L && 1.0 / value < 0.0) {
            return -0.0;
        }
        return result;
    }

    @Override
    public boolean getPositive() {
        return this.value > 0.0;
    }

    @Ignore
    public static boolean getPositive(double value) {
        return value > 0.0;
    }

    @Override
    public boolean getNegative() {
        return this.value < 0.0;
    }

    @Ignore
    public static boolean getNegative(double value) {
        return value < 0.0;
    }

    public boolean getStrictlyPositive() {
        return Double.doubleToRawLongBits(this.value) >> 63 == 0L && !Double.isNaN(this.value);
    }

    @Ignore
    public static boolean getStrictlyPositive(double value) {
        return Double.doubleToRawLongBits(value) >> 63 == 0L && !Double.isNaN(value);
    }

    public boolean getStrictlyNegative() {
        return Double.doubleToRawLongBits(this.value) >> 63 != 0L && !Double.isNaN(this.value);
    }

    @Ignore
    public static boolean getStrictlyNegative(double value) {
        return Double.doubleToRawLongBits(value) >> 63 != 0L && !Double.isNaN(value);
    }

    @Override
    public long getSign() {
        if (this.value > 0.0) {
            return 1L;
        }
        if (this.value < 0.0) {
            return -1L;
        }
        return 0L;
    }

    @Ignore
    public static long getSign(double value) {
        if (value > 0.0) {
            return 1L;
        }
        if (value < 0.0) {
            return -1L;
        }
        return 0L;
    }

    @Override
    public Float getNegated() {
        return Float.instance(-this.value);
    }

    @Ignore
    public static double getNegated(double value) {
        return -value;
    }

    @Override
    public Comparison compare(@Name(value="other") Float other) {
        double x = this.value;
        double y = other.value;
        return x < y ? smaller_.get_() : (x == y ? equal_.get_() : larger_.get_());
    }

    @Ignore
    public static Comparison compare(double value, double otherValue) {
        double x = value;
        double y = otherValue;
        return x < y ? smaller_.get_() : (x == y ? equal_.get_() : larger_.get_());
    }

    public String toString() {
        return Double.toString(this.value);
    }

    @Ignore
    public static String toString(double value) {
        return Double.toString(value);
    }

    public long getInteger() {
        return Float.getInteger(this.value);
    }

    @Ignore
    public static long getInteger(double value) {
        if (value >= -9.223372036854776E18 && value <= 9.223372036854776E18) {
            return (long)value;
        }
        throw new OverflowException(value + " cannot be coerced to a 64 bit integer");
    }

    @AliasesAnnotation$annotation$(aliases={"notANumber"})
    @Transient
    public boolean getUndefined() {
        return Double.isNaN(this.value);
    }

    @Ignore
    public static boolean getUndefined(double value) {
        return Double.isNaN(value);
    }

    @Transient
    public boolean getFinite() {
        return !Double.isInfinite(this.value) && !this.getUndefined();
    }

    @Ignore
    public static boolean getFinite(double value) {
        return !Double.isInfinite(value) && !Float.getUndefined(value);
    }

    @Transient
    public boolean getInfinite() {
        return Double.isInfinite(this.value);
    }

    @Ignore
    public static boolean getInfinite(double value) {
        return Double.isInfinite(value);
    }

    public boolean equals(@Name(value="that") Object that) {
        return Float.equals(this.value, that);
    }

    @Ignore
    public static boolean equals(double value, Object that) {
        if (that instanceof Integer) {
            long intValue = ((Integer)that).value;
            return value == (double)intValue && intValue > -9007199254740992L && intValue < 0x20000000000000L;
        }
        if (that instanceof Float) {
            return value == ((Float)that).value;
        }
        return false;
    }

    public int hashCode() {
        return Float.hashCode(this.value);
    }

    @Ignore
    public static int hashCode(double value) {
        long wholePart = (long)value;
        if (value == (double)wholePart) {
            return Integer.hashCode(wholePart);
        }
        long bits = Double.doubleToLongBits(value);
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    @Ignore
    public TypeDescriptor $getType$() {
        return $TypeDescriptor$;
    }

    public static boolean largerThan(double value, Float other) {
        return value > other.value;
    }

    public static boolean largerThan(double value, double other) {
        return value > other;
    }

    @Override
    public boolean largerThan(@Name(value="other") Float other) {
        return this.value > other.value;
    }

    public static boolean notSmallerThan(double value, Float other) {
        return value >= other.value;
    }

    public static boolean notSmallerThan(double value, double other) {
        return value >= other;
    }

    @Override
    public boolean notSmallerThan(@Name(value="other") Float other) {
        return this.value >= other.value;
    }

    public static boolean smallerThan(double value, Float other) {
        return value < other.value;
    }

    public static boolean smallerThan(double value, double other) {
        return value < other;
    }

    @Override
    public boolean smallerThan(@Name(value="other") Float other) {
        return this.value < other.value;
    }

    public static boolean notLargerThan(double value, Float other) {
        return value <= other.value;
    }

    public static boolean notLargerThan(double value, double other) {
        return value <= other;
    }

    @Override
    public boolean notLargerThan(@Name(value="other") Float other) {
        return this.value <= other.value;
    }

    @Override
    public Float timesInteger(@Name(value="integer") long integer) {
        return Float.instance(this.value * (double)integer);
    }

    public static double timesInteger(double value, long integer) {
        return value * (double)integer;
    }

    @Override
    public Float plusInteger(@Name(value="integer") long integer) {
        return Float.instance(this.value + (double)integer);
    }

    public static double plusInteger(double value, long integer) {
        return value + (double)integer;
    }

    @Override
    public Float powerOfInteger(@Name(value="integer") long integer) {
        return Float.instance(Float.powerOfInteger(this.value, integer));
    }

    public static double powerOfInteger(double value, long integer) {
        if (integer == 0L && !Double.isNaN(value)) {
            return 1.0;
        }
        if (integer == 1L) {
            return value;
        }
        if (integer == 2L) {
            return value * value;
        }
        if (integer == 3L) {
            return value * value * value;
        }
        if (integer == 4L) {
            double sqr = value * value;
            return sqr * sqr;
        }
        if (integer == 5L) {
            double sqr = value * value;
            return sqr * sqr * value;
        }
        if (integer == 6L) {
            double sqr = value * value;
            return sqr * sqr * sqr;
        }
        if (integer == -1L) {
            return 1.0 / value;
        }
        if (integer == -2L) {
            return 1.0 / value / value;
        }
        if (integer == -3L) {
            return 1.0 / value / value / value;
        }
        if (integer == -4L) {
            double sqr = value * value;
            return 1.0 / sqr / sqr;
        }
        if (integer == -5L) {
            double sqr = value * value;
            return 1.0 / sqr / sqr / value;
        }
        if (integer == -6L) {
            double sqr = value * value;
            return 1.0 / sqr / sqr / sqr;
        }
        return Math.pow(value, integer);
    }
}

