/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.AliasesAnnotation$annotation$;
import ceylon.language.AssertionError;
import ceylon.language.Binary;
import ceylon.language.Binary$impl;
import ceylon.language.Character;
import ceylon.language.Comparable$impl;
import ceylon.language.Comparison;
import ceylon.language.Enumerable$impl;
import ceylon.language.Exponentiable;
import ceylon.language.Float;
import ceylon.language.Integral;
import ceylon.language.Integral$impl;
import ceylon.language.Invertible$impl;
import ceylon.language.Number$impl;
import ceylon.language.OverflowException;
import ceylon.language.equal_;
import ceylon.language.larger_;
import ceylon.language.smaller_;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.ValueType;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import java.io.Serializable;

@Ceylon(major=8)
@SatisfiedTypes(value={"ceylon.language::Integral<ceylon.language::Integer>", "ceylon.language::Binary<ceylon.language::Integer>", "ceylon.language::Exponentiable<ceylon.language::Integer,ceylon.language::Integer>"})
@Class(extendsType="ceylon.language::Object", basic=false, identifiable=false)
@ValueType
public final class Integer
implements Integral<Integer>,
Binary<Integer>,
Exponentiable<Integer, Integer>,
ReifiedType,
Serializable {
    private static final long serialVersionUID = 3611850372864102202L;
    static final long TWO_FIFTY_THREE = 0x20000000000000L;
    @Ignore
    public static final TypeDescriptor $TypeDescriptor$ = TypeDescriptor.klass(Integer.class, new TypeDescriptor[0]);
    @Ignore
    final long value;
    private static final long POWER_BY_SQUARING_BREAKEVEN = 6L;

    public Integer(@Name(value="integer") long integer) {
        this.value = integer;
    }

    @Override
    @Ignore
    public Number$impl<Integer> $ceylon$language$Number$impl() {
        throw Util.makeUnimplementedMixinAccessException();
    }

    @Override
    @Ignore
    public Invertible$impl<Integer> $ceylon$language$Invertible$impl() {
        throw Util.makeUnimplementedMixinAccessException();
    }

    @Override
    @Ignore
    public Comparable$impl<Integer> $ceylon$language$Comparable$impl() {
        throw Util.makeUnimplementedMixinAccessException();
    }

    @Override
    @Ignore
    public Integral$impl<Integer> $ceylon$language$Integral$impl() {
        throw Util.makeUnimplementedMixinAccessException();
    }

    @Override
    @Ignore
    public Enumerable$impl<Integer> $ceylon$language$Enumerable$impl() {
        throw Util.makeUnimplementedMixinAccessException();
    }

    @Override
    @Ignore
    public Binary$impl<Integer> $ceylon$language$Binary$impl() {
        throw Util.makeUnimplementedMixinAccessException();
    }

    @Ignore
    public static Integer instance(long l) {
        return new Integer(l);
    }

    @Ignore
    public long longValue() {
        return this.value;
    }

    @Override
    public Integer plus(@Name(value="other") Integer other) {
        return Integer.instance(this.value + other.value);
    }

    @Ignore
    public static long plus(long value, long otherValue) {
        return value + otherValue;
    }

    @Override
    public Integer minus(@Name(value="other") Integer other) {
        return Integer.instance(this.value - other.value);
    }

    @Ignore
    public static long minus(long value, long otherValue) {
        return value - otherValue;
    }

    @Override
    public Integer times(@Name(value="other") Integer other) {
        return Integer.instance(this.value * other.value);
    }

    @Ignore
    public static long times(long value, long otherValue) {
        return value * otherValue;
    }

    @Override
    public Integer divided(@Name(value="other") Integer other) {
        return Integer.instance(this.value / other.value);
    }

    @Ignore
    public static long divided(long value, long otherValue) {
        return value / otherValue;
    }

    private static long powerBySquaring(long base, long power) {
        long result = 1L;
        long x = base;
        while (power != 0L) {
            if ((power & 1L) == 1L) {
                result *= x;
                --power;
            }
            x *= x;
            power /= 2L;
        }
        return result;
    }

    private static long powerByMultiplying(long base, long power) {
        long result = 1L;
        while (power > 0L) {
            result *= base;
            --power;
        }
        return result;
    }

    @Override
    public Integer power(@Name(value="other") Integer other) {
        return Integer.instance(Integer.power(this.value, other.value));
    }

    @Ignore
    public static long power(long value, long otherValue) {
        long power = otherValue;
        if (value == -1L) {
            return power % 2L == 0L ? 1L : -1L;
        }
        if (value == 1L) {
            return 1L;
        }
        if (power < 0L) {
            throw new AssertionError(value + "^" + power + " cannot be represented as an Integer");
        }
        if (power == 0L) {
            return 1L;
        }
        if (power == 1L) {
            return value;
        }
        if (power >= 6L) {
            return Integer.powerBySquaring(value, power);
        }
        return Integer.powerByMultiplying(value, power);
    }

    @Override
    @Ignore
    public Float plus(Float other) {
        return Float.instance((double)this.value + other.value);
    }

    @Ignore
    public static double plus(long value, double otherValue) {
        return (double)value + otherValue;
    }

    @Override
    @Ignore
    public Float minus(Float other) {
        return Float.instance((double)this.value - other.value);
    }

    @Ignore
    public static double minus(long value, double otherValue) {
        return (double)value - otherValue;
    }

    @Override
    @Ignore
    public Float times(Float other) {
        return Float.instance((double)this.value * other.value);
    }

    @Ignore
    public static double times(long value, double otherValue) {
        return (double)value * otherValue;
    }

    @Override
    @Ignore
    public Float divided(Float other) {
        return Float.instance((double)this.value / other.value);
    }

    @Ignore
    public static double divided(long value, double otherValue) {
        return (double)value / otherValue;
    }

    @Override
    @Ignore
    public Float power(Float other) {
        return Float.instance(Math.pow(this.value, other.value));
    }

    @Ignore
    public static double power(long value, double otherValue) {
        return Math.pow(value, otherValue);
    }

    @Override
    @AliasesAnnotation$annotation$(aliases={"absolute"})
    public Integer getMagnitude() {
        return Integer.instance(Math.abs(this.value));
    }

    @Ignore
    public static long getMagnitude(long value) {
        return Math.abs(value);
    }

    @Override
    public Integer getFractionalPart() {
        return Integer.instance(0L);
    }

    @Ignore
    public static long getFractionalPart(long value) {
        return 0L;
    }

    @Override
    public Integer getWholePart() {
        return this;
    }

    @Ignore
    public static long getWholePart(long value) {
        return value;
    }

    @Override
    public boolean getPositive() {
        return this.value > 0L;
    }

    @Ignore
    public static boolean getPositive(long value) {
        return value > 0L;
    }

    @Override
    public boolean getNegative() {
        return this.value < 0L;
    }

    @Ignore
    public static boolean getNegative(long value) {
        return value < 0L;
    }

    @Override
    public long getSign() {
        if (this.value > 0L) {
            return 1L;
        }
        if (this.value < 0L) {
            return -1L;
        }
        return 0L;
    }

    @Ignore
    public static long getSign(long value) {
        if (value > 0L) {
            return 1L;
        }
        if (value < 0L) {
            return -1L;
        }
        return 0L;
    }

    @Override
    public Integer remainder(@Name(value="other") Integer other) {
        return Integer.instance(this.value % other.value);
    }

    @Ignore
    public static long remainder(long value, long otherValue) {
        return value % otherValue;
    }

    @Override
    public Integer modulo(@Name(value="modulus") Integer modulus) {
        return Integer.instance(Integer.modulo(this.value, modulus.value));
    }

    @Ignore
    public static long modulo(long value, long modulus) {
        if (modulus < 0L) {
            throw new AssertionError("modulus must be positive: " + modulus);
        }
        long ret = value % modulus;
        if (ret < 0L) {
            return ret + modulus;
        }
        return ret;
    }

    @Override
    public final boolean divides(@Name(value="other") Integer other) {
        return other.value % this.value == 0L;
    }

    @Ignore
    public static boolean divides(long value, long otherValue) {
        return otherValue % value == 0L;
    }

    @Override
    public Integer getNegated() {
        return Integer.instance(-this.value);
    }

    @Ignore
    public static long getNegated(long value) {
        return -value;
    }

    @Override
    public Comparison compare(@Name(value="other") Integer other) {
        long x = this.value;
        long y = other.value;
        return x < y ? smaller_.get_() : (x == y ? equal_.get_() : larger_.get_());
    }

    @Ignore
    public static Comparison compare(long value, long otherValue) {
        long x = value;
        long y = otherValue;
        return x < y ? smaller_.get_() : (x == y ? equal_.get_() : larger_.get_());
    }

    public String toString() {
        return Long.toString(this.value);
    }

    @Ignore
    public static String toString(long value) {
        return Long.toString(value);
    }

    @Ignore
    public static long neighbour(long value, long offset) {
        long neighbour = value + offset;
        if (((value ^ neighbour) & (offset ^ neighbour)) < 0L) {
            throw new OverflowException(value + " has no neighbour with offset " + offset);
        }
        return neighbour;
    }

    @Override
    public Integer neighbour(@Name(value="offset") long offset) {
        return Integer.instance(Integer.neighbour(this.value, offset));
    }

    @Ignore
    public static long offset(long value, long other) {
        long offset = value - other;
        if (((value ^ other) & (value ^ offset)) < 0L) {
            throw new OverflowException("offset from " + value + " to " + other + " cannot be represented as a 64 bit integer.");
        }
        return offset;
    }

    @Override
    public long offset(@Name(value="other") Integer other) {
        return Integer.offset(this.value, other.value);
    }

    @Ignore
    public static long offsetSign(long value, long other) {
        if (value > other) {
            return 1L;
        }
        if (value < other) {
            return -1L;
        }
        return 0L;
    }

    @Override
    public long offsetSign(@Name(value="other") Integer other) {
        return Integer.offsetSign(this.value, other.value);
    }

    public double getFloat() {
        return Integer.getFloat(this.value);
    }

    @Ignore
    public static double getFloat(long value) {
        if (value <= -9007199254740992L || 0x20000000000000L <= value) {
            throw new OverflowException(value + " cannot be coerced into a 64 bit floating point value");
        }
        return value;
    }

    public double getNearestFloat() {
        return this.value;
    }

    @Ignore
    public static double getNearestFloat(long value) {
        return value;
    }

    public byte getByte() {
        return Integer.getByte(this.value);
    }

    @Ignore
    public static byte getByte(long value) {
        return (byte)value;
    }

    @TypeInfo(value="ceylon.language::Character")
    public int getCharacter() {
        return Integer.getCharacter(this.value);
    }

    @Ignore
    @TypeInfo(value="ceylon.language::Character")
    public static int getCharacter(long value) {
        return Character.codepoint(value);
    }

    @Transient
    public boolean getEven() {
        return (this.value & 1L) == 0L;
    }

    @Ignore
    public static boolean getEven(long value) {
        return (value & 1L) == 0L;
    }

    @Override
    public boolean getUnit() {
        return this.value == 1L;
    }

    @Ignore
    public static boolean getUnit(long value) {
        return value == 1L;
    }

    @Override
    public boolean getZero() {
        return this.value == 0L;
    }

    @Ignore
    public static boolean getZero(long value) {
        return value == 0L;
    }

    @Override
    public Integer getPredecessor() {
        return Integer.instance(this.value - 1L);
    }

    @Ignore
    public static long getPredecessor(long value) {
        return value - 1L;
    }

    @Override
    public Integer getSuccessor() {
        return Integer.instance(this.value + 1L);
    }

    @Ignore
    public static long getSuccessor(long value) {
        return value + 1L;
    }

    public boolean equals(@Name(value="that") Object that) {
        return Integer.equals(this.value, that);
    }

    @Ignore
    public static boolean equals(long value, Object that) {
        if (that instanceof Integer) {
            return value == ((Integer)that).value;
        }
        if (that instanceof Float) {
            return (double)value == ((Float)that).value && value > -9007199254740992L && value < 0x20000000000000L;
        }
        return false;
    }

    @Transient
    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Ignore
    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    @Override
    public Integer getNot() {
        return Integer.instance(this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Ignore
    public static long getNot(long value) {
        return value ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public Integer leftLogicalShift(@Name(value="shift") long shift) {
        return Integer.instance(this.value << (int)shift);
    }

    @Ignore
    public static long leftLogicalShift(long value, long shift) {
        return value << (int)shift;
    }

    @Override
    public Integer rightLogicalShift(@Name(value="shift") long shift) {
        return Integer.instance(this.value >>> (int)shift);
    }

    @Ignore
    public static long rightLogicalShift(long value, long shift) {
        return value >>> (int)shift;
    }

    @Override
    public Integer rightArithmeticShift(@Name(value="shift") long shift) {
        return Integer.instance(this.value >> (int)shift);
    }

    @Ignore
    public static long rightArithmeticShift(long value, long shift) {
        return value >> (int)shift;
    }

    @Override
    public Integer and(@Name(value="other") Integer other) {
        return Integer.instance(this.value & other.value);
    }

    @Ignore
    public static long and(long value, long other) {
        return value & other;
    }

    @Override
    public Integer or(@Name(value="other") Integer other) {
        return Integer.instance(this.value | other.value);
    }

    @Ignore
    public static long or(long value, long other) {
        return value | other;
    }

    @Override
    public Integer xor(@Name(value="other") Integer other) {
        return Integer.instance(this.value ^ other.value);
    }

    @Ignore
    public static long xor(long value, long other) {
        return value ^ other;
    }

    @Override
    public boolean get(@Name(value="index") long index) {
        return Integer.get(this.value, index);
    }

    @Ignore
    public static boolean get(long value, long index) {
        if (index < 0L || index > 63L) {
            return false;
        }
        long mask = 1L << (int)index;
        return (value & mask) != 0L;
    }

    @Override
    @Ignore
    public Integer set(long index) {
        return Integer.instance(Integer.set(this.value, index));
    }

    @Override
    public Integer set(@Name(value="index") long index, @Name(value="bit") @Defaulted boolean bit) {
        return Integer.instance(Integer.set(this.value, index, bit));
    }

    @Override
    @Ignore
    public boolean set$bit(long index) {
        return true;
    }

    @Ignore
    public static long set(long value, long index) {
        return Integer.set(value, index, true);
    }

    @Ignore
    public static long set(long value, long index, boolean bit) {
        if (index < 0L || index > 63L) {
            return value;
        }
        long mask = 1L << (int)index;
        return bit ? value | mask : value & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public Integer clear(@Name(value="index") long index) {
        return Integer.instance(Integer.clear(this.value, index));
    }

    @Ignore
    public static long clear(long value, long index) {
        if (index < 0L || index > 63L) {
            return value;
        }
        long mask = 1L << (int)index;
        return value & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public Integer flip(@Name(value="index") long index) {
        return Integer.instance(Integer.flip(this.value, index));
    }

    @Ignore
    public static long flip(long value, long index) {
        if (index < 0L || index > 63L) {
            return value;
        }
        long mask = 1L << (int)index;
        return value ^ mask;
    }

    @Override
    @Ignore
    public TypeDescriptor $getType$() {
        return $TypeDescriptor$;
    }

    public static boolean largerThan(long value, Integer other) {
        return value > other.value;
    }

    public static boolean largerThan(long value, long other) {
        return value > other;
    }

    @Override
    public boolean largerThan(@Name(value="other") Integer other) {
        return this.value > other.value;
    }

    public static boolean notSmallerThan(long value, Integer other) {
        return value >= other.value;
    }

    public static boolean notSmallerThan(long value, long other) {
        return value >= other;
    }

    @Override
    public boolean notSmallerThan(@Name(value="other") Integer other) {
        return this.value >= other.value;
    }

    public static boolean smallerThan(long value, Integer other) {
        return value < other.value;
    }

    public static boolean smallerThan(long value, long other) {
        return value < other;
    }

    @Override
    public boolean smallerThan(@Name(value="other") Integer other) {
        return this.value < other.value;
    }

    public static boolean notLargerThan(long value, Integer other) {
        return value <= other.value;
    }

    public static boolean notLargerThan(long value, long other) {
        return value <= other;
    }

    @Override
    public boolean notLargerThan(@Name(value="other") Integer other) {
        return this.value <= other.value;
    }

    @Override
    public Integer timesInteger(@Name(value="integer") long integer) {
        return Integer.instance(this.value * integer);
    }

    public static long timesInteger(long value, long integer) {
        return value * integer;
    }

    @Override
    public Integer plusInteger(@Name(value="integer") long integer) {
        return Integer.instance(this.value + integer);
    }

    public static long plusInteger(long value, long integer) {
        return value + integer;
    }

    @Override
    public Integer powerOfInteger(@Name(value="integer") long integer) {
        return Integer.instance(Integer.power(this.value, integer));
    }

    public static long powerOfInteger(long value, long integer) {
        return Integer.power(value, integer);
    }
}

