/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Category;
import ceylon.language.Comparison;
import ceylon.language.DefaultAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Entry;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.Integer;
import ceylon.language.Iterable$impl;
import ceylon.language.Iterator;
import ceylon.language.Map;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.Sequence;
import ceylon.language.Sequential;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.TagsAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotations$;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.FunctionalParameter;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.LocalDeclarations;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

@Ceylon(major=8)
@DocAnnotation$annotation$(description="Abstract supertype of [[categories|Category]] whose\nelements may be iterated. Iterable categories are often\ncalled _streams_. A stream need not be finite, but its\nelements must be countable. That is, for any given\nelement of the stream, every iterator of the stream must\neventually return the element, even if the iterator\nitself is not exhaustible.\n\nA stream may have null elements. That is, an iterator for\nthe stream may produce the value [[null]] one or more\ntimes. For every non-null `element` of a given stream\n`it`, the expression `element in it` must evaluate to\n`true`. Thus, a stream is a `Category` of its non-null\nelements.\n\nA given stream might not have a well-defined order, and\nso the order in which elements are produced by the\nstream's iterator may not be _stable_. That is, the order\nmay be different for two different iterators of the\nstream. However, a stream has a well-defined set of\nelements, and any two iterators for an immutable finite\nstream should eventually return the same elements.\nFurthermore, any two iterators for an immutable finite\nstream should eventually return exactly the same number\nof elements, which must be the [[size]] of the stream.\n\nA given stream may not be _finite_, in which case an\niterator for the stream is never exhaustible, and certain\noperations of this interface either never terminate or\nresult in an [[AssertionError]]. It may not, in general,\nbe possible to even determine if an `Iterable` is finite.\n\nThe type `Iterable<Element,Null>`, usually abbreviated\n`{Element*}`, represents a possibly-empty iterable\ncontainer. The type `Iterable<Element,Nothing>`, usually\nabbreviated `{Element+}`, represents a nonempty iterable\ncontainer.\n\nA value list in braces produces a new instance of \n`Iterable`:\n\n    {String+} words = { \"hello\", \"world\" };\n\nAn instance of `Iterable` may be iterated using a `for`\nloop:\n\n    for (c in \"hello world\") { ... }\n\nComprehensions provide a convenient syntax for \ntransforming streams:\n\n    {Integer+} lengths = { for (w in words) w.size };\n\nThe `*.` operator may be used to evaluate an attribute\nor invoke a method of the elements of the stream,\nproducing a new stream:\n\n    {Integer+} lengths = words*.size;\n\n`Iterable` and its subtypes define various operations\nthat return other iterable objects. Such operations come \nin two flavors:\n\n- _Lazy_ operations return a *view* of the receiving\n  iterable object. If the underlying iterable object is\n  mutable, then changes to the underlying object will be \n  reflected in the resulting view. Lazy operations are \n  usually efficient, avoiding memory allocation or\n  iteration of the receiving iterable object.\n- _Eager_ operations return an immutable object. If the\n  receiving iterable object is mutable, changes to this\n  object will not be reflected in the resulting immutable\n  object. Eager operations are often expensive, involving\n  memory allocation and iteration of the receiving \n  iterable object.\n\nLazy operations are generally preferred, because they can \nbe efficiently chained. For example:\n\n    string.filter((c) => c.letter||c.digit)\n          .map(Character.uppercased)\n\nis much less expensive than:\n\n    string.select((c) => c.letter||c.digit)\n          .collect(Character.uppercased)\n\nFurthermore, it is always easy to produce a new \nimmutable iterable object given the view produced by a\nlazy operation. For example:\n\n    [ *string.filter((c) => c.letter||c.digit)\n             .map(Character.uppercased) ]\n\nHowever, there are certain scenarios where an eager \noperation is more useful, more convenient, or no more \nexpensive than a lazy operation, including:\n\n- sorting operations, for example [[sort]], which are \n  eager by nature,\n- operations which result in a subset or subrange of the \n  receiving stream, where structural sharing would or\n  could result in unnecessary memory retention.\n\nCertain operations come in both lazy and eager flavors,\nfor example:\n\n- [[map]] vs [[collect]],\n- [[filter]] vs [[select]],\n- [[List.sublist]] vs [[List.measure]].\n\nLazy operations normally return an instance of `Iterable`, \nor even a [[List]], [[Map]], or [[Set]]. Eager operations \nusually return a [[sequence|Sequential]]. The method\n[[sequence]] materializes the current elements of a\nstream into a sequence.\n\nThere is no meaningful generic definition of equality for \nstreams. For some streams&mdash;for example, \n`List`s&mdash;order is significant; for others&mdash;for \nexample, `Set`s&mdash;order is not significant. Therefore, \nunlike [[Collection]], `Iterable` does not define or \nrequire any form of [[value equality|Object.equals]], and \nsome streams do not support value equality. It follows \nthat the `==` operator should not be used to compare \ngeneric streams, unless the streams are known to share\nsome additional structure.\n\nTo compare two streams, taking order into account, use\nthe function [[corresponding]].\n\n    {Float*} xs = ... ;\n    {Float*} ys = ... ;\n    Boolean same = corresponding(xs, ys);")
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::ICollection", "::1.2.2:ceylon.language::Fcorresponding"})})
@AuthorsAnnotation$annotation$(authors={"Gavin"})
@TagsAnnotation$annotation$(tags={"Streams"})
@SharedAnnotation$annotation$
@LocalDeclarations(value={"1anonymous_10_", "1anonymous_12_", "1anonymous_14_", "1anonymous_16_", "1anonymous_17_", "1anonymous_20_", "1anonymous_22_", "1anonymous_24_", "1anonymous_26_", "1anonymous_27_", "1anonymous_29_", "1anonymous_2_", "1anonymous_31_", "1anonymous_36_", "1anonymous_6_", "1anonymous_9_", "7$1anonymous_4_"})
@Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"Abstract supertype of [[categories|Category]] whose\nelements may be iterated. Iterable categories are often\ncalled _streams_. A stream need not be finite, but its\nelements must be countable. That is, for any given\nelement of the stream, every iterator of the stream must\neventually return the element, even if the iterator\nitself is not exhaustible.\n\nA stream may have null elements. That is, an iterator for\nthe stream may produce the value [[null]] one or more\ntimes. For every non-null `element` of a given stream\n`it`, the expression `element in it` must evaluate to\n`true`. Thus, a stream is a `Category` of its non-null\nelements.\n\nA given stream might not have a well-defined order, and\nso the order in which elements are produced by the\nstream's iterator may not be _stable_. That is, the order\nmay be different for two different iterators of the\nstream. However, a stream has a well-defined set of\nelements, and any two iterators for an immutable finite\nstream should eventually return the same elements.\nFurthermore, any two iterators for an immutable finite\nstream should eventually return exactly the same number\nof elements, which must be the [[size]] of the stream.\n\nA given stream may not be _finite_, in which case an\niterator for the stream is never exhaustible, and certain\noperations of this interface either never terminate or\nresult in an [[AssertionError]]. It may not, in general,\nbe possible to even determine if an `Iterable` is finite.\n\nThe type `Iterable<Element,Null>`, usually abbreviated\n`{Element*}`, represents a possibly-empty iterable\ncontainer. The type `Iterable<Element,Nothing>`, usually\nabbreviated `{Element+}`, represents a nonempty iterable\ncontainer.\n\nA value list in braces produces a new instance of \n`Iterable`:\n\n    {String+} words = { \"hello\", \"world\" };\n\nAn instance of `Iterable` may be iterated using a `for`\nloop:\n\n    for (c in \"hello world\") { ... }\n\nComprehensions provide a convenient syntax for \ntransforming streams:\n\n    {Integer+} lengths = { for (w in words) w.size };\n\nThe `*.` operator may be used to evaluate an attribute\nor invoke a method of the elements of the stream,\nproducing a new stream:\n\n    {Integer+} lengths = words*.size;\n\n`Iterable` and its subtypes define various operations\nthat return other iterable objects. Such operations come \nin two flavors:\n\n- _Lazy_ operations return a *view* of the receiving\n  iterable object. If the underlying iterable object is\n  mutable, then changes to the underlying object will be \n  reflected in the resulting view. Lazy operations are \n  usually efficient, avoiding memory allocation or\n  iteration of the receiving iterable object.\n- _Eager_ operations return an immutable object. If the\n  receiving iterable object is mutable, changes to this\n  object will not be reflected in the resulting immutable\n  object. Eager operations are often expensive, involving\n  memory allocation and iteration of the receiving \n  iterable object.\n\nLazy operations are generally preferred, because they can \nbe efficiently chained. For example:\n\n    string.filter((c) => c.letter||c.digit)\n          .map(Character.uppercased)\n\nis much less expensive than:\n\n    string.select((c) => c.letter||c.digit)\n          .collect(Character.uppercased)\n\nFurthermore, it is always easy to produce a new \nimmutable iterable object given the view produced by a\nlazy operation. For example:\n\n    [ *string.filter((c) => c.letter||c.digit)\n             .map(Character.uppercased) ]\n\nHowever, there are certain scenarios where an eager \noperation is more useful, more convenient, or no more \nexpensive than a lazy operation, including:\n\n- sorting operations, for example [[sort]], which are \n  eager by nature,\n- operations which result in a subset or subrange of the \n  receiving stream, where structural sharing would or\n  could result in unnecessary memory retention.\n\nCertain operations come in both lazy and eager flavors,\nfor example:\n\n- [[map]] vs [[collect]],\n- [[filter]] vs [[select]],\n- [[List.sublist]] vs [[List.measure]].\n\nLazy operations normally return an instance of `Iterable`, \nor even a [[List]], [[Map]], or [[Set]]. Eager operations \nusually return a [[sequence|Sequential]]. The method\n[[sequence]] materializes the current elements of a\nstream into a sequence.\n\nThere is no meaningful generic definition of equality for \nstreams. For some streams&mdash;for example, \n`List`s&mdash;order is significant; for others&mdash;for \nexample, `Set`s&mdash;order is not significant. Therefore, \nunlike [[Collection]], `Iterable` does not define or \nrequire any form of [[value equality|Object.equals]], and \nsome streams do not support value equality. It follows \nthat the `==` operator should not be used to compare \ngeneric streams, unless the streams are known to share\nsome additional structure.\n\nTo compare two streams, taking order into account, use\nthe function [[corresponding]].\n\n    {Float*} xs = ... ;\n    {Float*} ys = ... ;\n    Boolean same = corresponding(xs, ys);"}), @Annotation(value="see", arguments={"Collection", "corresponding"}), @Annotation(value="by", arguments={"Gavin"}), @Annotation(value="tagged", arguments={"Streams"})})
@SatisfiedTypes(value={"ceylon.language::Category<ceylon.language::Object>"})
@TypeParameters(value={@TypeParameter(value="Element", variance=Variance.OUT, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Anything"), @TypeParameter(value="Absent", variance=Variance.OUT, satisfies={"ceylon.language::Null"}, caseTypes={}, defaultValue="ceylon.language::Null")})
public interface Iterable<Element, Absent>
extends Category<Object> {
    @Ignore
    public Iterable$impl<? extends Element, ? extends Absent> $ceylon$language$Iterable$impl();

    @DocAnnotation$annotation$(description="An iterator for the elements belonging to this stream.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"An iterator for the elements belonging to this stream."})})
    @TypeInfo(value="ceylon.language::Iterator<Element>")
    public Iterator<? extends Element> iterator();

    @Override
    @DocAnnotation$annotation$(description="Returns `true` if the iterator for this stream produces\nthe given element, or `false` otherwise. In the case of \nan infinite stream, this operation might never terminate;\nfurthermore, this default implementation iterates all\nthe elements until found (or not), which might be very\nexpensive.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Returns `true` if the iterator for this stream produces\nthe given element, or `false` otherwise. In the case of \nan infinite stream, this operation might never terminate;\nfurthermore, this default implementation iterates all\nthe elements until found (or not), which might be very\nexpensive."})})
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean contains(@Name(value="element") @TypeInfo(value="ceylon.language::Object") Object var1);

    @DocAnnotation$annotation$(description="Determines if the stream is empty, that is to say, if \nthe iterator returns no elements.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Determines if the stream is empty, that is to say, if \nthe iterator returns no elements."})})
    @TypeInfo(value="ceylon.language::Boolean")
    @Transient
    public boolean getEmpty();

    @DocAnnotation$annotation$(description="The number of elements returned by the [[iterator]] of \nthis stream, if the iterator terminates. In the case of \nan infinite stream, this operation never terminates.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The number of elements returned by the [[iterator]] of \nthis stream, if the iterator terminates. In the case of \nan infinite stream, this operation never terminates."})})
    @TypeInfo(value="ceylon.language::Integer")
    @Transient
    public long getSize();

    @DocAnnotation$annotation$(description="Determines if this stream has more elements than the \ngiven [[length]]. This is an efficient operation for\nstreams with many elements.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Vsize"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Determines if this stream has more elements than the \ngiven [[length]]. This is an efficient operation for\nstreams with many elements."}), @Annotation(value="see", arguments={"size"})})
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean longerThan(@Name(value="length") @TypeInfo(value="ceylon.language::Integer") long var1);

    @DocAnnotation$annotation$(description="Determines if this stream has fewer elements than the \ngiven [[length]]. This is an efficient operation for \nstreams with many elements.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Vsize"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Determines if this stream has fewer elements than the \ngiven [[length]]. This is an efficient operation for \nstreams with many elements."}), @Annotation(value="see", arguments={"size"})})
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean shorterThan(@Name(value="length") @TypeInfo(value="ceylon.language::Integer") long var1);

    @DocAnnotation$annotation$(description="The first element returned by the iterator, if any, or \n`null` if this stream is empty. For a stream with an\nunstable iteration order, a different value might be\nproduced each time `first` is evaluated.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The first element returned by the iterator, if any, or \n`null` if this stream is empty. For a stream with an\nunstable iteration order, a different value might be\nproduced each time `first` is evaluated."})})
    @TypeInfo(value="Absent|Element", erased=true)
    @Transient
    public Object getFirst();

    @DocAnnotation$annotation$(description="The last element returned by the iterator, if any, or \n`null` if this stream is empty. In the case of an \ninfinite stream, this operation never terminates;\nfurthermore, this default implementation iterates all \nelements, which might be very expensive.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The last element returned by the iterator, if any, or \n`null` if this stream is empty. In the case of an \ninfinite stream, this operation never terminates;\nfurthermore, this default implementation iterates all \nelements, which might be very expensive."})})
    @TypeInfo(value="Absent|Element", erased=true)
    @Transient
    public Object getLast();

    @DocAnnotation$annotation$(description="The [[index]]th element returned by an iterator of this \nstream, or `null` if there are fewer than `index+1`\nelements in the stream. For a stream with an unstable \niteration order, a different value might be produced \neach time `getFromFirst(index)` is called for a given\ninteger `index`.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The [[index]]th element returned by an iterator of this \nstream, or `null` if there are fewer than `index+1`\nelements in the stream. For a stream with an unstable \niteration order, a different value might be produced \neach time `getFromFirst(index)` is called for a given\ninteger `index`."})})
    @TypeInfo(value="Element?")
    public Element getFromFirst(@Name(value="index") @TypeInfo(value="ceylon.language::Integer") long var1);

    @DocAnnotation$annotation$(description="A [[sequence|Sequential]] containing all the elements \nof this stream, in the same order they occur in this\nstream. This operation eagerly evaluates and collects \nevery element of the stream.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"A [[sequence|Sequential]] containing all the elements \nof this stream, in the same order they occur in this\nstream. This operation eagerly evaluates and collects \nevery element of the stream."})})
    @TypeInfo(value="Element[]")
    public Sequential<? extends Element> sequence();

    @DocAnnotation$annotation$(description="A [[Range]] containing all indexes of this stream, or \n`[]` if this list is empty. The resulting range is\nequal to `0:size`.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"A [[Range]] containing all indexes of this stream, or \n`[]` if this list is empty. The resulting range is\nequal to `0:size`."})})
    @TypeInfo(value="ceylon.language::Range<ceylon.language::Integer>|[]", erased=true)
    public Object indexes();

    @DocAnnotation$annotation$(description="A stream containing all but the first element of this \nstream. For a stream with an unstable iteration order, \na different stream might be produced each time `rest` \nis evaluated.\n\nTherefore, if the stream `i` has an unstable iteration\norder, the stream `{ i.first, *i.rest }` might not have\nthe same elements as `i`.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Vfirst"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"A stream containing all but the first element of this \nstream. For a stream with an unstable iteration order, \na different stream might be produced each time `rest` \nis evaluated.\n\nTherefore, if the stream `i` has an unstable iteration\norder, the stream `{ i.first, *i.rest }` might not have\nthe same elements as `i`."}), @Annotation(value="see", arguments={"first"})})
    @TypeInfo(value="{Element*}")
    @Transient
    public Iterable<? extends Element, ? extends Object> getRest();

    @DocAnnotation$annotation$(description="A stream containing all but the last element of this \nstream. For a stream with an unstable iteration order, \na different stream might be produced each time \n`exceptLast` is evaluated.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"A stream containing all but the last element of this \nstream. For a stream with an unstable iteration order, \na different stream might be produced each time \n`exceptLast` is evaluated."})})
    @TypeInfo(value="{Element*}")
    @Transient
    public Iterable<? extends Element, ? extends Object> getExceptLast();

    @DocAnnotation$annotation$(description="Call the given [[function|step]] for each element of \nthis stream, passing the elements in the order they \noccur in this stream.\n\nFor example:\n\n    words.each((word) {\n        print(word.lowercased);\n        print(word.uppercased);\n    });\n\nHas the same effect as the following `for` loop:\n\n    for (word in words) {\n        print(word.lowercased);\n        print(word.uppercased);\n    }\n\n_For certain streams this method is highly efficient,\nsurpassing the performance of `for` loops on the JVM.\nThus, `each()` is sometimes preferred in highly \nperformance-critical low-level code._")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Call the given [[function|step]] for each element of \nthis stream, passing the elements in the order they \noccur in this stream.\n\nFor example:\n\n    words.each((word) {\n        print(word.lowercased);\n        print(word.uppercased);\n    });\n\nHas the same effect as the following `for` loop:\n\n    for (word in words) {\n        print(word.lowercased);\n        print(word.uppercased);\n    }\n\n_For certain streams this method is highly efficient,\nsurpassing the performance of `for` loops on the JVM.\nThus, `each()` is sometimes preferred in highly \nperformance-critical low-level code._"})})
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    public Object each(@Name(value="step") @FunctionalParameter(value="!(element)") @TypeInfo(value="ceylon.language::Anything(Element)") @Annotations(value={@Annotation(value="doc", arguments={"The function to be called for each element in the\nstream."})}) Callable<? extends Object> var1);

    @DocAnnotation$annotation$(description="Produces a stream containing the results of applying \nthe given [[mapping|collecting]] to the elements of \nthis stream.\n\nFor any empty stream, `map()` returns an empty stream:\n\n    {}.map(f) == {}\n\nFor any nonempty stream `it`, and mapping function `f`,\nthe result of `map()` may be obtained according to this\nrecursive definition:\n\n    it.map(f).first == f(it.first)\n    it.map(f).rest == it.rest.map(f)\n\nAlternatively, and in practice, `map()` may be defined \nby this comprehension:\n\n    it.map(f) == { for (e in it) f(e) }\n\nFor example, the expression\n\n    (0..4).map(10.power)\n\nresults in the stream `{ 1, 10, 100, 1000, 10000 }`.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Fcollect"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Produces a stream containing the results of applying \nthe given [[mapping|collecting]] to the elements of \nthis stream.\n\nFor any empty stream, `map()` returns an empty stream:\n\n    {}.map(f) == {}\n\nFor any nonempty stream `it`, and mapping function `f`,\nthe result of `map()` may be obtained according to this\nrecursive definition:\n\n    it.map(f).first == f(it.first)\n    it.map(f).rest == it.rest.map(f)\n\nAlternatively, and in practice, `map()` may be defined \nby this comprehension:\n\n    it.map(f) == { for (e in it) f(e) }\n\nFor example, the expression\n\n    (0..4).map(10.power)\n\nresults in the stream `{ 1, 10, 100, 1000, 10000 }`."}), @Annotation(value="see", arguments={"collect"})})
    @TypeInfo(value="ceylon.language::Iterable<Result,Absent>")
    @TypeParameters(value={@TypeParameter(value="Result", variance=Variance.NONE, satisfies={}, caseTypes={})})
    public <Result> Iterable<? extends Result, ? extends Absent> map(@Ignore TypeDescriptor var1, @Name(value="collecting") @FunctionalParameter(value="(element)") @TypeInfo(value="Result(Element)") @Annotations(value={@Annotation(value="doc", arguments={"The mapping to apply to the elements."})}) Callable<? extends Result> var2);

    @DocAnnotation$annotation$(description="Given a [[mapping function|collecting]] that accepts an \n[[Element]] and returns a stream of [[Result]]s, \nproduces a new stream containing all elements of every \n`Result` stream that results from applying the function \nto the elements of this stream.\n\nFor example, the expression\n\n    { \"Hello\", \"World\" }.flatMap(String.lowercased)\n\nresults in this stream:\n\n    { 'h', 'e', 'l', 'l', 'o', 'w', 'o', 'r,' 'l', 'd' }\n\nThe expression\n    \n    { \"hello\"->\"hola\", \"world\"->\"mundo\" }\n            .flatMap(Entry<String,String>.pair)\n\nproduces this stream:\n\n    { \"hello\", \"hola\", \"world\", \"mundo\" }")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::Fexpand"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Given a [[mapping function|collecting]] that accepts an \n[[Element]] and returns a stream of [[Result]]s, \nproduces a new stream containing all elements of every \n`Result` stream that results from applying the function \nto the elements of this stream.\n\nFor example, the expression\n\n    { \"Hello\", \"World\" }.flatMap(String.lowercased)\n\nresults in this stream:\n\n    { 'h', 'e', 'l', 'l', 'o', 'w', 'o', 'r,' 'l', 'd' }\n\nThe expression\n    \n    { \"hello\"->\"hola\", \"world\"->\"mundo\" }\n            .flatMap(Entry<String,String>.pair)\n\nproduces this stream:\n\n    { \"hello\", \"hola\", \"world\", \"mundo\" }"}), @Annotation(value="see", arguments={"expand"})})
    @TypeInfo(value="ceylon.language::Iterable<Result,Absent|OtherAbsent>", erased=true)
    @TypeParameters(value={@TypeParameter(value="Result", variance=Variance.NONE, satisfies={}, caseTypes={}), @TypeParameter(value="OtherAbsent", variance=Variance.NONE, satisfies={"ceylon.language::Null"}, caseTypes={})})
    public <Result, OtherAbsent> Iterable flatMap(@Ignore TypeDescriptor var1, @Ignore TypeDescriptor var2, @Name(value="collecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Iterable<Result,OtherAbsent>(Element)") @Annotations(value={@Annotation(value="doc", arguments={"The mapping function to apply to the elements of \nthis stream, that produces a new stream of \n[[Result]]s."})}) Callable<? extends Iterable<? extends Result, ? extends OtherAbsent>> var3);

    @DocAnnotation$annotation$(description="Produces a stream containing the elements of this \nstream that satisfy the given [[predicate \nfunction|selecting]].\n\nFor any empty stream, `filter()` returns an empty \nstream:\n\n    {}.filter(p) == {}\n\nFor any nonempty stream `it`, and predicate `p`, the \nresult of `filter()` may be obtained according to this\nrecursive definition:\n\n    it.filter(p) == { if (p(it.first)) it.first }.chain(it.rest.filter(f))\n\nAlternatively, and in practice, `filter()` may be \ndefined by this comprehension:\n\n    it.filter(p) == { for (e in it) if (p(e)) e };\n\nFor example, the expression\n\n    (1..100).filter(13.divides)\n\nresults in the stream `{ 13, 26, 39, 52, 65, 78, 91 }`.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Fselect"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Produces a stream containing the elements of this \nstream that satisfy the given [[predicate \nfunction|selecting]].\n\nFor any empty stream, `filter()` returns an empty \nstream:\n\n    {}.filter(p) == {}\n\nFor any nonempty stream `it`, and predicate `p`, the \nresult of `filter()` may be obtained according to this\nrecursive definition:\n\n    it.filter(p) == { if (p(it.first)) it.first }.chain(it.rest.filter(f))\n\nAlternatively, and in practice, `filter()` may be \ndefined by this comprehension:\n\n    it.filter(p) == { for (e in it) if (p(e)) e };\n\nFor example, the expression\n\n    (1..100).filter(13.divides)\n\nresults in the stream `{ 13, 26, 39, 52, 65, 78, 91 }`."}), @Annotation(value="see", arguments={"select"})})
    @TypeInfo(value="{Element*}")
    public Iterable<? extends Element, ? extends Object> filter(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") @Annotations(value={@Annotation(value="doc", arguments={"The predicate the elements must satisfy. The \nelements which satisfy the predicate are included\nin the resulting stream."})}) Callable<? extends Boolean> var1);

    @DocAnnotation$annotation$(description="Produces a stream containing the elements of this \nstream that are instances of the given [[type|Type]].\n\nFor example, the expression\n\n    { 1, 2, null, 3 }.narrow<Object>()\n\nresults in the stream `{ 1, 2, 3 }` of type `{Integer*}`.\n\nIf the type argument `Type` is not explicitly specified,\n[[Nothing]] is inferred, and the resulting stream is \nempty.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Produces a stream containing the elements of this \nstream that are instances of the given [[type|Type]].\n\nFor example, the expression\n\n    { 1, 2, null, 3 }.narrow<Object>()\n\nresults in the stream `{ 1, 2, 3 }` of type `{Integer*}`.\n\nIf the type argument `Type` is not explicitly specified,\n[[Nothing]] is inferred, and the resulting stream is \nempty."})})
    @TypeInfo(value="{Element&Type*}", erased=true)
    @TypeParameters(value={@TypeParameter(value="Type", variance=Variance.NONE, satisfies={}, caseTypes={})})
    public <Type> Iterable narrow(@Ignore TypeDescriptor var1);

    @DocAnnotation$annotation$(description="Beginning with a given [[initial value|initial]], apply \nthe given [[combining function|accumulating]] to each \nelement of this stream in turn, progressively \naccumulating a single result.\n\nFor an empty stream, `fold()` returns the given initial \nvalue `z`:\n\n    {}.fold(z)(f) == z\n\nFor a given nonempty stream `it`, initial value `z`, \nand combining function `f`, the result of `fold()` is \nobtained according to the following recursive \ndefinition:\n\n    it.fold(z)(f) == f(it.exceptLast.fold(z)(f), it.last)\n\nFor example, the expression\n\n    (1..100).fold(0)(plus)\n\nresults in the integer `5050`.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Freduce", "::1.2.2:ceylon.language::IIterable.Fscan"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @FunctionalParameter(value="(accumulating(partial,element))")
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Beginning with a given [[initial value|initial]], apply \nthe given [[combining function|accumulating]] to each \nelement of this stream in turn, progressively \naccumulating a single result.\n\nFor an empty stream, `fold()` returns the given initial \nvalue `z`:\n\n    {}.fold(z)(f) == z\n\nFor a given nonempty stream `it`, initial value `z`, \nand combining function `f`, the result of `fold()` is \nobtained according to the following recursive \ndefinition:\n\n    it.fold(z)(f) == f(it.exceptLast.fold(z)(f), it.last)\n\nFor example, the expression\n\n    (1..100).fold(0)(plus)\n\nresults in the integer `5050`."}), @Annotation(value="see", arguments={"reduce", "scan"})})
    @TypeInfo(value="Result(Result(Result, Element))")
    @TypeParameters(value={@TypeParameter(value="Result", variance=Variance.NONE, satisfies={}, caseTypes={})})
    public <Result> Callable<? extends Result> fold(@Ignore TypeDescriptor var1, @Name(value="initial") @TypeInfo(value="Result") Result var2);

    @DocAnnotation$annotation$(description="Beginning with the [[first]] element of this stream,\napply the given [[combining function|accumulating]] to \neach element of this stream in turn, progressively\naccumulating a single result.\n\nFor an empty stream, `reduce()` always returns `null`.\n\nFor a stream with one element, `reduce()` returns that\nelement:\n\n    { first }.reduce(f) == first\n\nFor a given stream `it` with more than one element, and \ncombining function `f`, the result of `reduce()` is \nobtained according to the following recursive \ndefinition:\n\n    it.reduce(f) == f(it.exceptLast.reduce(f), it.last)\n\nFor example, the expression\n\n    (1..100).reduce(plus)\n\nresults in the integer `5050`.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Ffold"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Beginning with the [[first]] element of this stream,\napply the given [[combining function|accumulating]] to \neach element of this stream in turn, progressively\naccumulating a single result.\n\nFor an empty stream, `reduce()` always returns `null`.\n\nFor a stream with one element, `reduce()` returns that\nelement:\n\n    { first }.reduce(f) == first\n\nFor a given stream `it` with more than one element, and \ncombining function `f`, the result of `reduce()` is \nobtained according to the following recursive \ndefinition:\n\n    it.reduce(f) == f(it.exceptLast.reduce(f), it.last)\n\nFor example, the expression\n\n    (1..100).reduce(plus)\n\nresults in the integer `5050`."}), @Annotation(value="see", arguments={"fold"})})
    @TypeInfo(value="Result|Element|Absent", erased=true)
    @TypeParameters(value={@TypeParameter(value="Result", variance=Variance.NONE, satisfies={}, caseTypes={})})
    public <Result> Object reduce(@Ignore TypeDescriptor var1, @Name(value="accumulating") @FunctionalParameter(value="(partial,element)") @TypeInfo(value="Result(Result|Element, Element)") @Annotations(value={@Annotation(value="doc", arguments={"The accumulating function that accepts an\n[[intermediate result|partial]], and the \n[[next element|element]]."})}) Callable<? extends Result> var2);

    @DocAnnotation$annotation$(description="The stream of intermediate results obtained by \nbeginning with a given [[initial value|initial]] and\niteratively applying the given \n[[combining function|accumulating]] to each element of \nthis stream in turn.\n\nFor an empty stream, `scan()` returns a stream \ncontaining just the given initial value `z`:\n\n    {}.scan(z)(f) == { z }\n\nFor a given nonempty stream `it`, initial value `z`, \nand combining function `f`, the result of `scan()` is \nobtained according to the following recursive \ndefinition:\n\n    it.scan(z)(f).last == f(it.exceptLast.scan(z)(f).last, it.last)\n    it.scan(z)(f).exceptLast == it.exceptLast.scan(z)(f)\n\nThe following identities explain the relationship \nbetween `scan` and [[fold]]:\n\n    it.scan(z)(f).getFromFirst(n) == it.take(n).fold(z)(f)\n    it.scan(z)(f).last == it.fold(z)(f)\n    it.scan(z)(f).first == {}.fold(z)(f) == z\n\nFor example, the expression\n\n    (1..4).scan(0)(plus)\n\nresults in the stream `{ 0, 1, 3, 6, 10 }`.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Ffold"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @FunctionalParameter(value="(accumulating(partial,element))")
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The stream of intermediate results obtained by \nbeginning with a given [[initial value|initial]] and\niteratively applying the given \n[[combining function|accumulating]] to each element of \nthis stream in turn.\n\nFor an empty stream, `scan()` returns a stream \ncontaining just the given initial value `z`:\n\n    {}.scan(z)(f) == { z }\n\nFor a given nonempty stream `it`, initial value `z`, \nand combining function `f`, the result of `scan()` is \nobtained according to the following recursive \ndefinition:\n\n    it.scan(z)(f).last == f(it.exceptLast.scan(z)(f).last, it.last)\n    it.scan(z)(f).exceptLast == it.exceptLast.scan(z)(f)\n\nThe following identities explain the relationship \nbetween `scan` and [[fold]]:\n\n    it.scan(z)(f).getFromFirst(n) == it.take(n).fold(z)(f)\n    it.scan(z)(f).last == it.fold(z)(f)\n    it.scan(z)(f).first == {}.fold(z)(f) == z\n\nFor example, the expression\n\n    (1..4).scan(0)(plus)\n\nresults in the stream `{ 0, 1, 3, 6, 10 }`."}), @Annotation(value="see", arguments={"fold"})})
    @TypeInfo(value="{Result+}(Result(Result, Element))")
    @TypeParameters(value={@TypeParameter(value="Result", variance=Variance.NONE, satisfies={}, caseTypes={})})
    public <Result> Callable<? extends Iterable<? extends Result, ? extends Object>> scan(@Ignore TypeDescriptor var1, @Name(value="initial") @TypeInfo(value="Result") Result var2);

    @DocAnnotation$annotation$(description="The first element of this stream which satisfies the \n[[given predicate function|selecting]], if any, or \n`null` if there is no such element. For an infinite \nstream, this method might not terminate.\n\nFor example, the expression\n\n    (-10..10).find(Integer.positive)\n\nevaluates to `1`.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.FfindLast", "::1.2.2:ceylon.language::IIterable.Flocate"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The first element of this stream which satisfies the \n[[given predicate function|selecting]], if any, or \n`null` if there is no such element. For an infinite \nstream, this method might not terminate.\n\nFor example, the expression\n\n    (-10..10).find(Integer.positive)\n\nevaluates to `1`."}), @Annotation(value="see", arguments={"findLast", "locate"})})
    @TypeInfo(value="Element?")
    public Element find(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @Annotations(value={@Annotation(value="doc", arguments={"The predicate the element must satisfy."})}) Callable<? extends Boolean> var1);

    @DocAnnotation$annotation$(description="The last element of this stream which satisfies the \n[[given predicate function|selecting]], if any, or \n`null` if there is no such element. For an infinite \nstream, this method will not terminate.\n\nFor example, the expression\n\n    (-10..10).findLast(3.divides)\n\nevaluates to `9`.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Ffind", "::1.2.2:ceylon.language::IIterable.FlocateLast"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The last element of this stream which satisfies the \n[[given predicate function|selecting]], if any, or \n`null` if there is no such element. For an infinite \nstream, this method will not terminate.\n\nFor example, the expression\n\n    (-10..10).findLast(3.divides)\n\nevaluates to `9`."}), @Annotation(value="see", arguments={"find", "locateLast"})})
    @TypeInfo(value="Element?")
    public Element findLast(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @Annotations(value={@Annotation(value="doc", arguments={"The predicate the element must satisfy."})}) Callable<? extends Boolean> var1);

    @DocAnnotation$annotation$(description="The first element of this stream which satisfies the \n[[given predicate function|selecting]], if any, \ntogether with its position in the stream, or `null` if \nthere is no such element. For an infinite stream, this \nmethod might not terminate.\n\nFor example, the expression\n\n    (-10..10).locate(Integer.positive)\n\nevaluates to `11->1`.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.FlocateLast", "::1.2.2:ceylon.language::IIterable.Flocations", "::1.2.2:ceylon.language::IIterable.Ffind", "::1.2.2:ceylon.language::IList.FfirstIndexWhere"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The first element of this stream which satisfies the \n[[given predicate function|selecting]], if any, \ntogether with its position in the stream, or `null` if \nthere is no such element. For an infinite stream, this \nmethod might not terminate.\n\nFor example, the expression\n\n    (-10..10).locate(Integer.positive)\n\nevaluates to `11->1`."}), @Annotation(value="see", arguments={"locateLast", "locations", "find", "List.firstIndexWhere"})})
    @TypeInfo(value="<ceylon.language::Integer->Element&ceylon.language::Object>?")
    public Entry<? extends Integer, ? extends Element> locate(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @Annotations(value={@Annotation(value="doc", arguments={"The predicate the element must satisfy."})}) Callable<? extends Boolean> var1);

    @DocAnnotation$annotation$(description="The last element of this stream which satisfies the \n[[given predicate function|selecting]], if any, \ntogether with its position in the stream, or `null` if \nthere is no such element. For an infinite stream, this \nmethod might not terminate.\n\nFor example, the expression\n\n    (-10..10).locateLast(3.divides)\n\nevaluates to `19->9`.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Flocate", "::1.2.2:ceylon.language::IIterable.Flocations", "::1.2.2:ceylon.language::IIterable.FfindLast", "::1.2.2:ceylon.language::IList.FlastIndexWhere"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The last element of this stream which satisfies the \n[[given predicate function|selecting]], if any, \ntogether with its position in the stream, or `null` if \nthere is no such element. For an infinite stream, this \nmethod might not terminate.\n\nFor example, the expression\n\n    (-10..10).locateLast(3.divides)\n\nevaluates to `19->9`."}), @Annotation(value="see", arguments={"locate", "locations", "findLast", "List.lastIndexWhere"})})
    @TypeInfo(value="<ceylon.language::Integer->Element&ceylon.language::Object>?")
    public Entry<? extends Integer, ? extends Element> locateLast(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @Annotations(value={@Annotation(value="doc", arguments={"The predicate the element must satisfy."})}) Callable<? extends Boolean> var1);

    @DocAnnotation$annotation$(description="A stream producing all elements of this stream which\nsatisfy the [[given predicate function|selecting]],\ntogether with their positions in the stream.\n\nFor example, the expression\n\n    (-5..5).locations(3.divides)\n\nevaluates to the stream `{ 2->-3, 5->0, 8->3 }`.\n\nNote that this method is more efficient than the\nalternative of applying [[filter]] to an [[indexed]]\nstream.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Flocate", "::1.2.2:ceylon.language::IIterable.FlocateLast", "::1.2.2:ceylon.language::IList.FindexesWhere"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"A stream producing all elements of this stream which\nsatisfy the [[given predicate function|selecting]],\ntogether with their positions in the stream.\n\nFor example, the expression\n\n    (-5..5).locations(3.divides)\n\nevaluates to the stream `{ 2->-3, 5->0, 8->3 }`.\n\nNote that this method is more efficient than the\nalternative of applying [[filter]] to an [[indexed]]\nstream."}), @Annotation(value="see", arguments={"locate", "locateLast", "List.indexesWhere"})})
    @TypeInfo(value="{<ceylon.language::Integer->Element&ceylon.language::Object>*}")
    public Iterable<? extends Entry<? extends Integer, ? extends Element>, ? extends Object> locations(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @Annotations(value={@Annotation(value="doc", arguments={"The predicate the element must satisfy."})}) Callable<? extends Boolean> var1);

    @DocAnnotation$annotation$(description="Return the largest value in the stream, as measured by\nthe given [[comparator function|comparing]] imposing a \npartial order upon the elements of the stream, or `null`\nif this stream is empty.\n\nFor example, the expression\n\n    {-10.0, -1.0, 5.0}.max(byIncreasing(Float.magnitude))\n\nevaluates to `-10`.\n\nFor any nonempty stream `it`, and comparator function \n`c`, `it.max(c)` evaluates to the first element of `it` \nsuch that for every element `e` of `it`, \n`c(e, it.max(c)) != larger`.\n\nNote that the toplevel functions [[ceylon.language::max]]\nand [[ceylon.language::min]] may be used to find the  \nlargest and smallest values in a stream of [[Comparable]] \nvalues, according to the natural order of its elements.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::Fmax", "::1.2.2:ceylon.language::Fmin"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Return the largest value in the stream, as measured by\nthe given [[comparator function|comparing]] imposing a \npartial order upon the elements of the stream, or `null`\nif this stream is empty.\n\nFor example, the expression\n\n    {-10.0, -1.0, 5.0}.max(byIncreasing(Float.magnitude))\n\nevaluates to `-10`.\n\nFor any nonempty stream `it`, and comparator function \n`c`, `it.max(c)` evaluates to the first element of `it` \nsuch that for every element `e` of `it`, \n`c(e, it.max(c)) != larger`.\n\nNote that the toplevel functions [[ceylon.language::max]]\nand [[ceylon.language::min]] may be used to find the  \nlargest and smallest values in a stream of [[Comparable]] \nvalues, according to the natural order of its elements."}), @Annotation(value="see", arguments={"max", "min"})})
    @TypeInfo(value="Element|Absent", erased=true)
    public Object max(@Name(value="comparing") @FunctionalParameter(value="(x,y)") @TypeInfo(value="ceylon.language::Comparison(Element, Element)") @Annotations(value={@Annotation(value="doc", arguments={"The function comparing pairs of elements."})}) Callable<? extends Comparison> var1);

    @DocAnnotation$annotation$(description="Given a [[method]] of the element type [[Element]], \nreturn a function that, when supplied with a list of \nmethod arguments, produces a new iterable object that \napplies the `method` to each element of this iterable \nobject in turn.\n\n    {Boolean+}(Object) fun = (-1..1).spread(Object.equals);\n    print(fun(0)); //prints { false, true, false }")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Given a [[method]] of the element type [[Element]], \nreturn a function that, when supplied with a list of \nmethod arguments, produces a new iterable object that \napplies the `method` to each element of this iterable \nobject in turn.\n\n    {Boolean+}(Object) fun = (-1..1).spread(Object.equals);\n    print(fun(0)); //prints { false, true, false }"})})
    @TypeInfo(value="ceylon.language::Iterable<Result,Absent>(*Args)")
    @TypeParameters(value={@TypeParameter(value="Result", variance=Variance.NONE, satisfies={}, caseTypes={}), @TypeParameter(value="Args", variance=Variance.NONE, satisfies={"ceylon.language::Anything[]"}, caseTypes={})})
    public <Result, Args extends Sequential<? extends Object>> Callable<? extends Iterable<? extends Result, ? extends Absent>> spread(@Ignore TypeDescriptor var1, @Ignore TypeDescriptor var2, @Name(value="method") @FunctionalParameter(value="(element)") @TypeInfo(value="Result(*Args)(Element)") Callable<? extends Callable<? extends Result>> var3);

    @DocAnnotation$annotation$(description="Produce a new [[sequence|Sequential]] containing the \nelements of this stream, sorted according to the given \n[[comparator function|comparing]] imposing a partial \norder upon the elements of the stream.\n\nFor convenience, the functions [[byIncreasing]] and \n[[byDecreasing]] produce suitable comparator functions.\n\nFor example, this expression\n\n    \"Hello World!\".sort(byIncreasing(Character.lowercased))\n\nevaluates to the sequence \n`[ , !, d, e, H, l, l, l, o, o, r, W].`\n\nThis operation is eager by nature.\n\nNote that the toplevel function [[ceylon.language::sort]] \nmay be used to sort a stream of [[Comparable]] values \naccording to the natural order of its elements.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::Fincreasing", "::1.2.2:ceylon.language::Fdecreasing", "::1.2.2:ceylon.language::FbyIncreasing", "::1.2.2:ceylon.language::FbyDecreasing"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Produce a new [[sequence|Sequential]] containing the \nelements of this stream, sorted according to the given \n[[comparator function|comparing]] imposing a partial \norder upon the elements of the stream.\n\nFor convenience, the functions [[byIncreasing]] and \n[[byDecreasing]] produce suitable comparator functions.\n\nFor example, this expression\n\n    \"Hello World!\".sort(byIncreasing(Character.lowercased))\n\nevaluates to the sequence \n`[ , !, d, e, H, l, l, l, o, o, r, W].`\n\nThis operation is eager by nature.\n\nNote that the toplevel function [[ceylon.language::sort]] \nmay be used to sort a stream of [[Comparable]] values \naccording to the natural order of its elements."}), @Annotation(value="see", arguments={"increasing", "decreasing", "byIncreasing", "byDecreasing"})})
    @TypeInfo(value="Element[]")
    public Sequential<? extends Element> sort(@Name(value="comparing") @FunctionalParameter(value="(x,y)") @TypeInfo(value="ceylon.language::Comparison(Element, Element)") @Annotations(value={@Annotation(value="doc", arguments={"The function comparing pairs of elements."})}) Callable<? extends Comparison> var1);

    @DocAnnotation$annotation$(description="Produce a new [[sequence|Sequential]] containing the \nresults of applying the given [[mapping|collecting]] to\nthe elements of this stream.\n\nThis operation is an eager counterpart to [[map]]. For\nany stream `it`, and mapping `f`:\n\n    it.collect(f) == [*it.map(f)]")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Fmap"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Produce a new [[sequence|Sequential]] containing the \nresults of applying the given [[mapping|collecting]] to\nthe elements of this stream.\n\nThis operation is an eager counterpart to [[map]]. For\nany stream `it`, and mapping `f`:\n\n    it.collect(f) == [*it.map(f)]"}), @Annotation(value="see", arguments={"map"})})
    @TypeInfo(value="Result[]")
    @TypeParameters(value={@TypeParameter(value="Result", variance=Variance.NONE, satisfies={}, caseTypes={})})
    public <Result> Sequential<? extends Result> collect(@Ignore TypeDescriptor var1, @Name(value="collecting") @FunctionalParameter(value="(element)") @TypeInfo(value="Result(Element)") @Annotations(value={@Annotation(value="doc", arguments={"The transformation applied to the elements."})}) Callable<? extends Result> var2);

    @DocAnnotation$annotation$(description="Produce a new [[sequence|Sequential]] containing all \nelements of this stream that satisfy the given \n[[predicate function|selecting]], in the order in which \nthey occur in this stream.\n\nThis operation is an eager counterpart to [[filter]]. \nFor any stream `it`, and predicate `p`:\n\n    it.select(p) == [*it.filter(p)]")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Ffilter"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Produce a new [[sequence|Sequential]] containing all \nelements of this stream that satisfy the given \n[[predicate function|selecting]], in the order in which \nthey occur in this stream.\n\nThis operation is an eager counterpart to [[filter]]. \nFor any stream `it`, and predicate `p`:\n\n    it.select(p) == [*it.filter(p)]"}), @Annotation(value="see", arguments={"filter"})})
    @TypeInfo(value="Element[]")
    public Sequential<? extends Element> select(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") @Annotations(value={@Annotation(value="doc", arguments={"The predicate the elements must satisfy."})}) Callable<? extends Boolean> var1);

    @DocAnnotation$annotation$(description="Produces the number of elements in this stream that \nsatisfy the [[given predicate function|selecting]].\nFor an infinite stream, this method never terminates.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Produces the number of elements in this stream that \nsatisfy the [[given predicate function|selecting]].\nFor an infinite stream, this method never terminates."})})
    @TypeInfo(value="ceylon.language::Integer")
    public long count(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") @Annotations(value={@Annotation(value="doc", arguments={"The predicate satisfied by the elements to be \ncounted."})}) Callable<? extends Boolean> var1);

    @DocAnnotation$annotation$(description="Determines if there is at least one element of this \nstream that satisfies the given [[predicate \nfunction|selecting]]. If the stream is empty, returns \n`false`. For an infinite stream, this operation might \nnot terminate.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Fevery"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Determines if there is at least one element of this \nstream that satisfies the given [[predicate \nfunction|selecting]]. If the stream is empty, returns \n`false`. For an infinite stream, this operation might \nnot terminate."}), @Annotation(value="see", arguments={"every"})})
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean any(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") @Annotations(value={@Annotation(value="doc", arguments={"The predicate that at least one element must \nsatisfy."})}) Callable<? extends Boolean> var1);

    @DocAnnotation$annotation$(description="Determines if all elements of this stream satisfy the \ngiven [[predicate function|selecting]]. If the stream\nis empty, return `true`. For an infinite stream, this \noperation might not terminate.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Fany"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Determines if all elements of this stream satisfy the \ngiven [[predicate function|selecting]]. If the stream\nis empty, return `true`. For an infinite stream, this \noperation might not terminate."}), @Annotation(value="see", arguments={"any"})})
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean every(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") @Annotations(value={@Annotation(value="doc", arguments={"The predicate that all elements must satisfy."})}) Callable<? extends Boolean> var1);

    @DocAnnotation$annotation$(description="Produces a stream containing the elements of this \nstream, after skipping the first [[skipping]] elements\nproduced by its iterator.\n\nIf this stream does not contain more elements than the \nspecified number of elements to skip, the resulting \nstream has no elements. If the specified number of \nelements to skip is zero or fewer, the resulting stream \ncontains the same elements as this stream.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IList.FsublistFrom", "::1.2.2:ceylon.language::IIterable.FskipWhile", "::1.2.2:ceylon.language::IIterable.Ftake"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Produces a stream containing the elements of this \nstream, after skipping the first [[skipping]] elements\nproduced by its iterator.\n\nIf this stream does not contain more elements than the \nspecified number of elements to skip, the resulting \nstream has no elements. If the specified number of \nelements to skip is zero or fewer, the resulting stream \ncontains the same elements as this stream."}), @Annotation(value="see", arguments={"List.sublistFrom", "skipWhile", "take"})})
    @TypeInfo(value="{Element*}")
    public Iterable<? extends Element, ? extends Object> skip(@Name(value="skipping") @TypeInfo(value="ceylon.language::Integer") long var1);

    @DocAnnotation$annotation$(description="Produces a stream containing the first [[taking]]\nelements of this stream.\n\nIf the specified number of elements to take is larger \nthan the number of elements of this stream, the \nresulting stream contains the same elements as this \nstream. If the specified number of elements to take is\nfewer than one, the resulting stream has no elements.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IList.FsublistTo", "::1.2.2:ceylon.language::IList.Finitial", "::1.2.2:ceylon.language::IIterable.FtakeWhile", "::1.2.2:ceylon.language::IIterable.Fskip"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Produces a stream containing the first [[taking]]\nelements of this stream.\n\nIf the specified number of elements to take is larger \nthan the number of elements of this stream, the \nresulting stream contains the same elements as this \nstream. If the specified number of elements to take is\nfewer than one, the resulting stream has no elements."}), @Annotation(value="see", arguments={"List.sublistTo", "List.initial", "takeWhile", "skip"})})
    @TypeInfo(value="{Element*}")
    public Iterable<? extends Element, ? extends Object> take(@Name(value="taking") @TypeInfo(value="ceylon.language::Integer") long var1);

    @DocAnnotation$annotation$(description="Produces a stream containing the elements of this \nstream, after skipping the leading elements until the \ngiven [[predicate function|skipping]] returns `false`.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Fskip", "::1.2.2:ceylon.language::IIterable.FtakeWhile"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Produces a stream containing the elements of this \nstream, after skipping the leading elements until the \ngiven [[predicate function|skipping]] returns `false`."}), @Annotation(value="see", arguments={"skip", "takeWhile"})})
    @TypeInfo(value="{Element*}")
    public Iterable<? extends Element, ? extends Object> skipWhile(@Name(value="skipping") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") @Annotations(value={@Annotation(value="doc", arguments={"The function that returns `false` when the \nresulting stream should stop skipping elements from \nthe stream."})}) Callable<? extends Boolean> var1);

    @DocAnnotation$annotation$(description="Produces a stream containing the leading elements of \nthis stream until the given [[predicate function|taking]]\nreturns `false`.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Ftake", "::1.2.2:ceylon.language::IIterable.FskipWhile"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Produces a stream containing the leading elements of \nthis stream until the given [[predicate function|taking]]\nreturns `false`."}), @Annotation(value="see", arguments={"take", "skipWhile"})})
    @TypeInfo(value="{Element*}")
    public Iterable<? extends Element, ? extends Object> takeWhile(@Name(value="taking") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") @Annotations(value={@Annotation(value="doc", arguments={"The function that returns `false` when the \nresulting stream should stop taking elements from \nthis stream."})}) Callable<? extends Boolean> var1);

    @DocAnnotation$annotation$(description="Produces a stream formed by repeating the elements of \nthis stream the given [[number of times|times]], or an \nempty stream if `times<=0`.\n\nFor example, the expression\n\n    { 1, 2 }.repeat(3)\n\nevaluates to the stream `{ 1, 2, 1, 2, 1, 2 }`.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Vcycled"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Produces a stream formed by repeating the elements of \nthis stream the given [[number of times|times]], or an \nempty stream if `times<=0`.\n\nFor example, the expression\n\n    { 1, 2 }.repeat(3)\n\nevaluates to the stream `{ 1, 2, 1, 2, 1, 2 }`."}), @Annotation(value="see", arguments={"cycled"})})
    @TypeInfo(value="{Element*}")
    public Iterable<? extends Element, ? extends Object> repeat(@Name(value="times") @TypeInfo(value="ceylon.language::Integer") long var1);

    @DocAnnotation$annotation$(description="Produces a stream containing every [[step]]th element \nof this stream. If the step size is `1`, the resulting\nstream contains the same elements as this stream.\n\nFor example, the expression\n\n    (0..10).by(3)\n\nresults in the stream `{ 0, 3, 6, 9 }`.\n\nThe step size must be greater than zero.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.2.2:ceylon.language::CAssertionError", when="if the given step size is nonpositive, \ni.e. `step<1`")})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Produces a stream containing every [[step]]th element \nof this stream. If the step size is `1`, the resulting\nstream contains the same elements as this stream.\n\nFor example, the expression\n\n    (0..10).by(3)\n\nresults in the stream `{ 0, 3, 6, 9 }`.\n\nThe step size must be greater than zero."}), @Annotation(value="throws", arguments={"AssertionError", "if the given step size is nonpositive, \ni.e. `step<1`"})})
    @TypeInfo(value="ceylon.language::Iterable<Element,Absent>")
    public Iterable<? extends Element, ? extends Absent> by(@Name(value="step") @TypeInfo(value="ceylon.language::Integer") long var1);

    @DocAnnotation$annotation$(description="Produces a stream containing the elements of this \nstream, in the order in which they occur in this stream, \nafter replacing every `null` element in the stream with \nthe [[given default value|defaultValue]]. The value \n`null` does not ocur in the resulting stream.\n\nFor example, the expression\n\n    { \"123\", \"abc\", \"456\" }.map(parseInteger).defaultNullElements(0)\n\nresults in the stream `{ 123, 0, 456 }`.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Vcoalesced"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Produces a stream containing the elements of this \nstream, in the order in which they occur in this stream, \nafter replacing every `null` element in the stream with \nthe [[given default value|defaultValue]]. The value \n`null` does not ocur in the resulting stream.\n\nFor example, the expression\n\n    { \"123\", \"abc\", \"456\" }.map(parseInteger).defaultNullElements(0)\n\nresults in the stream `{ 123, 0, 456 }`."}), @Annotation(value="see", arguments={"coalesced"})})
    @TypeInfo(value="ceylon.language::Iterable<Element&ceylon.language::Object|Default,Absent>", erased=true)
    @TypeParameters(value={@TypeParameter(value="Default", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={})})
    public <Default> Iterable defaultNullElements(@Ignore TypeDescriptor var1, @Name(value="defaultValue") @TypeInfo(value="Default") @DocAnnotation$annotation$(description="A default value that replaces `null` elements.") @Annotations(value={@Annotation(value="doc", arguments={"A default value that replaces `null` elements."})}) Default var2);

    @DocAnnotation$annotation$(description="The non-null elements of this stream, in the order in\nwhich they occur in this stream. For null elements of \nthe original stream, there is no entry in the resulting \nstream.\n\nFor example, the expression\n\n    { \"123\", \"abc\", \"456\"}.map(parseInteger).coalesced\n\nresults in the stream `{ 123, 456 }`.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.FdefaultNullElements"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The non-null elements of this stream, in the order in\nwhich they occur in this stream. For null elements of \nthe original stream, there is no entry in the resulting \nstream.\n\nFor example, the expression\n\n    { \"123\", \"abc\", \"456\"}.map(parseInteger).coalesced\n\nresults in the stream `{ 123, 456 }`."}), @Annotation(value="see", arguments={"defaultNullElements"})})
    @TypeInfo(value="{Element&ceylon.language::Object*}")
    @Transient
    public Iterable<? extends Element, ? extends Object> getCoalesced();

    @DocAnnotation$annotation$(description="A stream containing all [[entries|Entry]] of form\n`index->element` where `element` is an element of this\nstream, and `index` is the position at which `element`\noccurs in this stream, ordered by increasing `index`.\n\nFor example, the expression\n\n    { \"hello\", null, \"world\" }.indexed\n\nresults in the stream `{ 0->\"hello\", 1->null, 2->\"world\" }`.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Flocations"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"A stream containing all [[entries|Entry]] of form\n`index->element` where `element` is an element of this\nstream, and `index` is the position at which `element`\noccurs in this stream, ordered by increasing `index`.\n\nFor example, the expression\n\n    { \"hello\", null, \"world\" }.indexed\n\nresults in the stream `{ 0->\"hello\", 1->null, 2->\"world\" }`."}), @Annotation(value="see", arguments={"locations"})})
    @TypeInfo(value="ceylon.language::Iterable<ceylon.language::Integer->Element,Absent>")
    @Transient
    public Iterable<? extends Entry<? extends Integer, ? extends Element>, ? extends Absent> getIndexed();

    @DocAnnotation$annotation$(description="A stream containing whose elements are pairs (2-tuples)\ncomprising an element of this stream paired with the \nnext element in the stream. The resulting stream has\none fewer elements than this stream.\n\nFor example, the expression\n\n    (1..5).paired\n\nresults in the stream \n`{ [1, 2], [2, 3], [3, 4], [4, 5] }`.\n\nThis expression determines if a stream is monotonically\nincreasing:\n\n    every { for ([x, y] in nums.paired) x < y }\n\nFor any stable `stream`, this operation is equivalent \nto `zipPairs(stream,stream.rest)`.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"A stream containing whose elements are pairs (2-tuples)\ncomprising an element of this stream paired with the \nnext element in the stream. The resulting stream has\none fewer elements than this stream.\n\nFor example, the expression\n\n    (1..5).paired\n\nresults in the stream \n`{ [1, 2], [2, 3], [3, 4], [4, 5] }`.\n\nThis expression determines if a stream is monotonically\nincreasing:\n\n    every { for ([x, y] in nums.paired) x < y }\n\nFor any stable `stream`, this operation is equivalent \nto `zipPairs(stream,stream.rest)`."})})
    @TypeInfo(value="{Element[2]*}", erased=true)
    @Transient
    public Iterable<? extends Sequence<? extends Element>, ? extends Object> getPaired();

    @DocAnnotation$annotation$(description="Produces a stream of sequences of the given [[length]],\ncontaining elements of this stream. Each sequence in \nthe stream contains the next [[length]] elements of \nthis sequence that have not yet been assigned to a \nprevious sequence, in the same order that they occur in \nthis stream. The very last sequence in the stream may \nbe shorter than the given `length`.\n\nFor example, the expression\n\n    \"hello\".partition(2)\n\nresults in the stream `{ ['h','e'], ['l','l'], ['o'] }.`\n\nFor any `stream` and for any strictly positive integer \n[[length]]:\n\n    expand { stream.partition(length) } == stream")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.2.2:ceylon.language::CAssertionError", when="if `length<=0`")})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Produces a stream of sequences of the given [[length]],\ncontaining elements of this stream. Each sequence in \nthe stream contains the next [[length]] elements of \nthis sequence that have not yet been assigned to a \nprevious sequence, in the same order that they occur in \nthis stream. The very last sequence in the stream may \nbe shorter than the given `length`.\n\nFor example, the expression\n\n    \"hello\".partition(2)\n\nresults in the stream `{ ['h','e'], ['l','l'], ['o'] }.`\n\nFor any `stream` and for any strictly positive integer \n[[length]]:\n\n    expand { stream.partition(length) } == stream"}), @Annotation(value="throws", arguments={"AssertionError", "if `length<=0`"})})
    @TypeInfo(value="ceylon.language::Iterable<[Element+],Absent>")
    public Iterable<? extends Sequence<? extends Element>, ? extends Absent> partition(@Name(value="length") @TypeInfo(value="ceylon.language::Integer") @DocAnnotation$annotation$(description="The length of the sequences in the resulting stream,\nwhich must be strictly positive.") @Annotations(value={@Annotation(value="doc", arguments={"The length of the sequences in the resulting stream,\nwhich must be strictly positive."})}) long var1);

    @DocAnnotation$annotation$(description="Produces a stream with a given [[initial element|head]], \nfollowed by the elements of this stream, in the order \nin which they occur in this stream.\n\nFor example, the expression\n\n    (1..3).follow(0)\n\nevaluates to the stream `{ 0, 1, 2, 3 }`.\n\nNote that the expression `stream.follow(head)` eagerly \nevaluates `head`, and therefore is not precisely the \nsame as this enumeration expression, where `head` is\nevaluated lazily:\n\n    { head, *stream }")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Fchain"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Produces a stream with a given [[initial element|head]], \nfollowed by the elements of this stream, in the order \nin which they occur in this stream.\n\nFor example, the expression\n\n    (1..3).follow(0)\n\nevaluates to the stream `{ 0, 1, 2, 3 }`.\n\nNote that the expression `stream.follow(head)` eagerly \nevaluates `head`, and therefore is not precisely the \nsame as this enumeration expression, where `head` is\nevaluated lazily:\n\n    { head, *stream }"}), @Annotation(value="see", arguments={"chain"})})
    @TypeInfo(value="{Element|Other+}", erased=true)
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={}, caseTypes={})})
    public <Other> Iterable follow(@Ignore TypeDescriptor var1, @Name(value="head") @TypeInfo(value="Other") Other var2);

    @DocAnnotation$annotation$(description="The elements of this stream, in the order in which they \noccur in this stream, followed by the elements of the \n[[given stream|other]] in the order in which they occur \nin the given stream.\n\nFor example, the expression\n\n    (1..3).chain(\"abc\")\n\nevaluates to the stream `{ 1, 2, 3, 'a', 'b', 'c' }`.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::Fexpand"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The elements of this stream, in the order in which they \noccur in this stream, followed by the elements of the \n[[given stream|other]] in the order in which they occur \nin the given stream.\n\nFor example, the expression\n\n    (1..3).chain(\"abc\")\n\nevaluates to the stream `{ 1, 2, 3, 'a', 'b', 'c' }`."}), @Annotation(value="see", arguments={"expand"})})
    @TypeInfo(value="ceylon.language::Iterable<Element|Other,Absent&OtherAbsent>", erased=true)
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={}, caseTypes={}), @TypeParameter(value="OtherAbsent", variance=Variance.NONE, satisfies={"ceylon.language::Null"}, caseTypes={})})
    public <Other, OtherAbsent> Iterable chain(@Ignore TypeDescriptor var1, @Ignore TypeDescriptor var2, @Name(value="other") @TypeInfo(value="ceylon.language::Iterable<Other,OtherAbsent>") Iterable<? extends Other, ? extends OtherAbsent> var3);

    @DocAnnotation$annotation$(description="A stream of pairs of elements of this stream and the \nthe given stream, where for each element `x` of this\nstream, and element `y` of the given stream, the pair \n`[x,y]` belongs to the resulting stream. The pairs are \nsorted first by the position of `x` in this stream, and\nthen by the position of `y` in the given stream.\n\nFor example, this expression\n\n    (1..3).product(\"ab\")\n\nevaluates to the stream \n`{ [1,'a'], [1,'b'], [2,'a'], [2,'b'], [3,'a'], [3,'b'] }`.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"A stream of pairs of elements of this stream and the \nthe given stream, where for each element `x` of this\nstream, and element `y` of the given stream, the pair \n`[x,y]` belongs to the resulting stream. The pairs are \nsorted first by the position of `x` in this stream, and\nthen by the position of `y` in the given stream.\n\nFor example, this expression\n\n    (1..3).product(\"ab\")\n\nevaluates to the stream \n`{ [1,'a'], [1,'b'], [2,'a'], [2,'b'], [3,'a'], [3,'b'] }`."})})
    @TypeInfo(value="ceylon.language::Iterable<[Element, Other],Absent|OtherAbsent>", erased=true)
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={}, caseTypes={}), @TypeParameter(value="OtherAbsent", variance=Variance.NONE, satisfies={"ceylon.language::Null"}, caseTypes={})})
    public <Other, OtherAbsent> Iterable product(@Ignore TypeDescriptor var1, @Ignore TypeDescriptor var2, @Name(value="other") @TypeInfo(value="ceylon.language::Iterable<Other,OtherAbsent>") Iterable<? extends Other, ? extends OtherAbsent> var3);

    @DocAnnotation$annotation$(description="An infinite stream that produces the elements of this \nstream, repeatedly.\n\nFor example, the expression\n\n    {6, 9}.cycled.take(5)\n\nevaluates to the stream `{ 6, 9, 6, 9, 6 }`.\n\nIf this stream is empty, the resulting stream also\nempty.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Frepeat"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"An infinite stream that produces the elements of this \nstream, repeatedly.\n\nFor example, the expression\n\n    {6, 9}.cycled.take(5)\n\nevaluates to the stream `{ 6, 9, 6, 9, 6 }`.\n\nIf this stream is empty, the resulting stream also\nempty."}), @Annotation(value="see", arguments={"repeat"})})
    @TypeInfo(value="ceylon.language::Iterable<Element,Absent>")
    @Transient
    public Iterable<? extends Element, ? extends Absent> getCycled();

    @Ignore
    public <Other> Iterable interpose(TypeDescriptor var1, Other var2);

    @Ignore
    public <Other> long interpose$step(TypeDescriptor var1, Other var2);

    @DocAnnotation$annotation$(description="A stream that contains the given [[element]] interposed\nbetween blocks of [[step]] elements of this stream. The\nresulting stream starts with the [[first]] element of \nthis stream and ends with the [[last]] element of this\nstream. Elements of this stream occur in the resulting\nstream in the same order they occur in this stream.\n\nFor example, the expression\n\n    String(\"hello\".interpose(' '))\n\nevaluates to the string `\"h e l l o\"`.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.2.2:ceylon.language::CAssertionError", when="if `step<1`")})
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::Finterleave"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"A stream that contains the given [[element]] interposed\nbetween blocks of [[step]] elements of this stream. The\nresulting stream starts with the [[first]] element of \nthis stream and ends with the [[last]] element of this\nstream. Elements of this stream occur in the resulting\nstream in the same order they occur in this stream.\n\nFor example, the expression\n\n    String(\"hello\".interpose(' '))\n\nevaluates to the string `\"h e l l o\"`."}), @Annotation(value="throws", arguments={"AssertionError", "if `step<1`"}), @Annotation(value="see", arguments={"interleave"})})
    @TypeInfo(value="ceylon.language::Iterable<Element|Other,Absent>", erased=true)
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={}, caseTypes={})})
    public <Other> Iterable interpose(@Ignore TypeDescriptor var1, @Name(value="element") @TypeInfo(value="Other") @DocAnnotation$annotation$(description="The value to interpose between blocks of \nelements of this stream.") @Annotations(value={@Annotation(value="doc", arguments={"The value to interpose between blocks of \nelements of this stream."})}) Other var2, @Name(value="step") @Defaulted @TypeInfo(value="ceylon.language::Integer") @DocAnnotation$annotation$(description="The step size that determines how often the \ngiven [[element]] occurs in the resulting \nstream. The `element` occurs after each block \nof size `step` of elements of this stream. If \n`step==1`, the `element` occurs at every second \nposition. The step size must be strictly positive.") @Annotations(value={@Annotation(value="doc", arguments={"The step size that determines how often the \ngiven [[element]] occurs in the resulting \nstream. The `element` occurs after each block \nof size `step` of elements of this stream. If \n`step==1`, the `element` occurs at every second \nposition. The step size must be strictly positive."})}) long var3);

    @DocAnnotation$annotation$(description="A stream that produces every element produced by this\nstream exactly once. Duplicate elements of this stream\nare eliminated. Two elements are considered distinct\nunless they are both [[null|Null]], or unless they are \nboth non-null and [[equal|Object.equals]].\n\nFor example:\n\n    String(\"hello world\".distinct)\n\nis the string `\"helo wrd\"`.\n\nThis is a lazy operation and the resulting stream \nreflects changes to this stream.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::Fset"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"A stream that produces every element produced by this\nstream exactly once. Duplicate elements of this stream\nare eliminated. Two elements are considered distinct\nunless they are both [[null|Null]], or unless they are \nboth non-null and [[equal|Object.equals]].\n\nFor example:\n\n    String(\"hello world\".distinct)\n\nis the string `\"helo wrd\"`.\n\nThis is a lazy operation and the resulting stream \nreflects changes to this stream."}), @Annotation(value="see", arguments={"set"})})
    @TypeInfo(value="ceylon.language::Iterable<Element,Absent>")
    @Transient
    public Iterable<? extends Element, ? extends Absent> getDistinct();

    @DocAnnotation$annotation$(description="Produce a [[Map]] mapping elements to frequencies where\neach [[entry|Entry]] maps a distinct non-null element \nof this stream to the number of times the element was \nproduced by the stream. Elements are considered \ndistinct if they are not [[equal|Object.equals]]. Null \nelements of this stream are simply discarded.\n\nThis is an eager operation, and the resulting map does\nnot reflect changes to this stream.")
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"Produce a [[Map]] mapping elements to frequencies where\neach [[entry|Entry]] maps a distinct non-null element \nof this stream to the number of times the element was \nproduced by the stream. Elements are considered \ndistinct if they are not [[equal|Object.equals]]. Null \nelements of this stream are simply discarded.\n\nThis is an eager operation, and the resulting map does\nnot reflect changes to this stream."})})
    @TypeInfo(value="ceylon.language::Map<Element&ceylon.language::Object,ceylon.language::Integer>")
    public Map<? extends Element, ? extends Integer> frequencies();

    @DocAnnotation$annotation$(description="Produces a [[Map]] mapping elements to items where each \n[[entry|Entry]] maps a distinct non-null element of \nthis stream to the item produced by the given \n[[function|collecting]]. Elements are considered \ndistinct if they are not [[equal|Object.equals]]. Null \nelements of this stream are simply discarded.\n\nThis is an eager operation, and the resulting map does\nnot reflect changes to the given stream.")
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"Produces a [[Map]] mapping elements to items where each \n[[entry|Entry]] maps a distinct non-null element of \nthis stream to the item produced by the given \n[[function|collecting]]. Elements are considered \ndistinct if they are not [[equal|Object.equals]]. Null \nelements of this stream are simply discarded.\n\nThis is an eager operation, and the resulting map does\nnot reflect changes to the given stream."})})
    @TypeInfo(value="ceylon.language::Map<Element&ceylon.language::Object,Result>")
    @TypeParameters(value={@TypeParameter(value="Result", variance=Variance.NONE, satisfies={}, caseTypes={})})
    public <Result> Map<? extends Element, ? extends Result> tabulate(@Ignore TypeDescriptor var1, @Name(value="collecting") @FunctionalParameter(value="(key)") @TypeInfo(value="Result(Element)") @Annotations(value={@Annotation(value="doc", arguments={"A function that produces an item for the given\n[[key]], an element of this stream."})}) Callable<? extends Result> var2);

    @DocAnnotation$annotation$(description="Classifies the elements of this stream into a new\nimmutable [[Map]] where each key is a value produced by \nthe given [[grouping function|grouping]] and each \ncorresponding item is [[sequence|Sequence]] of all \nelements that produced the key when passed as arguments \nto the grouping function.\n\nWithin each group, the sequence elements occur in the\nsame order they occurred in this stream.\n\nFor example:\n\n(0..10).group((i) => i.even then \"even\" else \"odd\")\n\nproduces the map \n`{ even->[0, 2, 4, 6, 8, 10], odd->[1, 3, 5, 7, 9] }`.\n\nThis is an eager operation, and the resulting map does\nnot reflect changes to this stream.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Fsummarize"})})
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"Classifies the elements of this stream into a new\nimmutable [[Map]] where each key is a value produced by \nthe given [[grouping function|grouping]] and each \ncorresponding item is [[sequence|Sequence]] of all \nelements that produced the key when passed as arguments \nto the grouping function.\n\nWithin each group, the sequence elements occur in the\nsame order they occurred in this stream.\n\nFor example:\n\n(0..10).group((i) => i.even then \"even\" else \"odd\")\n\nproduces the map \n`{ even->[0, 2, 4, 6, 8, 10], odd->[1, 3, 5, 7, 9] }`.\n\nThis is an eager operation, and the resulting map does\nnot reflect changes to this stream."}), @Annotation(value="see", arguments={"summarize"})})
    @TypeInfo(value="ceylon.language::Map<Group,[Element+]>")
    @TypeParameters(value={@TypeParameter(value="Group", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={})})
    public <Group> Map<? extends Group, ? extends Sequence<? extends Element>> group(@Ignore TypeDescriptor var1, @Name(value="grouping") @FunctionalParameter(value="(element)") @TypeInfo(value="Group(Element)") @Annotations(value={@Annotation(value="doc", arguments={"The grouping function that assigns a key to the\ngiven [[element]]. Multiple elements may be \nassigned to the same key, indicating that they\nbelong to the same [[Group]] in the resulting map."})}) Callable<? extends Group> var2);

    @DocAnnotation$annotation$(description="Efficiently [[group]] and [[fold]] the elements of this\nstream in a single step.\n\nFor example, the expression:\n\n    (1..10)\n       .summarize((i) => i%3, \n           (Integer[2]? pair, i) \n               => if (exists [sum, product] = pair) \n                  then [sum+i, product*i] else [i,i])\n\nproduces the map \n`{ 0->[18, 162], 1->[22, 280], 2->[15, 80] }`, being \nequivalent to, but much more efficient than, the \nfollowing expression written using `group()`, \n`mapItems()` and `fold()`:\n\n    (1..10)\n        .group((i) => i%3)\n        .mapItems((_, item) \n           => item.fold([0,1])\n               ((pair, i) \n                   => let ([sum, product] = pair) \n                       [sum+i, product*i]))\n\nThis is an eager operation, and the resulting map does\nnot reflect changes to this stream.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Fgroup", "::1.2.2:ceylon.language::IIterable.Ffold"})})
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"Efficiently [[group]] and [[fold]] the elements of this\nstream in a single step.\n\nFor example, the expression:\n\n    (1..10)\n       .summarize((i) => i%3, \n           (Integer[2]? pair, i) \n               => if (exists [sum, product] = pair) \n                  then [sum+i, product*i] else [i,i])\n\nproduces the map \n`{ 0->[18, 162], 1->[22, 280], 2->[15, 80] }`, being \nequivalent to, but much more efficient than, the \nfollowing expression written using `group()`, \n`mapItems()` and `fold()`:\n\n    (1..10)\n        .group((i) => i%3)\n        .mapItems((_, item) \n           => item.fold([0,1])\n               ((pair, i) \n                   => let ([sum, product] = pair) \n                       [sum+i, product*i]))\n\nThis is an eager operation, and the resulting map does\nnot reflect changes to this stream."}), @Annotation(value="see", arguments={"group", "fold"})})
    @TypeInfo(value="ceylon.language::Map<Group,Result>")
    @TypeParameters(value={@TypeParameter(value="Group", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={}), @TypeParameter(value="Result", variance=Variance.NONE, satisfies={}, caseTypes={})})
    public <Group, Result> Map<? extends Group, ? extends Result> summarize(@Ignore TypeDescriptor var1, @Ignore TypeDescriptor var2, @Name(value="grouping") @FunctionalParameter(value="(element)") @TypeInfo(value="Group(Element)") @Annotations(value={@Annotation(value="doc", arguments={"The grouping function that assigns a key to the\ngiven [[element]]. Multiple elements may be \nassigned to the same key, indicating that they\nshould be aggregated by calling [[accumulating]]."})}) Callable<? extends Group> var3, @Name(value="accumulating") @FunctionalParameter(value="(partial,element)") @TypeInfo(value="Result(Result?, Element)") @Annotations(value={@Annotation(value="doc", arguments={"The accumulating function that accepts an\n[[intermediate result|partial]] for a key, and the \n[[next element]] with that key."})}) Callable<? extends Result> var4);

    @DocAnnotation$annotation$(description="A string of form `\"{ x, y, z }\"` where `x`, `y`, and \n`z` are the `string` representations of the elements of \nthis collection, as produced by the iterator of the \nstream, or the string `\"{}\"` if this stream is empty. \nIf the stream is very long, the list of elements might \nbe truncated, as indicated by an ellipse.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"A string of form `\"{ x, y, z }\"` where `x`, `y`, and \n`z` are the `string` representations of the elements of \nthis collection, as produced by the iterator of the \nstream, or the string `\"{}\"` if this stream is empty. \nIf the stream is very long, the list of elements might \nbe truncated, as indicated by an ellipse."})})
    @TypeInfo(value="ceylon.language::String")
    @Transient
    public String toString();
}

