/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Collection;
import ceylon.language.Correspondence;
import ceylon.language.DefaultAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.Integer;
import ceylon.language.Iterable;
import ceylon.language.Iterator;
import ceylon.language.List$impl;
import ceylon.language.Ranged;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.Sequence;
import ceylon.language.Sequential;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.TagsAnnotation$annotation$;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.FunctionalParameter;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.LocalDeclarations;
import com.redhat.ceylon.compiler.java.metadata.Member;
import com.redhat.ceylon.compiler.java.metadata.Members;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

@Ceylon(major=8)
@DocAnnotation$annotation$(description="A collection in which every element has a unique \nnon-negative integer index. The elements of a nonempty \nlist are indexed starting with `0` at the [[first]] \nelement of the list, and ending with the index \n[[lastIndex]] at the [[last]] element of the list.\n\n- For any nonempty list, `lastIndex==size-1`. \n- For an empty list, `size==0` and the `lastIndex` is \n  `null`.\n\nThus, the range of indexes of the list is formed by the \nexpression `0:list.size`.\n\nA `List` is a [[Collection]] of its elements, and a \n[[Correspondence]] from indices to elements.\n\nEvery list has a well-defined and stable iteration order.\nAn [[iterator]] of a nonempty list is required to return \nthe elements of the list in order of increasing index, \nbeginning with the element at index `0`, and ending with\nthe element at index `lastIndex`. Thus, every iterator of \nan immutable list produces exactly the same elements in \nexactly the same order.\n\nDirect access to a list element by index produces a value \nof optional type. The following idiom may be used instead \nof upfront bounds-checking, as long as the list element \ntype is a non-`null` type:\n\n    if (exists char = \"hello world\"[index]) { \n        //do something with char\n    }\n    else {\n        //out of bounds\n    }\n\nWhen an algorithm guarantees that a list contains a given \nindex, the following idiom may be used:\n\n    assert (exists char = \"hello world\"[index]);\n    //do something with char\n\nTo iterate the indices of a `List`, use the following\nidiom:\n\n    for (i->char in \"hello world\".indexed) { ... }\n\n[[Strings|String]], [[sequences|Sequential]], \n[[tuples|Tuple]], and [[arrays|Array]] are all `List`s,\nand are all of fixed length. Variable-length mutable\n`List`s are also possible.")
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::ISequence", "::1.2.2:ceylon.language::IEmpty", "::1.2.2:ceylon.language::CArray"})})
@TagsAnnotation$annotation$(tags={"Collections"})
@SharedAnnotation$annotation$
@Members(value={@Member(klass=impl$Reversed.class), @Member(klass=impl$Patch.class), @Member(klass=impl$Repeat.class), @Member(klass=impl$Sublist.class), @Member(klass=impl$Rest.class), @Member(klass=impl$Indexes.class)})
@LocalDeclarations(value={"1anonymous_0_", "1list_"})
@Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"A collection in which every element has a unique \nnon-negative integer index. The elements of a nonempty \nlist are indexed starting with `0` at the [[first]] \nelement of the list, and ending with the index \n[[lastIndex]] at the [[last]] element of the list.\n\n- For any nonempty list, `lastIndex==size-1`. \n- For an empty list, `size==0` and the `lastIndex` is \n  `null`.\n\nThus, the range of indexes of the list is formed by the \nexpression `0:list.size`.\n\nA `List` is a [[Collection]] of its elements, and a \n[[Correspondence]] from indices to elements.\n\nEvery list has a well-defined and stable iteration order.\nAn [[iterator]] of a nonempty list is required to return \nthe elements of the list in order of increasing index, \nbeginning with the element at index `0`, and ending with\nthe element at index `lastIndex`. Thus, every iterator of \nan immutable list produces exactly the same elements in \nexactly the same order.\n\nDirect access to a list element by index produces a value \nof optional type. The following idiom may be used instead \nof upfront bounds-checking, as long as the list element \ntype is a non-`null` type:\n\n    if (exists char = \"hello world\"[index]) { \n        //do something with char\n    }\n    else {\n        //out of bounds\n    }\n\nWhen an algorithm guarantees that a list contains a given \nindex, the following idiom may be used:\n\n    assert (exists char = \"hello world\"[index]);\n    //do something with char\n\nTo iterate the indices of a `List`, use the following\nidiom:\n\n    for (i->char in \"hello world\".indexed) { ... }\n\n[[Strings|String]], [[sequences|Sequential]], \n[[tuples|Tuple]], and [[arrays|Array]] are all `List`s,\nand are all of fixed length. Variable-length mutable\n`List`s are also possible."}), @Annotation(value="see", arguments={"Sequence", "Empty", "Array"}), @Annotation(value="tagged", arguments={"Collections"})})
@SatisfiedTypes(value={"ceylon.language::Collection<Element>", "ceylon.language::Correspondence<ceylon.language::Integer,Element>", "ceylon.language::Ranged<ceylon.language::Integer,Element,ceylon.language::List<Element>>"})
@TypeParameters(value={@TypeParameter(value="Element", variance=Variance.OUT, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Anything")})
public interface List<Element>
extends Collection<Element>,
Correspondence<Integer, Element>,
Ranged<Integer, Element, List<? extends Element>> {
    @Ignore
    public List$impl<? extends Element> $ceylon$language$List$impl();

    @Override
    @DocAnnotation$annotation$(description="The first element of this `List`, if any.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"The first element of this `List`, if any."})})
    @TypeInfo(value="Element?", erased=true, untrusted=true)
    @Transient
    public Element getFirst();

    @Override
    @DocAnnotation$annotation$(description="The last element of this `List`, if any.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"The last element of this `List`, if any."})})
    @TypeInfo(value="Element?", erased=true, untrusted=true)
    @Transient
    public Element getLast();

    @Override
    @DocAnnotation$annotation$(description="Returns the element of this list with the given \n[[index]] if the index refers to an element of this\nlist, that is, if `0<=index<=list.lastIndex`, or `null` \notherwise. The first element of the list has index `0`,\nand the last element has index [[lastIndex]].")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L, value={@Annotation(value="doc", arguments={"Returns the element of this list with the given \n[[index]] if the index refers to an element of this\nlist, that is, if `0<=index<=list.lastIndex`, or `null` \notherwise. The first element of the list has index `0`,\nand the last element has index [[lastIndex]]."})})
    @TypeInfo(value="Element?")
    public Element get(@Name(value="index") @TypeInfo(value="ceylon.language::Integer") Integer var1);

    @Override
    @DocAnnotation$annotation$(description="Returns the element of this list with the given \n[[index]] if the index refers to an element of this\nlist, that is, if `0<=index<=list.lastIndex`, or `null` \notherwise. The first element of the list has index `0`, \nand the last element has index [[lastIndex]].")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IList.FgetFromLast"})})
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=194L, value={@Annotation(value="doc", arguments={"Returns the element of this list with the given \n[[index]] if the index refers to an element of this\nlist, that is, if `0<=index<=list.lastIndex`, or `null` \notherwise. The first element of the list has index `0`, \nand the last element has index [[lastIndex]]."}), @Annotation(value="see", arguments={"getFromLast"})})
    @TypeInfo(value="Element?")
    public Element getFromFirst(@Name(value="index") @TypeInfo(value="ceylon.language::Integer") long var1);

    @DocAnnotation$annotation$(description="Returns the element of this list with the given \n[[index]], where the list is indexed from the _end_ of \nthe list instead of from the start, if the index refers\nto an element of this list, or `null` otherwise. The\nlast element of the list has index `0`, and the first\nelement has index [[lastIndex]].")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Returns the element of this list with the given \n[[index]], where the list is indexed from the _end_ of \nthe list instead of from the start, if the index refers\nto an element of this list, or `null` otherwise. The\nlast element of the list has index `0`, and the first\nelement has index [[lastIndex]]."})})
    @TypeInfo(value="Element?")
    public Element getFromLast(@Name(value="index") @TypeInfo(value="ceylon.language::Integer") long var1);

    @DocAnnotation$annotation$(description="The index of the last element of the list, or `null` if \nthe list is empty. Always `size>0 then size-1`.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IList.Vsize"})})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"The index of the last element of the list, or `null` if \nthe list is empty. Always `size>0 then size-1`."}), @Annotation(value="see", arguments={"List.size"})})
    @TypeInfo(value="ceylon.language::Integer?")
    public Integer getLastIndex();

    @Override
    @DocAnnotation$annotation$(description="The number of elements in this list, always\n`1 + (lastIndex else -1)`.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IList.VlastIndex"})})
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"The number of elements in this list, always\n`1 + (lastIndex else -1)`."}), @Annotation(value="see", arguments={"List.lastIndex"})})
    @TypeInfo(value="ceylon.language::Integer")
    @Transient
    public long getSize();

    @Override
    @DocAnnotation$annotation$(description="Determines if the given index refers to an element of \nthis list, that is, if `0<=index<=list.lastIndex`.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Determines if the given index refers to an element of \nthis list, that is, if `0<=index<=list.lastIndex`."})})
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean defines(@Name(value="index") @TypeInfo(value="ceylon.language::Integer") Integer var1);

    @Override
    @DocAnnotation$annotation$(description="Determines if this list contains the given value.\nReturns `true` for every element of this list.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Determines if this list contains the given value.\nReturns `true` for every element of this list."})})
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean contains(@Name(value="element") @TypeInfo(value="ceylon.language::Object") Object var1);

    @DocAnnotation$annotation$(description="The rest of the list, without the first element.\n\nThis is a lazy operation returning a view of this list.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"The rest of the list, without the first element.\n\nThis is a lazy operation returning a view of this list."})})
    @TypeInfo(value="ceylon.language::List<Element>")
    @Transient
    public List<? extends Element> getRest();

    @Override
    @DocAnnotation$annotation$(description="A list containing all indexes of this list.\n\nThis is a lazy operation returning a view of this list.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Findexes"})})
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"A list containing all indexes of this list.\n\nThis is a lazy operation returning a view of this list."}), @Annotation(value="see", arguments={"indexes"})})
    @TypeInfo(value="ceylon.language::List<ceylon.language::Integer>")
    @Transient
    public List<? extends Integer> getKeys();

    @DocAnnotation$annotation$(description="A list containing the elements of this list in reverse \norder to the order in which they occur in this list. \nFor every `index` of a reversed `list`:\n\n    list.reversed[index]==list[size-1-index]\n\nThis is a lazy operation returning a view of this list.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"A list containing the elements of this list in reverse \norder to the order in which they occur in this list. \nFor every `index` of a reversed `list`:\n\n    list.reversed[index]==list[size-1-index]\n\nThis is a lazy operation returning a view of this list."})})
    @TypeInfo(value="ceylon.language::List<Element>")
    @Transient
    public List<? extends Element> getReversed();

    @Override
    @DocAnnotation$annotation$(description="A shallow copy of this list, that is, a list with the\nsame elements as this list, which do not change if the\nelements of this list change.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"A shallow copy of this list, that is, a list with the\nsame elements as this list, which do not change if the\nelements of this list change."})})
    @TypeInfo(value="ceylon.language::List<Element>")
    public List<? extends Element> $clone();

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L)
    @TypeInfo(value="ceylon.language::Iterator<Element>")
    public Iterator<? extends Element> iterator();

    @DocAnnotation$annotation$(description="Two `List`s are considered equal iff they have the \nsame `size` and _entry sets_. The entry set of a list \n`list` is the set of elements of `list.indexed`. This \ndefinition is equivalent to the more intuitive notion \nthat two lists are equal iff they have the same `size` \nand for every index either:\n\n- the lists both have the element `null`, or\n- the lists both have a non-null element, and the\n  two elements are equal.\n\nAs a special exception, a [[String]] is not equal to \nany list which is not also a [[String]].")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Two `List`s are considered equal iff they have the \nsame `size` and _entry sets_. The entry set of a list \n`list` is the set of elements of `list.indexed`. This \ndefinition is equivalent to the more intuitive notion \nthat two lists are equal iff they have the same `size` \nand for every index either:\n\n- the lists both have the element `null`, or\n- the lists both have a non-null element, and the\n  two elements are equal.\n\nAs a special exception, a [[String]] is not equal to \nany list which is not also a [[String]]."})})
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean equals(@Name(value="that") @TypeInfo(value="ceylon.language::Object") Object var1);

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L)
    @TypeInfo(value="ceylon.language::Integer")
    @Transient
    public int hashCode();

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L)
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean shorterThan(@Name(value="length") @TypeInfo(value="ceylon.language::Integer") long var1);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L)
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean longerThan(@Name(value="length") @TypeInfo(value="ceylon.language::Integer") long var1);

    @DocAnnotation$annotation$(description="A list containing the elements of this list repeated \nthe [[given number of times|times]], or an empty list\nif `times<=0`. For every `index` of a repeated `list`:\n\n    list.repeat(n)[index]==list[index%n]\n\nThis is a lazy operation returning a view of this list.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"A list containing the elements of this list repeated \nthe [[given number of times|times]], or an empty list\nif `times<=0`. For every `index` of a repeated `list`:\n\n    list.repeat(n)[index]==list[index%n]\n\nThis is a lazy operation returning a view of this list."})})
    @TypeInfo(value="ceylon.language::List<Element>")
    public List<? extends Element> repeat(@Name(value="times") @TypeInfo(value="ceylon.language::Integer") long var1);

    @Override
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=322L)
    @TypeInfo(value="Element?")
    public Element find(@Name(value="selecting") @FunctionalParameter(value="(elem)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") Callable<? extends Boolean> var1);

    @Override
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=322L)
    @TypeInfo(value="Element?")
    public Element findLast(@Name(value="selecting") @FunctionalParameter(value="(elem)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") Callable<? extends Boolean> var1);

    @DocAnnotation$annotation$(description="A sublist of this list, starting at the element with\nthe given [[index|from]].\n\nThis is a lazy operation, returning a view of this list.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Fskip"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"A sublist of this list, starting at the element with\nthe given [[index|from]].\n\nThis is a lazy operation, returning a view of this list."}), @Annotation(value="see", arguments={"skip"})})
    @TypeInfo(value="ceylon.language::List<Element>")
    public List<? extends Element> sublistFrom(@Name(value="from") @TypeInfo(value="ceylon.language::Integer") long var1);

    @DocAnnotation$annotation$(description="A sublist of this list, ending at the element with the \ngiven [[index|to]].\n\nThis is a lazy operation, returning a view of this list.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Ftake", "::1.2.2:ceylon.language::IList.Finitial"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"A sublist of this list, ending at the element with the \ngiven [[index|to]].\n\nThis is a lazy operation, returning a view of this list."}), @Annotation(value="see", arguments={"take", "initial"})})
    @TypeInfo(value="ceylon.language::List<Element>")
    public List<? extends Element> sublistTo(@Name(value="to") @TypeInfo(value="ceylon.language::Integer") long var1);

    @DocAnnotation$annotation$(description="A sublist of this list, starting at the element with\nindex [[from]], ending at the element with the index \n[[to]].\n\nThis is a lazy operation, returning a view of this list.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"A sublist of this list, starting at the element with\nindex [[from]], ending at the element with the index \n[[to]].\n\nThis is a lazy operation, returning a view of this list."})})
    @TypeInfo(value="ceylon.language::List<Element>")
    public List<? extends Element> sublist(@Name(value="from") @TypeInfo(value="ceylon.language::Integer") long var1, @Name(value="to") @TypeInfo(value="ceylon.language::Integer") long var3);

    @Ignore
    public <Other> List patch(TypeDescriptor var1, List<? extends Other> var2);

    @Ignore
    public <Other> long patch$from(TypeDescriptor var1, List<? extends Other> var2);

    @Ignore
    public <Other> List patch(TypeDescriptor var1, List<? extends Other> var2, long var3);

    @Ignore
    public <Other> long patch$length(TypeDescriptor var1, List<? extends Other> var2, long var3);

    @DocAnnotation$annotation$(description="Return a list formed by patching the given [[list]] \nin place of a segment of this list identified by the\ngiven [[starting index|from]] and [[length]].\n\nThis is a lazy operations, returning a view over this \nlist and the given list.\n\nFour special cases are interesting:\n\n- If `length==0`, the patched list has the given values \n  \"inserted\" into this list at the given index `from`.\n- If the given `list` is empty, the patched list has \n  the measure of this list identified by `from:length` \n  \"deleted\".\n- If `from==size`, the patched list is formed by\n  appending the given list.\n- If `from==0`, the patched list is formed by \n  prepending the given list.\n\nFor example:\n\n- `(-2..2).patch([], 1, 3)` produces the list `{-2, 2}`,\n- `[-2, 2].patch(-1..1, 1)` produces the list \n  `{-2, -1, 0, 1, 2}`, and\n- `0:3.patch(2..0)` produces the list \n  `{0, 1, 2, 2, 1, 0}`.\n\nFinally, to patch a single element, leaving the `size`\nof the list unchanged, explicitly specify `length==1`:\n\n- `[0, 1, 0, 1].patch([-1], 2, 1)` produces the list\n  `{0, 1, -1, 1}`.\n\nIf `length<0`, or if `from` is outside the range \n`0..size`, return this list.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Return a list formed by patching the given [[list]] \nin place of a segment of this list identified by the\ngiven [[starting index|from]] and [[length]].\n\nThis is a lazy operations, returning a view over this \nlist and the given list.\n\nFour special cases are interesting:\n\n- If `length==0`, the patched list has the given values \n  \"inserted\" into this list at the given index `from`.\n- If the given `list` is empty, the patched list has \n  the measure of this list identified by `from:length` \n  \"deleted\".\n- If `from==size`, the patched list is formed by\n  appending the given list.\n- If `from==0`, the patched list is formed by \n  prepending the given list.\n\nFor example:\n\n- `(-2..2).patch([], 1, 3)` produces the list `{-2, 2}`,\n- `[-2, 2].patch(-1..1, 1)` produces the list \n  `{-2, -1, 0, 1, 2}`, and\n- `0:3.patch(2..0)` produces the list \n  `{0, 1, 2, 2, 1, 0}`.\n\nFinally, to patch a single element, leaving the `size`\nof the list unchanged, explicitly specify `length==1`:\n\n- `[0, 1, 0, 1].patch([-1], 2, 1)` produces the list\n  `{0, 1, -1, 1}`.\n\nIf `length<0`, or if `from` is outside the range \n`0..size`, return this list."})})
    @TypeInfo(value="ceylon.language::List<Element|Other>", erased=true)
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={}, caseTypes={})})
    public <Other> List patch(@Ignore TypeDescriptor var1, @Name(value="list") @TypeInfo(value="ceylon.language::List<Other>") @DocAnnotation$annotation$(description="The list of new elements.") @Annotations(value={@Annotation(value="doc", arguments={"The list of new elements."})}) List<? extends Other> var2, @Name(value="from") @Defaulted @TypeInfo(value="ceylon.language::Integer") @DocAnnotation$annotation$(description="The index at which the elements will occur, and\nthe start index of the segment to replace.") @Annotations(value={@Annotation(value="doc", arguments={"The index at which the elements will occur, and\nthe start index of the segment to replace."})}) long var3, @Name(value="length") @Defaulted @TypeInfo(value="ceylon.language::Integer") @DocAnnotation$annotation$(description="The length of the segment to replace.") @Annotations(value={@Annotation(value="doc", arguments={"The length of the segment to replace."})}) long var5);

    @DocAnnotation$annotation$(description="Determine if the given [[list|sublist]] occurs at the \nstart of this list.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IList.FendsWith"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Determine if the given [[list|sublist]] occurs at the \nstart of this list."}), @Annotation(value="see", arguments={"endsWith"})})
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean startsWith(@Name(value="sublist") @TypeInfo(value="ceylon.language::List<ceylon.language::Anything>") List<? extends Object> var1);

    @DocAnnotation$annotation$(description="Determine if the given [[list|sublist]] occurs at the \nend of this list.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IList.FstartsWith"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Determine if the given [[list|sublist]] occurs at the \nend of this list."}), @Annotation(value="see", arguments={"startsWith"})})
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean endsWith(@Name(value="sublist") @TypeInfo(value="ceylon.language::List<ceylon.language::Anything>") List<? extends Object> var1);

    @DocAnnotation$annotation$(description="The indexes in this list for which the element is not\nnull and satisfies the given \n[[predicate function|selecting]].")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Flocations"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The indexes in this list for which the element is not\nnull and satisfies the given \n[[predicate function|selecting]]."}), @Annotation(value="see", arguments={"locations"})})
    @TypeInfo(value="{ceylon.language::Integer*}")
    public Iterable<? extends Integer, ? extends Object> indexesWhere(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @Annotations(value={@Annotation(value="doc", arguments={"The predicate function the indexed elements must \nsatisfy."})}) Callable<? extends Boolean> var1);

    @DocAnnotation$annotation$(description="The first index in this list for which the element is\nnot null and satisfies the given \n[[predicate function|selecting]].")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.Flocate"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The first index in this list for which the element is\nnot null and satisfies the given \n[[predicate function|selecting]]."}), @Annotation(value="see", arguments={"locate"})})
    @TypeInfo(value="ceylon.language::Integer?")
    public Integer firstIndexWhere(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @Annotations(value={@Annotation(value="doc", arguments={"The predicate function the indexed elements must \nsatisfy."})}) Callable<? extends Boolean> var1);

    @DocAnnotation$annotation$(description="The last index in this list for which the element is\nnot null and satisfies the given \n[[predicate function|selecting]].")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IIterable.FlocateLast"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The last index in this list for which the element is\nnot null and satisfies the given \n[[predicate function|selecting]]."}), @Annotation(value="see", arguments={"locateLast"})})
    @TypeInfo(value="ceylon.language::Integer?")
    public Integer lastIndexWhere(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @Annotations(value={@Annotation(value="doc", arguments={"The predicate function the indexed elements must \nsatisfy."})}) Callable<? extends Boolean> var1);

    @DocAnnotation$annotation$(description="Trim the elements satisfying the given [[predicate \nfunction|trimming]], along with any null elements, from \nthe start and end of this list, returning a list no \nlonger than this list.\n\nThis is an eager operation.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Trim the elements satisfying the given [[predicate \nfunction|trimming]], along with any null elements, from \nthe start and end of this list, returning a list no \nlonger than this list.\n\nThis is an eager operation."})})
    @TypeInfo(value="ceylon.language::List<Element>")
    public List<? extends Element> trim(@Name(value="trimming") @FunctionalParameter(value="(elem)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @Annotations(value={@Annotation(value="doc", arguments={"The predicate function that the trimmed elements \nsatisfy."})}) Callable<? extends Boolean> var1);

    @DocAnnotation$annotation$(description="Trim the elements satisfying the given [[predicate \nfunction|trimming]], along with any null elements, from\nthe start of this list, returning a list no longer than \nthis list.\n\nThis is an eager operation.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Trim the elements satisfying the given [[predicate \nfunction|trimming]], along with any null elements, from\nthe start of this list, returning a list no longer than \nthis list.\n\nThis is an eager operation."})})
    @TypeInfo(value="ceylon.language::List<Element>")
    public List<? extends Element> trimLeading(@Name(value="trimming") @FunctionalParameter(value="(elem)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @Annotations(value={@Annotation(value="doc", arguments={"The predicate function that the trimmed elements \nsatisfy."})}) Callable<? extends Boolean> var1);

    @DocAnnotation$annotation$(description="Trim the elements satisfying the given [[predicate \nfunction|trimming]], along with any null elements, from \nthe end of this list, returning a list no longer than \nthis list.\n\nThis is an eager operation.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Trim the elements satisfying the given [[predicate \nfunction|trimming]], along with any null elements, from \nthe end of this list, returning a list no longer than \nthis list.\n\nThis is an eager operation."})})
    @TypeInfo(value="ceylon.language::List<Element>")
    public List<? extends Element> trimTrailing(@Name(value="trimming") @FunctionalParameter(value="(elem)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @Annotations(value={@Annotation(value="doc", arguments={"The predicate function that the trimmed elements \nsatisfy."})}) Callable<? extends Boolean> var1);

    @DocAnnotation$annotation$(description="Return two lists, the first containing the elements\nthat occur before the given [[index]], the second with\nthe elements that occur after the given `index`. If the\ngiven `index` is outside the range of indices of this\nlist, one of the returned lists will be empty.\n\nFor any `list`, and for any integer `index`:\n\n    list.slice(index) == [list[...index-1], list[index...]]\n\nThis is an eager operation.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Return two lists, the first containing the elements\nthat occur before the given [[index]], the second with\nthe elements that occur after the given `index`. If the\ngiven `index` is outside the range of indices of this\nlist, one of the returned lists will be empty.\n\nFor any `list`, and for any integer `index`:\n\n    list.slice(index) == [list[...index-1], list[index...]]\n\nThis is an eager operation."})})
    @TypeInfo(value="ceylon.language::List<Element>[2]", erased=true)
    public Sequence<? extends List<? extends Element>> slice(@Name(value="index") @TypeInfo(value="ceylon.language::Integer") long var1);

    @DocAnnotation$annotation$(description="Select the first elements of this list, returning a \nlist no longer than the given length. If this list is \nshorter than the given length, return this list. \nOtherwise return a list of the given length. If \n`length<=0` return an empty list.\n\nFor any `list`, and for any integer `length`:\n\n    list.initial(length) == list[...length-1] == list[0:length]\n\nThis is an eager operation.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IList.Fterminal", "::1.2.2:ceylon.language::IList.FsublistTo", "::1.2.2:ceylon.language::IIterable.Ftake"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Select the first elements of this list, returning a \nlist no longer than the given length. If this list is \nshorter than the given length, return this list. \nOtherwise return a list of the given length. If \n`length<=0` return an empty list.\n\nFor any `list`, and for any integer `length`:\n\n    list.initial(length) == list[...length-1] == list[0:length]\n\nThis is an eager operation."}), @Annotation(value="see", arguments={"terminal", "sublistTo", "take"})})
    @TypeInfo(value="ceylon.language::List<Element>")
    public List<? extends Element> initial(@Name(value="length") @TypeInfo(value="ceylon.language::Integer") long var1);

    @DocAnnotation$annotation$(description="Select the last elements of the list, returning a list \nno longer than the given length. If this list is \nshorter than the given length, return this list. \nOtherwise return a list of the given length.\n\nFor any `list`, and for any integer `length`:\n\n    list.terminal(length) == list[size-length...]\n\nThis is an eager operation.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IList.Finitial"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Select the last elements of the list, returning a list \nno longer than the given length. If this list is \nshorter than the given length, return this list. \nOtherwise return a list of the given length.\n\nFor any `list`, and for any integer `length`:\n\n    list.terminal(length) == list[size-length...]\n\nThis is an eager operation."}), @Annotation(value="see", arguments={"initial"})})
    @TypeInfo(value="ceylon.language::List<Element>")
    public List<? extends Element> terminal(@Name(value="length") @TypeInfo(value="ceylon.language::Integer") long var1);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L)
    @TypeInfo(value="ceylon.language::List<Element>")
    public List<? extends Element> span(@Name(value="from") @TypeInfo(value="ceylon.language::Integer") Integer var1, @Name(value="to") @TypeInfo(value="ceylon.language::Integer") Integer var2);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L)
    @TypeInfo(value="ceylon.language::List<Element>")
    public List<? extends Element> spanFrom(@Name(value="from") @TypeInfo(value="ceylon.language::Integer") Integer var1);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L)
    @TypeInfo(value="ceylon.language::List<Element>")
    public List<? extends Element> spanTo(@Name(value="to") @TypeInfo(value="ceylon.language::Integer") Integer var1);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L)
    @TypeInfo(value="ceylon.language::List<Element>")
    public List<? extends Element> measure(@Name(value="from") @TypeInfo(value="ceylon.language::Integer") Integer var1, @Name(value="length") @TypeInfo(value="ceylon.language::Integer") long var2);

    @Override
    @DocAnnotation$annotation$(description="A sequence containing the results of applying the given \nmapping to the elements of this list.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"A sequence containing the results of applying the given \nmapping to the elements of this list."})})
    @TypeInfo(value="Result[]")
    @TypeParameters(value={@TypeParameter(value="Result", variance=Variance.NONE, satisfies={}, caseTypes={})})
    public <Result> Sequential<? extends Result> collect(@Ignore TypeDescriptor var1, @Name(value="collecting") @FunctionalParameter(value="(element)") @TypeInfo(value="Result(Element)") @Annotations(value={@Annotation(value="doc", arguments={"The transformation applied to the elements."})}) Callable<? extends Result> var2);
}

