/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.Iterable;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.SharedAnnotation$annotation$;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.CaseTypes;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;

@Ceylon(major=8)
@DocAnnotation$annotation$(description="Abstract supertype of _ranged streams_ mapping a range of \ndiscrete indices to elements of the stream, and supporting \noperations that produce a subrange of indexed elements. The \ntype parameter [[Subrange]] abstracts the type of the \nresulting subrange. A subrange may be obtained from an \ninstance of `Ranged` using the _span_ and _measure_ \noperators.\n\nOften, in a [[List]] or sorted map for example, an index\nand its element are distinct values. Sometimes, in a sorted \nset for example, the index and element are identical.\n\nThe _span_ operator accepts the first and last indices of \nthe subrange.\n\n    print(\"hello world\"[0..4]); //prints \"hello\"\n    print(\"hello world\"[6..6]); //prints \"w\"\n\nIf the last index is smaller than the first index, the\nsubrange is reversed.\n\n    print(\"hello world\"[4..0]); //prints \"olleh\"\n\nIf the range of indices identified by the first and last\nindices is outside the range of indices of this object, an\nempty subrange is produced.\n\n    print(\"hello world\"[-5..-1]); //prints \"\"\n    print(\"hello world\"[11..11]); //prints \"\"\n\nThe first index may be omitted, implying that the subrange\nextends forward from the smallest possible index (in this\ncase `runtime.minIntegerValue`) to the given index.\n\n    print(\"hello world\"[...4]) //prints \"hello\"\n\nIf the first index is before the first index of this object, \nthe first index of the object is used.\n\n    print(\"hello world\"[-5...]); //prints \"hello world\"\n\nThe last index may be omitted, implying that the subrange \nextends forward from the given index to the largest \npossible index (in this case `runtime.maxIntegerValue`).\n\n    print(\"hello world\"[6...]) //prints \"world\"\n\nIf the last index is after the last index of this object, \nan empty subrange is produced. (A reversed subrange is \nnever produced.)\n\n    print(\"hello world\"[11...]); //prints \"\"\n\nThe _measure_ operator accepts the first index and maximum \nlength of the subrange.\n\n    print(\"hello world\"[6:5]) //prints \"world\"\n    print(\"hello world\"[6:0]) //prints \"\"\n\nIf the length is nonpositive, the subrange is empty. If the\nrange of indices identified by the first index and length\nis outside the range of indices of this object, an empty\nsubrange is produced. (A reversed subrange is never \nproduced.)\n\n    print(\"hello world\"[-3:3]) //prints \"\"\n    print(\"hello world\"[11:3]) //prints \"\"\n    print(\"hello world\"[6:-3]) //prints \"\"\n\nThe span and measure operations must be consistent. That is, \nfor every pair of indices `x` and `y` in the ranged object \n`ranged` such that `y` does not occur before `x` and the \nspan `ranged[x..y]` has length `n`:\n\n- `ranged[x..y]==ranged[x:n]`.")
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::IList", "::1.2.2:ceylon.language::ISequence", "::1.2.2:ceylon.language::CString"})})
@SharedAnnotation$annotation$
@Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"Abstract supertype of _ranged streams_ mapping a range of \ndiscrete indices to elements of the stream, and supporting \noperations that produce a subrange of indexed elements. The \ntype parameter [[Subrange]] abstracts the type of the \nresulting subrange. A subrange may be obtained from an \ninstance of `Ranged` using the _span_ and _measure_ \noperators.\n\nOften, in a [[List]] or sorted map for example, an index\nand its element are distinct values. Sometimes, in a sorted \nset for example, the index and element are identical.\n\nThe _span_ operator accepts the first and last indices of \nthe subrange.\n\n    print(\"hello world\"[0..4]); //prints \"hello\"\n    print(\"hello world\"[6..6]); //prints \"w\"\n\nIf the last index is smaller than the first index, the\nsubrange is reversed.\n\n    print(\"hello world\"[4..0]); //prints \"olleh\"\n\nIf the range of indices identified by the first and last\nindices is outside the range of indices of this object, an\nempty subrange is produced.\n\n    print(\"hello world\"[-5..-1]); //prints \"\"\n    print(\"hello world\"[11..11]); //prints \"\"\n\nThe first index may be omitted, implying that the subrange\nextends forward from the smallest possible index (in this\ncase `runtime.minIntegerValue`) to the given index.\n\n    print(\"hello world\"[...4]) //prints \"hello\"\n\nIf the first index is before the first index of this object, \nthe first index of the object is used.\n\n    print(\"hello world\"[-5...]); //prints \"hello world\"\n\nThe last index may be omitted, implying that the subrange \nextends forward from the given index to the largest \npossible index (in this case `runtime.maxIntegerValue`).\n\n    print(\"hello world\"[6...]) //prints \"world\"\n\nIf the last index is after the last index of this object, \nan empty subrange is produced. (A reversed subrange is \nnever produced.)\n\n    print(\"hello world\"[11...]); //prints \"\"\n\nThe _measure_ operator accepts the first index and maximum \nlength of the subrange.\n\n    print(\"hello world\"[6:5]) //prints \"world\"\n    print(\"hello world\"[6:0]) //prints \"\"\n\nIf the length is nonpositive, the subrange is empty. If the\nrange of indices identified by the first index and length\nis outside the range of indices of this object, an empty\nsubrange is produced. (A reversed subrange is never \nproduced.)\n\n    print(\"hello world\"[-3:3]) //prints \"\"\n    print(\"hello world\"[11:3]) //prints \"\"\n    print(\"hello world\"[6:-3]) //prints \"\"\n\nThe span and measure operations must be consistent. That is, \nfor every pair of indices `x` and `y` in the ranged object \n`ranged` such that `y` does not occur before `x` and the \nspan `ranged[x..y]` has length `n`:\n\n- `ranged[x..y]==ranged[x:n]`."}), @Annotation(value="see", arguments={"List", "Sequence", "String"})})
@SatisfiedTypes(value={"{Element*}"})
@CaseTypes(of="Subrange")
@TypeParameters(value={@TypeParameter(value="Index", variance=Variance.IN, satisfies={}, caseTypes={}), @TypeParameter(value="Element", variance=Variance.OUT, satisfies={}, caseTypes={}), @TypeParameter(value="Subrange", variance=Variance.OUT, satisfies={"ceylon.language::Ranged<Index,Element,Subrange>"}, caseTypes={})})
public interface Ranged<Index, Element, Subrange extends Ranged<? super Index, Element, ? extends Subrange>>
extends Iterable<Element, Object> {
    @DocAnnotation$annotation$(description="Obtain a span containing the elements between the two \ngiven indices. \n\nThe span should contain elements of this stream, \nstarting from the element at the given [[starting \nindex|from]], and ending with the element at the given \n[[ending index|to]], in the same order as they are \nproduced by the [[iterator]] of the stream, except when \nthe ending index occurs earlier than the starting index, \nin which case they occur in the opposite order.\n\nWhen one or both of the given indices does not belong \nto this ranged stream, the behavior is implementation \ndependent.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Obtain a span containing the elements between the two \ngiven indices. \n\nThe span should contain elements of this stream, \nstarting from the element at the given [[starting \nindex|from]], and ending with the element at the given \n[[ending index|to]], in the same order as they are \nproduced by the [[iterator]] of the stream, except when \nthe ending index occurs earlier than the starting index, \nin which case they occur in the opposite order.\n\nWhen one or both of the given indices does not belong \nto this ranged stream, the behavior is implementation \ndependent."})})
    @TypeInfo(value="Subrange", erased=true)
    public Subrange span(@Name(value="from") @TypeInfo(value="Index") Index var1, @Name(value="to") @TypeInfo(value="Index") Index var2);

    @DocAnnotation$annotation$(description="Obtain a span containing the elements between the given\n[[starting index|from]] and the last index of this \nranged object.\n\nThe span should contain elements of this stream, \nstarting from the element at the given [[starting \nindex|from]], in the same order as they are produced by \nthe [[iterator]] of the stream.\n\nWhen the given index does not belong to this ranged \nstream, the behavior is implementation dependent.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Obtain a span containing the elements between the given\n[[starting index|from]] and the last index of this \nranged object.\n\nThe span should contain elements of this stream, \nstarting from the element at the given [[starting \nindex|from]], in the same order as they are produced by \nthe [[iterator]] of the stream.\n\nWhen the given index does not belong to this ranged \nstream, the behavior is implementation dependent."})})
    @TypeInfo(value="Subrange", erased=true)
    public Subrange spanFrom(@Name(value="from") @TypeInfo(value="Index") Index var1);

    @DocAnnotation$annotation$(description="Obtain a span containing the elements between the first \nindex of this ranged stream and given [[end index|to]].\n\nThe span should contain elements of this stream, up to \nthe element at the given [[ending index|to]], in the \nsame order as they are produced by the [[iterator]] of\nthe stream.\n\nWhen the given index does not belong to this ranged \nstream, the behavior is implementation dependent.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Obtain a span containing the elements between the first \nindex of this ranged stream and given [[end index|to]].\n\nThe span should contain elements of this stream, up to \nthe element at the given [[ending index|to]], in the \nsame order as they are produced by the [[iterator]] of\nthe stream.\n\nWhen the given index does not belong to this ranged \nstream, the behavior is implementation dependent."})})
    @TypeInfo(value="Subrange", erased=true)
    public Subrange spanTo(@Name(value="to") @TypeInfo(value="Index") Index var1);

    @DocAnnotation$annotation$(description="Obtain a measure containing the mapped values starting \nfrom the given [[starting index|from]], with the given \n[[length]]. If `length<=0`, the resulting measure is \nempty.\n\nThe measure should contain the given [[number|length]] \nof elements of this stream, starting from the element \nat the given [[starting index|from]], in the same order \nas they are produced by the [[iterator]] of the stream. \nIn the case where the iterator would be exhausted \nbefore [[length]] elements are produced, the resulting \nmeasure contains only those elements which were \nproduced before the iterator was exhausted, and the \nlength of the measure is less then the given `length`.\n\nWhen the given index does not belong to this ranged \nobject, the behavior is implementation dependent.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Obtain a measure containing the mapped values starting \nfrom the given [[starting index|from]], with the given \n[[length]]. If `length<=0`, the resulting measure is \nempty.\n\nThe measure should contain the given [[number|length]] \nof elements of this stream, starting from the element \nat the given [[starting index|from]], in the same order \nas they are produced by the [[iterator]] of the stream. \nIn the case where the iterator would be exhausted \nbefore [[length]] elements are produced, the resulting \nmeasure contains only those elements which were \nproduced before the iterator was exhausted, and the \nlength of the measure is less then the given `length`.\n\nWhen the given index does not belong to this ranged \nobject, the behavior is implementation dependent."})})
    @TypeInfo(value="Subrange", erased=true)
    public Subrange measure(@Name(value="from") @TypeInfo(value="Index") Index var1, @Name(value="length") @TypeInfo(value="ceylon.language::Integer") long var2);
}

