/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.Collection;
import ceylon.language.DefaultAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.Iterable;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.Set$impl;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.TagsAnnotation$annotation$;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

@Ceylon(major=8)
@DocAnnotation$annotation$(description="A collection in which each distinct element occurs at most \nonce. Two non-[[identical|Identifiable]] values are \nconsidered distinct only if they are unequal, according to\ntheir own definition of [[value equality|Object.equals]].\n\nA `Set` is a [[Collection]] of its elements. Sets may not\nhave [[null|Null]] elements.\n\nA new `Set` may be obtained by calling the function [[set]].\n    \n    value words = set { \"hello\", \"world\" };\n    value greetings = set { \"hello\", \"goodbye\", \"hola\", \"adios\" };\n\nThe [[emptySet]] is a `Set` with no elements.\n\nSets may be the subject of the binary union, intersection, \nand complement operators `|`, `&`, and `~`.\n\n    value greetingsInWords = words & greetings;\n    value allWords = words | greetings;\n\nAn implementation of `Set` may compare elements for \nequality using [[Object.equals]] or [[Comparable.compare]].")
@TagsAnnotation$annotation$(tags={"Collections"})
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::Fset", "::1.2.2:ceylon.language::VemptySet"})})
@SharedAnnotation$annotation$
@Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"A collection in which each distinct element occurs at most \nonce. Two non-[[identical|Identifiable]] values are \nconsidered distinct only if they are unequal, according to\ntheir own definition of [[value equality|Object.equals]].\n\nA `Set` is a [[Collection]] of its elements. Sets may not\nhave [[null|Null]] elements.\n\nA new `Set` may be obtained by calling the function [[set]].\n    \n    value words = set { \"hello\", \"world\" };\n    value greetings = set { \"hello\", \"goodbye\", \"hola\", \"adios\" };\n\nThe [[emptySet]] is a `Set` with no elements.\n\nSets may be the subject of the binary union, intersection, \nand complement operators `|`, `&`, and `~`.\n\n    value greetingsInWords = words & greetings;\n    value allWords = words | greetings;\n\nAn implementation of `Set` may compare elements for \nequality using [[Object.equals]] or [[Comparable.compare]]."}), @Annotation(value="tagged", arguments={"Collections"}), @Annotation(value="see", arguments={"set", "emptySet"})})
@SatisfiedTypes(value={"ceylon.language::Collection<Element>"})
@TypeParameters(value={@TypeParameter(value="Element", variance=Variance.OUT, satisfies={"ceylon.language::Object"}, caseTypes={}, defaultValue="ceylon.language::Object")})
public interface Set<Element>
extends Collection<Element> {
    @Ignore
    public Set$impl<? extends Element> $ceylon$language$Set$impl();

    @Override
    @DocAnnotation$annotation$(description="The fundamental operation for `Set`s. Determines if the\ngiven value belongs to this set.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"The fundamental operation for `Set`s. Determines if the\ngiven value belongs to this set."})})
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean contains(@Name(value="element") @TypeInfo(value="ceylon.language::Object") Object var1);

    @Override
    @DocAnnotation$annotation$(description="A shallow copy of this set, that is, a set with the\nsame elements as this set, which do not change if the\nelements of this set change.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=194L, value={@Annotation(value="doc", arguments={"A shallow copy of this set, that is, a set with the\nsame elements as this set, which do not change if the\nelements of this set change."})})
    @TypeInfo(value="ceylon.language::Set<Element>")
    public Set<? extends Element> $clone();

    @DocAnnotation$annotation$(description="Determines if this set is a superset of the given \n`Set`, that is, if this set contains all of the \nelements in the given set.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Determines if this set is a superset of the given \n`Set`, that is, if this set contains all of the \nelements in the given set."})})
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean superset(@Name(value="set") @TypeInfo(value="ceylon.language::Set<ceylon.language::Object>") Set<? extends Object> var1);

    @DocAnnotation$annotation$(description="Determines if this set is a subset of the given `Set`, \nthat is, if the given set contains all of the elements \nin this set.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Determines if this set is a subset of the given `Set`, \nthat is, if the given set contains all of the elements \nin this set."})})
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean subset(@Name(value="set") @TypeInfo(value="ceylon.language::Set<ceylon.language::Object>") Set<? extends Object> var1);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="{Element*}")
    @Transient
    public Iterable<? extends Element, ? extends Object> getDistinct();

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="{Element*}", erased=true, untrusted=true)
    @TypeParameters(value={@TypeParameter(value="Default", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={})})
    public <Default> Iterable defaultNullElements(@Ignore TypeDescriptor var1, @Name(value="defaultValue") @TypeInfo(value="Default") Default var2);

    @DocAnnotation$annotation$(description="Returns a new `Set` containing all the elements of this \nset and all the elements of the given `Set`.\n\nFor example:\n\n    set { \"hello\", \"world\" } | set { 1, 2, \"hello\" }\n\nProduces the set `{ \"hello\", \"world\", 1, 2 }` of \ntype `Set<String|Integer>`.\n\nNote that it is possible for two sets of disjoint \nelement type to be considered to have elements in \ncommon. For example, since `1==1.0` \n[[evaluates to true|Integer.equals]], \nthe expression \n\n    set { 1 } | set { 1.0 }\n\nproduces the set `{ 1 }`.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Returns a new `Set` containing all the elements of this \nset and all the elements of the given `Set`.\n\nFor example:\n\n    set { \"hello\", \"world\" } | set { 1, 2, \"hello\" }\n\nProduces the set `{ \"hello\", \"world\", 1, 2 }` of \ntype `Set<String|Integer>`.\n\nNote that it is possible for two sets of disjoint \nelement type to be considered to have elements in \ncommon. For example, since `1==1.0` \n[[evaluates to true|Integer.equals]], \nthe expression \n\n    set { 1 } | set { 1.0 }\n\nproduces the set `{ 1 }`."})})
    @TypeInfo(value="ceylon.language::Set<Element|Other>", erased=true)
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={})})
    public <Other> Set union(@Ignore TypeDescriptor var1, @Name(value="set") @TypeInfo(value="ceylon.language::Set<Other>") Set<? extends Other> var2);

    @DocAnnotation$annotation$(description="Returns a new `Set` containing only the elements that \nare present in both this set and the given `Set` and \nthat are instances of the intersection `Element&Other` \nof the element types of the two sets.\n\nFor example:\n\n    set { \"hello\", \"world\" } & set { 1, 2, \"hello\" }\n\nProduces the set `{ \"hello\" }` of type `Set<String>`.\n\nNote that, according to this definition, and even \nthough `1==1.0` [[evaluates to true|Integer.equals]], \nthe expression\n\n    set { 1 } & set { 1.0 }\n\nproduces the empty set `{}`.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Returns a new `Set` containing only the elements that \nare present in both this set and the given `Set` and \nthat are instances of the intersection `Element&Other` \nof the element types of the two sets.\n\nFor example:\n\n    set { \"hello\", \"world\" } & set { 1, 2, \"hello\" }\n\nProduces the set `{ \"hello\" }` of type `Set<String>`.\n\nNote that, according to this definition, and even \nthough `1==1.0` [[evaluates to true|Integer.equals]], \nthe expression\n\n    set { 1 } & set { 1.0 }\n\nproduces the empty set `{}`."})})
    @TypeInfo(value="ceylon.language::Set<Element&Other>", erased=true)
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={})})
    public <Other> Set intersection(@Ignore TypeDescriptor var1, @Name(value="set") @TypeInfo(value="ceylon.language::Set<Other>") Set<? extends Other> var2);

    @DocAnnotation$annotation$(description="Returns a new `Set` containing all the elements in this \nset that are not contained in the given `Set`.\n\nFor example:\n\n    set { \"hello\", \"world\" } ~ set { 1, 2, \"hello\" }\n\nProduces the set `{ \"world\" }` of type `Set<String>`.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Returns a new `Set` containing all the elements in this \nset that are not contained in the given `Set`.\n\nFor example:\n\n    set { \"hello\", \"world\" } ~ set { 1, 2, \"hello\" }\n\nProduces the set `{ \"world\" }` of type `Set<String>`."})})
    @TypeInfo(value="ceylon.language::Set<Element>")
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={})})
    public <Other> Set<? extends Element> complement(@Ignore TypeDescriptor var1, @Name(value="set") @TypeInfo(value="ceylon.language::Set<Other>") Set<? extends Other> var2);

    @DocAnnotation$annotation$(description="Returns a new `Set` containing only the elements \ncontained in either this set or the given `Set`, but no \nelement contained in both sets.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Returns a new `Set` containing only the elements \ncontained in either this set or the given `Set`, but no \nelement contained in both sets."})})
    @TypeInfo(value="ceylon.language::Set<Element|Other>", erased=true)
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={})})
    public <Other> Set exclusiveUnion(@Ignore TypeDescriptor var1, @Name(value="set") @TypeInfo(value="ceylon.language::Set<Other>") Set<? extends Other> var2);

    @DocAnnotation$annotation$(description="Two `Set`s are considered equal if they have the same \nsize and if every element of the first set is also an \nelement of the second set, as determined by \n[[contains]]. Equivalently, a set is equal to a second \nset if it is both a subset and a superset of the second\nset.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Two `Set`s are considered equal if they have the same \nsize and if every element of the first set is also an \nelement of the second set, as determined by \n[[contains]]. Equivalently, a set is equal to a second \nset if it is both a subset and a superset of the second\nset."})})
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean equals(@Name(value="that") @TypeInfo(value="ceylon.language::Object") Object var1);

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L)
    @TypeInfo(value="ceylon.language::Integer")
    @Transient
    public int hashCode();
}

