/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.AssertionError;
import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Category$impl;
import ceylon.language.Comparison;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Entry;
import ceylon.language.Enumerable;
import ceylon.language.FinalAnnotation$annotation$;
import ceylon.language.Finished;
import ceylon.language.Integer;
import ceylon.language.Iterable;
import ceylon.language.Iterable$impl;
import ceylon.language.Iterator;
import ceylon.language.Map;
import ceylon.language.Measure;
import ceylon.language.Object;
import ceylon.language.OverflowException;
import ceylon.language.Range;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.Sequence;
import ceylon.language.Sequential;
import ceylon.language.SerializableAnnotation$annotation$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.VariableAnnotation$annotation$;
import ceylon.language.empty_;
import ceylon.language.finished_;
import ceylon.language.impl.MemberImpl;
import ceylon.language.larger_;
import ceylon.language.meta.declaration.ClassOrInterfaceDeclaration;
import ceylon.language.meta.declaration.FunctionDeclaration;
import ceylon.language.meta.declaration.FunctionOrValueDeclaration;
import ceylon.language.meta.declaration.ValueDeclaration;
import ceylon.language.runtime_;
import ceylon.language.serialization.Member;
import ceylon.language.serialization.ReachableReference;
import ceylon.language.span_;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.language.EnumeratedTypeError;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.metadata.Container;
import com.redhat.ceylon.compiler.java.metadata.FunctionalParameter;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Jpa;
import com.redhat.ceylon.compiler.java.metadata.LocalDeclaration;
import com.redhat.ceylon.compiler.java.metadata.LocalDeclarations;
import com.redhat.ceylon.compiler.java.metadata.Members;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.compiler.java.runtime.serialization.$Serialization$;
import com.redhat.ceylon.compiler.java.runtime.serialization.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Collection;

@Ceylon(major=8)
@DocAnnotation$annotation$(description="A [[Range]] of adjacent [[Enumerable]] values generated by \ntwo endpoints: [[first]] and [[last]]. The range includes \nboth endpoints, and all values falling _between_ the \nendpoints.")
@AuthorsAnnotation$annotation$(authors={"Gavin"})
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::CMeasure", "::1.2.2:ceylon.language::IEnumerable"})})
@FinalAnnotation$annotation$
@SerializableAnnotation$annotation$
@Members(value={@com.redhat.ceylon.compiler.java.metadata.Member(klass=By.class)})
@LocalDeclarations(value={"1anonymous_0_"})
@Annotations(modifiers=4128L, value={@Annotation(value="doc", arguments={"A [[Range]] of adjacent [[Enumerable]] values generated by \ntwo endpoints: [[first]] and [[last]]. The range includes \nboth endpoints, and all values falling _between_ the \nendpoints."}), @Annotation(value="by", arguments={"Gavin"}), @Annotation(value="see", arguments={"Measure", "Enumerable"})})
@TypeParameters(value={@TypeParameter(value="Element", variance=Variance.NONE, satisfies={"ceylon.language::Enumerable<Element>"}, caseTypes={})})
@Class(identifiable=false, basic=false, extendsType="ceylon.language::Range<Element>")
final class Span<Element extends Enumerable<Element>>
extends Range<Element>
implements Serializable {
    @Ignore
    private final TypeDescriptor $reified$Element;
    @Ignore
    private final Element first;
    @Ignore
    private final Element last;
    @Ignore
    private final boolean increasing;
    @Ignore
    private final boolean recursive;

    @Jpa
    @Ignore
    protected Span(@Ignore TypeDescriptor $reified$Element) {
        this(null, $reified$Element);
    }

    @Ignore
    public Span($Serialization$ ignored, TypeDescriptor $reified$Element) {
        super(ignored, $reified$Element);
        this.$reified$Element = $reified$Element;
        this.first = null;
        this.last = null;
        this.increasing = false;
        this.recursive = false;
    }

    Span(@Ignore TypeDescriptor $reified$Element, @Name(value="first") @TypeInfo(value="Element", erased=true, untrusted=true) Element first, @Name(value="last") @TypeInfo(value="Element", erased=true, untrusted=true) Element last) {
        super($reified$Element);
        this.$reified$Element = $reified$Element;
        this.first = first;
        this.last = last;
        this.increasing = this.getLast().offsetSign((Enumerable)this.getFirst()) >= 0L;
        this.recursive = this.getFirst().offsetSign((Enumerable)this.getFirst().getSuccessor()) > 0L && this.getLast().getPredecessor().offsetSign((Enumerable)((Enumerable)this.getLast())) > 0L;
    }

    @Override
    @DocAnnotation$annotation$(description="The start of the range.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L, value={@Annotation(value="doc", arguments={"The start of the range."})})
    @TypeInfo(value="Element", erased=true, untrusted=true)
    public final Element getFirst() {
        return this.first;
    }

    @Override
    @DocAnnotation$annotation$(description="The end of the range.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L, value={@Annotation(value="doc", arguments={"The end of the range."})})
    @TypeInfo(value="Element", erased=true, untrusted=true)
    public final Element getLast() {
        return this.last;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::String")
    @Transient
    public final String toString() {
        return this.getFirst().toString() + ".." + this.getLast().toString();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::Boolean")
    public final boolean getIncreasing() {
        return this.increasing;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::Boolean")
    @Transient
    public final boolean getDecreasing() {
        return !this.getIncreasing();
    }

    @DocAnnotation$annotation$(description="Determines if the range is of recursive values, that \nis, if successors wrap back on themselves. All \nrecursive ranges are [[increasing]].")
    @Annotations(value={@Annotation(value="doc", arguments={"Determines if the range is of recursive values, that \nis, if successors wrap back on themselves. All \nrecursive ranges are [[increasing]]."})})
    @TypeInfo(value="ceylon.language::Boolean")
    private final boolean getRecursive$priv$() {
        return this.recursive;
    }

    @TypeInfo(value="Element", erased=true)
    private final Element next$priv$(@Name(value="x") @TypeInfo(value="Element", erased=true) Element x) {
        return (Element)(this.getIncreasing() ? (Enumerable)x.getSuccessor() : (Enumerable)x.getPredecessor());
    }

    @TypeInfo(value="Element", erased=true)
    private final Element nextStep$priv$(@Name(value="x") @TypeInfo(value="Element", erased=true) Element x, @Name(value="step") @TypeInfo(value="ceylon.language::Integer") long step) {
        return (Element)(this.getIncreasing() ? (Enumerable)x.neighbour(step) : (Enumerable)x.neighbour(-step));
    }

    @TypeInfo(value="Element", erased=true)
    private final Element fromFirst$priv$(@Name(value="offset") @TypeInfo(value="ceylon.language::Integer") long offset) {
        return (Element)(this.getIncreasing() ? (Enumerable)this.getFirst().neighbour(offset) : (Enumerable)this.getFirst().neighbour(-offset));
    }

    @TypeInfo(value="ceylon.language::Boolean")
    private final boolean afterLast$priv$(@Name(value="x") @TypeInfo(value="Element", erased=true) Element x) {
        return this.getIncreasing() ? x.offsetSign((Enumerable)((Enumerable)this.getLast())) > 0L : x.offsetSign((Enumerable)((Enumerable)this.getLast())) < 0L;
    }

    @TypeInfo(value="ceylon.language::Boolean")
    private final boolean beforeLast$priv$(@Name(value="x") @TypeInfo(value="Element", erased=true) Element x) {
        return this.getIncreasing() ? x.offsetSign((Enumerable)((Enumerable)this.getLast())) < 0L : x.offsetSign((Enumerable)((Enumerable)this.getLast())) > 0L;
    }

    @TypeInfo(value="ceylon.language::Boolean")
    private final boolean beforeFirst$priv$(@Name(value="x") @TypeInfo(value="Element", erased=true) Element x) {
        return this.getIncreasing() ? x.offsetSign((Enumerable)((Enumerable)this.getFirst())) < 0L : x.offsetSign((Enumerable)((Enumerable)this.getFirst())) > 0L;
    }

    @TypeInfo(value="ceylon.language::Boolean")
    private final boolean afterFirst$priv$(@Name(value="x") @TypeInfo(value="Element", erased=true) Element x) {
        return this.getIncreasing() ? x.offsetSign((Enumerable)((Enumerable)this.getFirst())) > 0L : x.offsetSign((Enumerable)((Enumerable)this.getFirst())) < 0L;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::Integer")
    @Transient
    public final long getSize() {
        long lastIndex = Integer.getMagnitude(this.getLast().offset((Enumerable)this.getFirst()));
        if (lastIndex < runtime_.get_().getMaxIntegerValue()) {
            return lastIndex + 1L;
        }
        throw new OverflowException("size of range");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::Boolean")
    public final boolean longerThan(@Name(value="length") @TypeInfo(value="ceylon.language::Integer") long length) {
        void var3_2;
        boolean $ceylontmp$ifResult$1090;
        if (length < 1L) {
            $ceylontmp$ifResult$1090 = true;
        } else {
            boolean $ceylontmp$ifResult$1092 = this.getRecursive$priv$() ? this.getSize() > length : this.beforeLast$priv$(this.fromFirst$priv$(length - 1L));
            $ceylontmp$ifResult$1090 = $ceylontmp$ifResult$1092;
        }
        return (boolean)var3_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::Boolean")
    public final boolean shorterThan(@Name(value="length") @TypeInfo(value="ceylon.language::Integer") long length) {
        void var3_2;
        boolean $ceylontmp$ifResult$1094;
        if (length < 1L) {
            $ceylontmp$ifResult$1094 = true;
        } else {
            boolean $ceylontmp$ifResult$1096 = this.getRecursive$priv$() ? this.getSize() < length : this.afterLast$priv$(this.fromFirst$priv$(length - 1L));
            $ceylontmp$ifResult$1094 = $ceylontmp$ifResult$1096;
        }
        return (boolean)var3_2;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::Integer")
    @Transient
    public final Integer getLastIndex() {
        return Integer.instance(this.getSize() - 1L);
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="Element[]", erased=true)
    @Transient
    public final Sequential getRest() {
        return ((Enumerable)this.getFirst()).equals((Enumerable)this.getLast()) ? empty_.get_() : span_.span(this.$reified$Element, this.next$priv$((Enumerable)this.getFirst()), (Enumerable)this.getLast());
    }

    @Override
    @DocAnnotation$annotation$(description="This range in reverse, with [[first]] and [[last]]\ninterchanged.\n\nFor any two range endpoints, `x` and `y`: \n\n    `(x..y).reversed == y..x`\n\nexcept for [[recursive]] ranges, where the elements are\nevaluated and collected into a new sequence.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L, value={@Annotation(value="doc", arguments={"This range in reverse, with [[first]] and [[last]]\ninterchanged.\n\nFor any two range endpoints, `x` and `y`: \n\n    `(x..y).reversed == y..x`\n\nexcept for [[recursive]] ranges, where the elements are\nevaluated and collected into a new sequence."})})
    @TypeInfo(value="[Element+]", erased=true)
    @Transient
    public final Sequence getReversed() {
        return this.getRecursive$priv$() ? this.$ceylon$language$Sequence$this$.getReversed() : span_.span(this.$reified$Element, (Enumerable)this.getLast(), (Enumerable)this.getFirst());
    }

    @Override
    @DocAnnotation$annotation$(description="The element of the range that occurs [[index]] values \nafter the start of the range.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L, value={@Annotation(value="doc", arguments={"The element of the range that occurs [[index]] values \nafter the start of the range."})})
    @TypeInfo(value="Element?", erased=true)
    public final Element getFromFirst(@Name(value="index") @TypeInfo(value="ceylon.language::Integer") long index) {
        if (index < 0L) {
            return null;
        }
        if (this.getRecursive$priv$()) {
            return index < this.getSize() ? (Element)this.fromFirst$priv$(index) : null;
        }
        Element result = this.fromFirst$priv$(index);
        return (Element)(!this.afterLast$priv$(result) ? result : null);
    }

    @Override
    @DocAnnotation$annotation$(description="An iterator for the elements of the range. The returned \niterator produces elements from [[first]] and continues \nproducing elements until it reaches an element whose \n`offset` from [[last] is zero.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L, value={@Annotation(value="doc", arguments={"An iterator for the elements of the range. The returned \niterator produces elements from [[first]] and continues \nproducing elements until it reaches an element whose \n`offset` from [[last] is zero."})})
    @TypeInfo(value="ceylon.language::Iterator<Element>", erased=true)
    public final Iterator iterator() {
        @Ceylon(major=8)
        @Name(value="anonymous#0")
        @LocalDeclaration(qualifier="1")
        @com.redhat.ceylon.compiler.java.metadata.Object
        @SatisfiedTypes(value={"ceylon.language::Iterator<Element>"})
        class Anonymous_0_
        implements java.io.Serializable,
        ReifiedType,
        Iterator<Element> {
            @Ignore
            private boolean firstTime = true;
            @Ignore
            private java.lang.Object element;

            Anonymous_0_() {
                this.element = Span.this.getFirst();
            }

            @VariableAnnotation$annotation$
            @Annotations(modifiers=4L)
            @TypeInfo(value="ceylon.language::Boolean")
            private final boolean getFirstTime$priv$() {
                return this.firstTime;
            }

            private final void setFirstTime$priv$(@Name(value="firstTime") @TypeInfo(value="ceylon.language::Boolean") boolean firstTime) {
                this.firstTime = firstTime;
            }

            @VariableAnnotation$annotation$
            @Annotations(modifiers=4L)
            @TypeInfo(value="Element|ceylon.language::Finished", erased=true)
            private final java.lang.Object getElement$priv$() {
                return this.element;
            }

            private final void setElement$priv$(@Name(value="element") @TypeInfo(value="Element|ceylon.language::Finished", erased=true) java.lang.Object element) {
                this.element = element;
            }

            @Override
            @SharedAnnotation$annotation$
            @ActualAnnotation$annotation$
            @Annotations(modifiers=66L)
            @TypeInfo(value="Element|ceylon.language::Finished", erased=true)
            public final java.lang.Object next() {
                java.lang.Object c$1101 = this.getElement$priv$();
                if (!(c$1101 instanceof Finished)) {
                    Enumerable result;
                    Enumerable c$1102 = (Enumerable)c$1101;
                    if (this.getFirstTime$priv$()) {
                        this.setFirstTime$priv$(false);
                        result = c$1102;
                    } else {
                        result = Span.this.next$priv$(c$1102);
                    }
                    if (result.offset((Enumerable)Span.this.getLast()) == 0L) {
                        this.setElement$priv$(finished_.get_());
                    } else {
                        this.setElement$priv$(result);
                    }
                    return result;
                }
                return this.getElement$priv$();
            }

            @SharedAnnotation$annotation$
            @ActualAnnotation$annotation$
            @Annotations(modifiers=66L)
            @TypeInfo(value="ceylon.language::String")
            @Transient
            public final String toString() {
                return "(" + Span.this.toString() + ").iterator()";
            }

            @Override
            @Ignore
            public TypeDescriptor $getType$() {
                return TypeDescriptor.member(TypeDescriptor.member(TypeDescriptor.klass(Span.class, Span.this.$reified$Element), TypeDescriptor.functionOrValue("iterator", new TypeDescriptor[0])), TypeDescriptor.klass(Anonymous_0_.class, new TypeDescriptor[0]));
            }
        }
        return new Anonymous_0_();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="{Element+}", erased=true)
    public final Iterable by(@Name(value="step") @TypeInfo(value="ceylon.language::Integer") long step) {
        if (step <= 0L) {
            throw new AssertionError("Assertion failed: step size must be greater than zero" + System.lineSeparator() + "\tviolated " + "step > 0");
        }
        return step == 1L ? this : new By(step);
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::Range<Element>", erased=true, untrusted=true)
    public final Range shifted(@Name(value="shift") @TypeInfo(value="ceylon.language::Integer") long shift) {
        return shift == 0L ? this : new Span<Enumerable>(this.$reified$Element, (Enumerable)this.getFirst().neighbour(shift), (Enumerable)this.getLast().neighbour(shift));
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::Boolean")
    public final boolean containsElement(@Name(value="x") @TypeInfo(value="Element", erased=true) Element x) {
        return this.getRecursive$priv$() ? x.offset((Enumerable)((Enumerable)this.getFirst())) <= this.getLast().offset((Enumerable)this.getFirst()) : !this.afterLast$priv$(x) && !this.beforeFirst$priv$(x);
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::Integer")
    public final long count(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") Callable<? extends Boolean> selecting) {
        Enumerable element = (Enumerable)this.getFirst();
        long count = 0L;
        while (this.containsElement(element)) {
            if (selecting.$call$((java.lang.Object)element).booleanValue()) {
                ++count;
            }
            element = this.next$priv$(element);
        }
        return count;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::Boolean")
    public final boolean includesRange(@Name(value="range") @TypeInfo(value="ceylon.language::Range<Element>", erased=true) Range<Element> range) {
        Range<Element> sel$1107 = range;
        if (sel$1107 instanceof Span && Util.isReified(sel$1107, TypeDescriptor.klass(Span.class, this.$reified$Element))) {
            Span range$1111 = (Span)sel$1107;
            if (this.getRecursive$priv$()) {
                return range$1111.getFirst().offset((Enumerable)this.getFirst()) < this.getSize() && range$1111.getLast().offset((Enumerable)this.getFirst()) < this.getSize();
            }
            return this.getIncreasing() == range$1111.getIncreasing() && !range$1111.afterFirst$priv$((Enumerable)this.getFirst()) && !range$1111.beforeLast$priv$((Enumerable)this.getLast());
        }
        if (sel$1107 instanceof Measure && Util.isReified(sel$1107, TypeDescriptor.klass(Measure.class, this.$reified$Element))) {
            Measure range$1108 = (Measure)sel$1107;
            if (this.getDecreasing()) {
                return false;
            }
            long offset = range$1108.getFirst().offset((Enumerable)this.getFirst());
            long middle$1110 = offset;
            return 0L <= middle$1110 && middle$1110 <= this.getSize() - range$1108.getSize();
        }
        throw new EnumeratedTypeError("Supposedly exhaustive switch was not exhaustive");
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::Boolean")
    public final boolean equals(@Name(value="that") @TypeInfo(value="ceylon.language::Object") java.lang.Object that) {
        java.lang.Object that$1114 = that;
        if (that$1114 instanceof Span) {
            Span that$1118 = (Span)that$1114;
            return that$1118.getFirst().equals((Enumerable)this.getFirst()) && that$1118.getLast().equals((Enumerable)this.getLast());
        }
        java.lang.Object that$1116 = that;
        if (that$1116 instanceof Measure) {
            Measure that$1117 = (Measure)that$1116;
            return this.getIncreasing() && that$1117.getFirst().equals((Enumerable)this.getFirst()) && that$1117.getSize() == this.getSize();
        }
        return this.$ceylon$language$List$this$.equals(that);
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="Element[]", erased=true)
    public final Sequential measure(@Name(value="from") @TypeInfo(value="ceylon.language::Integer") Integer from, @Name(value="length") @TypeInfo(value="ceylon.language::Integer") long length) {
        return length <= 0L ? empty_.get_() : this.span(from, Integer.instance(from.longValue() + length - 1L));
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="Element[]", erased=true)
    public final Sequential span(@Name(value="from") @TypeInfo(value="ceylon.language::Integer") Integer from, @Name(value="to") @TypeInfo(value="ceylon.language::Integer") Integer to) {
        if (Integer.compare(from.longValue(), to.longValue()) != larger_.get_()) {
            if (to.longValue() < 0L || !this.longerThan(from.longValue())) {
                return empty_.get_();
            }
            java.lang.Object $ceylontmp$1133 = this.getFromFirst(from.longValue());
            java.lang.Object object = $ceylontmp$1133 != null ? $ceylontmp$1133 : (Enumerable)this.getFirst();
            java.lang.Object $ceylontmp$1134 = this.getFromFirst(to.longValue());
            return span_.span(this.$reified$Element, object, $ceylontmp$1134 != null ? $ceylontmp$1134 : (Enumerable)this.getLast());
        }
        if (from.longValue() < 0L || !this.longerThan(to.longValue())) {
            return empty_.get_();
        }
        java.lang.Object $ceylontmp$1130 = this.getFromFirst(to.longValue());
        java.lang.Object object = $ceylontmp$1130 != null ? $ceylontmp$1130 : (Enumerable)this.getFirst();
        java.lang.Object $ceylontmp$1131 = this.getFromFirst(from.longValue());
        Range<java.lang.Object> range = span_.span(this.$reified$Element, object, $ceylontmp$1131 != null ? $ceylontmp$1131 : (Enumerable)this.getLast());
        return range.getReversed();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="Element[]", erased=true)
    public final Sequential spanFrom(@Name(value="from") @TypeInfo(value="ceylon.language::Integer") Integer from) {
        if (from.longValue() <= 0L) {
            return this;
        }
        if (this.longerThan(from.longValue())) {
            java.lang.Object first$1138 = null;
            first$1138 = this.getFromFirst(from.longValue());
            if (first$1138 == null) {
                throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists first = this[from]");
            }
            java.lang.Object first$1139 = first$1138;
            return span_.span(this.$reified$Element, first$1139, (Enumerable)this.getLast());
        }
        return empty_.get_();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="Element[]", erased=true)
    public final Sequential spanTo(@Name(value="to") @TypeInfo(value="ceylon.language::Integer") Integer to) {
        if (to.longValue() < 0L) {
            return empty_.get_();
        }
        if (this.longerThan(to.longValue() + 1L)) {
            java.lang.Object last$1143 = null;
            last$1143 = this.getFromFirst(to.longValue());
            if (last$1143 == null) {
                throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists last = this[to]");
            }
            java.lang.Object last$1144 = last$1143;
            return span_.span(this.$reified$Element, (Enumerable)this.getFirst(), last$1144);
        }
        return this;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    public final java.lang.Object each(@Name(value="step") @FunctionalParameter(value="!(element)") @TypeInfo(value="ceylon.language::Anything(Element)") Callable<? extends java.lang.Object> step) {
        Enumerable current = (Enumerable)this.getFirst();
        while (true) {
            step.$call$((java.lang.Object)current);
            if (current.offset((Enumerable)this.getLast()) == 0L) break;
            current = this.next$priv$(current);
        }
        return null;
    }

    @Override
    @Ignore
    public TypeDescriptor $getType$() {
        return TypeDescriptor.klass(Span.class, this.$reified$Element);
    }

    @Override
    @Ignore
    public Collection<ReachableReference> $references$() {
        Collection<ReachableReference> reference = super.$references$();
        reference.add(new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(Span.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "first")));
        reference.add(new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(Span.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "last")));
        reference.add(new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(Span.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "recursive")));
        reference.add(new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(Span.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "increasing")));
        reference.add(new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(Span.class)).getDeclaredMemberDeclaration(FunctionDeclaration.$TypeDescriptor$, "longerThan")));
        reference.add(new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(Span.class)).getDeclaredMemberDeclaration(FunctionDeclaration.$TypeDescriptor$, "shorterThan")));
        reference.add(new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(Span.class)).getDeclaredMemberDeclaration(FunctionDeclaration.$TypeDescriptor$, "shifted")));
        reference.add(new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(Span.class)).getDeclaredMemberDeclaration(FunctionDeclaration.$TypeDescriptor$, "containsElement")));
        return reference;
    }

    @Override
    @Ignore
    public java.lang.Object $get$(ReachableReference reference) {
        switch (((Member)reference).getAttribute().getQualifiedName()) {
            case "ceylon.language::Span.first": {
                return this.first;
            }
            case "ceylon.language::Span.last": {
                return this.last;
            }
            case "ceylon.language::Span.recursive": {
                return Boolean.instance(this.recursive);
            }
            case "ceylon.language::Span.increasing": {
                return Boolean.instance(this.increasing);
            }
        }
        return super.$get$(reference);
    }

    @Override
    @Ignore
    public void $set$(ReachableReference reference, java.lang.Object instance) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        if (reference instanceof Member) {
            switch (((Member)reference).getAttribute().getQualifiedName()) {
                case "ceylon.language::Span.first": {
                    Util.setter(lookup, "first").invokeExact(this, (Enumerable)instance);
                    break;
                }
                case "ceylon.language::Span.last": {
                    Util.setter(lookup, "last").invokeExact(this, (Enumerable)instance);
                    break;
                }
                case "ceylon.language::Span.recursive": {
                    Util.setter(lookup, "recursive").invokeExact(this, ((Boolean)instance).booleanValue());
                    break;
                }
                case "ceylon.language::Span.increasing": {
                    Util.setter(lookup, "increasing").invokeExact(this, ((Boolean)instance).booleanValue());
                    break;
                }
                default: {
                    super.$set$(reference, instance);
                    break;
                }
            }
        } else {
            throw new AssertionError("unexpected reachable reference " + reference);
        }
    }

    @Ceylon(major=8)
    @Name(value="By")
    @LocalDeclarations(value={"1anonymous_1_", "1anonymous_2_"})
    @Container(klass=Span.class)
    @SatisfiedTypes(value={"{Element+}"})
    class By
    implements ReifiedType,
    Iterable<Element, java.lang.Object>,
    java.io.Serializable {
        @Ignore
        private final long step;
        @Ignore
        protected final Iterable$impl<Element, java.lang.Object> $ceylon$language$Iterable$this$;
        @Ignore
        protected final Category$impl<java.lang.Object> $ceylon$language$Category$this$;

        By(long step) {
            this.step = step;
            this.$ceylon$language$Iterable$this$ = new Iterable$impl(Span.this.$reified$Element, TypeDescriptor.NothingType, this);
            this.$ceylon$language$Category$this$ = new Category$impl<java.lang.Object>(Object.$TypeDescriptor$, this);
        }

        @TypeInfo(value="ceylon.language::Integer")
        private final long getStep$priv$() {
            return this.step;
        }

        @Override
        @Ignore
        public Iterable$impl<? extends Element, ? extends java.lang.Object> $ceylon$language$Iterable$impl() {
            return this.$ceylon$language$Iterable$this$;
        }

        @Override
        @Ignore
        public boolean any(Callable<? extends Boolean> selecting) {
            return this.$ceylon$language$Iterable$this$.any(selecting);
        }

        @Override
        @Ignore
        public Iterable<? extends Element, ? extends java.lang.Object> by(long step) {
            return this.$ceylon$language$Iterable$this$.by(step);
        }

        @Override
        @Ignore
        public <Other, OtherAbsent> Iterable chain(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
            return this.$ceylon$language$Iterable$this$.chain($reified$Other, $reified$OtherAbsent, other);
        }

        @Override
        @Ignore
        public Iterable<? extends Element, ? extends java.lang.Object> getCoalesced() {
            return this.$ceylon$language$Iterable$this$.getCoalesced();
        }

        @Override
        @Ignore
        public <Result> Sequential<? extends Result> collect(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
            return this.$ceylon$language$Iterable$this$.collect($reified$Result, collecting);
        }

        @Override
        @Ignore
        public boolean contains(java.lang.Object element) {
            return this.$ceylon$language$Iterable$this$.contains(element);
        }

        @Override
        @Ignore
        public long count(Callable<? extends Boolean> selecting) {
            return this.$ceylon$language$Iterable$this$.count(selecting);
        }

        @Override
        @Ignore
        public Iterable<? extends Element, ? extends java.lang.Object> getCycled() {
            return this.$ceylon$language$Iterable$this$.getCycled();
        }

        @Override
        @Ignore
        public <Default> Iterable defaultNullElements(TypeDescriptor $reified$Default, Default defaultValue) {
            return this.$ceylon$language$Iterable$this$.defaultNullElements($reified$Default, defaultValue);
        }

        @Override
        @Ignore
        public Iterable<? extends Element, ? extends java.lang.Object> getDistinct() {
            return this.$ceylon$language$Iterable$this$.getDistinct();
        }

        @Override
        @Ignore
        public java.lang.Object each(Callable<? extends java.lang.Object> step) {
            return this.$ceylon$language$Iterable$this$.each(step);
        }

        @Override
        @Ignore
        public boolean getEmpty() {
            return this.$ceylon$language$Iterable$this$.getEmpty();
        }

        @Override
        @Ignore
        public boolean every(Callable<? extends Boolean> selecting) {
            return this.$ceylon$language$Iterable$this$.every(selecting);
        }

        @Override
        @Ignore
        public Iterable<? extends Element, ? extends java.lang.Object> getExceptLast() {
            return this.$ceylon$language$Iterable$this$.getExceptLast();
        }

        @Override
        @Ignore
        public Iterable<? extends Element, ? extends java.lang.Object> filter(Callable<? extends Boolean> selecting) {
            return this.$ceylon$language$Iterable$this$.filter(selecting);
        }

        @Override
        @Ignore
        public Element find(Callable<? extends Boolean> selecting) {
            return (Enumerable)this.$ceylon$language$Iterable$this$.find(selecting);
        }

        @Override
        @Ignore
        public Element findLast(Callable<? extends Boolean> selecting) {
            return (Enumerable)this.$ceylon$language$Iterable$this$.findLast(selecting);
        }

        @Override
        @Ignore
        public <Result, OtherAbsent> Iterable flatMap(TypeDescriptor $reified$Result, TypeDescriptor $reified$OtherAbsent, Callable<? extends Iterable<? extends Result, ? extends OtherAbsent>> collecting) {
            return this.$ceylon$language$Iterable$this$.flatMap($reified$Result, $reified$OtherAbsent, collecting);
        }

        @Override
        @Ignore
        public <Result> Callable<? extends Result> fold(TypeDescriptor $reified$Result, Result initial) {
            return this.$ceylon$language$Iterable$this$.fold($reified$Result, initial);
        }

        @Override
        @Ignore
        public <Other> Iterable follow(TypeDescriptor $reified$Other, Other head) {
            return this.$ceylon$language$Iterable$this$.follow($reified$Other, head);
        }

        @Override
        @Ignore
        public final Map<? extends Element, ? extends Integer> frequencies() {
            return this.$ceylon$language$Iterable$this$.frequencies();
        }

        @Override
        @Ignore
        public Element getFromFirst(long index) {
            return (Enumerable)this.$ceylon$language$Iterable$this$.getFromFirst(index);
        }

        @Override
        @Ignore
        public final <Group> Map<? extends Group, ? extends Sequence<? extends Element>> group(TypeDescriptor $reified$Group, Callable<? extends Group> grouping) {
            return this.$ceylon$language$Iterable$this$.group($reified$Group, grouping);
        }

        @Override
        @Ignore
        public Iterable<? extends Entry<? extends Integer, ? extends Element>, ? extends java.lang.Object> getIndexed() {
            return this.$ceylon$language$Iterable$this$.getIndexed();
        }

        @Override
        @Ignore
        public java.lang.Object indexes() {
            return this.$ceylon$language$Iterable$this$.indexes();
        }

        @Override
        @Ignore
        public final <Other> long interpose$step(TypeDescriptor $reified$Other, Other element) {
            return this.$ceylon$language$Iterable$this$.interpose$step($reified$Other, element);
        }

        @Override
        @Ignore
        public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element) {
            long $ceylontmp$step$1119 = this.interpose$step($reified$Other, element);
            return this.interpose$canonical$($reified$Other, element, $ceylontmp$step$1119);
        }

        @Override
        @Ignore
        public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element, long step) {
            return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
        }

        @Ignore
        private <Other> Iterable interpose$canonical$(TypeDescriptor $reified$Other, Other element, long step) {
            return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
        }

        @Override
        @Ignore
        public Element getLast() {
            return (Enumerable)this.$ceylon$language$Iterable$this$.getLast();
        }

        @Override
        @Ignore
        public Entry<? extends Integer, ? extends Element> locate(Callable<? extends Boolean> selecting) {
            return this.$ceylon$language$Iterable$this$.locate(selecting);
        }

        @Override
        @Ignore
        public Entry<? extends Integer, ? extends Element> locateLast(Callable<? extends Boolean> selecting) {
            return this.$ceylon$language$Iterable$this$.locateLast(selecting);
        }

        @Override
        @Ignore
        public Iterable<? extends Entry<? extends Integer, ? extends Element>, ? extends java.lang.Object> locations(Callable<? extends Boolean> selecting) {
            return this.$ceylon$language$Iterable$this$.locations(selecting);
        }

        @Override
        @Ignore
        public boolean longerThan(long length) {
            return this.$ceylon$language$Iterable$this$.longerThan(length);
        }

        @Override
        @Ignore
        public <Result> Iterable<? extends Result, ? extends java.lang.Object> map(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
            return this.$ceylon$language$Iterable$this$.map($reified$Result, collecting);
        }

        @Override
        @Ignore
        public Element max(Callable<? extends Comparison> comparing) {
            return (Enumerable)this.$ceylon$language$Iterable$this$.max(comparing);
        }

        @Override
        @Ignore
        public <Type> Iterable narrow(TypeDescriptor $reified$Type) {
            return this.$ceylon$language$Iterable$this$.narrow($reified$Type);
        }

        @Override
        @Ignore
        public Iterable getPaired() {
            return this.$ceylon$language$Iterable$this$.getPaired();
        }

        @Override
        @Ignore
        public Iterable<? extends Sequence<? extends Element>, ? extends java.lang.Object> partition(long length) {
            return this.$ceylon$language$Iterable$this$.partition(length);
        }

        @Override
        @Ignore
        public <Other, OtherAbsent> Iterable product(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
            return this.$ceylon$language$Iterable$this$.product($reified$Other, $reified$OtherAbsent, other);
        }

        @Override
        @Ignore
        public <Result> java.lang.Object reduce(TypeDescriptor $reified$Result, Callable<? extends Result> accumulating) {
            return this.$ceylon$language$Iterable$this$.reduce($reified$Result, accumulating);
        }

        @Override
        @Ignore
        public Iterable<? extends Element, ? extends java.lang.Object> repeat(long times) {
            return this.$ceylon$language$Iterable$this$.repeat(times);
        }

        @Override
        @Ignore
        public Iterable<? extends Element, ? extends java.lang.Object> getRest() {
            return this.$ceylon$language$Iterable$this$.getRest();
        }

        @Override
        @Ignore
        public <Result> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> scan(TypeDescriptor $reified$Result, Result initial) {
            return this.$ceylon$language$Iterable$this$.scan($reified$Result, initial);
        }

        @Override
        @Ignore
        public Sequential<? extends Element> select(Callable<? extends Boolean> selecting) {
            return this.$ceylon$language$Iterable$this$.select(selecting);
        }

        @Override
        @Ignore
        public Sequential<? extends Element> sequence() {
            return this.$ceylon$language$Iterable$this$.sequence();
        }

        @Override
        @Ignore
        public boolean shorterThan(long length) {
            return this.$ceylon$language$Iterable$this$.shorterThan(length);
        }

        @Override
        @Ignore
        public Iterable<? extends Element, ? extends java.lang.Object> skip(long skipping) {
            return this.$ceylon$language$Iterable$this$.skip(skipping);
        }

        @Override
        @Ignore
        public Iterable<? extends Element, ? extends java.lang.Object> skipWhile(Callable<? extends Boolean> skipping) {
            return this.$ceylon$language$Iterable$this$.skipWhile(skipping);
        }

        @Override
        @Ignore
        public Sequential<? extends Element> sort(Callable<? extends Comparison> comparing) {
            return this.$ceylon$language$Iterable$this$.sort(comparing);
        }

        @Override
        @Ignore
        public <Result, Args extends Sequential<? extends java.lang.Object>> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> spread(TypeDescriptor $reified$Result, TypeDescriptor $reified$Args, Callable<? extends Callable<? extends Result>> method) {
            return this.$ceylon$language$Iterable$this$.spread($reified$Result, $reified$Args, method);
        }

        @Override
        @Ignore
        public final <Group, Result> Map<? extends Group, ? extends Result> summarize(TypeDescriptor $reified$Group, TypeDescriptor $reified$Result, Callable<? extends Group> grouping, Callable<? extends Result> accumulating) {
            return this.$ceylon$language$Iterable$this$.summarize($reified$Group, $reified$Result, grouping, accumulating);
        }

        @Override
        @Ignore
        public final <Result> Map<? extends Element, ? extends Result> tabulate(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
            return this.$ceylon$language$Iterable$this$.tabulate($reified$Result, collecting);
        }

        @Override
        @Ignore
        public Iterable<? extends Element, ? extends java.lang.Object> take(long taking) {
            return this.$ceylon$language$Iterable$this$.take(taking);
        }

        @Override
        @Ignore
        public Iterable<? extends Element, ? extends java.lang.Object> takeWhile(Callable<? extends Boolean> taking) {
            return this.$ceylon$language$Iterable$this$.takeWhile(taking);
        }

        @Override
        @Ignore
        public Category$impl<? super java.lang.Object> $ceylon$language$Category$impl() {
            return this.$ceylon$language$Category$this$;
        }

        @Override
        @Ignore
        public boolean containsAny(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
            return this.$ceylon$language$Category$this$.containsAny(elements);
        }

        @Override
        @Ignore
        public boolean containsEvery(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
            return this.$ceylon$language$Category$this$.containsEvery(elements);
        }

        @Override
        @SharedAnnotation$annotation$
        @ActualAnnotation$annotation$
        @Annotations(modifiers=66L)
        @TypeInfo(value="ceylon.language::Integer")
        @Transient
        public final long getSize() {
            return 1L + (Span.this.getSize() - 1L) / this.getStep$priv$();
        }

        @Override
        @SharedAnnotation$annotation$
        @ActualAnnotation$annotation$
        @Annotations(modifiers=66L)
        @TypeInfo(value="Element", erased=true, untrusted=true)
        @Transient
        public final Element getFirst() {
            return (Enumerable)Span.this.getFirst();
        }

        @Override
        @SharedAnnotation$annotation$
        @ActualAnnotation$annotation$
        @Annotations(modifiers=66L)
        @TypeInfo(value="ceylon.language::String")
        @Transient
        public final String toString() {
            return "(" + Span.this.toString() + ").by(" + this.getStep$priv$() + ")";
        }

        @Override
        @SharedAnnotation$annotation$
        @ActualAnnotation$annotation$
        @Annotations(modifiers=66L)
        @TypeInfo(value="ceylon.language::Iterator<Element>", erased=true)
        public final Iterator iterator() {
            if (Span.this.getRecursive$priv$()) {
                @Ceylon(major=8)
                @Name(value="anonymous#1")
                @LocalDeclaration(qualifier="1")
                @com.redhat.ceylon.compiler.java.metadata.Object
                @SatisfiedTypes(value={"ceylon.language::Iterator<Element>"})
                class Anonymous_1_
                implements java.io.Serializable,
                ReifiedType,
                Iterator<Element> {
                    @Ignore
                    private long count = 0L;
                    @Ignore
                    private Element current;

                    Anonymous_1_() {
                        this.current = (Enumerable)By.this.getFirst();
                    }

                    @VariableAnnotation$annotation$
                    @Annotations(modifiers=4L)
                    @TypeInfo(value="ceylon.language::Integer")
                    private final long getCount$priv$() {
                        return this.count;
                    }

                    private final void setCount$priv$(@Name(value="count") @TypeInfo(value="ceylon.language::Integer") long count) {
                        this.count = count;
                    }

                    @VariableAnnotation$annotation$
                    @Annotations(modifiers=4L)
                    @TypeInfo(value="Element", erased=true)
                    private final Element getCurrent$priv$() {
                        return this.current;
                    }

                    private final void setCurrent$priv$(@Name(value="current") @TypeInfo(value="Element", erased=true) Element current) {
                        this.current = current;
                    }

                    @Override
                    @SharedAnnotation$annotation$
                    @ActualAnnotation$annotation$
                    @Annotations(modifiers=66L)
                    @TypeInfo(value="Element|ceylon.language::Finished", erased=true)
                    public final java.lang.Object next() {
                        long $ceylontmp$op$1127 = this.getCount$priv$() + 1L;
                        this.setCount$priv$($ceylontmp$op$1127);
                        if ($ceylontmp$op$1127 > By.this.getSize()) {
                            return finished_.get_();
                        }
                        java.lang.Object result = this.getCurrent$priv$();
                        this.setCurrent$priv$((Enumerable)this.getCurrent$priv$().neighbour(By.this.getStep$priv$()));
                        return result;
                    }

                    @SharedAnnotation$annotation$
                    @ActualAnnotation$annotation$
                    @Annotations(modifiers=66L)
                    @TypeInfo(value="ceylon.language::String")
                    @Transient
                    public final String toString() {
                        return By.this.toString() + ".iterator()";
                    }

                    @Override
                    @Ignore
                    public TypeDescriptor $getType$() {
                        return TypeDescriptor.member(TypeDescriptor.member(TypeDescriptor.member(TypeDescriptor.klass(Span.class, Span.this.$reified$Element), TypeDescriptor.klass(By.class, new TypeDescriptor[0])), TypeDescriptor.functionOrValue("iterator", new TypeDescriptor[0])), TypeDescriptor.klass(Anonymous_1_.class, new TypeDescriptor[0]));
                    }
                }
                return new Anonymous_1_();
            }
            @Ceylon(major=8)
            @Name(value="anonymous#2")
            @LocalDeclaration(qualifier="1")
            @com.redhat.ceylon.compiler.java.metadata.Object
            @SatisfiedTypes(value={"ceylon.language::Iterator<Element>"})
            class Anonymous_2_
            implements java.io.Serializable,
            ReifiedType,
            Iterator<Element> {
                @Ignore
                private java.lang.Object current;
                @Ignore
                private boolean firstTime;

                Anonymous_2_() {
                    this.current = By.this.getFirst();
                    this.firstTime = true;
                }

                @VariableAnnotation$annotation$
                @Annotations(modifiers=4L)
                @TypeInfo(value="Element|ceylon.language::Finished", erased=true)
                private final java.lang.Object getCurrent$priv$() {
                    return this.current;
                }

                private final void setCurrent$priv$(@Name(value="current") @TypeInfo(value="Element|ceylon.language::Finished", erased=true) java.lang.Object current) {
                    this.current = current;
                }

                @VariableAnnotation$annotation$
                @Annotations(modifiers=4L)
                @TypeInfo(value="ceylon.language::Boolean")
                private final boolean getFirstTime$priv$() {
                    return this.firstTime;
                }

                private final void setFirstTime$priv$(@Name(value="firstTime") @TypeInfo(value="ceylon.language::Boolean") boolean firstTime) {
                    this.firstTime = firstTime;
                }

                @Override
                @SharedAnnotation$annotation$
                @ActualAnnotation$annotation$
                @Annotations(modifiers=66L)
                @TypeInfo(value="Element|ceylon.language::Finished", erased=true)
                public final java.lang.Object next() {
                    if (this.getFirstTime$priv$()) {
                        this.setFirstTime$priv$(false);
                        return this.getCurrent$priv$();
                    }
                    java.lang.Object c$1123 = this.getCurrent$priv$();
                    if (!(c$1123 instanceof Finished)) {
                        Enumerable c$1124 = (Enumerable)c$1123;
                        Enumerable r = Span.this.nextStep$priv$(c$1124, By.this.getStep$priv$());
                        if (!Span.this.containsElement(r)) {
                            this.setCurrent$priv$(finished_.get_());
                        } else {
                            this.setCurrent$priv$(r);
                        }
                    }
                    return this.getCurrent$priv$();
                }

                @SharedAnnotation$annotation$
                @ActualAnnotation$annotation$
                @Annotations(modifiers=66L)
                @TypeInfo(value="ceylon.language::String")
                @Transient
                public final String toString() {
                    return By.this.toString() + ".iterator()";
                }

                @Override
                @Ignore
                public TypeDescriptor $getType$() {
                    return TypeDescriptor.member(TypeDescriptor.member(TypeDescriptor.member(TypeDescriptor.klass(Span.class, Span.this.$reified$Element), TypeDescriptor.klass(By.class, new TypeDescriptor[0])), TypeDescriptor.functionOrValue("iterator", new TypeDescriptor[0])), TypeDescriptor.klass(Anonymous_2_.class, new TypeDescriptor[0]));
                }
            }
            return new Anonymous_2_();
        }

        @Override
        @Ignore
        public TypeDescriptor $getType$() {
            return TypeDescriptor.member(TypeDescriptor.klass(Span.class, Span.this.$reified$Element), TypeDescriptor.klass(By.class, new TypeDescriptor[0]));
        }
    }
}

