/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Character;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Float;
import ceylon.language.Integer;
import ceylon.language.Iterable;
import ceylon.language.Object;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.String;
import ceylon.language.TagsAnnotation$annotation$;
import ceylon.language.empty_;
import ceylon.language.runtime_;
import ceylon.language.scaleByPowerOfTen_;
import ceylon.language.zeroInt_;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.language.AbstractCallable;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Method;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

@Ceylon(major=8)
@Method
public final class formatFloat_ {
    private formatFloat_() {
    }

    @Ignore
    public static java.lang.String formatFloat(double $float) {
        long $ceylontmp$minDecimalPlaces$1267 = formatFloat_.formatFloat$minDecimalPlaces($float);
        long $ceylontmp$maxDecimalPlaces$1268 = formatFloat_.formatFloat$maxDecimalPlaces($float, $ceylontmp$minDecimalPlaces$1267);
        return formatFloat_.formatFloat($float, $ceylontmp$minDecimalPlaces$1267, $ceylontmp$maxDecimalPlaces$1268);
    }

    @Ignore
    public static final long formatFloat$minDecimalPlaces(double $float) {
        return 1L;
    }

    @Ignore
    public static java.lang.String formatFloat(double $float, long minDecimalPlaces) {
        long $ceylontmp$maxDecimalPlaces$1269 = formatFloat_.formatFloat$maxDecimalPlaces($float, minDecimalPlaces);
        return formatFloat_.formatFloat($float, minDecimalPlaces, $ceylontmp$maxDecimalPlaces$1269);
    }

    @Ignore
    public static final long formatFloat$maxDecimalPlaces(double $float, long minDecimalPlaces) {
        return 9L;
    }

    @DocAnnotation$annotation$(description="The string decimal representation of the given \n[[floating point number|float]]. If the given number is \n[[negative|Float.negative]], the string representation will \nbegin with `-`. The [[whole part|Float.wholePart]] and \n[[fractional parts|Float.fractionalPart]] of the number are\nseparated by a `.` decimal point. Digits consist of decimal \ndigits `0` to `9`. \n\nThe number of decimal places following the decimal point is \ncontrolled by the parameters [[minDecimalPlaces]] and \n[[maxDecimalPlaces]], which default to `1` and `9` \nrespectively, so that by default the string representation\nalways contains a decimal point, and never contains more \nthan nine decimal places. The decimal representation is \ntruncated so that the number of decimal places never \nexceeds the specified maximum.\n\nFor example:\n\n- `formatFloat(1234.1234)` is `\"1234.1234\"`\n- `formatFloat(0.1234)` is `\"0.1234\"`\n- `formatFloat(1234.0)` is `\"1234.0\"`\n- `formatFloat(1234.0,0)` is `\"1234\"`\n- `formatFloat(1234.1234,6)` is `\"1234.123400\"`\n- `formatFloat(1234.1234,0,2)` is `\"1234.12\"`\n- `formatFloat(0.0001,2,2)` is `\"0.00\"`\n- `formatFloat(0.0001,0,2)` is `\"0\"`\n\nFinally:\n\n- `formatFloat(-0.0)` is `\"0.0\"`,\n- `formatFloat(0.0/0)` is `\"NaN\"`,\n- `formatFloat(1.0/0)` is `\"Infinity\"`, and\n- `formatFloat(-1.0/0)` is `\"-Infinity\".`\n\nThis function never produces a representation involving \nscientific notation.")
    @TagsAnnotation$annotation$(tags={"Numbers"})
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::FformatInteger", "::1.2.2:ceylon.language::FparseFloat"})})
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"The string decimal representation of the given \n[[floating point number|float]]. If the given number is \n[[negative|Float.negative]], the string representation will \nbegin with `-`. The [[whole part|Float.wholePart]] and \n[[fractional parts|Float.fractionalPart]] of the number are\nseparated by a `.` decimal point. Digits consist of decimal \ndigits `0` to `9`. \n\nThe number of decimal places following the decimal point is \ncontrolled by the parameters [[minDecimalPlaces]] and \n[[maxDecimalPlaces]], which default to `1` and `9` \nrespectively, so that by default the string representation\nalways contains a decimal point, and never contains more \nthan nine decimal places. The decimal representation is \ntruncated so that the number of decimal places never \nexceeds the specified maximum.\n\nFor example:\n\n- `formatFloat(1234.1234)` is `\"1234.1234\"`\n- `formatFloat(0.1234)` is `\"0.1234\"`\n- `formatFloat(1234.0)` is `\"1234.0\"`\n- `formatFloat(1234.0,0)` is `\"1234\"`\n- `formatFloat(1234.1234,6)` is `\"1234.123400\"`\n- `formatFloat(1234.1234,0,2)` is `\"1234.12\"`\n- `formatFloat(0.0001,2,2)` is `\"0.00\"`\n- `formatFloat(0.0001,0,2)` is `\"0\"`\n\nFinally:\n\n- `formatFloat(-0.0)` is `\"0.0\"`,\n- `formatFloat(0.0/0)` is `\"NaN\"`,\n- `formatFloat(1.0/0)` is `\"Infinity\"`, and\n- `formatFloat(-1.0/0)` is `\"-Infinity\".`\n\nThis function never produces a representation involving \nscientific notation."}), @Annotation(value="tagged", arguments={"Numbers"}), @Annotation(value="see", arguments={"formatInteger", "parseFloat"})})
    @TypeInfo(value="ceylon.language::String")
    public static java.lang.String formatFloat(@Name(value="float") @TypeInfo(value="ceylon.language::Float") @DocAnnotation$annotation$(description="The floating point value to format.") @Annotations(value={@Annotation(value="doc", arguments={"The floating point value to format."})}) double $float, @Name(value="minDecimalPlaces") @Defaulted @TypeInfo(value="ceylon.language::Integer") @DocAnnotation$annotation$(description="The minimum number of allowed decimal places.\n\nIf `minDecimalPlaces<=0`, the result may have no\ndecimal point.") @Annotations(value={@Annotation(value="doc", arguments={"The minimum number of allowed decimal places.\n\nIf `minDecimalPlaces<=0`, the result may have no\ndecimal point."})}) long minDecimalPlaces, @Name(value="maxDecimalPlaces") @Defaulted @TypeInfo(value="ceylon.language::Integer") @DocAnnotation$annotation$(description="The maximum number of allowed decimal places.\n\nIf `maxDecimalPlaces<=0`, the result always has no\ndecimal point.") @Annotations(value={@Annotation(value="doc", arguments={"The maximum number of allowed decimal places.\n\nIf `maxDecimalPlaces<=0`, the result always has no\ndecimal point."})}) long maxDecimalPlaces) {
        java.lang.String fractionalPart;
        java.lang.String wholePart;
        long i;
        if (Float.getUndefined($float) || Float.getInfinite($float)) {
            return Float.toString($float);
        }
        double magnitude = Float.getMagnitude($float);
        double maxExactIntegralFloat = Integer.getFloat(runtime_.get_().getMaxExactIntegralFloat());
        for (i = maxDecimalPlaces; i > 0L && magnitude > maxExactIntegralFloat / (double)Integer.power(10L, i); --i) {
        }
        long decimalPlaces = i;
        boolean previousZero = false;
        Iterable<java.lang.Object, java.lang.Object> digits = empty_.get_();
        while (true) {
            double scaled = scaleByPowerOfTen_.scaleByPowerOfTen(magnitude, i);
            double fractional = Float.getFractionalPart(scaled);
            double whole = Float.getWholePart(scaled);
            long d = Float.getInteger(fractional * 10.0);
            long digit = previousZero ? (Float.getInteger(fractional * 100.0) > d * 10L ? (d == 9L ? 0L : d + 1L) : d) : d;
            int c = Integer.getCharacter(digit + zeroInt_.get_());
            digits = digits.follow(Character.$TypeDescriptor$, Character.instance(c));
            if (whole == 0.0) break;
            previousZero = digit == 0L;
            --i;
        }
        java.lang.String string = new String(digits.getExceptLast()).toString();
        long point = String.getSize(string) - decimalPlaces;
        if (point > 0L) {
            wholePart = ((String)String.instance(string).measure(Integer.instance(0L), point)).toString();
            fractionalPart = ((String)String.instance(string).spanFrom(Integer.instance(point))).toString();
        } else {
            wholePart = "0";
            fractionalPart = String.padLeading(string, maxDecimalPlaces, Util.toInt(48L));
        }
        int $instance$ = 48;
        java.lang.String normalized = String.padTrailing(String.trimTrailing(fractionalPart, (Callable<? extends Boolean>)new AbstractCallable<Boolean>(Boolean.$TypeDescriptor$, TypeDescriptor.tuple(false, false, -1, Object.$TypeDescriptor$), "Boolean(Object)", -1){

            @Override
            @Ignore
            public Boolean $call$(java.lang.Object $param$0) {
                java.lang.Object $ceylontmp$that = $param$0;
                return Boolean.instance(Character.equals(48, $ceylontmp$that));
            }
        }), minDecimalPlaces, Util.toInt(48L));
        java.lang.String signed = Float.getNegative($float) ? "-" + wholePart : wholePart;
        return String.getEmpty(normalized) ? signed : signed + "." + normalized;
    }
}

