/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.AssertionError;
import ceylon.language.Character;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Integer;
import ceylon.language.Iterable;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.String;
import ceylon.language.TagsAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotations$;
import ceylon.language.aIntLower_;
import ceylon.language.empty_;
import ceylon.language.maxRadix_;
import ceylon.language.minRadix_;
import ceylon.language.zeroInt_;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Method;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;

@Ceylon(major=8)
@Method
public final class formatInteger_ {
    private formatInteger_() {
    }

    @Ignore
    public static java.lang.String formatInteger(long integer) {
        long $ceylontmp$radix$1283 = formatInteger_.formatInteger$radix(integer);
        return formatInteger_.formatInteger(integer, $ceylontmp$radix$1283);
    }

    @Ignore
    public static final long formatInteger$radix(long integer) {
        return 10L;
    }

    @DocAnnotation$annotation$(description="The string representation of the given [[integer]] in the \nbase given by [[radix]]. If the given integer is \n[[negative|Integer.negative]], the string representation \nwill begin with `-`. Digits consist of decimal digits `0` \nto `9`, together with and lowercase letters `a` to `z` for \nbases greater than 10.\n\nFor example:\n\n- `formatInteger(-46)` is `\"-46\"`\n- `formatInteger(9,2)` is `\"1001\"`\n- `formatInteger(10,8)` is `\"12\"`\n- `formatInteger(511,16)` is `\"1ff\"`\n- `formatInteger(512,32)` is `\"g0\"`")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.2.2:ceylon.language::CAssertionError", when="if [[radix]] is not between [[minRadix]] and \n[[maxRadix]]")})
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::FformatFloat", "::1.2.2:ceylon.language::FparseInteger"})})
    @TagsAnnotation$annotation$(tags={"Numbers"})
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"The string representation of the given [[integer]] in the \nbase given by [[radix]]. If the given integer is \n[[negative|Integer.negative]], the string representation \nwill begin with `-`. Digits consist of decimal digits `0` \nto `9`, together with and lowercase letters `a` to `z` for \nbases greater than 10.\n\nFor example:\n\n- `formatInteger(-46)` is `\"-46\"`\n- `formatInteger(9,2)` is `\"1001\"`\n- `formatInteger(10,8)` is `\"12\"`\n- `formatInteger(511,16)` is `\"1ff\"`\n- `formatInteger(512,32)` is `\"g0\"`"}), @Annotation(value="throws", arguments={"AssertionError", "if [[radix]] is not between [[minRadix]] and \n[[maxRadix]]"}), @Annotation(value="see", arguments={"formatFloat", "parseInteger"}), @Annotation(value="tagged", arguments={"Numbers"})})
    @TypeInfo(value="ceylon.language::String")
    public static java.lang.String formatInteger(@Name(value="integer") @TypeInfo(value="ceylon.language::Integer") @DocAnnotation$annotation$(description="The integer value to format.") @Annotations(value={@Annotation(value="doc", arguments={"The integer value to format."})}) long integer, @Name(value="radix") @Defaulted @TypeInfo(value="ceylon.language::Integer") @DocAnnotation$annotation$(description="The base, between [[minRadix]] and [[maxRadix]] \ninclusive.") @Annotations(value={@Annotation(value="doc", arguments={"The base, between [[minRadix]] and [[maxRadix]] \ninclusive."})}) long radix) {
        long i;
        long middle$1275 = radix;
        if (!(minRadix_.get_() <= middle$1275 && middle$1275 <= maxRadix_.get_())) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "minRadix <= radix <= maxRadix");
        }
        if (integer == 0L) {
            return "0";
        }
        Iterable<Object, Object> digits = empty_.get_();
        long l = i = integer < 0L ? integer : -integer;
        while (i != 0L) {
            int c;
            long d = -(i % radix);
            long middle$1278 = d;
            if (0L <= middle$1278 && middle$1278 < 10L) {
                c = Integer.getCharacter(d + zeroInt_.get_());
            } else {
                long middle$1280 = d;
                if (10L <= middle$1280 && middle$1280 < 36L) {
                    c = Integer.getCharacter(d - 10L + aIntLower_.get_());
                } else {
                    throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "false");
                }
            }
            digits = digits.follow(Character.$TypeDescriptor$, Character.instance(c));
            i = (i + d) / radix;
        }
        if (integer < 0L) {
            digits = digits.follow(Character.$TypeDescriptor$, Character.instance(45));
        }
        return new String(digits).toString();
    }
}

