/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language.meta;

import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.TagsAnnotation$annotation$;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Package;

@Ceylon(major=8)
@Package(name="ceylon.language.meta", doc="The Ceylon metamodel base package.\n\nThe Ceylon metamodel allows you to: \n\n* dynamically inspect modules, packages, functions, values and types, \n* invoke functions, constructors and class initialisers, \n* read and write values, and\n* inspect the annotations on program elements.\n\n### A little bit of terminology\n\nThere are a few concepts and terms in the Ceylon metamodel API that you should be familiar with:\n\n- A _declaration_ is the definition of a Ceylon construct, such as a module, package, value, function\n  or class. Declarations are singletons: there is only a single instance of a given class declaration,\n  for example. You can inspect declarations to get information about how they were defined by their\n  author. You cannot directly invoke function or class declarations, but you can _apply_ them to get\n  a _model_ that you can invoke.\n- A _model_ is a Ceylon definition that represents a declaration where all the type variables have\n  been bound to _closed type_ values. You can query models for their member models and you can directly\n  invoke models.\n- A _closed type_ is a type which does not contain any unbound type variables.\n- An _open type_ is a type which may contain unbound type variables.\n\nFor example, given the following Ceylon program:\n\n    shared abstract class MyList<T>() satisfies List<T>{}\n\nThe declaration of `MyList` represents the class declaration and contains the information that it is\n`abstract` and that it satisfies the `List<T>` open type. That type is open because it contains an\nunbound type variable `T`, which is not bound when we inspect the `MyList` class declaration.\n\nGiven an particular instance of `MyList`, we can query its (closed) type with the [[type]] function,\nand we obtain a closed type representing (for example) `MyList<Integer>`. Object instances necessarily\nhave a closed type at runtime, since in order to instantiate an object, all type arguments must be\nprovided and known during instantiation, so the type of an object instance at runtime is necessarily\na closed type: they cannot contain unbound type variables.\n\nClosed types that represent class or interfaces are also models. For example, the closed type of our\n`MyList<Integer>` instance is both a closed type and a class model: you can query its satisfied types\nand find that it satisfies `List<Integer>` closed type and model (as opposed to the class declaration\nof `MyList` which satisfies the `List<T>` open type). You can also invoke that model to obtain a new\ninstance of `MyList<Integer>`.\n\n### Model and declaration literals\n\nCeylon supports getting declaration values using either the declaration API or using declaration\nliterals:\n\n- <code>\\`module ceylon.file\\`</code> returns the [[Module|ceylon.language.meta.declaration::Module]] \n  declaration which corresponds to the `ceylon.file` module you imported in your module descriptor, or\n  to the current module if it is `ceylon.file`. You can also obtain a reference to the current module\n  with <code>\\`module\\`</code>.\n- <code>\\`package ceylon.language.meta\\`</code> returns the [[Package|ceylon.language.meta.declaration::Package]]\n  declaration from your current module or its imports. You can also obtain a reference to the current package\n  with <code>\\`package\\`</code>.\n- <code>\\`interface List\\`</code> returns the [[InterfaceDeclaration|ceylon.language.meta.declaration::InterfaceDeclaration]] \n  for the [[List|ceylon.language::List]] type. You can also obtain a reference to the current interface\n  with <code>\\`interface\\`</code>.\n- <code>\\`class Integer\\`</code> returns the [[ClassDeclaration|ceylon.language.meta.declaration::ClassDeclaration]] \n  for the [[Integer|ceylon.language::Integer]] type. You can also obtain a reference to the current class\n  with <code>\\`class\\`</code>.\n- <code>\\`new Array.ofSize\\`</code> returns the \n  [[CallableConstructorDeclaration|ceylon.language.meta.declaration::CallableConstructorDeclaration]] \n  for the [[Array.ofSize]] constructor. Similarly <code>\\`new Color.black\\`</code> for \n  [[value constructors|ceylon.language.meta.declaration::ValueConstructorDeclaration]].\n- <code>\\`function type\\`</code> returns the [[FunctionDeclaration|ceylon.language.meta.declaration::FunctionDeclaration]] \n  for the [[type]] function. Similarly <code>\\`function List.shorterThan\\`</code> for methods.\n- <code>\\`value modules\\`</code> returns the [[ValueDeclaration|ceylon.language.meta.declaration::ValueDeclaration]] \n  for the [[modules]] value. Similarly <code>\\`function List.size\\`</code> for attributes.\n- <code>\\`alias AliasName\\`</code> returns the [[AliasDeclaration|ceylon.language.meta.declaration::AliasDeclaration]]\n  for the `AliasName` type alias. \n- <code>\\`given T\\`</code> returns the [[TypeParameter|ceylon.language.meta.declaration::TypeParameter]] \n  for the `T` type parameter.\n\nNote that declaration literals cannot have type arguments specified on types or methods, as declarations are not types.\n\nYou can also get access to closed types and model using either the model API or using literals: \n\n- <code>\\`List&lt;Integer>\\`</code> returns the [[Interface|ceylon.language.meta.model::Interface]] model and \n  closed type for the [[List|ceylon.language::List]] type applied with the [[Integer|ceylon.language::Integer]] type argument.\n- <code>\\`Integer\\`</code> returns the [[Class|ceylon.language.meta.model::Class]] model and closed type \n  for the [[Integer|ceylon.language::Integer]] type.\n- <code>\\`Array<Integer>.ofSize\\`</code> returns the \n  [[CallableConstructor|ceylon.language.meta.model::CallableConstructor]] model \n  for the [[Array<Integer>.ofSize|Array.ofSize]] constructor.\n  Similarly <code>\\`Color.black\\`</code> for \n  [[value constructor models|ceylon.language.meta.model::ValueConstructor]].\n- <code>\\`type&lt;Integer>\\`</code> returns the [[Function|ceylon.language.meta.model::Function]] model \n  for the [[type]] function applied with the [[Integer|ceylon.language::Integer]] type argument.\n  Similarly <code>\\`List&lt;Integer>.shorterThan\\`</code> for \n  [[method models|ceylon.language.meta.model::Method]].\n- <code>\\`modules\\`</code> returns the [[Value|ceylon.language.meta.model::Value]] model \n  for the [[modules]] value. Similarly <code>\\`List&lt;Integer>.size\\`</code> for \n  [[attribute models|ceylon.language.meta.model::Attribute]].\n- <code>\\`A & B\\`</code> returns a [[IntersectionType|ceylon.language.meta.model::IntersectionType]]\n  for the `A & B` intersection type.\n- <code>\\`A | B\\`</code> returns a [[UnionType|ceylon.language.meta.model::UnionType]]\n  for the `A | B` union type.\n- <code>\\`T\\`</code> returns a [[Type|ceylon.language.meta.model::Type]] representing the runtime type \n  argument value for the `T` type parameter.\n\nNotice that all model and close type literals must be applied with all required type arguments.\n\n### Accessing the metamodel using the API\n\nAside from declaration and model literals there are several ways you can start using the metamodel API:\n\n- The [[modules]] object contains a list of all currently loaded [[Module|ceylon.language.meta.declaration::Module]]\n  declarations. Note that these contain even modules you did not import as it contains all transitive\n  dependencies, and may contain multiple different versions of the same module.\n- The [[classDeclaration]] function will return the \n  [[ceylon.language.meta.declaration::ClassDeclaration]] of the given instance.\n- The [[type]] function will return the closed type of the given instance, which can only be a\n  [[ClassModel|ceylon.language.meta.model::ClassModel]] since only classes can be instantiated.\n- The [[typeLiteral]] function is the functional equivalent to closed type literals: it turns a type argument\n  value into a metamodel closed type.\n- The [declaration](declaration/index.html) package contains all the declaration and open types.\n- The [model](model/index.html) package contains all the model and closed types.\n\n### Inspecting annotations\n\nConstrained annotations can be inspected using the [[annotations]] \nfunction, like this:\n\n    // Does the process declaration have the Shared annotation?\n    value isShared = annotations(`SharedAnnotation`, `value process`) exists;\n\nor the related [[optionalAnnotation]] and [[sequencedAnnotations]] functions.\n\nNote that annotations are queried for via their \n[[ceylon.language::Annotation]] type, \nnot by the annotation constructor which was used to annotate \nthe program element.\n", by={"Gavin King", "Stephane Epardaud", "Tom Bentley"}, shared=true)
@DocAnnotation$annotation$(description="The Ceylon metamodel base package.\n\nThe Ceylon metamodel allows you to: \n\n* dynamically inspect modules, packages, functions, values and types, \n* invoke functions, constructors and class initialisers, \n* read and write values, and\n* inspect the annotations on program elements.\n\n### A little bit of terminology\n\nThere are a few concepts and terms in the Ceylon metamodel API that you should be familiar with:\n\n- A _declaration_ is the definition of a Ceylon construct, such as a module, package, value, function\n  or class. Declarations are singletons: there is only a single instance of a given class declaration,\n  for example. You can inspect declarations to get information about how they were defined by their\n  author. You cannot directly invoke function or class declarations, but you can _apply_ them to get\n  a _model_ that you can invoke.\n- A _model_ is a Ceylon definition that represents a declaration where all the type variables have\n  been bound to _closed type_ values. You can query models for their member models and you can directly\n  invoke models.\n- A _closed type_ is a type which does not contain any unbound type variables.\n- An _open type_ is a type which may contain unbound type variables.\n\nFor example, given the following Ceylon program:\n\n    shared abstract class MyList<T>() satisfies List<T>{}\n\nThe declaration of `MyList` represents the class declaration and contains the information that it is\n`abstract` and that it satisfies the `List<T>` open type. That type is open because it contains an\nunbound type variable `T`, which is not bound when we inspect the `MyList` class declaration.\n\nGiven an particular instance of `MyList`, we can query its (closed) type with the [[type]] function,\nand we obtain a closed type representing (for example) `MyList<Integer>`. Object instances necessarily\nhave a closed type at runtime, since in order to instantiate an object, all type arguments must be\nprovided and known during instantiation, so the type of an object instance at runtime is necessarily\na closed type: they cannot contain unbound type variables.\n\nClosed types that represent class or interfaces are also models. For example, the closed type of our\n`MyList<Integer>` instance is both a closed type and a class model: you can query its satisfied types\nand find that it satisfies `List<Integer>` closed type and model (as opposed to the class declaration\nof `MyList` which satisfies the `List<T>` open type). You can also invoke that model to obtain a new\ninstance of `MyList<Integer>`.\n\n### Model and declaration literals\n\nCeylon supports getting declaration values using either the declaration API or using declaration\nliterals:\n\n- <code>\\`module ceylon.file\\`</code> returns the [[Module|ceylon.language.meta.declaration::Module]] \n  declaration which corresponds to the `ceylon.file` module you imported in your module descriptor, or\n  to the current module if it is `ceylon.file`. You can also obtain a reference to the current module\n  with <code>\\`module\\`</code>.\n- <code>\\`package ceylon.language.meta\\`</code> returns the [[Package|ceylon.language.meta.declaration::Package]]\n  declaration from your current module or its imports. You can also obtain a reference to the current package\n  with <code>\\`package\\`</code>.\n- <code>\\`interface List\\`</code> returns the [[InterfaceDeclaration|ceylon.language.meta.declaration::InterfaceDeclaration]] \n  for the [[List|ceylon.language::List]] type. You can also obtain a reference to the current interface\n  with <code>\\`interface\\`</code>.\n- <code>\\`class Integer\\`</code> returns the [[ClassDeclaration|ceylon.language.meta.declaration::ClassDeclaration]] \n  for the [[Integer|ceylon.language::Integer]] type. You can also obtain a reference to the current class\n  with <code>\\`class\\`</code>.\n- <code>\\`new Array.ofSize\\`</code> returns the \n  [[CallableConstructorDeclaration|ceylon.language.meta.declaration::CallableConstructorDeclaration]] \n  for the [[Array.ofSize]] constructor. Similarly <code>\\`new Color.black\\`</code> for \n  [[value constructors|ceylon.language.meta.declaration::ValueConstructorDeclaration]].\n- <code>\\`function type\\`</code> returns the [[FunctionDeclaration|ceylon.language.meta.declaration::FunctionDeclaration]] \n  for the [[type]] function. Similarly <code>\\`function List.shorterThan\\`</code> for methods.\n- <code>\\`value modules\\`</code> returns the [[ValueDeclaration|ceylon.language.meta.declaration::ValueDeclaration]] \n  for the [[modules]] value. Similarly <code>\\`function List.size\\`</code> for attributes.\n- <code>\\`alias AliasName\\`</code> returns the [[AliasDeclaration|ceylon.language.meta.declaration::AliasDeclaration]]\n  for the `AliasName` type alias. \n- <code>\\`given T\\`</code> returns the [[TypeParameter|ceylon.language.meta.declaration::TypeParameter]] \n  for the `T` type parameter.\n\nNote that declaration literals cannot have type arguments specified on types or methods, as declarations are not types.\n\nYou can also get access to closed types and model using either the model API or using literals: \n\n- <code>\\`List&lt;Integer>\\`</code> returns the [[Interface|ceylon.language.meta.model::Interface]] model and \n  closed type for the [[List|ceylon.language::List]] type applied with the [[Integer|ceylon.language::Integer]] type argument.\n- <code>\\`Integer\\`</code> returns the [[Class|ceylon.language.meta.model::Class]] model and closed type \n  for the [[Integer|ceylon.language::Integer]] type.\n- <code>\\`Array<Integer>.ofSize\\`</code> returns the \n  [[CallableConstructor|ceylon.language.meta.model::CallableConstructor]] model \n  for the [[Array<Integer>.ofSize|Array.ofSize]] constructor.\n  Similarly <code>\\`Color.black\\`</code> for \n  [[value constructor models|ceylon.language.meta.model::ValueConstructor]].\n- <code>\\`type&lt;Integer>\\`</code> returns the [[Function|ceylon.language.meta.model::Function]] model \n  for the [[type]] function applied with the [[Integer|ceylon.language::Integer]] type argument.\n  Similarly <code>\\`List&lt;Integer>.shorterThan\\`</code> for \n  [[method models|ceylon.language.meta.model::Method]].\n- <code>\\`modules\\`</code> returns the [[Value|ceylon.language.meta.model::Value]] model \n  for the [[modules]] value. Similarly <code>\\`List&lt;Integer>.size\\`</code> for \n  [[attribute models|ceylon.language.meta.model::Attribute]].\n- <code>\\`A & B\\`</code> returns a [[IntersectionType|ceylon.language.meta.model::IntersectionType]]\n  for the `A & B` intersection type.\n- <code>\\`A | B\\`</code> returns a [[UnionType|ceylon.language.meta.model::UnionType]]\n  for the `A | B` union type.\n- <code>\\`T\\`</code> returns a [[Type|ceylon.language.meta.model::Type]] representing the runtime type \n  argument value for the `T` type parameter.\n\nNotice that all model and close type literals must be applied with all required type arguments.\n\n### Accessing the metamodel using the API\n\nAside from declaration and model literals there are several ways you can start using the metamodel API:\n\n- The [[modules]] object contains a list of all currently loaded [[Module|ceylon.language.meta.declaration::Module]]\n  declarations. Note that these contain even modules you did not import as it contains all transitive\n  dependencies, and may contain multiple different versions of the same module.\n- The [[classDeclaration]] function will return the \n  [[ceylon.language.meta.declaration::ClassDeclaration]] of the given instance.\n- The [[type]] function will return the closed type of the given instance, which can only be a\n  [[ClassModel|ceylon.language.meta.model::ClassModel]] since only classes can be instantiated.\n- The [[typeLiteral]] function is the functional equivalent to closed type literals: it turns a type argument\n  value into a metamodel closed type.\n- The [declaration](declaration/index.html) package contains all the declaration and open types.\n- The [model](model/index.html) package contains all the model and closed types.\n\n### Inspecting annotations\n\nConstrained annotations can be inspected using the [[annotations]] \nfunction, like this:\n\n    // Does the process declaration have the Shared annotation?\n    value isShared = annotations(`SharedAnnotation`, `value process`) exists;\n\nor the related [[optionalAnnotation]] and [[sequencedAnnotations]] functions.\n\nNote that annotations are queried for via their \n[[ceylon.language::Annotation]] type, \nnot by the annotation constructor which was used to annotate \nthe program element.\n")
@AuthorsAnnotation$annotation$(authors={"Gavin King", "Stephane Epardaud", "Tom Bentley"})
@TagsAnnotation$annotation$(tags={"Metamodel"})
@SharedAnnotation$annotation$
final class $package_ {
    private $package_() {
    }
}

