/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language.meta.declaration;

import ceylon.language.DefaultAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.SealedAnnotation$annotation$;
import ceylon.language.Sequential;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotations$;
import ceylon.language.meta.declaration.CallableConstructorDeclaration;
import ceylon.language.meta.declaration.ClassDeclaration$impl;
import ceylon.language.meta.declaration.ClassOrInterfaceDeclaration;
import ceylon.language.meta.declaration.ConstructorDeclaration;
import ceylon.language.meta.declaration.FunctionOrValueDeclaration;
import ceylon.language.meta.declaration.ValueDeclaration;
import ceylon.language.meta.model.Class;
import ceylon.language.meta.model.MemberClass;
import ceylon.language.meta.model.Type;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.CaseTypes;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Sequenced;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import java.lang.annotation.Annotation;

@Ceylon(major=8)
@DocAnnotation$annotation$(description="Class declaration.\n\n### Callable classes\n\nSince Ceylon 1.2 classes are not always directly invokable\n(if the class has constructors, but not a default constructor). Thus\nmembers of `ClassDeclaration` which depend on the class parameter \nlist typically have optional type, but are refined on \n[[ClassWithInitializerDeclaration]] to be non-optional. The exceptions to \nthis are [[instantiate]] and [[memberInstantiate]], \nwhich throw exceptions.\n\n<a name=\"toplevel-sample\"></a>\n### Usage sample for toplevel classes\n\nBecause some classes have type parameters, getting a model requires applying type arguments to the\nclass declaration with [[classApply]] in order to be able to instantiate that class. For example, here is how you would\nobtain a class model that you can instantiate from a toplevel class declaration:\n\n    class Foo<T>(){\n        string => \"Hello, our T is: ``typeLiteral<T>()``\";\n    }\n    \n    void test(){\n        // We need to apply the Integer closed type to the Foo declaration in order to get the Foo<Integer> closed type\n        Class<Foo<Integer>,[]> classModel = `class Foo`.classApply<Foo<Integer>,[]>(`Integer`);\n        // This will print: Hello, our T is: ceylon.language::Integer\n        print(classModel());\n    }\n\n<a name=\"member-sample\"></a>\n### Usage sample for member classes\n\nFor member classes it is a bit longer, because member classes need to be applied not only their type arguments but also\nthe containing type, so you should use [[memberClassApply]] and start by giving the containing closed type:\n\n    class Outer(){\n        shared class Inner(){\n            string => \"Hello\";\n        }\n    }\n\n    void test(){\n        // apply the containing closed type `Outer` to the member class declaration `Outer.Inner`\n        MemberClass<Outer,Outer.Inner,[]> memberClassModel = `class Outer.Inner`.memberClassApply<Outer,Outer.Inner,[]>(`Outer`);\n        // We now have a MemberClass, which needs to be applied to a containing instance in order to become an\n        // invokable class model:\n        Class<Outer.Inner,[]> boundMemberClassModel = memberClassModel(Outer());\n        // This will print: Hello\n        print(boundMemberClassModel());\n    }\n")
@SharedAnnotation$annotation$
@SealedAnnotation$annotation$
@Annotations(modifiers=18L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"Class declaration.\n\n### Callable classes\n\nSince Ceylon 1.2 classes are not always directly invokable\n(if the class has constructors, but not a default constructor). Thus\nmembers of `ClassDeclaration` which depend on the class parameter \nlist typically have optional type, but are refined on \n[[ClassWithInitializerDeclaration]] to be non-optional. The exceptions to \nthis are [[instantiate]] and [[memberInstantiate]], \nwhich throw exceptions.\n\n<a name=\"toplevel-sample\"></a>\n### Usage sample for toplevel classes\n\nBecause some classes have type parameters, getting a model requires applying type arguments to the\nclass declaration with [[classApply]] in order to be able to instantiate that class. For example, here is how you would\nobtain a class model that you can instantiate from a toplevel class declaration:\n\n    class Foo<T>(){\n        string => \"Hello, our T is: ``typeLiteral<T>()``\";\n    }\n    \n    void test(){\n        // We need to apply the Integer closed type to the Foo declaration in order to get the Foo<Integer> closed type\n        Class<Foo<Integer>,[]> classModel = `class Foo`.classApply<Foo<Integer>,[]>(`Integer`);\n        // This will print: Hello, our T is: ceylon.language::Integer\n        print(classModel());\n    }\n\n<a name=\"member-sample\"></a>\n### Usage sample for member classes\n\nFor member classes it is a bit longer, because member classes need to be applied not only their type arguments but also\nthe containing type, so you should use [[memberClassApply]] and start by giving the containing closed type:\n\n    class Outer(){\n        shared class Inner(){\n            string => \"Hello\";\n        }\n    }\n\n    void test(){\n        // apply the containing closed type `Outer` to the member class declaration `Outer.Inner`\n        MemberClass<Outer,Outer.Inner,[]> memberClassModel = `class Outer.Inner`.memberClassApply<Outer,Outer.Inner,[]>(`Outer`);\n        // We now have a MemberClass, which needs to be applied to a containing instance in order to become an\n        // invokable class model:\n        Class<Outer.Inner,[]> boundMemberClassModel = memberClassModel(Outer());\n        // This will print: Hello\n        print(boundMemberClassModel());\n    }\n"})})
@SatisfiedTypes(value={"ceylon.language.meta.declaration::ClassOrInterfaceDeclaration"})
@CaseTypes(value={"ceylon.language.meta.declaration::ClassWithInitializerDeclaration", "ceylon.language.meta.declaration::ClassWithConstructorsDeclaration"})
public interface ClassDeclaration
extends ClassOrInterfaceDeclaration {
    @Ignore
    public static final TypeDescriptor $TypeDescriptor$ = TypeDescriptor.klass(ClassDeclaration.class, new TypeDescriptor[0]);

    @Ignore
    public ClassDeclaration$impl $ceylon$language$meta$declaration$ClassDeclaration$impl();

    @DocAnnotation$annotation$(description="A constructor declaration representing the class initializer \n(for a class with a parameter list) or\nthe default constructor, or null if the class lacks \nboth a parameter list and a default constructor.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"A constructor declaration representing the class initializer \n(for a class with a parameter list) or\nthe default constructor, or null if the class lacks \nboth a parameter list and a default constructor."})})
    @TypeInfo(value="ceylon.language.meta.declaration::CallableConstructorDeclaration?")
    public CallableConstructorDeclaration getDefaultConstructor();

    @DocAnnotation$annotation$(description="The list of parameter declarations for this class. \nReturns `null` if the class lacks both a parameter list and a \ndefault constructor.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"The list of parameter declarations for this class. \nReturns `null` if the class lacks both a parameter list and a \ndefault constructor."})})
    @TypeInfo(value="ceylon.language.meta.declaration::FunctionOrValueDeclaration[]?")
    public Sequential<? extends FunctionOrValueDeclaration> getParameterDeclarations();

    @DocAnnotation$annotation$(description="Gets a parameter declaration by name. \nReturns `null` if this class lacks both a parameter list and a \ndefault constructor, \nor if no such parameter exists in the parameter list.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"Gets a parameter declaration by name. \nReturns `null` if this class lacks both a parameter list and a \ndefault constructor, \nor if no such parameter exists in the parameter list."})})
    @TypeInfo(value="ceylon.language.meta.declaration::FunctionOrValueDeclaration?")
    public FunctionOrValueDeclaration getParameterDeclaration(@Name(value="name") @TypeInfo(value="ceylon.language::String") String var1);

    @DocAnnotation$annotation$(description="True if the current declaration is an annotation class or function.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"True if the current declaration is an annotation class or function."})})
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean getAnnotation();

    @DocAnnotation$annotation$(description="True if the class has an [[abstract|ceylon.language::abstract]] annotation.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"True if the class has an [[abstract|ceylon.language::abstract]] annotation."})})
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean getAbstract();

    @DocAnnotation$annotation$(description="True if the class is serializable class.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"True if the class is serializable class."})})
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean getSerializable();

    @DocAnnotation$annotation$(description="True if the class is an anonymous class, as is the case for the class of object value declarations.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"True if the class is an anonymous class, as is the case for the class of object value declarations."})})
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean getAnonymous();

    @DocAnnotation$annotation$(description="This anonymous class' object value declaration if this class is an anonymous class. `null` otherwise.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"This anonymous class' object value declaration if this class is an anonymous class. `null` otherwise."})})
    @TypeInfo(value="ceylon.language.meta.declaration::ValueDeclaration?")
    public ValueDeclaration getObjectValue();

    @DocAnnotation$annotation$(description="True if the class has a [[final|ceylon.language::final]] annotation.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"True if the class has a [[final|ceylon.language::final]] annotation."})})
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean getFinal();

    @Ignore
    public <Type, Arguments extends Sequential<? extends Object>> Class<? extends Type, ? super Arguments> classApply(TypeDescriptor var1, TypeDescriptor var2);

    @DocAnnotation$annotation$(description="Applies the given closed type arguments to this toplevel class declaration in order to obtain a class model. \nSee [this code sample](#toplevel-sample) for an example on how to use this.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.2.2:ceylon.language:meta.model:CIncompatibleTypeException", when="If the specified `Type` or `Arguments` type arguments are not \ncompatible with the actual result."), @ThrownExceptionAnnotation$annotation$(type="::1.2.2:ceylon.language:meta.model:CTypeApplicationException", when="If the specified closed type argument values are not compatible \nwith the actual result's type parameters.")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"Applies the given closed type arguments to this toplevel class declaration in order to obtain a class model. \nSee [this code sample](#toplevel-sample) for an example on how to use this."}), @com.redhat.ceylon.compiler.java.metadata.Annotation(value="throws", arguments={"IncompatibleTypeException", "If the specified `Type` or `Arguments` type arguments are not \ncompatible with the actual result."}), @com.redhat.ceylon.compiler.java.metadata.Annotation(value="throws", arguments={"TypeApplicationException", "If the specified closed type argument values are not compatible \nwith the actual result's type parameters."})})
    @TypeInfo(value="ceylon.language.meta.model::Class<Type,Arguments>", erased=true)
    @TypeParameters(value={@TypeParameter(value="Type", variance=Variance.NONE, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Anything"), @TypeParameter(value="Arguments", variance=Variance.NONE, satisfies={"ceylon.language::Anything[]"}, caseTypes={}, defaultValue="ceylon.language::Nothing")})
    public <Type, Arguments extends Sequential<? extends Object>> Class<? extends Type, ? super Arguments> classApply(@Ignore TypeDescriptor var1, @Ignore TypeDescriptor var2, @Name(value="typeArguments") @Sequenced @TypeInfo(value="ceylon.language.meta.model::Type<ceylon.language::Anything>[]") Sequential<? extends Type<? extends Object>> var3);

    @Ignore
    public <Container, Type, Arguments extends Sequential<? extends Object>> MemberClass<? super Container, ? extends Type, ? super Arguments> memberClassApply(TypeDescriptor var1, TypeDescriptor var2, TypeDescriptor var3, Type<? extends Object> var4);

    @DocAnnotation$annotation$(description="Applies the given closed container type and type arguments to this member class declaration in order to obtain a member class model. \nSee [this code sample](#member-sample) for an example on how to use this.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.2.2:ceylon.language:meta.model:CIncompatibleTypeException", when="If the specified `Container`, `Type` or `Arguments` type arguments \nare not compatible with the actual result."), @ThrownExceptionAnnotation$annotation$(type="::1.2.2:ceylon.language:meta.model:CTypeApplicationException", when="If the specified closed container type or type argument values \nare not compatible with the actual result's container type or \ntype parameters.")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"Applies the given closed container type and type arguments to this member class declaration in order to obtain a member class model. \nSee [this code sample](#member-sample) for an example on how to use this."}), @com.redhat.ceylon.compiler.java.metadata.Annotation(value="throws", arguments={"IncompatibleTypeException", "If the specified `Container`, `Type` or `Arguments` type arguments \nare not compatible with the actual result."}), @com.redhat.ceylon.compiler.java.metadata.Annotation(value="throws", arguments={"TypeApplicationException", "If the specified closed container type or type argument values \nare not compatible with the actual result's container type or \ntype parameters."})})
    @TypeInfo(value="ceylon.language.meta.model::MemberClass<Container,Type,Arguments>", erased=true)
    @TypeParameters(value={@TypeParameter(value="Container", variance=Variance.NONE, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Nothing"), @TypeParameter(value="Type", variance=Variance.NONE, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Anything"), @TypeParameter(value="Arguments", variance=Variance.NONE, satisfies={"ceylon.language::Anything[]"}, caseTypes={}, defaultValue="ceylon.language::Nothing")})
    public <Container, Type, Arguments extends Sequential<? extends Object>> MemberClass<? super Container, ? extends Type, ? super Arguments> memberClassApply(@Ignore TypeDescriptor var1, @Ignore TypeDescriptor var2, @Ignore TypeDescriptor var3, @Name(value="containerType") @TypeInfo(value="ceylon.language.meta.model::Type<ceylon.language::Object>") Type<? extends Object> var4, @Name(value="typeArguments") @Sequenced @TypeInfo(value="ceylon.language.meta.model::Type<ceylon.language::Anything>[]") Sequential<? extends Type<? extends Object>> var5);

    @Ignore
    public Object instantiate();

    @Ignore
    public Sequential<? extends Type<? extends Object>> instantiate$typeArguments();

    @Ignore
    public Object instantiate(Sequential<? extends Type<? extends Object>> var1);

    @DocAnnotation$annotation$(description="Creates a new instance of this toplevel class, \nby applying the specified type arguments and value arguments.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.2.2:ceylon.language:meta.model:CIncompatibleTypeException", when="If the specified type or value arguments are not compatible with \nthis toplevel class, or if the class lacks both a parameter list\nand a default constructor.")})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"Creates a new instance of this toplevel class, \nby applying the specified type arguments and value arguments."}), @com.redhat.ceylon.compiler.java.metadata.Annotation(value="throws", arguments={"IncompatibleTypeException", "If the specified type or value arguments are not compatible with \nthis toplevel class, or if the class lacks both a parameter list\nand a default constructor."})})
    @TypeInfo(value="ceylon.language::Object")
    public Object instantiate(@Name(value="typeArguments") @Defaulted @TypeInfo(value="ceylon.language.meta.model::Type<ceylon.language::Anything>[]") Sequential<? extends Type<? extends Object>> var1, @Name(value="arguments") @Sequenced @TypeInfo(value="ceylon.language::Anything[]") Sequential<? extends Object> var2);

    @Ignore
    public Object memberInstantiate(Object var1);

    @Ignore
    public Sequential<? extends Type<? extends Object>> memberInstantiate$typeArguments(Object var1);

    @Ignore
    public Object memberInstantiate(Object var1, Sequential<? extends Type<? extends Object>> var2);

    @DocAnnotation$annotation$(description="Creates a new instance of this member class, by applying the specified \ntype arguments and value arguments.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.2.2:ceylon.language:meta.model:CIncompatibleTypeException", when="If the specified container, type or value arguments are not \ncompatible with this method, or if the class lacks both a parameter list\nand a default constructor.")})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"Creates a new instance of this member class, by applying the specified \ntype arguments and value arguments."}), @com.redhat.ceylon.compiler.java.metadata.Annotation(value="throws", arguments={"IncompatibleTypeException", "If the specified container, type or value arguments are not \ncompatible with this method, or if the class lacks both a parameter list\nand a default constructor."})})
    @TypeInfo(value="ceylon.language::Object")
    public Object memberInstantiate(@Name(value="container") @TypeInfo(value="ceylon.language::Object") Object var1, @Name(value="typeArguments") @Defaulted @TypeInfo(value="ceylon.language.meta.model::Type<ceylon.language::Anything>[]") Sequential<? extends Type<? extends Object>> var2, @Name(value="arguments") @Sequenced @TypeInfo(value="ceylon.language::Anything[]") Sequential<? extends Object> var3);

    @DocAnnotation$annotation$(description="Looks up a constructor declaration directly declared on this class, by name. \nReturns `null` if no such constructor matches. \nThis includes unshared constructors but not inherited constructors \n(since constructors are not members).")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"Looks up a constructor declaration directly declared on this class, by name. \nReturns `null` if no such constructor matches. \nThis includes unshared constructors but not inherited constructors \n(since constructors are not members)."})})
    @TypeInfo(value="ceylon.language::Null|ceylon.language.meta.declaration::CallableConstructorDeclaration|ceylon.language.meta.declaration::ValueConstructorDeclaration", erased=true)
    public Object getConstructorDeclaration(@Name(value="name") @TypeInfo(value="ceylon.language::String") String var1);

    @DocAnnotation$annotation$(description="Returns the list of constructors declared on this class. This includes unshared constructors.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"Returns the list of constructors declared on this class. This includes unshared constructors."})})
    @TypeInfo(value="ceylon.language.meta.declaration::ConstructorDeclaration[]")
    public Sequential<? extends ConstructorDeclaration> constructorDeclarations();

    @DocAnnotation$annotation$(description="Returns the list of constructors declared on this class that are annotated with the \ngiven `Annotation` type argument. This includes unshared constructors.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"Returns the list of constructors declared on this class that are annotated with the \ngiven `Annotation` type argument. This includes unshared constructors."})})
    @TypeInfo(value="ceylon.language.meta.declaration::ConstructorDeclaration[]")
    @TypeParameters(value={@TypeParameter(value="Annotation", variance=Variance.NONE, satisfies={"ceylon.language::Annotation"}, caseTypes={})})
    public <Annotation extends Annotation> Sequential<? extends ConstructorDeclaration> annotatedConstructorDeclarations(@Ignore TypeDescriptor var1);
}

