/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language.meta.declaration;

import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.SealedAnnotation$annotation$;
import ceylon.language.Sequential;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotations$;
import ceylon.language.meta.declaration.GenericDeclaration;
import ceylon.language.meta.declaration.NestableDeclaration;
import ceylon.language.meta.declaration.OpenClassType;
import ceylon.language.meta.declaration.OpenInterfaceType;
import ceylon.language.meta.declaration.OpenType;
import ceylon.language.meta.model.ClassOrInterface;
import ceylon.language.meta.model.Type;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.CaseTypes;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Sequenced;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import java.lang.annotation.Annotation;

@Ceylon(major=8)
@DocAnnotation$annotation$(description="A class or interface declaration.\n\n<a name=\"toplevel-sample\"></a>\n### Usage sample for toplevel classes\n\nBecause some classes have type parameters, getting a model requires applying type arguments to the\nclass declaration with [[apply]] in order to be able to instantiate that class. For example, here is how you would\nobtain a class or interface model that you can instantiate from a toplevel class declaration:\n\n    class Foo<T>() {\n        string => \"Hello, our T is: ``typeLiteral<T>()``\";\n    }\n    \n    void test(){\n        // We need to apply the Integer closed type to the Foo declaration in order to get the Foo<Integer> closed type\n        ClassOrInterface<Foo<Integer>> classOrInterfaceModel = `class Foo`.apply<Foo<Integer>>(`Integer`);\n        assert(is Class<Foo<Integer>,[]> classOrInterfaceModel);\n        // This will print: Hello, our T is: ceylon.language::Integer\n        print(classOrInterfaceModel());\n    }\n\nNote that there are more specialised versions of [[apply]] in [[ClassDeclaration.classApply]] and \n[[InterfaceDeclaration.interfaceApply]].\n\n<a name=\"member-sample\"></a>\n### Usage sample for member classes\n\nFor member classes or interfaces it is a bit longer, because member types need to be applied not only their type arguments but also\nthe containing type, so you should use [[memberApply]] and start by giving the containing closed type:\n\n    class Outer(){\n        shared class Inner(){\n            string => \"Hello\";\n        }\n    }\n\n    void test(){\n        // apply the containing closed type `Outer` to the member class declaration `Outer.Inner`\n        value memberClassModel = `class Outer.Inner`.memberApply<Outer,Outer.Inner>(`Outer`);\n        assert(is MemberClass<Outer,Outer.Inner,[]> memberClassModel);\n        // We now have a MemberClass, which needs to be applied to a containing instance in order to become an\n        // invokable class model:\n        Class<Outer.Inner,[]> boundMemberClassModel = memberClassModel(Outer());\n        // This will print: Hello\n        print(boundMemberClassModel());\n    }\n\nNote that there are more specialised versions of [[memberApply]] in [[ClassDeclaration.memberClassApply]] and \n[[InterfaceDeclaration.memberInterfaceApply]].\n")
@SharedAnnotation$annotation$
@SealedAnnotation$annotation$
@Annotations(modifiers=18L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"A class or interface declaration.\n\n<a name=\"toplevel-sample\"></a>\n### Usage sample for toplevel classes\n\nBecause some classes have type parameters, getting a model requires applying type arguments to the\nclass declaration with [[apply]] in order to be able to instantiate that class. For example, here is how you would\nobtain a class or interface model that you can instantiate from a toplevel class declaration:\n\n    class Foo<T>() {\n        string => \"Hello, our T is: ``typeLiteral<T>()``\";\n    }\n    \n    void test(){\n        // We need to apply the Integer closed type to the Foo declaration in order to get the Foo<Integer> closed type\n        ClassOrInterface<Foo<Integer>> classOrInterfaceModel = `class Foo`.apply<Foo<Integer>>(`Integer`);\n        assert(is Class<Foo<Integer>,[]> classOrInterfaceModel);\n        // This will print: Hello, our T is: ceylon.language::Integer\n        print(classOrInterfaceModel());\n    }\n\nNote that there are more specialised versions of [[apply]] in [[ClassDeclaration.classApply]] and \n[[InterfaceDeclaration.interfaceApply]].\n\n<a name=\"member-sample\"></a>\n### Usage sample for member classes\n\nFor member classes or interfaces it is a bit longer, because member types need to be applied not only their type arguments but also\nthe containing type, so you should use [[memberApply]] and start by giving the containing closed type:\n\n    class Outer(){\n        shared class Inner(){\n            string => \"Hello\";\n        }\n    }\n\n    void test(){\n        // apply the containing closed type `Outer` to the member class declaration `Outer.Inner`\n        value memberClassModel = `class Outer.Inner`.memberApply<Outer,Outer.Inner>(`Outer`);\n        assert(is MemberClass<Outer,Outer.Inner,[]> memberClassModel);\n        // We now have a MemberClass, which needs to be applied to a containing instance in order to become an\n        // invokable class model:\n        Class<Outer.Inner,[]> boundMemberClassModel = memberClassModel(Outer());\n        // This will print: Hello\n        print(boundMemberClassModel());\n    }\n\nNote that there are more specialised versions of [[memberApply]] in [[ClassDeclaration.memberClassApply]] and \n[[InterfaceDeclaration.memberInterfaceApply]].\n"})})
@SatisfiedTypes(value={"ceylon.language.meta.declaration::NestableDeclaration", "ceylon.language.meta.declaration::GenericDeclaration"})
@CaseTypes(value={"ceylon.language.meta.declaration::ClassDeclaration", "ceylon.language.meta.declaration::InterfaceDeclaration"})
public interface ClassOrInterfaceDeclaration
extends NestableDeclaration,
GenericDeclaration {
    @Ignore
    public static final TypeDescriptor $TypeDescriptor$ = TypeDescriptor.klass(ClassOrInterfaceDeclaration.class, new TypeDescriptor[0]);

    @DocAnnotation$annotation$(description="This type's extended type, unless this is the class for \n[[Anything|ceylon.language::Anything]], whichis the root \nof the type hierarchy and thus does not have any extended type.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"This type's extended type, unless this is the class for \n[[Anything|ceylon.language::Anything]], whichis the root \nof the type hierarchy and thus does not have any extended type."})})
    @TypeInfo(value="ceylon.language.meta.declaration::OpenClassType?")
    public OpenClassType getExtendedType();

    @DocAnnotation$annotation$(description="The list of types satisfied by this type.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"The list of types satisfied by this type."})})
    @TypeInfo(value="ceylon.language.meta.declaration::OpenInterfaceType[]")
    public Sequential<? extends OpenInterfaceType> getSatisfiedTypes();

    @DocAnnotation$annotation$(description="If this type has an `of` clause, this is the list of case types for the current type.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"If this type has an `of` clause, this is the list of case types for the current type."})})
    @TypeInfo(value="ceylon.language.meta.declaration::OpenType[]")
    public Sequential<? extends OpenType> getCaseTypes();

    @DocAnnotation$annotation$(description="True if this type is an alias type, in which case the [[extendedType]] will \ncontain the substituted type.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"True if this type is an alias type, in which case the [[extendedType]] will \ncontain the substituted type."})})
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean getIsAlias();

    @DocAnnotation$annotation$(description="Returns the list of shared member declarations that satisfy the \ngiven `Kind` type argument. \nThis includes inherited declarations but not unshared declarations.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"Returns the list of shared member declarations that satisfy the \ngiven `Kind` type argument. \nThis includes inherited declarations but not unshared declarations."})})
    @TypeInfo(value="Kind[]", erased=true)
    @TypeParameters(value={@TypeParameter(value="Kind", variance=Variance.NONE, satisfies={"ceylon.language.meta.declaration::NestableDeclaration"}, caseTypes={})})
    public <Kind extends NestableDeclaration> Sequential<? extends Kind> memberDeclarations(@Ignore TypeDescriptor var1);

    @DocAnnotation$annotation$(description="Returns the list of member declarations directly declared on this class or interface, \nwhich satisfy the given `Kind` type argument. \nThis includes unshared declarations but not inherited declarations.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"Returns the list of member declarations directly declared on this class or interface, \nwhich satisfy the given `Kind` type argument. \nThis includes unshared declarations but not inherited declarations."})})
    @TypeInfo(value="Kind[]", erased=true)
    @TypeParameters(value={@TypeParameter(value="Kind", variance=Variance.NONE, satisfies={"ceylon.language.meta.declaration::NestableDeclaration"}, caseTypes={})})
    public <Kind extends NestableDeclaration> Sequential<? extends Kind> declaredMemberDeclarations(@Ignore TypeDescriptor var1);

    @DocAnnotation$annotation$(description="Returns the list of shared member declarations that satisfy the given `Kind` type argument and\nthat are annotated with the given `Annotation` type argument. This includes inherited\ndeclarations but not unshared declarations.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"Returns the list of shared member declarations that satisfy the given `Kind` type argument and\nthat are annotated with the given `Annotation` type argument. This includes inherited\ndeclarations but not unshared declarations."})})
    @TypeInfo(value="Kind[]", erased=true)
    @TypeParameters(value={@TypeParameter(value="Kind", variance=Variance.NONE, satisfies={"ceylon.language.meta.declaration::NestableDeclaration"}, caseTypes={}), @TypeParameter(value="Annotation", variance=Variance.NONE, satisfies={"ceylon.language::Annotation"}, caseTypes={})})
    public <Kind extends NestableDeclaration, Annotation extends Annotation> Sequential<? extends Kind> annotatedMemberDeclarations(@Ignore TypeDescriptor var1, @Ignore TypeDescriptor var2);

    @DocAnnotation$annotation$(description="Returns the list of member declarations directly declared on this class or interface, which satisfy the given \n`Kind` type argument and that are annotated with the given `Annotation` type argument.\nThis includes unshared declarations but not inherited declarations.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"Returns the list of member declarations directly declared on this class or interface, which satisfy the given \n`Kind` type argument and that are annotated with the given `Annotation` type argument.\nThis includes unshared declarations but not inherited declarations."})})
    @TypeInfo(value="Kind[]", erased=true)
    @TypeParameters(value={@TypeParameter(value="Kind", variance=Variance.NONE, satisfies={"ceylon.language.meta.declaration::NestableDeclaration"}, caseTypes={}), @TypeParameter(value="Annotation", variance=Variance.NONE, satisfies={"ceylon.language::Annotation"}, caseTypes={})})
    public <Kind extends NestableDeclaration, Annotation extends Annotation> Sequential<? extends Kind> annotatedDeclaredMemberDeclarations(@Ignore TypeDescriptor var1, @Ignore TypeDescriptor var2);

    @DocAnnotation$annotation$(description="Looks up a shared member declaration by name, \nprovided it satisfies the given `Kind` type argument. \nReturns `null` if no such member matches. \nThis includes inherited declarations but not unshared declarations")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"Looks up a shared member declaration by name, \nprovided it satisfies the given `Kind` type argument. \nReturns `null` if no such member matches. \nThis includes inherited declarations but not unshared declarations"})})
    @TypeInfo(value="Kind?", erased=true)
    @TypeParameters(value={@TypeParameter(value="Kind", variance=Variance.NONE, satisfies={"ceylon.language.meta.declaration::NestableDeclaration"}, caseTypes={})})
    public <Kind extends NestableDeclaration> Kind getMemberDeclaration(@Ignore TypeDescriptor var1, @Name(value="name") @TypeInfo(value="ceylon.language::String") String var2);

    @DocAnnotation$annotation$(description="Looks up a member declaration directly declared on this class or interface, by name, \nprovided it satisfies the given `Kind` type argument. \nReturns `null` if no such member matches. \nThis includes unshared declarations but not inherited declarations.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"Looks up a member declaration directly declared on this class or interface, by name, \nprovided it satisfies the given `Kind` type argument. \nReturns `null` if no such member matches. \nThis includes unshared declarations but not inherited declarations."})})
    @TypeInfo(value="Kind?", erased=true)
    @TypeParameters(value={@TypeParameter(value="Kind", variance=Variance.NONE, satisfies={"ceylon.language.meta.declaration::NestableDeclaration"}, caseTypes={})})
    public <Kind extends NestableDeclaration> Kind getDeclaredMemberDeclaration(@Ignore TypeDescriptor var1, @Name(value="name") @TypeInfo(value="ceylon.language::String") String var2);

    @Ignore
    public <Type> ClassOrInterface<? extends Type> apply(TypeDescriptor var1);

    @DocAnnotation$annotation$(description="Applies the given closed type arguments to this toplevel class or interface declaration in order to obtain a class or interface model. \nSee [this code sample](#toplevel-sample) for an example on how to use this.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.2.2:ceylon.language:meta.model:CIncompatibleTypeException", when="If the specified `Type` type argument is not compatible with the actual result."), @ThrownExceptionAnnotation$annotation$(type="::1.2.2:ceylon.language:meta.model:CTypeApplicationException", when="If the specified closed type argument values are not compatible \nwith the actual result's type parameters.")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"Applies the given closed type arguments to this toplevel class or interface declaration in order to obtain a class or interface model. \nSee [this code sample](#toplevel-sample) for an example on how to use this."}), @com.redhat.ceylon.compiler.java.metadata.Annotation(value="throws", arguments={"IncompatibleTypeException", "If the specified `Type` type argument is not compatible with the actual result."}), @com.redhat.ceylon.compiler.java.metadata.Annotation(value="throws", arguments={"TypeApplicationException", "If the specified closed type argument values are not compatible \nwith the actual result's type parameters."})})
    @TypeInfo(value="ceylon.language.meta.model::ClassOrInterface<Type>")
    @TypeParameters(value={@TypeParameter(value="Type", variance=Variance.NONE, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Anything")})
    public <Type> ClassOrInterface<? extends Type> apply(@Ignore TypeDescriptor var1, @Name(value="typeArguments") @Sequenced @TypeInfo(value="ceylon.language.meta.model::Type<ceylon.language::Anything>[]") Sequential<? extends Type<? extends Object>> var2);

    @Ignore
    public <Container, Type> Object memberApply(TypeDescriptor var1, TypeDescriptor var2, Type<? extends Object> var3);

    @DocAnnotation$annotation$(description="Applies the given closed container type and type arguments to this member class or interface declaration in order to obtain a \nmember class or interface model. See [this code sample](#member-sample) for an example on how to use this.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.2.2:ceylon.language:meta.model:CIncompatibleTypeException", when="If the specified `Container` or `Type` type arguments are not \ncompatible with the actual result."), @ThrownExceptionAnnotation$annotation$(type="::1.2.2:ceylon.language:meta.model:CTypeApplicationException", when="If the specified closed container type or type argument values \nare not compatible with the actual result's container type or \ntype parameters.")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@com.redhat.ceylon.compiler.java.metadata.Annotation(value="doc", arguments={"Applies the given closed container type and type arguments to this member class or interface declaration in order to obtain a \nmember class or interface model. See [this code sample](#member-sample) for an example on how to use this."}), @com.redhat.ceylon.compiler.java.metadata.Annotation(value="throws", arguments={"IncompatibleTypeException", "If the specified `Container` or `Type` type arguments are not \ncompatible with the actual result."}), @com.redhat.ceylon.compiler.java.metadata.Annotation(value="throws", arguments={"TypeApplicationException", "If the specified closed container type or type argument values \nare not compatible with the actual result's container type or \ntype parameters."})})
    @TypeInfo(value="ceylon.language.meta.model::Member<Container,ceylon.language.meta.model::ClassOrInterface<Type>>&ceylon.language.meta.model::ClassOrInterface<Type>", erased=true)
    @TypeParameters(value={@TypeParameter(value="Container", variance=Variance.NONE, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Nothing"), @TypeParameter(value="Type", variance=Variance.NONE, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Anything")})
    public <Container, Type> Object memberApply(@Ignore TypeDescriptor var1, @Ignore TypeDescriptor var2, @Name(value="containerType") @TypeInfo(value="ceylon.language.meta.model::Type<ceylon.language::Object>") Type<? extends Object> var3, @Name(value="typeArguments") @Sequenced @TypeInfo(value="ceylon.language.meta.model::Type<ceylon.language::Anything>[]") Sequential<? extends Type<? extends Object>> var4);
}

